/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.meta;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.sql.DataSource;
import org.finos.tracdap.common.config.ConfigManager;
import org.finos.tracdap.common.db.JdbcDialect;
import org.finos.tracdap.common.db.JdbcSetup;
import org.finos.tracdap.common.exception.EStartup;
import org.finos.tracdap.common.startup.Startup;
import org.finos.tracdap.common.util.InterfaceLogging;
import org.finos.tracdap.config.MetaServiceConfig;
import org.finos.tracdap.config.PlatformConfig;
import org.finos.tracdap.svc.meta.dal.IMetadataDal;
import org.finos.tracdap.svc.meta.dal.jdbc.JdbcMetadataDal;
import org.finos.tracdap.test.meta.IDalTestable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JdbcIntegration
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String TRAC_CONFIG_FILE = "TRAC_CONFIG_FILE";
    private static final String TRAC_KEYSTORE_KEY = "TRAC_KEYSTORE_KEY";
    private JdbcDialect dialect;
    private DataSource source;
    private JdbcMetadataDal dal;

    public void beforeAll(ExtensionContext context) {
        Map<String, String> env = System.getenv();
        Path workingDir = Paths.get(".", new String[0]).toAbsolutePath().normalize();
        String configFile = env.get(TRAC_CONFIG_FILE);
        String keystoreKey = env.get(TRAC_KEYSTORE_KEY);
        if (configFile == null || configFile.isBlank()) {
            throw new EStartup("Missing environment variable for integration testing: TRAC_CONFIG_FILE");
        }
        ConfigManager configManager = Startup.quickConfig((Path)workingDir, (String)configFile, (String)keystoreKey);
        PlatformConfig platformConfig = (PlatformConfig)configManager.loadRootConfigObject(PlatformConfig.class);
        MetaServiceConfig metaConfig = platformConfig.getServices().getMeta();
        Properties dalProps = new Properties();
        dalProps.putAll((Map<?, ?>)metaConfig.getDalPropsMap());
        this.dialect = JdbcSetup.getSqlDialect((Properties)dalProps, (String)"");
        this.source = JdbcSetup.createDatasource((Properties)dalProps, (String)"");
    }

    public void beforeEach(ExtensionContext context) {
        Optional testClass = context.getTestClass();
        if (testClass.isEmpty() || !IDalTestable.class.isAssignableFrom((Class)testClass.get())) {
            Assertions.fail((String)"JUnit extension for DAL testing requires the test class to implement IDalTestable");
        }
        JdbcMetadataDal dal = new JdbcMetadataDal(this.dialect, this.source, Runnable::run);
        dal.startup();
        this.dal = dal;
        IMetadataDal dalWithLogging = (IMetadataDal)InterfaceLogging.wrap((Object)dal, IMetadataDal.class);
        Optional testInstance = context.getTestInstance();
        if (testInstance.isPresent()) {
            IDalTestable testCase = (IDalTestable)testInstance.get();
            testCase.setDal(dalWithLogging);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.dal != null) {
            this.dal.shutdown();
        }
    }

    public void afterAll(ExtensionContext context) {
        JdbcSetup.destroyDatasource((DataSource)this.source);
        this.source = null;
    }
}

