/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.meta;

import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Statement;
import java.util.Optional;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import javax.sql.DataSource;
import org.finos.tracdap.common.db.JdbcDialect;
import org.finos.tracdap.common.db.JdbcSetup;
import org.finos.tracdap.common.util.InterfaceLogging;
import org.finos.tracdap.svc.meta.dal.IMetadataDal;
import org.finos.tracdap.svc.meta.dal.jdbc.JdbcMetadataDal;
import org.finos.tracdap.test.meta.IDalTestable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JdbcUnit
implements BeforeAllCallback,
BeforeEachCallback,
AfterEachCallback,
AfterAllCallback {
    private static final String JDBC_URL_TEMPLATE = "mem:%s;DB_CLOSE_DELAY=-1";
    private DataSource source;
    private JdbcMetadataDal dal;

    public void beforeAll(ExtensionContext context) throws Exception {
        UUID dbId = UUID.randomUUID();
        String jdbcUrl = String.format(JDBC_URL_TEMPLATE, dbId);
        Properties props = new Properties();
        props.setProperty("unit.jdbcUrl", jdbcUrl);
        props.setProperty("unit.dialect", "H2");
        props.setProperty("unit.h2.user", "trac");
        props.setProperty("unit.h2.pass", "trac");
        props.setProperty("unit.pool.size", "1");
        this.source = JdbcSetup.createDatasource((Properties)props, (String)"unit");
        InputStream inputStream = JdbcUnit.class.getResourceAsStream("/h2/001__trac_metadata.ddl");
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        String deployScript = scanner.next();
        try (Connection conn = this.source.getConnection();
             Statement stmt = conn.createStatement();){
            System.out.println("SQL >>> Deploying database schema");
            for (String deployCommand : deployScript.split(";")) {
                if (deployCommand.isBlank()) continue;
                System.out.println("SQL >>>\n\n" + deployCommand.strip() + "\n");
                stmt.execute(deployCommand);
            }
            stmt.execute(String.format("insert into tenant (tenant_id, tenant_code) values (1, '%s')", "ACME_CORP"));
        }
    }

    public void beforeEach(ExtensionContext context) {
        Optional testClass = context.getTestClass();
        if (testClass.isEmpty() || !IDalTestable.class.isAssignableFrom((Class)testClass.get())) {
            Assertions.fail((String)"JUnit extension for DAL testing requires the test class to implement IDalTestable");
        }
        JdbcMetadataDal dal = new JdbcMetadataDal(JdbcDialect.H2, this.source, Runnable::run);
        dal.startup();
        this.dal = dal;
        IMetadataDal dalWithLogging = (IMetadataDal)InterfaceLogging.wrap((Object)dal, IMetadataDal.class);
        Optional testInstance = context.getTestInstance();
        if (testInstance.isPresent()) {
            IDalTestable testCase = (IDalTestable)testInstance.get();
            testCase.setDal(dalWithLogging);
        }
    }

    public void afterEach(ExtensionContext context) {
        if (this.dal != null) {
            this.dal.shutdown();
        }
    }

    public void afterAll(ExtensionContext context) {
        JdbcSetup.destroyDatasource((DataSource)this.source);
        this.source = null;
    }
}

