/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.meta;

import com.google.protobuf.ByteString;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.CopyStatus;
import org.finos.tracdap.metadata.CustomDefinition;
import org.finos.tracdap.metadata.DataDefinition;
import org.finos.tracdap.metadata.DateValue;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.DecimalValue;
import org.finos.tracdap.metadata.FieldSchema;
import org.finos.tracdap.metadata.FileDefinition;
import org.finos.tracdap.metadata.FlowDefinition;
import org.finos.tracdap.metadata.FlowEdge;
import org.finos.tracdap.metadata.FlowModelStub;
import org.finos.tracdap.metadata.FlowNode;
import org.finos.tracdap.metadata.FlowNodeType;
import org.finos.tracdap.metadata.FlowSocket;
import org.finos.tracdap.metadata.IncarnationStatus;
import org.finos.tracdap.metadata.JobDefinition;
import org.finos.tracdap.metadata.JobType;
import org.finos.tracdap.metadata.ModelDefinition;
import org.finos.tracdap.metadata.ModelInputSchema;
import org.finos.tracdap.metadata.ModelOutputSchema;
import org.finos.tracdap.metadata.ModelParameter;
import org.finos.tracdap.metadata.ObjectDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.PartKey;
import org.finos.tracdap.metadata.PartType;
import org.finos.tracdap.metadata.RunModelJob;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.SchemaType;
import org.finos.tracdap.metadata.StorageCopy;
import org.finos.tracdap.metadata.StorageDefinition;
import org.finos.tracdap.metadata.StorageIncarnation;
import org.finos.tracdap.metadata.StorageItem;
import org.finos.tracdap.metadata.TableSchema;
import org.finos.tracdap.metadata.Tag;
import org.finos.tracdap.metadata.TagHeader;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TagUpdate;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

public class TestData {
    public static final boolean INCLUDE_HEADER = true;
    public static final boolean NO_HEADER = false;
    public static final boolean UPDATE_TAG_VERSION = true;
    public static final boolean KEEP_ORIGINAL_TAG_VERSION = false;
    public static final String TEST_TENANT = "ACME_CORP";
    private static final Random random = new Random(Instant.now().getEpochSecond());

    public static ObjectDefinition dummyDefinitionForType(ObjectType objectType) {
        switch (objectType) {
            case DATA: {
                return TestData.dummyDataDef();
            }
            case MODEL: {
                return TestData.dummyModelDef();
            }
            case FLOW: {
                return TestData.dummyFlowDef();
            }
            case JOB: {
                return TestData.dummyJobDef();
            }
            case FILE: {
                return TestData.dummyFileDef();
            }
            case CUSTOM: {
                return TestData.dummyCustomDef();
            }
            case STORAGE: {
                return TestData.dummyStorageDef();
            }
            case SCHEMA: {
                return TestData.dummySchemaDef();
            }
        }
        throw new RuntimeException("No dummy data available for object type " + objectType.name());
    }

    public static Tag dummyTagForObjectType(ObjectType objectType) {
        return TestData.dummyTag(TestData.dummyDefinitionForType(objectType), true);
    }

    public static ObjectDefinition dummyVersionForType(ObjectDefinition definition) {
        ObjectType objectType = definition.getObjectType();
        switch (objectType) {
            case DATA: {
                return TestData.nextDataDef(definition);
            }
            case MODEL: {
                return TestData.nextModelDef(definition);
            }
            case CUSTOM: {
                return TestData.nextCustomDef(definition);
            }
            case STORAGE: {
                return TestData.nextStorageDef(definition);
            }
            case SCHEMA: {
                return TestData.nextSchemaDef(definition);
            }
            case FLOW: 
            case JOB: 
            case FILE: {
                return definition;
            }
        }
        throw new RuntimeException("No second version available in dummy data for object type " + objectType.name());
    }

    public static TagHeader newHeader(ObjectType objectType) {
        OffsetDateTime timestamp = Instant.now().atOffset(ZoneOffset.UTC);
        return TagHeader.newBuilder().setObjectType(objectType).setObjectId(UUID.randomUUID().toString()).setObjectVersion(1).setTagVersion(1).setObjectTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)timestamp)).setTagTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)timestamp)).build();
    }

    public static TagHeader nextTagHeader(TagHeader priorTagHeader) {
        OffsetDateTime timestamp = Instant.now().atOffset(ZoneOffset.UTC);
        return priorTagHeader.toBuilder().setTagVersion(priorTagHeader.getTagVersion() + 1).setTagTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)timestamp)).build();
    }

    public static ObjectDefinition dummyDataDef() {
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.DATA).setData(DataDefinition.newBuilder().setStorageId(TagSelector.newBuilder().setObjectType(ObjectType.STORAGE).setObjectId(UUID.randomUUID().toString()).setLatestObject(true).setLatestTag(true)).setSchema(SchemaDefinition.newBuilder().setSchemaType(SchemaType.TABLE).setTable(TableSchema.newBuilder().addFields(FieldSchema.newBuilder().setFieldName("transaction_id").setFieldType(BasicType.STRING).setFieldOrder(0).setBusinessKey(true)).addFields(FieldSchema.newBuilder().setFieldName("customer_id").setFieldType(BasicType.STRING).setFieldOrder(1).setBusinessKey(true)).addFields(FieldSchema.newBuilder().setFieldName("order_date").setFieldType(BasicType.DATE).setFieldOrder(2).setBusinessKey(true)).addFields(FieldSchema.newBuilder().setFieldName("widgets_ordered").setFieldType(BasicType.INTEGER).setFieldOrder(3).setBusinessKey(true)))).putParts("part-root", DataDefinition.Part.newBuilder().setPartKey(PartKey.newBuilder().setPartType(PartType.PART_ROOT).setOpaqueKey("part-root")).setSnap(DataDefinition.Snap.newBuilder().setSnapIndex(0).addDeltas(DataDefinition.Delta.newBuilder().setDeltaIndex(0).setDataItem("data/table/" + UUID.randomUUID() + "/snap-0/delta-0-x123456"))).build())).build();
    }

    public static ObjectDefinition nextDataDef(ObjectDefinition origDef) {
        SchemaDefinition newSchema = TestData.addFieldToSchema(origDef.getData().getSchema());
        return origDef.toBuilder().setData(origDef.getData().toBuilder().setSchema(newSchema)).build();
    }

    public static ObjectDefinition dummySchemaDef() {
        ObjectDefinition dataDef = TestData.dummyDataDef();
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.SCHEMA).setSchema(dataDef.getData().getSchema()).build();
    }

    public static ObjectDefinition nextSchemaDef(ObjectDefinition origDef) {
        return origDef.toBuilder().setSchema(TestData.addFieldToSchema(origDef.getSchema())).build();
    }

    private static SchemaDefinition addFieldToSchema(SchemaDefinition origSchema) {
        String fieldName = "extra_field_" + (origSchema.getTable().getFieldsCount() + 1);
        TableSchema.Builder newTableSchema = origSchema.getTable().toBuilder().addFields(FieldSchema.newBuilder().setFieldName(fieldName).setFieldOrder(origSchema.getTable().getFieldsCount()).setFieldType(BasicType.FLOAT).setLabel("We got an extra field!").setFormatCode("PERCENT"));
        return origSchema.toBuilder().setTable(newTableSchema).build();
    }

    public static ObjectDefinition dummyStorageDef() {
        OffsetDateTime storageTimestamp = OffsetDateTime.now();
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.STORAGE).setStorage(StorageDefinition.newBuilder().putDataItems("dummy_item", StorageItem.newBuilder().addIncarnations(StorageIncarnation.newBuilder().setIncarnationIndex(1).setIncarnationTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)storageTimestamp)).setIncarnationStatus(IncarnationStatus.INCARNATION_AVAILABLE).addCopies(StorageCopy.newBuilder().setStorageKey("DUMMY_STORAGE").setStoragePath("path/to/the/dataset").setStorageFormat("AVRO").setCopyTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)storageTimestamp)).setCopyStatus(CopyStatus.COPY_AVAILABLE))).build())).build();
    }

    public static ObjectDefinition nextStorageDef(ObjectDefinition definition) {
        OffsetDateTime storageTimestamp = OffsetDateTime.now();
        StorageCopy.Builder archiveCopy = StorageCopy.newBuilder().setStorageKey("DUMMY_ARCHIVE_STORAGE").setStoragePath("path/to/the/dataset").setStorageFormat("PARQUET").setCopyTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)storageTimestamp)).setCopyStatus(CopyStatus.COPY_AVAILABLE);
        StorageIncarnation.Builder archivedIncarnation = definition.getStorage().getDataItemsOrThrow("dummy_item").getIncarnations(0).toBuilder().addCopies(archiveCopy);
        return definition.toBuilder().setStorage(definition.getStorage().toBuilder().putDataItems("dummy_item", StorageItem.newBuilder().addIncarnations(archivedIncarnation).build())).build();
    }

    public static ObjectDefinition dummyModelDef() {
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.MODEL).setModel(ModelDefinition.newBuilder().setLanguage("python").setRepository("trac_test_repo").setPath("src/main/python").setVersion("trac-test-repo-1.2.3-RC4").setEntryPoint("trac_test.test1.SampleModel1").putParameters("param1", ModelParameter.newBuilder().setParamType(TypeSystem.descriptor((BasicType)BasicType.STRING)).build()).putParameters("param2", ModelParameter.newBuilder().setParamType(TypeSystem.descriptor((BasicType)BasicType.INTEGER)).build()).putInputs("input1", ModelInputSchema.newBuilder().setSchema(SchemaDefinition.newBuilder().setSchemaType(SchemaType.TABLE).setTable(TableSchema.newBuilder().addFields(FieldSchema.newBuilder().setFieldName("field1").setFieldType(BasicType.DATE).setBusinessKey(true)).addFields(FieldSchema.newBuilder().setFieldName("field2").setFieldType(BasicType.STRING).setCategorical(true)).addFields(FieldSchema.newBuilder().setFieldName("field3").setFieldType(BasicType.DECIMAL).setLabel("A display name").setFormatCode("GBP")))).build()).putOutputs("output1", ModelOutputSchema.newBuilder().setSchema(SchemaDefinition.newBuilder().setSchemaType(SchemaType.TABLE).setTable(TableSchema.newBuilder().addFields(FieldSchema.newBuilder().setFieldName("checksum_field").setFieldType(BasicType.DECIMAL)))).build())).build();
    }

    public static ObjectDefinition nextModelDef(ObjectDefinition origDef) {
        return origDef.toBuilder().setModel(origDef.getModel().toBuilder().putParameters("param3", ModelParameter.newBuilder().setParamType(TypeSystem.descriptor((BasicType)BasicType.DATE)).build())).build();
    }

    public static ObjectDefinition dummyFlowDef() {
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.FLOW).setFlow(FlowDefinition.newBuilder().putNodes("input_1", FlowNode.newBuilder().setNodeType(FlowNodeType.INPUT_NODE).build()).putNodes("output_1", FlowNode.newBuilder().setNodeType(FlowNodeType.OUTPUT_NODE).build()).putNodes("main_model", FlowNode.newBuilder().setNodeType(FlowNodeType.MODEL_NODE).setModelStub(FlowModelStub.newBuilder().putParameters("param_1", TypeSystem.descriptor((BasicType)BasicType.FLOAT)).addInputs("input_1").addOutputs("output_1")).build()).addEdges(FlowEdge.newBuilder().setSource(FlowSocket.newBuilder().setNode("input_1")).setTarget(FlowSocket.newBuilder().setNode("main_model").setSocket("input_1"))).addEdges(FlowEdge.newBuilder().setSource(FlowSocket.newBuilder().setNode("main_model").setSocket("output_1")).setTarget(FlowSocket.newBuilder().setNode("output_1")))).build();
    }

    public static ObjectDefinition dummyJobDef() {
        TagSelector.Builder targetSelector = TagSelector.newBuilder().setObjectType(ObjectType.MODEL).setObjectId(UUID.randomUUID().toString()).setObjectVersion(1).setLatestTag(true);
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.JOB).setJob(JobDefinition.newBuilder().setJobType(JobType.RUN_MODEL).setRunModel(RunModelJob.newBuilder().setModel(targetSelector))).build();
    }

    public static ObjectDefinition dummyFileDef() {
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.FILE).setFile(FileDefinition.newBuilder().setName("magic_template").setExtension("docx").setMimeType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet").setSize(45285L).setStorageId(TagSelector.newBuilder().setObjectType(ObjectType.STORAGE).setObjectId(UUID.randomUUID().toString()).setLatestObject(true).setLatestTag(true)).setDataItem("file/FILE_ID/version-1")).build();
    }

    public static ObjectDefinition dummyCustomDef() {
        String jsonReportDef = "{ reportType: 'magic', mainGraph: { content: 'more_magic' } }";
        return ObjectDefinition.newBuilder().setObjectType(ObjectType.CUSTOM).setCustom(CustomDefinition.newBuilder().setCustomSchemaType("REPORT").setCustomSchemaVersion(2).setCustomData(ByteString.copyFromUtf8((String)jsonReportDef))).build();
    }

    public static ObjectDefinition nextCustomDef(ObjectDefinition origDef) {
        UUID ver = UUID.randomUUID();
        String jsonReportDef = "{ reportType: 'magic', mainGraph: { content: 'more_magic_" + ver + " ' } }";
        return origDef.toBuilder().setCustom(origDef.getCustom().toBuilder().setCustomData(ByteString.copyFromUtf8((String)jsonReportDef))).build();
    }

    public static Tag dummyTag(ObjectDefinition definition, boolean includeHeader) {
        Tag.Builder tag = Tag.newBuilder().setDefinition(definition).putAttrs("dataset_key", MetadataCodec.encodeValue((String)"widget_orders")).putAttrs("widget_type", MetadataCodec.encodeValue((String)"non_standard_widget"));
        if (includeHeader) {
            TagHeader header = TestData.newHeader(definition.getObjectType());
            return tag.setHeader(header).build();
        }
        return tag.build();
    }

    public static Map<String, Value> dummyAttrs() {
        HashMap<String, Value> attrs = new HashMap<String, Value>();
        attrs.put("dataset_key", MetadataCodec.encodeValue((String)"widget_orders"));
        attrs.put("widget_type", MetadataCodec.encodeValue((String)"non_standard_widget"));
        return attrs;
    }

    public static List<TagUpdate> tagUpdatesForAttrs(Map<String, Value> attrs) {
        return attrs.entrySet().stream().map(entry -> TagUpdate.newBuilder().setAttrName((String)entry.getKey()).setValue((Value)entry.getValue()).build()).collect(Collectors.toList());
    }

    public static Tag tagForNextObject(Tag previous, ObjectDefinition obj, boolean includeHeader) {
        OffsetDateTime timestamp = Instant.now().atOffset(ZoneOffset.UTC);
        Tag.Builder newTag = previous.toBuilder().setDefinition(obj).putAttrs("extra_attr", Value.newBuilder().setType(TypeSystem.descriptor((BasicType)BasicType.STRING)).setStringValue("A new descriptive value").build());
        if (includeHeader) {
            TagHeader header = previous.getHeader().toBuilder().setObjectVersion(previous.getHeader().getObjectVersion() + 1).setTagVersion(1).setObjectTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)timestamp)).setTagTimestamp(MetadataCodec.encodeDatetime((OffsetDateTime)timestamp)).build();
            return newTag.setHeader(header).build();
        }
        return newTag.clearHeader().build();
    }

    public static Tag nextTag(Tag previous, boolean updateTagVersion) {
        Tag.Builder updatedTag = previous.toBuilder().putAttrs("extra_attr", Value.newBuilder().setType(TypeSystem.descriptor((BasicType)BasicType.STRING)).setStringValue("A new descriptive value").build());
        if (!updateTagVersion) {
            return updatedTag.build();
        }
        TagHeader nextHeader = TestData.nextTagHeader(previous.getHeader());
        return updatedTag.setHeader(nextHeader).build();
    }

    public static Tag addMultiValuedAttr(Tag tag) {
        Value dataClassification = MetadataCodec.encodeArrayValue(List.of("pii", "bcbs239", "confidential"), (TypeDescriptor)TypeSystem.descriptor((BasicType)BasicType.STRING));
        return tag.toBuilder().putAttrs("data_classification", dataClassification).build();
    }

    public static <T> T unwrap(CompletableFuture<T> future) throws Exception {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public static Object objectOfType(BasicType basicType) {
        switch (basicType) {
            case BOOLEAN: {
                return true;
            }
            case INTEGER: {
                return 42L;
            }
            case FLOAT: {
                return Math.PI;
            }
            case DECIMAL: {
                return new BigDecimal("1234.567");
            }
            case STRING: {
                return "the_droids_you_are_looking_for";
            }
            case DATE: {
                return LocalDate.now();
            }
            case DATETIME: {
                OffsetDateTime dateTime = OffsetDateTime.now(ZoneOffset.UTC);
                return TestData.truncateMicrosecondPrecision(dateTime);
            }
        }
        throw new RuntimeException("Test object not available for basic type " + basicType);
    }

    public static Object objectOfDifferentType(BasicType basicType) {
        if (basicType == BasicType.STRING) {
            return TestData.objectOfType(BasicType.INTEGER);
        }
        return TestData.objectOfType(BasicType.STRING);
    }

    public static Object differentObjectOfSameType(BasicType basicType, Object originalObject) {
        switch (basicType) {
            case BOOLEAN: {
                return (Boolean)originalObject == false;
            }
            case INTEGER: {
                return (Long)originalObject + 1L;
            }
            case FLOAT: {
                return (Double)originalObject + 2.0;
            }
            case DECIMAL: {
                return ((BigDecimal)originalObject).add(new BigDecimal(2));
            }
            case STRING: {
                return originalObject.toString() + " and friends";
            }
            case DATE: {
                return ((LocalDate)originalObject).plusDays(1L);
            }
            case DATETIME: {
                return ((OffsetDateTime)originalObject).plusHours(1L);
            }
        }
        throw new RuntimeException("Test object not available for basic type " + basicType);
    }

    public static OffsetDateTime truncateMicrosecondPrecision(OffsetDateTime dateTime) {
        int precision = 6;
        int nanos = dateTime.getNano();
        int nanoPrecision = (int)Math.pow(10.0, 9 - precision);
        int truncatedNanos = nanos / nanoPrecision * nanoPrecision;
        return dateTime.withNano(truncatedNanos);
    }

    public static TagSelector selectorForTag(TagHeader tagHeader) {
        return TagSelector.newBuilder().setObjectType(tagHeader.getObjectType()).setObjectId(tagHeader.getObjectId()).setObjectVersion(tagHeader.getObjectVersion()).setTagVersion(tagHeader.getTagVersion()).build();
    }

    public static TagSelector selectorForTag(Tag tag) {
        return TestData.selectorForTag(tag.getHeader());
    }

    public static Value randomPrimitive(BasicType basicType) {
        TypeDescriptor typeDescriptor = TypeSystem.descriptor((BasicType)basicType);
        switch (basicType) {
            case BOOLEAN: {
                return Value.newBuilder().setType(typeDescriptor).setBooleanValue(true).build();
            }
            case INTEGER: {
                return Value.newBuilder().setType(typeDescriptor).setIntegerValue(random.nextLong()).build();
            }
            case FLOAT: {
                return Value.newBuilder().setType(typeDescriptor).setFloatValue(random.nextDouble()).build();
            }
            case DECIMAL: {
                BigDecimal decimalValue = BigDecimal.valueOf(random.nextDouble());
                return Value.newBuilder().setType(typeDescriptor).setDecimalValue(DecimalValue.newBuilder().setDecimal(decimalValue.toPlainString())).build();
            }
            case STRING: {
                String stringValue = "random_string_" + random.nextLong();
                return Value.newBuilder().setType(typeDescriptor).setStringValue(stringValue).build();
            }
            case DATE: {
                DateValue dateValue = MetadataCodec.encodeDate((LocalDate)LocalDate.now());
                return Value.newBuilder().setType(typeDescriptor).setDateValue(dateValue).build();
            }
            case DATETIME: {
                DatetimeValue datetimeValue = MetadataCodec.encodeDatetime((Instant)Instant.now());
                return Value.newBuilder().setType(typeDescriptor).setDatetimeValue(datetimeValue).build();
            }
        }
        throw new EUnexpected();
    }
}

