/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.test.storage;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.stream.Stream;
import org.finos.tracdap.common.concurrent.Flows;
import org.finos.tracdap.common.concurrent.IExecutionContext;
import org.finos.tracdap.common.storage.IFileStorage;

public class StorageTestHelpers {
    public static CompletableFuture<Long> makeFile(String storagePath, ByteBuf content, IFileStorage storage, IExecutionContext execContext) {
        CompletableFuture<Long> signal = new CompletableFuture<Long>();
        Flow.Subscriber writer = storage.writer(storagePath, signal, execContext);
        Flows.publish(Stream.of(content)).subscribe(writer);
        return signal;
    }

    public static CompletableFuture<Long> makeSmallFile(String storagePath, IFileStorage storage, IExecutionContext execContext) {
        ByteBuf content = ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap("Small file test content\n"), (Charset)StandardCharsets.UTF_8);
        return StorageTestHelpers.makeFile(storagePath, content, storage, execContext);
    }

    public static CompletionStage<ByteBuf> readFile(String storagePath, IFileStorage storage, IExecutionContext execContext) {
        Flow.Publisher reader = storage.reader(storagePath, execContext);
        return Flows.fold((Flow.Publisher)reader, (composite, buf) -> ((CompositeByteBuf)composite).addComponent(true, buf), (Object)ByteBufAllocator.DEFAULT.compositeBuffer());
    }
}

