/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation;

import java.util.List;
import java.util.regex.Pattern;

public class ValidationConstants {
    public static final Pattern MIME_TYPE = Pattern.compile("\\A\\w+/[-.\\w]+(?:\\+[-.\\w]+)?\\Z");
    public static final List<String> REGISTERED_MIME_TYPES = List.of("application", "audio", "font", "example", "image", "message", "model", "multipart", "text", "video");
    public static final Pattern PATH_ILLEGAL_CHARS = Pattern.compile(".*[<>\"|?*].*");
    public static final Pattern PATH_ILLEGAL_WHITESPACE = Pattern.compile(".*[\\s\\vR&&[^ ]].*");
    public static final Pattern PATH_ILLEGAL_CTRL = Pattern.compile(".*\\p{Cntrl}.*");
    public static final Pattern PATH_SEPARATORS = Pattern.compile("[/\\\\]");
    public static final String UNIX_PATH_SEPARATOR = "/";
    public static final String WINDOWS_PATH_SEPARATOR = "\\";
    public static final Pattern PATH_SINGLE_DOT = Pattern.compile("\\A\\.\\Z");
    public static final Pattern PATH_DOUBLE_DOT = Pattern.compile("\\A\\.\\.\\Z");
    public static final Pattern FILENAME_ILLEGAL_CHARS = Pattern.compile(".*[:/\\\\].*");
    public static final Pattern FILENAME_ILLEGAL_START = Pattern.compile("\\A[ ].*");
    public static final Pattern FILENAME_ILLEGAL_ENDING = Pattern.compile(".*[. ]\\Z");
    public static final Pattern FILENAME_RESERVED = Pattern.compile("\\A(COM\\d*|LPT\\d*|PRN|AUX|NUL)(\\..*)?\\Z", 2);
    public static final Pattern RELATIVE_PATH_ILLEGAL_CHARS = Pattern.compile(".*[:].*");
    public static final Pattern RELATIVE_PATH_IS_ABSOLUTE = Pattern.compile("\\A[/\\\\]");
    public static final Pattern RELATIVE_PATH_DOUBLE_SLASH = Pattern.compile("[/\\\\]{2}");
    public static final Pattern DATA_ITEM_KEY = Pattern.compile("\\A\\w[\\w-.]*(/\\w[\\w-.]*)*\\Z");
    public static final Pattern OPAQUE_PART_KEY = Pattern.compile("\\Apart-(root|range-.*|value-.*)\\Z");
    public static final Pattern MODEL_ENTRY_POINT = Pattern.compile("\\A[a-zA-Z]\\w*(\\.[a-zA-Z]\\w*)*\\Z");
    public static final Pattern MODEL_VERSION = Pattern.compile("\\A\\p{Alnum}[\\w-.]*\\Z");
}

