/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.api;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import org.finos.tracdap.api.Data;
import org.finos.tracdap.api.DataReadRequest;
import org.finos.tracdap.api.DataWriteRequest;
import org.finos.tracdap.api.FileReadRequest;
import org.finos.tracdap.api.FileWriteRequest;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.SchemaValidator;
import org.finos.tracdap.common.validation.static_.TagUpdateValidator;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TagUpdate;

@Validator(type=ValidationType.STATIC, serviceFile=Data.class, serviceName="tracdap.api.TracDataApi")
public class DataApiValidator {
    private static final Descriptors.Descriptor DATA_WRITE_REQUEST = DataWriteRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor DWR_TENANT = ValidatorUtils.field(DATA_WRITE_REQUEST, 1);
    private static final Descriptors.FieldDescriptor DWR_TAG_UPDATES = ValidatorUtils.field(DATA_WRITE_REQUEST, 3);
    private static final Descriptors.FieldDescriptor DWR_PRIOR_VERSION = ValidatorUtils.field(DATA_WRITE_REQUEST, 2);
    private static final Descriptors.FieldDescriptor DWR_SCHEMA_ID = ValidatorUtils.field(DATA_WRITE_REQUEST, 4);
    private static final Descriptors.FieldDescriptor DWR_SCHEMA = ValidatorUtils.field(DATA_WRITE_REQUEST, 5);
    private static final Descriptors.OneofDescriptor DWR_SCHEMA_SPECIFIER = DWR_SCHEMA.getContainingOneof();
    private static final Descriptors.FieldDescriptor DWR_FORMAT = ValidatorUtils.field(DATA_WRITE_REQUEST, 9);
    private static final Descriptors.FieldDescriptor DWR_CONTENT = ValidatorUtils.field(DATA_WRITE_REQUEST, 1000);
    private static final Descriptors.Descriptor DATA_READ_REQUEST = DataReadRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor DRR_TENANT = ValidatorUtils.field(DATA_READ_REQUEST, 1);
    private static final Descriptors.FieldDescriptor DRR_SELECTOR = ValidatorUtils.field(DATA_READ_REQUEST, 2);
    private static final Descriptors.FieldDescriptor DRR_FORMAT = ValidatorUtils.field(DATA_READ_REQUEST, 3);
    private static final Descriptors.Descriptor FILE_WRITE_REQUEST = FileWriteRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor FWR_TENANT = ValidatorUtils.field(FILE_WRITE_REQUEST, 1);
    private static final Descriptors.FieldDescriptor FWR_TAG_UPDATES = ValidatorUtils.field(FILE_WRITE_REQUEST, 3);
    private static final Descriptors.FieldDescriptor FWR_PRIOR_VERSION = ValidatorUtils.field(FILE_WRITE_REQUEST, 2);
    private static final Descriptors.FieldDescriptor FWR_NAME = ValidatorUtils.field(FILE_WRITE_REQUEST, 4);
    private static final Descriptors.FieldDescriptor FWR_MIME_TYPE = ValidatorUtils.field(FILE_WRITE_REQUEST, 5);
    private static final Descriptors.FieldDescriptor FWR_SIZE = ValidatorUtils.field(FILE_WRITE_REQUEST, 6);
    private static final Descriptors.FieldDescriptor FWR_CONTENT = ValidatorUtils.field(FILE_WRITE_REQUEST, 1000);
    private static final Descriptors.Descriptor FILE_READ_REQUEST = FileReadRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor FRR_TENANT = ValidatorUtils.field(FILE_READ_REQUEST, 1);
    private static final Descriptors.FieldDescriptor FRR_SELECTOR = ValidatorUtils.field(FILE_READ_REQUEST, 2);

    @Validator(method="createDataset")
    public static ValidationContext createDataset(DataWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(DWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        return DataApiValidator.createOrUpdateDataset(msg, ctx);
    }

    @Validator(method="createSmallDataset")
    public static ValidationContext createSmallDataset(DataWriteRequest msg, ValidationContext ctx) {
        ctx = DataApiValidator.createDataset(msg, ctx);
        ctx.push(DWR_CONTENT).apply(CommonValidators::required).apply(DataApiValidator::contentNotEmpty, ByteString.class).pop();
        return ctx;
    }

    @Validator(method="updateDataset")
    public static ValidationContext updateDataset(DataWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(DWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.DATA).pop();
        return DataApiValidator.createOrUpdateDataset(msg, ctx);
    }

    @Validator(method="updateSmallDataset")
    public static ValidationContext updateSmallDataset(DataWriteRequest msg, ValidationContext ctx) {
        ctx = DataApiValidator.updateDataset(msg, ctx);
        ctx.push(DWR_CONTENT).apply(CommonValidators::required).apply(DataApiValidator::contentNotEmpty, ByteString.class).pop();
        return ctx;
    }

    private static ValidationContext createOrUpdateDataset(DataWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(DWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(DWR_TAG_UPDATES).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, false).pop();
        ctx = ctx.pushOneOf(DWR_SCHEMA_SPECIFIER).apply(CommonValidators::required).applyOneOf(DWR_SCHEMA_ID, ObjectIdValidator::tagSelector, TagSelector.class).applyOneOf(DWR_SCHEMA_ID, ObjectIdValidator::selectorType, TagSelector.class, ObjectType.SCHEMA).applyOneOf(DWR_SCHEMA_ID, ObjectIdValidator::fixedObjectVersion, TagSelector.class).applyOneOf(DWR_SCHEMA, SchemaValidator::schema, SchemaDefinition.class).pop();
        ctx = ctx.push(DWR_FORMAT).apply(CommonValidators::required).apply(CommonValidators::mimeType).pop();
        return ctx;
    }

    @Validator(method="readDataset")
    public static ValidationContext readDataset(DataReadRequest msg, ValidationContext ctx) {
        ctx = ctx.push(DRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(DRR_SELECTOR).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.DATA).pop();
        ctx = ctx.push(DRR_FORMAT).apply(CommonValidators::required).apply(CommonValidators::mimeType).pop();
        return ctx;
    }

    @Validator(method="readSmallDataset")
    public static ValidationContext readSmallDataset(DataReadRequest msg, ValidationContext ctx) {
        return DataApiValidator.readDataset(msg, ctx);
    }

    @Validator(method="createFile")
    public static ValidationContext createFile(FileWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(FWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        return DataApiValidator.createOrUpdateFile(msg, ctx);
    }

    @Validator(method="createSmallFile")
    public static ValidationContext createSmallFile(FileWriteRequest msg, ValidationContext ctx) {
        ctx = DataApiValidator.createFile(msg, ctx);
        ctx.push(FWR_CONTENT).apply(CommonValidators::required).apply(DataApiValidator::contentNotEmpty, ByteString.class).pop();
        return ctx;
    }

    @Validator(method="updateFile")
    public static ValidationContext updateFile(FileWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(FWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.FILE).pop();
        return DataApiValidator.createOrUpdateFile(msg, ctx);
    }

    @Validator(method="updateSmallFile")
    public static ValidationContext updateSmallFile(FileWriteRequest msg, ValidationContext ctx) {
        ctx = DataApiValidator.updateFile(msg, ctx);
        ctx.push(FWR_CONTENT).apply(CommonValidators::required).apply(DataApiValidator::contentNotEmpty, ByteString.class).pop();
        return ctx;
    }

    private static ValidationContext createOrUpdateFile(FileWriteRequest msg, ValidationContext ctx) {
        ctx = ctx.push(FWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(FWR_TAG_UPDATES).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, false).pop();
        ctx = ctx.push(FWR_NAME).apply(CommonValidators::required).apply(CommonValidators::fileName).apply(CommonValidators::notTracReserved).pop();
        ctx = ctx.push(FWR_MIME_TYPE).apply(CommonValidators::required).apply(CommonValidators::mimeType).pop();
        ctx = ctx.push(FWR_SIZE).apply(CommonValidators::optional).apply(CommonValidators::notNegative, Long.class).pop();
        return ctx;
    }

    @Validator(method="readFile")
    public static ValidationContext readFile(FileReadRequest msg, ValidationContext ctx) {
        ctx = ctx.push(FRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(FRR_SELECTOR).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.FILE).pop();
        return ctx;
    }

    @Validator(method="readSmallFile")
    public static ValidationContext readSmallFile(FileReadRequest msg, ValidationContext ctx) {
        return DataApiValidator.readFile(msg, ctx);
    }

    private static ValidationContext contentNotEmpty(ByteString content, ValidationContext ctx) {
        if (content.isEmpty()) {
            return ctx.error("Content cannot be empty");
        }
        return ctx;
    }
}

