/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.api;

import com.google.protobuf.Descriptors;
import java.util.HashSet;
import java.util.Set;
import org.finos.tracdap.api.Metadata;
import org.finos.tracdap.api.MetadataBatchRequest;
import org.finos.tracdap.api.MetadataGetRequest;
import org.finos.tracdap.api.MetadataReadRequest;
import org.finos.tracdap.api.MetadataSearchRequest;
import org.finos.tracdap.api.MetadataWriteBatchRequest;
import org.finos.tracdap.api.MetadataWriteRequest;
import org.finos.tracdap.api.UniversalMetadataWriteBatchRequest;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationFunction;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.ObjectValidator;
import org.finos.tracdap.common.validation.static_.SearchValidator;
import org.finos.tracdap.common.validation.static_.TagUpdateValidator;
import org.finos.tracdap.metadata.ObjectDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.SearchParameters;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TagUpdate;

@Validator(type=ValidationType.STATIC, serviceFile=Metadata.class, serviceName="tracdap.api.TracMetadataApi")
public class MetadataApiValidator {
    public static final boolean PUBLIC_API = false;
    public static final boolean TRUSTED_API = true;
    private static final Descriptors.Descriptor METADATA_WRITE_REQUEST = MetadataWriteRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor MWR_TENANT = ValidatorUtils.field(METADATA_WRITE_REQUEST, 1);
    private static final Descriptors.FieldDescriptor MWR_OBJECT_TYPE = ValidatorUtils.field(METADATA_WRITE_REQUEST, 2);
    private static final Descriptors.FieldDescriptor MWR_PRIOR_VERSION = ValidatorUtils.field(METADATA_WRITE_REQUEST, 3);
    private static final Descriptors.FieldDescriptor MWR_DEFINITION = ValidatorUtils.field(METADATA_WRITE_REQUEST, 4);
    private static final Descriptors.FieldDescriptor MWR_ATTRS = ValidatorUtils.field(METADATA_WRITE_REQUEST, 5);
    private static final Descriptors.Descriptor METADATA_READ_REQUEST = MetadataReadRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor MRR_TENANT = ValidatorUtils.field(METADATA_READ_REQUEST, 1);
    private static final Descriptors.FieldDescriptor MRR_SELECTOR = ValidatorUtils.field(METADATA_READ_REQUEST, 2);
    private static final Descriptors.Descriptor BATCH_READ_REQUEST = MetadataBatchRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor BRR_TENANT = ValidatorUtils.field(BATCH_READ_REQUEST, 1);
    private static final Descriptors.FieldDescriptor BRR_SELECTORS = ValidatorUtils.field(BATCH_READ_REQUEST, 2);
    private static final Descriptors.Descriptor BATCH_WRITE_REQUEST = MetadataWriteBatchRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor BWR_TENANT = ValidatorUtils.field(BATCH_WRITE_REQUEST, 1);
    private static final Descriptors.FieldDescriptor BWR_REQUESTS = ValidatorUtils.field(BATCH_WRITE_REQUEST, 2);
    private static final Descriptors.FieldDescriptor BWR_BATCH_ATTRS = ValidatorUtils.field(BATCH_WRITE_REQUEST, 3);
    private static final Descriptors.Descriptor METADATA_SEARCH_REQUEST = MetadataSearchRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor MSR_TENANT = ValidatorUtils.field(METADATA_SEARCH_REQUEST, 1);
    private static final Descriptors.FieldDescriptor MSR_SEARCH_PARAMS = ValidatorUtils.field(METADATA_SEARCH_REQUEST, 2);
    private static final Descriptors.Descriptor METADATA_GET_REQUEST = MetadataGetRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor MGR_TENANT = ValidatorUtils.field(METADATA_GET_REQUEST, 1);
    private static final Descriptors.FieldDescriptor MGR_OBJECT_TYPE = ValidatorUtils.field(METADATA_GET_REQUEST, 2);
    private static final Descriptors.FieldDescriptor MGR_OBJECT_ID = ValidatorUtils.field(METADATA_GET_REQUEST, 3);
    private static final Descriptors.FieldDescriptor MGR_OBJECT_VERSION = ValidatorUtils.field(METADATA_GET_REQUEST, 4);
    private static final Descriptors.FieldDescriptor MGR_TAG_VERSION = ValidatorUtils.field(METADATA_GET_REQUEST, 5);
    private static final Descriptors.Descriptor UNIVERSAL_METADATA_WRITE_BATCH_REQUEST = UniversalMetadataWriteBatchRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor UMWBR_TENANT = ValidatorUtils.field(UNIVERSAL_METADATA_WRITE_BATCH_REQUEST, 1);

    @Validator(method="writeBatch")
    public static ValidationContext writeBatch(UniversalMetadataWriteBatchRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.writeBatch(msg, ctx, false);
    }

    public static ValidationContext writeBatch(UniversalMetadataWriteBatchRequest msg, ValidationContext ctx, boolean apiTrust) {
        ctx = ctx.push(UMWBR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        HashSet<String> knownObjectIds = new HashSet<String>();
        ValidationFunction.Typed<MetadataWriteRequest> objectIdCheck = MetadataApiValidator.uniqueObjectIdCheck(knownObjectIds);
        ctx = ctx.pushRepeated(ValidatorUtils.field(UNIVERSAL_METADATA_WRITE_BATCH_REQUEST, 3)).applyRepeated((m, c) -> MetadataApiValidator.createObject(m, c, apiTrust, false), MetadataWriteRequest.class).applyRepeated(objectIdCheck, MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(ValidatorUtils.field(UNIVERSAL_METADATA_WRITE_BATCH_REQUEST, 2)).applyRepeated((m, c) -> MetadataApiValidator.createPreallocatedObject(m, c, false), MetadataWriteRequest.class).applyRepeated(objectIdCheck, MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(ValidatorUtils.field(UNIVERSAL_METADATA_WRITE_BATCH_REQUEST, 4)).applyRepeated((m, c) -> MetadataApiValidator.updateObject(m, c, apiTrust, false), MetadataWriteRequest.class).applyRepeated(objectIdCheck, MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(ValidatorUtils.field(UNIVERSAL_METADATA_WRITE_BATCH_REQUEST, 5)).applyRepeated((m, c) -> MetadataApiValidator.updateTag(m, c, apiTrust, false), MetadataWriteRequest.class).applyRepeated(objectIdCheck, MetadataWriteRequest.class).pop();
        return ctx;
    }

    @Validator(method="createObject")
    public static ValidationContext createObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.createObject(msg, ctx, false, true);
    }

    static ValidationContext createObject(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, boolean tenantRequired) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, apiTrust, tenantRequired);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    @Validator(method="createObjectBatch")
    public static ValidationContext createObjectBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.createObjectBatch(msg, ctx, false);
    }

    static ValidationContext createObjectBatch(MetadataWriteBatchRequest msg, ValidationContext ctx, boolean apiTrust) {
        ctx = ctx.push(BWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BWR_REQUESTS).apply(CommonValidators::listNotEmpty).applyRepeated((r, c) -> MetadataApiValidator.createObject(r, c, apiTrust, false), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(BWR_BATCH_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, apiTrust).pop();
        return ctx;
    }

    @Validator(method="updateObject")
    public static ValidationContext updateObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateObject(msg, ctx, false, true);
    }

    static ValidationContext updateObject(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, boolean tenantRequired) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, true, apiTrust, tenantRequired);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).apply(ObjectIdValidator::explicitObjectVersion, TagSelector.class).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    @Validator(method="updateObjectBatch")
    public static ValidationContext updateObjectBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateObjectBatch(msg, ctx, false);
    }

    static ValidationContext updateObjectBatch(MetadataWriteBatchRequest msg, ValidationContext ctx, boolean apiTrust) {
        ctx = ctx.push(BWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BWR_REQUESTS).apply(CommonValidators::listNotEmpty).applyRepeated((r, c) -> MetadataApiValidator.updateObject(r, c, apiTrust, false), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(BWR_BATCH_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, apiTrust).pop();
        return ctx;
    }

    @Validator(method="updateTag")
    public static ValidationContext updateTag(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateTag(msg, ctx, false, true);
    }

    static ValidationContext updateTag(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, boolean tenantRequired) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, apiTrust, tenantRequired);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).apply(ObjectIdValidator::explicitObjectVersion, TagSelector.class).apply(ObjectIdValidator::explicitTagVersion, TagSelector.class).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    @Validator(method="updateTagBatch")
    public static ValidationContext updateTagBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateTagBatch(msg, ctx, false);
    }

    static ValidationContext updateTagBatch(MetadataWriteBatchRequest msg, ValidationContext ctx, boolean apiTrust) {
        ctx = ctx.push(BWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BWR_REQUESTS).apply(CommonValidators::listNotEmpty).applyRepeated((r, c) -> MetadataApiValidator.updateTag(r, c, apiTrust, false), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(BWR_BATCH_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, apiTrust).pop();
        return ctx;
    }

    static ValidationContext preallocateId(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.preallocateId(msg, ctx, true);
    }

    private static ValidationContext preallocateId(MetadataWriteRequest msg, ValidationContext ctx, boolean tenantRequired) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, true, tenantRequired);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    static ValidationContext preallocateIdBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(BWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BWR_REQUESTS).apply(CommonValidators::listNotEmpty).applyRepeated((r, c) -> MetadataApiValidator.preallocateId(r, c, false), MetadataWriteRequest.class).pop();
        return ctx;
    }

    static ValidationContext createPreallocatedObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.createPreallocatedObject(msg, ctx, true);
    }

    private static ValidationContext createPreallocatedObject(MetadataWriteRequest msg, ValidationContext ctx, boolean tenantRequired) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, true, tenantRequired);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::preallocated, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    static ValidationContext createPreallocatedObjectBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(BWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BWR_REQUESTS).apply(CommonValidators::listNotEmpty).applyRepeated((r, c) -> MetadataApiValidator.createPreallocatedObject(r, c, false), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(BWR_BATCH_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, true).pop();
        return ctx;
    }

    private static ValidationContext createOrUpdate(ValidationContext ctx, boolean isVersioned, boolean apiTrust, boolean tenantRequired) {
        ctx = tenantRequired ? ctx.push(MWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop() : ctx.push(MWR_TENANT).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MWR_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ObjectType.class).applyIf(isVersioned, ObjectIdValidator::versioningSupported, ObjectType.class).pop();
        ctx = ctx.pushRepeated(MWR_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, apiTrust).pop();
        return ctx;
    }

    @Validator(method="readObject")
    public static ValidationContext readObject(MetadataReadRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MRR_SELECTOR).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).pop();
        return ctx;
    }

    @Validator(method="readBatch")
    public static ValidationContext readBatch(MetadataBatchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(BRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BRR_SELECTORS).apply(CommonValidators::listNotEmpty).applyRepeated(ObjectIdValidator::tagSelector, TagSelector.class).pop();
        return ctx;
    }

    @Validator(method="search")
    public static ValidationContext search(MetadataSearchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MSR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MSR_SEARCH_PARAMS).apply(CommonValidators::required).apply(SearchValidator::searchParameters, SearchParameters.class).pop();
        return ctx;
    }

    @Validator(method="getObject")
    public static ValidationContext getObject(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        return ctx;
    }

    @Validator(method="getObject")
    public static ValidationContext getLatestObject(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    @Validator(method="getObject")
    public static ValidationContext getLatestTag(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    private static ValidationContext getRequest(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MGR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MGR_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, ObjectType.class).pop();
        ctx = ctx.push(MGR_OBJECT_ID).apply(CommonValidators::required).apply(CommonValidators::uuid).pop();
        return ctx;
    }

    private static ValidationFunction.Typed<MetadataWriteRequest> uniqueObjectIdCheck(Set<String> knownObjectIds) {
        return (request, ctx) -> {
            String objectId = request.getPriorVersion().getObjectId();
            if (request.getPriorVersion().getObjectId().isEmpty()) {
                return ctx;
            }
            if (knownObjectIds.contains(objectId)) {
                String err = String.format("object ID [%s] is already modified in the write batch", objectId);
                return ctx.error(err);
            }
            knownObjectIds.add(objectId);
            return ctx;
        };
    }
}

