/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import org.finos.tracdap.common.exception.EUnexpected;

class ValidationLocation {
    private final ValidationLocation parent;
    private final Object target;
    private final Descriptors.MethodDescriptor method;
    private final Descriptors.OneofDescriptor oneOf;
    private final Descriptors.FieldDescriptor field;
    private final String fieldName;
    private boolean failed;
    private boolean skipped;

    public ValidationLocation(ValidationLocation parent, Object target, Descriptors.MethodDescriptor method, Descriptors.OneofDescriptor oneOf, Descriptors.FieldDescriptor field, String fieldName) {
        this.parent = parent;
        this.target = target;
        this.method = method;
        this.oneOf = oneOf;
        this.field = field;
        this.fieldName = fieldName;
        this.failed = false;
        this.skipped = false;
    }

    public ValidationLocation(ValidationLocation parent, Object target, Descriptors.OneofDescriptor oneOf, Descriptors.FieldDescriptor field, String fieldName) {
        this(parent, target, null, oneOf, field, fieldName);
    }

    public ValidationLocation(ValidationLocation parent, Object target, Descriptors.FieldDescriptor field, String fieldName) {
        this(parent, target, null, field, fieldName);
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String elementPath() {
        if (this.isRoot()) {
            return "";
        }
        if (this.parent.isRoot()) {
            return this.fieldName;
        }
        if (this.isRepeated() && this.field == this.parent.field) {
            return this.parent.elementPath() + "[" + this.fieldName + "]";
        }
        return this.parent.elementPath() + "." + this.fieldName;
    }

    public ValidationLocation parent() {
        return this.parent;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object target() {
        return this.target;
    }

    public Descriptors.MethodDescriptor method() {
        return this.method;
    }

    public boolean isOneOf() {
        return this.oneOf != null;
    }

    public boolean isRepeated() {
        return this.field != null && this.field.isRepeated();
    }

    public Descriptors.OneofDescriptor oneOf() {
        return this.oneOf;
    }

    public Descriptors.FieldDescriptor field() {
        return this.field;
    }

    public boolean failed() {
        return this.failed;
    }

    public boolean skipped() {
        return this.skipped;
    }

    public boolean done() {
        return this.failed || this.skipped;
    }

    void fail() {
        this.failed = true;
    }

    void skip() {
        this.skipped = true;
    }

    Message msg() {
        if (!(this.target instanceof Message)) {
            throw new EUnexpected();
        }
        return (Message)this.target;
    }

    public List<ValidationLocation> stack() {
        return this.stack(0);
    }

    private List<ValidationLocation> stack(int depth) {
        List<Object> stack = this.parent == null ? new ArrayList(depth + 1) : this.parent.stack(depth + 1);
        stack.set(depth, this);
        return stack;
    }
}

