/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.impl.ValidationFailure;

public class ValidationResult {
    private static final String MULTIPLE_ERRORS_MESSAGE = "There were multiple validation errors";
    private final List<ValidationFailure> failures;

    public static ValidationResult pass() {
        return new ValidationResult(List.of());
    }

    public static ValidationResult forContext(ValidationContext ctx) {
        return new ValidationResult(ctx.getErrors());
    }

    public ValidationResult(List<ValidationFailure> failures) {
        this.failures = Collections.unmodifiableList(failures);
    }

    public boolean ok() {
        return this.failures.isEmpty();
    }

    public List<ValidationFailure> failures() {
        return this.failures;
    }

    public String failureMessage() {
        if (this.failures.isEmpty()) {
            return "";
        }
        if (this.failures.size() == 1) {
            return this.failures.get(0).message();
        }
        return "There were multiple validation errors\n" + this.failures().stream().map(ValidationFailure::message).collect(Collectors.joining("\n"));
    }
}

