/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.validation.api.DataApiValidator;
import org.finos.tracdap.common.validation.core.ValidationFunction;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.impl.ValidationKey;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.version.SchemaVersionValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidatorBuilder {
    private static final Logger log = LoggerFactory.getLogger(ValidatorBuilder.class);
    private static final String GET_DESCRIPTOR_METHOD = "getDescriptor";

    public static Map<ValidationKey, ValidationFunction<?>> buildValidatorMap() {
        Package apiValidatorPackage = DataApiValidator.class.getPackage();
        Package staticValidatorPackage = ObjectIdValidator.class.getPackage();
        Package versionValidatorPackage = SchemaVersionValidator.class.getPackage();
        return ValidatorBuilder.scanPackages(apiValidatorPackage, staticValidatorPackage, versionValidatorPackage);
    }

    public static Map<ValidationKey, ValidationFunction<?>> scanPackages(Package ... packages) {
        HashMap validatorMap = new HashMap();
        for (Package package_ : packages) {
            Map<ValidationKey, ValidationFunction<?>> packageValidators = ValidatorBuilder.scanPackage(package_);
            validatorMap.putAll(packageValidators);
        }
        return validatorMap;
    }

    public static Map<ValidationKey, ValidationFunction<?>> scanPackage(Package package_) {
        try {
            HashMap validatorMap = new HashMap();
            ClassPath classPath = ClassPath.from((ClassLoader)ValidatorBuilder.class.getClassLoader());
            ImmutableSet classes = classPath.getTopLevelClasses(package_.getName());
            for (ClassPath.ClassInfo classInfo : classes) {
                Class class_ = classInfo.load();
                if (!class_.isAnnotationPresent(Validator.class)) continue;
                Map<ValidationKey, ValidationFunction<?>> validators = ValidatorBuilder.scanClass(class_);
                validatorMap.putAll(validators);
            }
            return validatorMap;
        }
        catch (IOException e) {
            log.error("Failed to set up validation: Error scanning validation classes", (Throwable)e);
            throw new EUnexpected((Throwable)e);
        }
    }

    public static Map<ValidationKey, ValidationFunction<?>> scanClass(Class<?> class_) {
        HashMap validatorMap = new HashMap();
        if (!class_.isAnnotationPresent(Validator.class)) {
            throw new EUnexpected();
        }
        Validator classAnnotation = class_.getAnnotation(Validator.class);
        for (Method method : class_.getDeclaredMethods()) {
            Map.Entry<ValidationKey, ValidationFunction<?>> validator;
            String methodName;
            ValidationType validationType;
            if (!method.isAnnotationPresent(Validator.class)) continue;
            Validator methodAnnotation = method.getAnnotation(Validator.class);
            Class<?>[] methodParams = method.getParameterTypes();
            if (methodParams.length < 2 || !Message.class.isAssignableFrom(methodParams[0])) {
                throw new EUnexpected();
            }
            ValidationType validationType2 = validationType = methodAnnotation.type() != ValidationType.UNDEFINED ? methodAnnotation.type() : classAnnotation.type();
            Class<? extends Message> objectType = methodAnnotation.object() != Message.class ? methodAnnotation.object() : (classAnnotation.object() != Message.class ? classAnnotation.object() : methodParams[0]);
            Class<?> serviceFile = methodAnnotation.serviceFile() != Object.class ? methodAnnotation.serviceFile() : classAnnotation.serviceFile();
            String serviceName = !methodAnnotation.serviceName().isEmpty() ? methodAnnotation.serviceName() : classAnnotation.serviceName();
            String string = methodName = !methodAnnotation.method().isEmpty() ? methodAnnotation.method() : classAnnotation.method();
            if (validationType == ValidationType.STATIC && methodName.isEmpty()) {
                validator = ValidatorBuilder.buildObjectValidator(objectType, method);
            } else if (validationType == ValidationType.STATIC) {
                validator = ValidatorBuilder.buildMethodValidator(serviceFile, serviceName, methodName, objectType, method);
            } else if (validationType == ValidationType.VERSION) {
                validator = ValidatorBuilder.buildVersionValidator(objectType, method);
            } else {
                throw new EUnexpected();
            }
            validatorMap.put(validator.getKey(), validator.getValue());
        }
        return validatorMap;
    }

    private static Map.Entry<ValidationKey, ValidationFunction<?>> buildObjectValidator(Class<?> objectType, Method validationFunc) {
        try {
            Method descriptorFunc = objectType.getMethod(GET_DESCRIPTOR_METHOD, new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)descriptorFunc.invoke(null, new Object[0]);
            ValidationKey key = ValidationKey.forObject(descriptor);
            ValidationFunction<?> func = ValidationFunction.makeTyped(validationFunc, objectType);
            return Map.entry(key, func);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to set up validation: Descriptor lookup failed", (Throwable)e);
            throw new EUnexpected((Throwable)e);
        }
    }

    private static Map.Entry<ValidationKey, ValidationFunction<?>> buildMethodValidator(Class<?> serviceFile, String serviceName, String methodName, Class<?> objectType, Method validationFunc) {
        try {
            String[] serviceNameParts = serviceName.split("\\.");
            serviceName = serviceNameParts[serviceNameParts.length - 1];
            Method fileDescriptorFunc = serviceFile.getMethod(GET_DESCRIPTOR_METHOD, new Class[0]);
            Descriptors.FileDescriptor fileDescriptor = (Descriptors.FileDescriptor)fileDescriptorFunc.invoke(null, new Object[0]);
            Descriptors.ServiceDescriptor serviceDescriptor = fileDescriptor.findServiceByName(serviceName);
            Descriptors.MethodDescriptor serviceMethod = serviceDescriptor.findMethodByName(methodName);
            Method descriptorFunc = objectType.getMethod(GET_DESCRIPTOR_METHOD, new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)descriptorFunc.invoke(null, new Object[0]);
            if (!descriptor.equals(serviceMethod.getInputType())) {
                throw new EUnexpected();
            }
            ValidationKey key = ValidationKey.forMethod(serviceMethod.getInputType(), serviceMethod);
            ValidationFunction<?> func = ValidationFunction.makeTyped(validationFunc, objectType);
            return Map.entry(key, func);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to set up validation: Descriptor lookup failed", (Throwable)e);
            throw new EUnexpected((Throwable)e);
        }
    }

    private static Map.Entry<ValidationKey, ValidationFunction<?>> buildVersionValidator(Class<?> objectType, Method validationFunc) {
        try {
            Method descriptorFunc = objectType.getMethod(GET_DESCRIPTOR_METHOD, new Class[0]);
            Descriptors.Descriptor descriptor = (Descriptors.Descriptor)descriptorFunc.invoke(null, new Object[0]);
            ValidationKey key = ValidationKey.forVersion(descriptor);
            ValidationFunction<?> func = ValidationFunction.makeVersion(validationFunc, objectType);
            return Map.entry(key, func);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to set up validation: Descriptor lookup failed", (Throwable)e);
            throw new EUnexpected((Throwable)e);
        }
    }
}

