/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.common.metadata.MetadataConstants;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.ValidationConstants;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationFunction;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.DecimalValue;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

public class CommonValidators {
    public static ValidationContext required(ValidationContext ctx) {
        return CommonValidators.required(ctx, null);
    }

    private static ValidationContext required(ValidationContext ctx, String qualifier) {
        String err = qualifier != null ? String.format("A value is required for [%s] %s", ctx.fieldName(), qualifier) : String.format("A value is required for [%s]", ctx.fieldName());
        Message parentMsg = ctx.parentMsg();
        if (ctx.isOneOf()) {
            if (!parentMsg.hasOneof(ctx.oneOf())) {
                return ctx.error(err);
            }
        } else if (ctx.isRepeated()) {
            if (parentMsg.getRepeatedFieldCount(ctx.field()) == 0) {
                return ctx.error(err);
            }
        } else {
            String str;
            if (!parentMsg.hasField(ctx.field())) {
                return ctx.error(err);
            }
            if (ctx.field().getType() == Descriptors.FieldDescriptor.Type.STRING && (str = (String)ctx.target()).isEmpty()) {
                return ctx.error(err);
            }
        }
        return ctx;
    }

    public static ValidationContext omitted(ValidationContext ctx) {
        return CommonValidators.omitted(ctx, null);
    }

    private static ValidationContext omitted(ValidationContext ctx, String qualifier) {
        String err = qualifier != null ? String.format("A value cannot be given for [%s] %s", ctx.fieldName(), qualifier) : String.format("A value cannot be given for [%s]", ctx.fieldName());
        Message parentMsg = ctx.parentMsg();
        if (ctx.isOneOf() ? parentMsg.hasOneof(ctx.oneOf()) : (ctx.isRepeated() ? parentMsg.getRepeatedFieldCount(ctx.field()) != 0 : parentMsg.hasField(ctx.field()))) {
            return ctx.error(err);
        }
        return ctx.skip();
    }

    public static ValidationContext optional(ValidationContext ctx) {
        Message parentMsg = ctx.parentMsg();
        if (ctx.isOneOf() ? !parentMsg.hasOneof(ctx.oneOf()) : (ctx.isRepeated() ? parentMsg.getRepeatedFieldCount(ctx.field()) == 0 : !parentMsg.hasField(ctx.field()))) {
            return ctx.skip();
        }
        return ctx;
    }

    public static ValidationFunction.Basic ifAndOnlyIf(boolean condition, String qualifier) {
        return CommonValidators.ifAndOnlyIf(condition, qualifier, false);
    }

    public static ValidationFunction.Basic ifAndOnlyIf(boolean condition, String qualifier, boolean inverted) {
        String positiveQualifier = (inverted ? "unless " : "when ") + qualifier;
        String negativeQualifier = (inverted ? "when " : "unless ") + qualifier;
        if (condition) {
            return ctx -> CommonValidators.required(ctx, positiveQualifier);
        }
        return ctx -> CommonValidators.omitted(ctx, negativeQualifier);
    }

    public static <T> ValidationFunction.Typed<T> equalTo(T other, String errorMessage) {
        return (value, ctx) -> {
            if (!value.equals(other)) {
                ctx.error(errorMessage);
            }
            return ctx;
        };
    }

    public static ValidationContext primitiveType(BasicType basicType, ValidationContext ctx) {
        if (!TypeSystem.isPrimitive((BasicType)basicType)) {
            String err = String.format("Type specified in [%s] is not a primitive type: [%s]", ctx.fieldName(), basicType);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext primitiveType(TypeDescriptor typeDescriptor, ValidationContext ctx) {
        if (!TypeSystem.isPrimitive((TypeDescriptor)typeDescriptor)) {
            String err = String.format("Type specified in [%s] is not a primitive type: [%s]", ctx.fieldName(), typeDescriptor.getBasicType());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext primitiveValue(Value value, ValidationContext ctx) {
        if (!TypeSystem.isPrimitive((Value)value)) {
            String err = String.format("Value [%s] is not a primitive value: [%s]", ctx.fieldName(), TypeSystem.basicType((Value)value));
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext uuid(String value, ValidationContext ctx) {
        try {
            UUID uUID = UUID.fromString(value);
        }
        catch (IllegalArgumentException e) {
            String err = String.format("Value of [%s] is not a valid object ID: [%s]", ctx.fieldName(), value);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext decimal(String value, ValidationContext ctx) {
        if (ctx.field().getType() != Descriptors.FieldDescriptor.Type.STRING) {
            throw new EUnexpected();
        }
        try {
            MetadataCodec.DECIMAL_FORMAT.parse(value);
            return ctx;
        }
        catch (ParseException e) {
            String err = String.format("Value of [%s] is not a valid decimal: [%s] %s", ctx.fieldName(), value, e.getMessage());
            return ctx.error(err);
        }
    }

    public static ValidationContext isoDate(String value, ValidationContext ctx) {
        if (ctx.field().getType() != Descriptors.FieldDescriptor.Type.STRING) {
            throw new EUnexpected();
        }
        try {
            MetadataCodec.ISO_DATE_FORMAT.parse((CharSequence)value, LocalDate::from);
            return ctx;
        }
        catch (DateTimeParseException e) {
            String err = String.format("Value of [%s] is not a valid date: [%s] %s", ctx.fieldName(), value, e.getMessage());
            return ctx.error(err);
        }
    }

    public static ValidationContext isoDatetime(String value, ValidationContext ctx) {
        if (ctx.field().getType() != Descriptors.FieldDescriptor.Type.STRING) {
            throw new EUnexpected();
        }
        try {
            MetadataCodec.ISO_DATETIME_INPUT_FORMAT.parseBest(value, OffsetDateTime::from, Instant::from);
            return ctx;
        }
        catch (DateTimeParseException e) {
            String err = String.format("Value of [%s] is not a valid datetime: [%s] %s", ctx.fieldName(), value, e.getMessage());
            return ctx.error(err);
        }
    }

    public static ValidationContext identifier(String value, ValidationContext ctx) {
        return CommonValidators.regexMatch(MetadataConstants.VALID_IDENTIFIER, true, "is not a valid identifier", value, ctx);
    }

    public static ValidationContext notTracReserved(String value, ValidationContext ctx) {
        return CommonValidators.regexMatch(MetadataConstants.TRAC_RESERVED_IDENTIFIER, false, "is a TRAC reserved identifier", value, ctx);
    }

    public static ValidationContext mimeType(String value, ValidationContext ctx) {
        if ((ctx = CommonValidators.regexMatch(ValidationConstants.MIME_TYPE, true, "is not a valid mime type", value, ctx)).failed()) {
            return ctx;
        }
        String mainType = value.substring(0, value.indexOf("/"));
        if (!ValidationConstants.REGISTERED_MIME_TYPES.contains(mainType)) {
            String err = String.format("Value of [%s] is not a registered mime type: [%s]", ctx.fieldName(), value);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext fileName(String value, ValidationContext ctx) {
        ctx = ctx.apply(CommonValidators::pathAlwaysIllegal);
        ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_CHARS, false, "contains characters not allowed in a filename (:, / or \\)", value, ctx);
        ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_START, false, "starts with a space character", value, ctx);
        ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_ENDING, false, "ends with a space or period character", value, ctx);
        ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_RESERVED, false, "is a reserved filename", value, ctx);
        return ctx;
    }

    public static ValidationContext relativePath(String path, ValidationContext ctx) {
        ctx = ctx.apply(CommonValidators::pathAlwaysIllegal);
        if (path.contains("/") && path.contains("\\")) {
            ctx = ctx.error("Path contains both Windows and Unix separators (use one or the other, not both)");
        }
        ctx = CommonValidators.regexMatch(ValidationConstants.RELATIVE_PATH_ILLEGAL_CHARS, false, "contains characters not allowed in a relative path (:)", path, ctx);
        ctx = CommonValidators.regexMatch(ValidationConstants.RELATIVE_PATH_IS_ABSOLUTE, false, "is an absolute path", path, ctx);
        if ((ctx = CommonValidators.regexMatch(ValidationConstants.RELATIVE_PATH_DOUBLE_SLASH, false, "contains a double slash", path, ctx)).failed()) {
            return ctx;
        }
        String[] segments = path.split(ValidationConstants.PATH_SEPARATORS.pattern());
        Predicate<String> singleDotPredicate = ValidationConstants.PATH_SINGLE_DOT.asPredicate();
        Predicate<String> doubleDotPredicate = ValidationConstants.PATH_SINGLE_DOT.asPredicate();
        for (String segment : segments) {
            ctx = CommonValidators.regexMatch(ValidationConstants.PATH_DOUBLE_DOT, false, "segment refers to parent directory", segment, ctx);
            if (segments.length > 1) {
                ctx = CommonValidators.regexMatch(ValidationConstants.PATH_SINGLE_DOT, false, "segment refers to itself and can be omitted", segment, ctx);
            }
            if (singleDotPredicate.test(segment) || doubleDotPredicate.test(segment)) continue;
            ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_CHARS, false, "segment contains characters illegal characters", segment, ctx);
            ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_START, false, "segment starts with a space character", segment, ctx);
            ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_ILLEGAL_ENDING, false, "segment ends with a space or period character", segment, ctx);
            ctx = CommonValidators.regexMatch(ValidationConstants.FILENAME_RESERVED, false, "segment is a reserved filename", segment, ctx);
        }
        return ctx;
    }

    private static ValidationContext pathAlwaysIllegal(String path, ValidationContext ctx) {
        ctx = CommonValidators.regexMatch(ValidationConstants.PATH_ILLEGAL_CHARS, false, "contains illegal characters", path, ctx);
        ctx = CommonValidators.regexMatch(ValidationConstants.PATH_ILLEGAL_WHITESPACE, false, "contains non-standard whitespace (tab, return, form-feed etc.)", path, ctx);
        if (!ValidationConstants.PATH_ILLEGAL_WHITESPACE.matcher(path).matches()) {
            ctx = CommonValidators.regexMatch(ValidationConstants.PATH_ILLEGAL_CTRL, false, "contains ASCII control characters", path, ctx);
        }
        return ctx;
    }

    private static ValidationContext regexMatch(Pattern regex, boolean invertMatch, String desc, String value, ValidationContext ctx) {
        Matcher matcher = regex.matcher(value);
        if (matcher.matches() ^ invertMatch) {
            String err = String.format("[%s] %s: [%s]", ctx.fieldName(), desc, value);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext notNegative(Object value, ValidationContext ctx) {
        boolean negative;
        switch (ctx.field().getJavaType()) {
            case INT: {
                negative = (Integer)value < 0;
                break;
            }
            case LONG: {
                negative = (Long)value < 0L;
                break;
            }
            case FLOAT: {
                negative = ((Float)value).floatValue() < 0.0f;
                break;
            }
            case DOUBLE: {
                negative = (Double)value < 0.0;
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msgType = ctx.field().getMessageType();
                if (msgType.equals(DecimalValue.getDescriptor())) {
                    DecimalValue decimalMsg = (DecimalValue)value;
                    BigDecimal decimalValue = new BigDecimal(decimalMsg.getDecimal());
                    negative = !decimalValue.abs().equals(decimalValue);
                    break;
                }
            }
            default: {
                throw new EUnexpected();
            }
        }
        if (negative) {
            String err = String.format("Value of [%s] cannot be negative: [%s]", ctx.fieldName(), value);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext optionalTrue(boolean value, ValidationContext ctx) {
        if (!value) {
            String err = String.format("Optional field [%s] must either be omitted or set to 'true'", ctx.fieldName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext positive(Object value, ValidationContext ctx) {
        boolean positive;
        switch (ctx.field().getJavaType()) {
            case INT: {
                positive = (Integer)value > 0;
                break;
            }
            case LONG: {
                positive = (Long)value > 0L;
                break;
            }
            case FLOAT: {
                positive = ((Float)value).floatValue() > 0.0f;
                break;
            }
            case DOUBLE: {
                positive = (Double)value > 0.0;
                break;
            }
            case MESSAGE: {
                Descriptors.Descriptor msgType = ctx.field().getMessageType();
                if (msgType.equals(DecimalValue.getDescriptor())) {
                    DecimalValue decimalMsg = (DecimalValue)value;
                    BigDecimal decimalValue = new BigDecimal(decimalMsg.getDecimal());
                    positive = decimalValue.abs().equals(decimalValue) && !decimalValue.equals(BigDecimal.ZERO);
                    break;
                }
            }
            default: {
                throw new EUnexpected();
            }
        }
        if (!positive) {
            String err = String.format("Value of [%s] must be positive: [%s]", ctx.fieldName(), value);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext recognizedEnum(ProtocolMessageEnum protoEnum, ValidationContext ctx) {
        if (protoEnum.getNumber() < 0) {
            String err = String.format("Unrecognised value specified for [%s]: [%s]", ctx.fieldName(), protoEnum.getValueDescriptor().getName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext nonZeroEnum(ProtocolMessageEnum protoEnum, ValidationContext ctx) {
        if (protoEnum.getNumber() <= 0) {
            String err = String.format("Unrecognised value specified for [%s]: [%s]", ctx.fieldName(), protoEnum.getValueDescriptor().getName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext listNotEmpty(ValidationContext ctx) {
        if (!ctx.field().isRepeated() || ctx.field().isMapField()) {
            throw new ETracInternal("Validator [listNotEmpty] can only be applied to repeated fields (and not map fields)");
        }
        int nItems = ctx.parentMsg().getRepeatedFieldCount(ctx.field());
        if (nItems == 0) {
            String err = String.format("The list of [%s] contains no items", ctx.fieldName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext mapNotEmpty(ValidationContext ctx) {
        if (!ctx.field().isMapField()) {
            throw new ETracInternal("Validator [mapNotEmpty] can only be applied to map fields");
        }
        int nItems = ctx.parentMsg().getRepeatedFieldCount(ctx.field());
        if (nItems == 0) {
            String err = String.format("The map of [%s] contains no entries", ctx.fieldName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext bytesNotEmpty(ByteString content, ValidationContext ctx) {
        if (content.isEmpty()) {
            return ctx.error(String.format("[%s] cannot be empty", ctx.fieldName()));
        }
        return ctx;
    }

    public static ValidationContext caseInsensitiveDuplicates(ValidationContext ctx) {
        int itemCount = ctx.parentMsg().getRepeatedFieldCount(ctx.field());
        HashMap knownItems = new HashMap(itemCount);
        try (Stream<String> items = CommonValidators.caseInsensitiveDuplicatesItems(ctx);){
            items.forEach(itemCase -> {
                String lowerCase = itemCase.toLowerCase();
                String priorCase = knownItems.getOrDefault(lowerCase, null);
                if (priorCase == null) {
                    knownItems.put(lowerCase, itemCase);
                } else if (itemCase.equals(priorCase)) {
                    String err = String.format("[%s] is included more than once in [%s]", itemCase, ctx.fieldName());
                    ctx.error(err);
                } else {
                    String err = String.format("In [%s], [%s] and [%s] differ only by case", ctx.fieldName(), priorCase, itemCase);
                    ctx.error(err);
                }
            });
        }
        return ctx;
    }

    private static Stream<String> caseInsensitiveDuplicatesItems(ValidationContext ctx) {
        if (ctx.isMap()) {
            Descriptors.FieldDescriptor keyField = ctx.field().getMessageType().findFieldByNumber(1);
            if (keyField.getType() != Descriptors.FieldDescriptor.Type.STRING) {
                throw new ETracInternal("[caseInsensitiveDuplicates] can only be applied to repeated string fields or maps with string keys");
            }
            if (ctx.target() instanceof Map) {
                Map map = (Map)ctx.target();
                return map.keySet().stream().map(Object::toString);
            }
            List entries = (List)ctx.target();
            return entries.stream().map(MapEntry::getKey).map(Object::toString);
        }
        if (ctx.isRepeated()) {
            if (ctx.field().getType() != Descriptors.FieldDescriptor.Type.STRING) {
                throw new ETracInternal("[caseInsensitiveDuplicates] can only be applied to repeated string fields or maps with string keys");
            }
            List list = (List)ctx.target();
            return list.stream();
        }
        throw new ETracInternal("[caseInsensitiveDuplicates] can only be applied to repeated string fields or maps with string keys");
    }
}

