/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import org.finos.tracdap.common.metadata.PartKeys;
import org.finos.tracdap.common.validation.ValidationConstants;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.SchemaValidator;
import org.finos.tracdap.common.validation.static_.StorageValidator;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.DataDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.PartKey;
import org.finos.tracdap.metadata.PartType;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class DataValidator {
    private static final Descriptors.Descriptor DATA_DEFINITION = DataDefinition.getDescriptor();
    private static final Descriptors.OneofDescriptor DD_SCHEMA_SPECIFIER = ValidatorUtils.field(DATA_DEFINITION, 1).getContainingOneof();
    private static final Descriptors.FieldDescriptor DD_SCHEMA_ID = ValidatorUtils.field(DATA_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor DD_SCHEMA = ValidatorUtils.field(DATA_DEFINITION, 2);
    private static final Descriptors.FieldDescriptor DD_PARTS = ValidatorUtils.field(DATA_DEFINITION, 3);
    private static final Descriptors.FieldDescriptor DD_STORAGE_ID = ValidatorUtils.field(DATA_DEFINITION, 4);
    private static final Descriptors.Descriptor PART_KEY = PartKey.getDescriptor();
    private static final Descriptors.FieldDescriptor PK_OPAQUE_KEY = ValidatorUtils.field(PART_KEY, 1);
    private static final Descriptors.FieldDescriptor PK_PART_TYPE = ValidatorUtils.field(PART_KEY, 2);
    private static final Descriptors.FieldDescriptor PK_PART_VALUES = ValidatorUtils.field(PART_KEY, 3);
    private static final Descriptors.FieldDescriptor PK_PART_RANGE_MIN = ValidatorUtils.field(PART_KEY, 4);
    private static final Descriptors.FieldDescriptor PK_PART_RANGE_MAX = ValidatorUtils.field(PART_KEY, 5);
    private static final Descriptors.Descriptor DATA_PART = DataDefinition.Part.getDescriptor();
    private static final Descriptors.FieldDescriptor DP_PART_KEY = ValidatorUtils.field(DATA_PART, 1);
    private static final Descriptors.FieldDescriptor DP_SNAP = ValidatorUtils.field(DATA_PART, 2);
    private static final Descriptors.Descriptor DATA_SNAP = DataDefinition.Snap.getDescriptor();
    private static final Descriptors.FieldDescriptor DS_SNAP_INDEX = ValidatorUtils.field(DATA_SNAP, 1);
    private static final Descriptors.FieldDescriptor DS_DELTAS = ValidatorUtils.field(DATA_SNAP, 2);
    private static final Descriptors.Descriptor DATA_DELTA = DataDefinition.Delta.getDescriptor();
    private static final Descriptors.FieldDescriptor DD_DELTA_INDEX = ValidatorUtils.field(DATA_DELTA, 1);
    private static final Descriptors.FieldDescriptor DD_DATA_ITEM = ValidatorUtils.field(DATA_DELTA, 2);

    @Validator
    public static ValidationContext dataDefinition(DataDefinition msg, ValidationContext ctx) {
        ctx = ctx.pushOneOf(DD_SCHEMA_SPECIFIER).apply(CommonValidators::required).applyOneOf(DD_SCHEMA_ID, ObjectIdValidator::tagSelector, TagSelector.class).applyOneOf(DD_SCHEMA_ID, ObjectIdValidator::selectorType, TagSelector.class, ObjectType.SCHEMA).applyOneOf(DD_SCHEMA_ID, ObjectIdValidator::fixedObjectVersion, TagSelector.class).applyOneOf(DD_SCHEMA, SchemaValidator::schema, SchemaDefinition.class).pop();
        ctx = ctx.pushMap(DD_PARTS, DataDefinition::getPartsMap).apply(CommonValidators::mapNotEmpty).applyMapKeys(DataValidator::opaqueKey).applyMapValues(DataValidator::dataPart, DataDefinition.Part.class).apply(DataValidator::partMapIsConsistent, Map.class).pop();
        ctx = ctx.push(DD_STORAGE_ID).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.STORAGE).apply(ObjectIdValidator::selectorForLatest, TagSelector.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext dataPart(DataDefinition.Part msg, ValidationContext ctx) {
        ctx = ctx.push(DP_PART_KEY).apply(CommonValidators::required).apply(DataValidator::partKey, PartKey.class).pop();
        ctx = ctx.push(DP_SNAP).apply(CommonValidators::required).apply(DataValidator::dataSnap, DataDefinition.Snap.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext dataSnap(DataDefinition.Snap msg, ValidationContext ctx) {
        ctx = ctx.push(DS_SNAP_INDEX).apply(CommonValidators::notNegative, Integer.class).pop();
        ctx = ctx.pushRepeated(DS_DELTAS).apply(CommonValidators::listNotEmpty).applyRepeated(DataValidator::dataDelta, DataDefinition.Delta.class).applyRepeated(DataValidator::deltaMatchesIndex, DataDefinition.Delta.class, msg).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext dataDelta(DataDefinition.Delta msg, ValidationContext ctx) {
        ctx = ctx.push(DD_DELTA_INDEX).apply(CommonValidators::notNegative, Integer.class).pop();
        DataDefinition.Snap snap = (DataDefinition.Snap)(ctx = ctx.push(DD_DATA_ITEM).apply(CommonValidators::required).apply(StorageValidator::dataItemKey).pop()).parentMsg();
        if (snap.getDeltasCount() <= msg.getDeltaIndex() || snap.getDeltas(msg.getDeltaIndex()) != msg) {
            String err = String.format("Unexpected delta index [%d] (should match list index)", msg.getDeltaIndex());
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext deltaMatchesIndex(DataDefinition.Delta msg, DataDefinition.Snap snap, ValidationContext ctx) {
        if (snap.getDeltasCount() <= msg.getDeltaIndex() || snap.getDeltas(msg.getDeltaIndex()) != msg) {
            String err = String.format("Unexpected delta index [%d] (should match list index in the snap)", msg.getDeltaIndex());
            return ctx.error(err);
        }
        return ctx;
    }

    @Validator
    public static ValidationContext partKey(PartKey msg, ValidationContext ctx) {
        ctx = ctx.push(PK_PART_TYPE).apply(CommonValidators::optional).apply(CommonValidators::recognizedEnum, PartType.class).pop();
        String partByValueQualifier = String.format("%s == %s", PK_PART_TYPE.getName(), PartType.PART_BY_VALUE.name());
        String partByRangeQualifier = String.format("%s == %s", PK_PART_TYPE.getName(), PartType.PART_BY_RANGE.name());
        ctx = ctx.pushRepeated(PK_PART_VALUES).apply(CommonValidators.ifAndOnlyIf(msg.getPartType() == PartType.PART_BY_VALUE, partByValueQualifier)).apply(CommonValidators::listNotEmpty).applyRepeated(TypeSystemValidator::value, Value.class).pop();
        ctx = ctx.push(PK_PART_RANGE_MIN).apply(CommonValidators.ifAndOnlyIf(msg.getPartType() == PartType.PART_BY_RANGE, partByRangeQualifier)).apply(TypeSystemValidator::value, Value.class).pop();
        ctx = ctx.push(PK_PART_RANGE_MAX).apply(CommonValidators.ifAndOnlyIf(msg.getPartType() == PartType.PART_BY_RANGE, partByRangeQualifier)).apply(TypeSystemValidator::value, Value.class).pop();
        boolean keyFieldsOk = !ctx.failed();
        ctx = ctx.push(PK_OPAQUE_KEY).apply(CommonValidators::required).apply(DataValidator::opaqueKey).applyIf(keyFieldsOk, DataValidator::opaqueKeyMatchesPart, String.class, msg).pop();
        return ctx;
    }

    private static ValidationContext opaqueKey(String opaqueKey, ValidationContext ctx) {
        Matcher matcher = ValidationConstants.OPAQUE_PART_KEY.matcher(opaqueKey);
        if (!matcher.matches()) {
            String err = String.format("Invalid part key [%s]", opaqueKey);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext opaqueKeyMatchesPart(String opaqueKey, PartKey partKey, ValidationContext ctx) {
        String expectedOpaqueKey = PartKeys.opaqueKey((PartKey)partKey);
        if (!opaqueKey.equals(expectedOpaqueKey)) {
            String err = String.format("Part key does not match part definition (expected [%s], got [%s])", expectedOpaqueKey, opaqueKey);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext partMapIsConsistent(Map<String, DataDefinition.Part> partMap, ValidationContext ctx) {
        Iterator<Map.Entry<String, DataDefinition.Part>> iterator = partMap.entrySet().iterator();
        if (iterator.hasNext()) {
            String part;
            Map.Entry<String, DataDefinition.Part> partEntry = iterator.next();
            String partKey = partEntry.getKey();
            if (!partKey.equals(part = partEntry.getValue().getPartKey().getOpaqueKey())) {
                String err = String.format("Part key [%s] does not match part definition for [%s]", partKey, part);
                return ctx.error(err);
            }
            return ctx;
        }
        return ctx;
    }
}

