/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.time.OffsetDateTime;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.common.metadata.MetadataConstants;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.TagHeader;
import org.finos.tracdap.metadata.TagSelector;

@Validator(type=ValidationType.STATIC)
public class ObjectIdValidator {
    private static final Descriptors.Descriptor TAG_HEADER = TagHeader.getDescriptor();
    private static final Descriptors.FieldDescriptor TH_OBJECT_TYPE = ValidatorUtils.field(TAG_HEADER, 1);
    private static final Descriptors.FieldDescriptor TH_OBJECT_ID = ValidatorUtils.field(TAG_HEADER, 2);
    private static final Descriptors.FieldDescriptor TH_OBJECT_VERSION = ValidatorUtils.field(TAG_HEADER, 3);
    private static final Descriptors.FieldDescriptor TH_OBJECT_TIMESTAMP = ValidatorUtils.field(TAG_HEADER, 4);
    private static final Descriptors.FieldDescriptor TH_TAG_VERSION = ValidatorUtils.field(TAG_HEADER, 5);
    private static final Descriptors.FieldDescriptor TH_TAG_TIMESTAMP = ValidatorUtils.field(TAG_HEADER, 6);
    private static final Descriptors.Descriptor TAG_SELECTOR = TagSelector.getDescriptor();
    private static final Descriptors.FieldDescriptor TS_OBJECT_TYPE = ValidatorUtils.field(TAG_SELECTOR, 1);
    private static final Descriptors.FieldDescriptor TS_OBJECT_ID = ValidatorUtils.field(TAG_SELECTOR, 2);
    private static final Descriptors.OneofDescriptor TS_OBJECT_CRITERIA = ValidatorUtils.field(TAG_SELECTOR, 3).getContainingOneof();
    private static final Descriptors.FieldDescriptor TS_LATEST_OBJECT = ValidatorUtils.field(TAG_SELECTOR, 3);
    private static final Descriptors.FieldDescriptor TS_OBJECT_VERSION = ValidatorUtils.field(TAG_SELECTOR, 4);
    private static final Descriptors.FieldDescriptor TS_OBJECT_ASOF = ValidatorUtils.field(TAG_SELECTOR, 5);
    private static final Descriptors.OneofDescriptor TS_TAG_CRITERIA = ValidatorUtils.field(TAG_SELECTOR, 6).getContainingOneof();
    private static final Descriptors.FieldDescriptor TS_LATEST_TAG = ValidatorUtils.field(TAG_SELECTOR, 6);
    private static final Descriptors.FieldDescriptor TS_TAG_VERSION = ValidatorUtils.field(TAG_SELECTOR, 7);
    private static final Descriptors.FieldDescriptor TS_TAG_ASOF = ValidatorUtils.field(TAG_SELECTOR, 8);

    @Validator
    public static ValidationContext tagHeader(TagHeader msg, ValidationContext ctx) {
        ctx = ctx.push(TH_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, ObjectType.class).pop();
        ctx = ctx.push(TH_OBJECT_ID).apply(CommonValidators::required).apply(CommonValidators::uuid).pop();
        ctx = ctx.push(TH_OBJECT_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        ctx = ctx.push(TH_OBJECT_TIMESTAMP).apply(CommonValidators::required).apply(TypeSystemValidator::datetimeValue, DatetimeValue.class).pop();
        ctx = ctx.push(TH_TAG_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        if (!(ctx = ctx.push(TH_TAG_TIMESTAMP).apply(CommonValidators::required).apply(TypeSystemValidator::datetimeValue, DatetimeValue.class).pop()).failed()) {
            OffsetDateTime objectTimestamp = MetadataCodec.decodeDatetime((DatetimeValue)msg.getObjectTimestamp());
            OffsetDateTime tagTimestamp = MetadataCodec.decodeDatetime((DatetimeValue)msg.getTagTimestamp());
            if (msg.getTagVersion() == 1) {
                if (!tagTimestamp.equals(objectTimestamp)) {
                    ctx.error("Tag timestamp should be the same as object timestamp when tag version = 1");
                }
            } else if (!tagTimestamp.isAfter(objectTimestamp)) {
                ctx.error("Tag timestamp should be later than object timestamp when tag version > 1");
            }
        }
        return ctx;
    }

    @Validator
    public static ValidationContext tagSelector(TagSelector msg, ValidationContext ctx) {
        ctx = ctx.push(TS_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, ObjectType.class).pop();
        ctx = ctx.push(TS_OBJECT_ID).apply(CommonValidators::required).apply(CommonValidators::uuid).pop();
        ctx = ctx.pushOneOf(TS_OBJECT_CRITERIA).apply(CommonValidators::required).applyOneOf(TS_LATEST_OBJECT, CommonValidators::optionalTrue, Boolean.class).applyOneOf(TS_OBJECT_VERSION, CommonValidators::positive, Integer.class).applyOneOf(TS_OBJECT_ASOF, TypeSystemValidator::datetimeValue, DatetimeValue.class).pop();
        ctx = ctx.pushOneOf(TS_TAG_CRITERIA).apply(CommonValidators::required).applyOneOf(TS_LATEST_TAG, CommonValidators::optionalTrue, Boolean.class).applyOneOf(TS_TAG_VERSION, CommonValidators::positive, Integer.class).applyOneOf(TS_TAG_ASOF, TypeSystemValidator::datetimeValue, DatetimeValue.class).pop();
        return ctx;
    }

    public static ValidationContext preallocated(TagSelector selector, ValidationContext ctx) {
        boolean isPreallocated;
        ctx = ctx.push(TS_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, ObjectType.class).pop();
        ctx = ctx.push(TS_OBJECT_ID).apply(CommonValidators::required).apply(CommonValidators::uuid).pop();
        boolean bl = isPreallocated = selector.hasObjectVersion() && selector.hasTagVersion() && selector.getObjectVersion() == 0 && selector.getTagVersion() == 0;
        if (!isPreallocated) {
            String err = String.format("The [%s] selector is not a preallocated object ID (object and tag version must be set to zero)", ctx.fieldName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext selectorType(TagSelector selector, ObjectType requiredType, ValidationContext ctx) {
        if (!selector.getObjectType().equals((Object)requiredType)) {
            String err = String.format("Wrong object type in [%s] selector: expected [%s], got [%s]", ctx.fieldName(), requiredType, selector.getObjectType());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext selectorForLatest(TagSelector selector, ValidationContext ctx) {
        if (!selector.getLatestObject() || !selector.getLatestTag()) {
            String err = String.format("The [%s] selector must refer to the latest object and tag version, fixed versions are not allowed", ctx.fieldName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext fixedObjectVersion(TagSelector selector, ValidationContext ctx) {
        if (selector.hasLatestObject()) {
            String err = String.format("The [%s] selector must refer to a fixed object version, [latestObject] is not allowed", ctx.fieldName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext explicitObjectVersion(TagSelector selector, ValidationContext ctx) {
        if (!selector.hasObjectVersion()) {
            String err = String.format("The [%s] selector must use an explicit [%s]", ctx.fieldName(), TS_OBJECT_VERSION.getName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext explicitTagVersion(TagSelector selector, ValidationContext ctx) {
        if (!selector.hasTagVersion()) {
            String err = String.format("The [%s] selector must use an explicit [%s]", ctx.fieldName(), TS_TAG_VERSION.getName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext versioningSupported(ObjectType objectType, ValidationContext ctx) {
        if (!MetadataConstants.VERSIONED_OBJECT_TYPES.contains(objectType)) {
            String err = String.format("Object type [%s] does not support versioning", objectType.name());
            return ctx.error(err);
        }
        return ctx;
    }
}

