/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.regex.Matcher;
import org.finos.tracdap.common.metadata.MetadataConstants;
import org.finos.tracdap.common.validation.ValidationConstants;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.CopyStatus;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.IncarnationStatus;
import org.finos.tracdap.metadata.StorageCopy;
import org.finos.tracdap.metadata.StorageDefinition;
import org.finos.tracdap.metadata.StorageIncarnation;
import org.finos.tracdap.metadata.StorageItem;

@Validator(type=ValidationType.STATIC)
public class StorageValidator {
    private static final Descriptors.Descriptor STORAGE_DEFINITION = StorageDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor SD_DATA_ITEMS = ValidatorUtils.field(STORAGE_DEFINITION, 1);
    private static final Descriptors.Descriptor STORAGE_ITEM = StorageItem.getDescriptor();
    private static final Descriptors.FieldDescriptor SIT_INCARNATIONS = ValidatorUtils.field(STORAGE_ITEM, 1);
    private static final Descriptors.Descriptor STORAGE_INCARNATION = StorageIncarnation.getDescriptor();
    private static final Descriptors.FieldDescriptor SIC_COPIES = ValidatorUtils.field(STORAGE_INCARNATION, 1);
    private static final Descriptors.FieldDescriptor SIC_INCARNATION_INDEX = ValidatorUtils.field(STORAGE_INCARNATION, 2);
    private static final Descriptors.FieldDescriptor SIC_INCARNATION_TIMESTAMP = ValidatorUtils.field(STORAGE_INCARNATION, 3);
    private static final Descriptors.FieldDescriptor SIC_INCARNATION_STATUS = ValidatorUtils.field(STORAGE_INCARNATION, 4);
    private static final Descriptors.Descriptor STORAGE_COPY = StorageCopy.getDescriptor();
    private static final Descriptors.FieldDescriptor SD_STORAGE_KEY = ValidatorUtils.field(STORAGE_COPY, 1);
    private static final Descriptors.FieldDescriptor SD_STORAGE_PATH = ValidatorUtils.field(STORAGE_COPY, 2);
    private static final Descriptors.FieldDescriptor SD_STORAGE_FORMAT = ValidatorUtils.field(STORAGE_COPY, 3);
    private static final Descriptors.FieldDescriptor SD_COPY_STATUS = ValidatorUtils.field(STORAGE_COPY, 4);
    private static final Descriptors.FieldDescriptor SD_COPY_TIMESTAMP = ValidatorUtils.field(STORAGE_COPY, 5);

    @Validator
    public static ValidationContext storageDefinition(StorageDefinition msg, ValidationContext ctx) {
        ctx = ctx.pushMap(SD_DATA_ITEMS).apply(CommonValidators::mapNotEmpty).applyMapKeys(StorageValidator::dataItemKey).applyMapValues(StorageValidator::storageItem, StorageItem.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext storageItem(StorageItem msg, ValidationContext ctx) {
        ctx = ctx.pushRepeated(SIT_INCARNATIONS).apply(CommonValidators::listNotEmpty).applyRepeated(StorageValidator::storageIncarnation, StorageIncarnation.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext storageIncarnation(StorageIncarnation msg, ValidationContext ctx) {
        ctx = ctx.push(SIC_INCARNATION_INDEX).apply(CommonValidators::optional).apply(CommonValidators::notNegative, Integer.class).pop();
        ctx = ctx.push(SIC_INCARNATION_TIMESTAMP).apply(CommonValidators::required).apply(TypeSystemValidator::datetimeValue, DatetimeValue.class).apply(TypeSystemValidator::notInTheFuture, DatetimeValue.class).pop();
        ctx = ctx.push(SIC_INCARNATION_STATUS).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, IncarnationStatus.class).pop();
        ctx = ctx.pushRepeated(SIC_COPIES).apply(CommonValidators::listNotEmpty).applyRepeated(StorageValidator::storageCopy, StorageCopy.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext storageCopy(StorageCopy msg, ValidationContext ctx) {
        ctx = ctx.push(SD_STORAGE_KEY).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(SD_STORAGE_PATH).apply(CommonValidators::required).apply(CommonValidators::relativePath).pop();
        ctx = ctx.push(SD_STORAGE_FORMAT).apply(CommonValidators::required).apply(StorageValidator::storageFormat).pop();
        ctx = ctx.push(SD_COPY_STATUS).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, CopyStatus.class).pop();
        ctx = ctx.push(SD_COPY_TIMESTAMP).apply(CommonValidators::required).apply(TypeSystemValidator::datetimeValue, DatetimeValue.class).apply(TypeSystemValidator::notInTheFuture, DatetimeValue.class).pop();
        return ctx;
    }

    public static ValidationContext dataItemKey(String dataItem, ValidationContext ctx) {
        Matcher dataItemMatcher = ValidationConstants.DATA_ITEM_KEY.matcher(dataItem);
        if (!dataItemMatcher.matches()) {
            String err = String.format("Invalid data item key [%s]", dataItem);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext storageFormat(String storageFormat, ValidationContext ctx) {
        Matcher mimeTypeMatcher = ValidationConstants.MIME_TYPE.matcher(storageFormat);
        Matcher identifierMatcher = MetadataConstants.VALID_IDENTIFIER.matcher(storageFormat);
        if (!mimeTypeMatcher.matches() && !identifierMatcher.matches()) {
            String err = String.format("Invalid [%s], expected an identifier or a mime type, got [%s]", ctx.fieldName(), storageFormat);
            return ctx.error(err);
        }
        return ctx;
    }
}

