/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.regex.Matcher;
import org.finos.tracdap.common.metadata.MetadataConstants;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.TagOperation;
import org.finos.tracdap.metadata.TagUpdate;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class TagUpdateValidator {
    private static final Descriptors.Descriptor TAG_UPDATE = TagUpdate.getDescriptor();
    private static final Descriptors.FieldDescriptor TU_OPERATION;
    private static final Descriptors.FieldDescriptor TU_ATTR_NAME;
    private static final Descriptors.FieldDescriptor TU_VALUE;
    private static final Descriptors.Descriptor VALUE;
    private static final Descriptors.OneofDescriptor V_VALUE;

    @Validator
    public static ValidationContext tagUpdate(TagUpdate msg, ValidationContext ctx) {
        ctx = ctx.push(TU_OPERATION).apply(CommonValidators::optional).apply(CommonValidators::recognizedEnum, TagOperation.class).pop();
        boolean nameRequired = msg.getOperation() != TagOperation.CLEAR_ALL_ATTR;
        boolean valueRequired = nameRequired && msg.getOperation() != TagOperation.DELETE_ATTR;
        String nameRequiredQualifier = String.format("%s == %s", TU_OPERATION.getName(), TagOperation.CLEAR_ALL_ATTR.name());
        String valueRequiredQualifier = String.format("%s == %s or %s == %s", TU_OPERATION.getName(), TagOperation.DELETE_ATTR.name(), TU_OPERATION.getName(), TagOperation.CLEAR_ALL_ATTR.name());
        ctx = ctx.push(TU_ATTR_NAME).apply(CommonValidators.ifAndOnlyIf(nameRequired, nameRequiredQualifier, true)).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(TU_VALUE).apply(CommonValidators.ifAndOnlyIf(valueRequired, valueRequiredQualifier, true)).apply(TypeSystemValidator::value, Value.class).apply(TagUpdateValidator::notNull, Value.class).apply(TagUpdateValidator::allowedValueTypes, Value.class).pop();
        return ctx;
    }

    public static ValidationContext reservedAttrs(TagUpdate msg, boolean allowReserved, ValidationContext ctx) {
        if (allowReserved) {
            return ctx;
        }
        Matcher isReserved = MetadataConstants.TRAC_RESERVED_IDENTIFIER.matcher(msg.getAttrName());
        if (isReserved.matches()) {
            String err = String.format("Attribute name [%s] is a reserved identifier", msg.getAttrName());
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext notNull(Value msg, ValidationContext ctx) {
        if (!msg.hasOneof(V_VALUE)) {
            return ctx.error("Null values are not allowed for tag updates");
        }
        return ctx;
    }

    private static ValidationContext allowedValueTypes(Value msg, ValidationContext ctx) {
        if (TypeSystem.isPrimitive((Value)msg)) {
            return ctx;
        }
        if (TypeSystem.basicType((Value)msg) == BasicType.ARRAY) {
            if (TypeSystem.isPrimitive((TypeDescriptor)msg.getType().getArrayType())) {
                return ctx;
            }
            return ctx.error("Nested array types are now allowed for tag updates");
        }
        String err = String.format("Value type [%s] is not allowed for tag updates", TypeSystem.basicType((Value)msg));
        return ctx.error(err);
    }

    static {
        TU_ATTR_NAME = ValidatorUtils.field(TAG_UPDATE, 2);
        TU_OPERATION = ValidatorUtils.field(TAG_UPDATE, 1);
        TU_VALUE = ValidatorUtils.field(TAG_UPDATE, 3);
        VALUE = Value.getDescriptor();
        V_VALUE = ValidatorUtils.field(VALUE, 2).getContainingOneof();
    }
}

