/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.version;

import com.google.protobuf.Descriptors;
import java.time.OffsetDateTime;
import java.util.Objects;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.Value;

public class CommonValidators {
    private static final Descriptors.Descriptor TAG_SELECTOR = TagSelector.getDescriptor();
    private static final Descriptors.FieldDescriptor OBJECT_TYPE = ValidatorUtils.field(TAG_SELECTOR, 1);
    private static final Descriptors.FieldDescriptor OBJECT_ID = ValidatorUtils.field(TAG_SELECTOR, 2);
    private static final Descriptors.OneofDescriptor OBJECT_CRITERIA = ValidatorUtils.field(TAG_SELECTOR, 3).getContainingOneof();
    private static final Descriptors.FieldDescriptor OBJECT_VERSION = ValidatorUtils.field(TAG_SELECTOR, 4);
    private static final Descriptors.FieldDescriptor OBJECT_ASOF = ValidatorUtils.field(TAG_SELECTOR, 5);
    private static final Descriptors.OneofDescriptor TAG_CRITERIA = ValidatorUtils.field(TAG_SELECTOR, 6).getContainingOneof();
    private static final Descriptors.FieldDescriptor TAG_VERSION = ValidatorUtils.field(TAG_SELECTOR, 7);
    private static final Descriptors.FieldDescriptor TAG_ASOF = ValidatorUtils.field(TAG_SELECTOR, 8);

    public static ValidationContext exactMatch(Object current, Object prior, ValidationContext ctx) {
        boolean equal = Objects.equals(prior, current);
        if (!equal) {
            String err = String.format("Value of [%s] must not change between versions: prior = [%s], new = [%s]", ctx.fieldName(), CommonValidators.displayValue(prior), CommonValidators.displayValue(current));
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext equalOrGreater(Integer current, Integer prior, ValidationContext ctx) {
        if (current < prior) {
            String err = String.format("Value of [%s] cannot be lower than the previous version: prior = [%d], new = [%d]", ctx.fieldName(), prior, current);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext equalOrAfter(DatetimeValue current, DatetimeValue prior, ValidationContext ctx) {
        OffsetDateTime priorTimestamp;
        OffsetDateTime currentTimestamp = MetadataCodec.decodeDatetime((DatetimeValue)current);
        if (currentTimestamp.isBefore(priorTimestamp = MetadataCodec.decodeDatetime((DatetimeValue)prior))) {
            String err = String.format("Value of [%s] cannot be before the previous version: prior = [%s], new = [%s]", ctx.fieldName(), MetadataCodec.ISO_DATETIME_INPUT_FORMAT.format(priorTimestamp), MetadataCodec.ISO_DATETIME_INPUT_FORMAT.format(currentTimestamp));
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext sameOneOf(Object current, Object prior, ValidationContext ctx) {
        if (!ctx.isOneOf()) {
            throw new EUnexpected();
        }
        if (ctx.field().getNumber() != ctx.prior().field().getNumber()) {
            String err = String.format("Selected one of [%s] must not change between versions: prior = [%s], new = [%s]", ctx.oneOf().getName(), ctx.prior().fieldName(), ctx.fieldName());
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext equalOrLaterVersion(TagSelector current, TagSelector prior, ValidationContext ctx) {
        int initialErrCount = ctx.getErrors().size();
        ctx = ctx.push(OBJECT_TYPE).apply(CommonValidators::exactMatch).pop();
        if ((ctx = ctx.push(OBJECT_ID).apply(CommonValidators::exactMatch).pop()).getErrors().size() > initialErrCount) {
            return ctx;
        }
        if ((ctx = ctx.pushOneOf(OBJECT_CRITERIA).apply(CommonValidators::sameOneOf).applyOneOf(OBJECT_VERSION, CommonValidators::equalOrGreater, Integer.class).applyOneOf(OBJECT_ASOF, CommonValidators::equalOrAfter, DatetimeValue.class).pop()).getErrors().size() > initialErrCount) {
            return ctx;
        }
        ctx = ctx.pushOneOf(TAG_CRITERIA).apply(CommonValidators::sameOneOf).applyOneOf(TAG_VERSION, CommonValidators::equalOrGreater, Integer.class).applyOneOf(TAG_ASOF, CommonValidators::equalOrAfter, DatetimeValue.class).pop();
        return ctx;
    }

    private static String displayValue(Object value) {
        if (value instanceof DatetimeValue) {
            return ((DatetimeValue)value).getIsoDatetime();
        }
        if (value instanceof Value && TypeSystem.isPrimitive((Value)((Value)value))) {
            return MetadataCodec.decodeValue((Value)((Value)value)).toString();
        }
        return value.toString();
    }
}

