/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import org.finos.tracdap.api.TracErrorDetails;
import org.finos.tracdap.common.exception.EConsistencyValidation;
import org.finos.tracdap.common.exception.EInputValidation;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.exception.EVersionValidation;
import org.finos.tracdap.common.metadata.MetadataBundle;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.impl.ValidationFailure;
import org.finos.tracdap.common.validation.core.impl.ValidationKey;
import org.finos.tracdap.common.validation.core.impl.ValidationResult;
import org.finos.tracdap.config.PlatformConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validator {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public <TMsg extends Message> void validateFixedMethod(TMsg message, Descriptors.MethodDescriptor method) {
        ValidationContext ctx = ValidationContext.forMethod(message, method);
        this.doValidation(ctx);
    }

    public <TMsg extends Message> void validateFixedObject(TMsg message) {
        ValidationContext ctx = ValidationContext.forMessage(message);
        this.doValidation(ctx);
    }

    public <TMsg extends Message> void validateVersion(TMsg current, TMsg prior) {
        ValidationContext ctx = ValidationContext.forVersion(current, prior);
        this.doValidation(ctx);
    }

    public <TMsg extends Message> void validateConsistency(TMsg message, MetadataBundle metadata, PlatformConfig resources) {
        ValidationContext ctx = ValidationContext.forConsistency(message, metadata, resources);
        this.doValidation(ctx);
    }

    private void doValidation(ValidationContext ctx) {
        ValidationKey key = ctx.key();
        this.log.info("VALIDATION START: [{}]", (Object)key.displayName());
        ValidationContext resultCtx = ctx.applyRegistered();
        ValidationResult result = ValidationResult.forContext(resultCtx);
        if (!result.ok()) {
            for (ValidationFailure failure : result.failures()) {
                this.log.error(failure.locationAndMessage());
            }
            this.log.error("VALIDATION FAILED: [{}]", (Object)key.displayName());
            TracErrorDetails details = result.errorDetails();
            switch (ctx.validationType()) {
                case STATIC: {
                    throw new EInputValidation(details.getMessage(), details);
                }
                case VERSION: {
                    throw new EVersionValidation(details.getMessage(), details);
                }
                case CONSISTENCY: {
                    throw new EConsistencyValidation(details.getMessage(), details);
                }
            }
            throw new EUnexpected();
        }
        this.log.info("VALIDATION SUCCEEDED: [{}]", (Object)key.displayName());
    }
}

