/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.api;

import com.google.protobuf.Descriptors;
import java.util.HashSet;
import java.util.Set;
import org.finos.tracdap.api.ListResourcesRequest;
import org.finos.tracdap.api.ListTenantsRequest;
import org.finos.tracdap.api.Metadata;
import org.finos.tracdap.api.MetadataBatchRequest;
import org.finos.tracdap.api.MetadataGetRequest;
import org.finos.tracdap.api.MetadataReadRequest;
import org.finos.tracdap.api.MetadataSearchRequest;
import org.finos.tracdap.api.MetadataWriteBatchRequest;
import org.finos.tracdap.api.MetadataWriteRequest;
import org.finos.tracdap.api.PlatformInfoRequest;
import org.finos.tracdap.api.ResourceInfoRequest;
import org.finos.tracdap.common.metadata.MetadataUtil;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationFunction;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.ObjectValidator;
import org.finos.tracdap.common.validation.static_.SearchValidator;
import org.finos.tracdap.common.validation.static_.TagUpdateValidator;
import org.finos.tracdap.metadata.ObjectDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.ResourceType;
import org.finos.tracdap.metadata.SearchParameters;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TagUpdate;

@Validator(type=ValidationType.STATIC, serviceFile=Metadata.class, serviceName="tracdap.api.TracMetadataApi")
public class MetadataApiValidator {
    public static final boolean PUBLIC_API = false;
    public static final boolean TRUSTED_API = true;
    private static final Descriptors.Descriptor METADATA_WRITE_REQUEST = MetadataWriteRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor MWR_TENANT = ValidatorUtils.field(METADATA_WRITE_REQUEST, 1);
    private static final Descriptors.FieldDescriptor MWR_OBJECT_TYPE = ValidatorUtils.field(METADATA_WRITE_REQUEST, 2);
    private static final Descriptors.FieldDescriptor MWR_PRIOR_VERSION = ValidatorUtils.field(METADATA_WRITE_REQUEST, 3);
    private static final Descriptors.FieldDescriptor MWR_DEFINITION = ValidatorUtils.field(METADATA_WRITE_REQUEST, 4);
    private static final Descriptors.FieldDescriptor MWR_ATTRS = ValidatorUtils.field(METADATA_WRITE_REQUEST, 5);
    private static final Descriptors.Descriptor METADATA_WRITE_BATCH_REQUEST;
    private static final Descriptors.FieldDescriptor MWBR_TENANT;
    private static final Descriptors.FieldDescriptor MWBR_CREATE_OBJECTS;
    private static final Descriptors.FieldDescriptor MWBR_UPDATE_OBJECTS;
    private static final Descriptors.FieldDescriptor MWBR_UPDATE_TAGS;
    private static final Descriptors.FieldDescriptor MWBR_PREALLOCATE_IDS;
    private static final Descriptors.FieldDescriptor MWBR_CREATE_PREALLOCATED_OBJECTS;
    private static final Descriptors.Descriptor METADATA_READ_REQUEST;
    private static final Descriptors.FieldDescriptor MRR_TENANT;
    private static final Descriptors.FieldDescriptor MRR_SELECTOR;
    private static final Descriptors.Descriptor BATCH_READ_REQUEST;
    private static final Descriptors.FieldDescriptor BRR_TENANT;
    private static final Descriptors.FieldDescriptor BRR_SELECTORS;
    private static final Descriptors.Descriptor METADATA_SEARCH_REQUEST;
    private static final Descriptors.FieldDescriptor MSR_TENANT;
    private static final Descriptors.FieldDescriptor MSR_SEARCH_PARAMS;
    private static final Descriptors.Descriptor METADATA_GET_REQUEST;
    private static final Descriptors.FieldDescriptor MGR_TENANT;
    private static final Descriptors.FieldDescriptor MGR_OBJECT_TYPE;
    private static final Descriptors.FieldDescriptor MGR_OBJECT_ID;
    private static final Descriptors.FieldDescriptor MGR_OBJECT_VERSION;
    private static final Descriptors.FieldDescriptor MGR_TAG_VERSION;
    private static final Descriptors.Descriptor LIST_RESOURCES_REQUEST;
    private static final Descriptors.FieldDescriptor LRR_TENANT;
    private static final Descriptors.FieldDescriptor LRR_RESOURCE_TYPE;
    private static final Descriptors.Descriptor RESOURCE_INFO_REQUEST;
    private static final Descriptors.FieldDescriptor RIR_TENANT;
    private static final Descriptors.FieldDescriptor RIR_RESOURCE_TYPE;
    private static final Descriptors.FieldDescriptor RIR_RESOURCE_KEY;

    @Validator(method="createObject")
    public static ValidationContext createObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.createObject(msg, ctx, false, null);
    }

    static ValidationContext createObject(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, String expectedTenant) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, apiTrust, expectedTenant);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    @Validator(method="updateObject")
    public static ValidationContext updateObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateObject(msg, ctx, false, null);
    }

    static ValidationContext updateObject(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, String expectedTenant) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, true, apiTrust, expectedTenant);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).apply(ObjectIdValidator::explicitObjectVersion, TagSelector.class).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    @Validator(method="updateTag")
    public static ValidationContext updateTag(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.updateTag(msg, ctx, false, null);
    }

    static ValidationContext updateTag(MetadataWriteRequest msg, ValidationContext ctx, boolean apiTrust, String expectedTenant) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, apiTrust, expectedTenant);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).apply(ObjectIdValidator::explicitObjectVersion, TagSelector.class).apply(ObjectIdValidator::explicitTagVersion, TagSelector.class).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    static ValidationContext preallocateId(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.preallocateId(msg, ctx, null);
    }

    private static ValidationContext preallocateId(MetadataWriteRequest msg, ValidationContext ctx, String expectedTenant) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, true, expectedTenant);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    static ValidationContext createPreallocatedObject(MetadataWriteRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.createPreallocatedObject(msg, ctx, null);
    }

    private static ValidationContext createPreallocatedObject(MetadataWriteRequest msg, ValidationContext ctx, String expectedTenantd) {
        ctx = MetadataApiValidator.createOrUpdate(ctx, false, true, expectedTenantd);
        ctx = ctx.push(MWR_PRIOR_VERSION).apply(CommonValidators::required).apply(ObjectIdValidator::preallocated, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, msg.getObjectType()).pop();
        ctx = ctx.push(MWR_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::objectType, ObjectDefinition.class, msg.getObjectType()).applyRegistered().pop();
        return ctx;
    }

    @Validator(method="writeBatch")
    public static ValidationContext writeBatch(MetadataWriteBatchRequest msg, ValidationContext ctx) {
        return MetadataApiValidator.writeBatch(msg, ctx, false);
    }

    public static ValidationContext writeBatch(MetadataWriteBatchRequest msg, ValidationContext ctx, boolean apiTrust) {
        ctx = ctx.push(MWBR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        if (msg.getCreateObjectsCount() == 0 && msg.getUpdateObjectsCount() == 0 && msg.getUpdateTagsCount() == 0 && msg.getPreallocateIdsCount() == 0 && msg.getCreatePreallocatedObjectsCount() == 0) {
            return ctx.error("Write batch request does not contain any operations");
        }
        ctx = ctx.pushRepeated(MWBR_CREATE_OBJECTS).applyRepeated((m, c) -> MetadataApiValidator.createObject(m, c, apiTrust, msg.getTenant()), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(MWBR_UPDATE_OBJECTS).applyRepeated((m, c) -> MetadataApiValidator.updateObject(m, c, apiTrust, msg.getTenant()), MetadataWriteRequest.class).applyRepeated(MetadataApiValidator.uniquePriorObject(), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(MWBR_UPDATE_TAGS).applyRepeated((m, c) -> MetadataApiValidator.updateTag(m, c, apiTrust, msg.getTenant()), MetadataWriteRequest.class).applyRepeated(MetadataApiValidator.uniquePriorVersion(), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(MWBR_PREALLOCATE_IDS).applyRepeated((m, c) -> MetadataApiValidator.preallocateId(m, c, msg.getTenant()), MetadataWriteRequest.class).pop();
        ctx = ctx.pushRepeated(MWBR_CREATE_PREALLOCATED_OBJECTS).applyRepeated((m, c) -> MetadataApiValidator.createPreallocatedObject(m, c, msg.getTenant()), MetadataWriteRequest.class).applyRepeated(MetadataApiValidator.uniquePriorObject(), MetadataWriteRequest.class).pop();
        return ctx;
    }

    private static ValidationContext createOrUpdate(ValidationContext ctx, boolean isVersioned, boolean apiTrust, String expectedTenant) {
        ctx = expectedTenant == null ? ctx.push(MWR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop() : ctx.push(MWR_TENANT).apply(CommonValidators::optional).apply(CommonValidators::identifier).apply(CommonValidators.equalTo(expectedTenant, "Tenant does not match the batch request")).pop();
        ctx = ctx.push(MWR_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ObjectType.class).applyIf(isVersioned, ObjectIdValidator::versioningSupported, ObjectType.class).pop();
        ctx = ctx.pushRepeated(MWR_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, apiTrust).pop();
        return ctx;
    }

    @Validator(method="readObject")
    public static ValidationContext readObject(MetadataReadRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MRR_SELECTOR).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).pop();
        return ctx;
    }

    @Validator(method="readBatch")
    public static ValidationContext readBatch(MetadataBatchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(BRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.pushRepeated(BRR_SELECTORS).apply(CommonValidators::listNotEmpty).applyRepeated(ObjectIdValidator::tagSelector, TagSelector.class).pop();
        return ctx;
    }

    @Validator(method="search")
    public static ValidationContext search(MetadataSearchRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MSR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MSR_SEARCH_PARAMS).apply(CommonValidators::required).apply(SearchValidator::searchParameters, SearchParameters.class).pop();
        return ctx;
    }

    @Validator(method="getObject")
    public static ValidationContext getObject(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        return ctx;
    }

    @Validator(method="getLatestObject")
    public static ValidationContext getLatestObject(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::omitted).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    @Validator(method="getLatestTag")
    public static ValidationContext getLatestTag(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.apply(MetadataApiValidator::getRequest, MetadataGetRequest.class);
        ctx = ctx.push(MGR_OBJECT_VERSION).apply(CommonValidators::required).apply(CommonValidators::positive, Integer.class).pop();
        ctx = ctx.push(MGR_TAG_VERSION).apply(CommonValidators::omitted).pop();
        return ctx;
    }

    private static ValidationContext getRequest(MetadataGetRequest msg, ValidationContext ctx) {
        ctx = ctx.push(MGR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(MGR_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, ObjectType.class).pop();
        ctx = ctx.push(MGR_OBJECT_ID).apply(CommonValidators::required).apply(CommonValidators::uuid).pop();
        return ctx;
    }

    private static ValidationFunction.Typed<MetadataWriteRequest> uniquePriorObject() {
        HashSet knownIds = new HashSet();
        return (msg, ctx) -> MetadataApiValidator.uniquePriorObject(msg, ctx, knownIds);
    }

    private static ValidationContext uniquePriorObject(MetadataWriteRequest msg, ValidationContext ctx, Set<String> knownObjectIds) {
        boolean alreadyPresent;
        String priorId = msg.getPriorVersion().getObjectId();
        boolean bl = alreadyPresent = !knownObjectIds.add(priorId);
        if (alreadyPresent) {
            String err = String.format("Duplicate object ID [%s] in batch operation", priorId);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationFunction.Typed<MetadataWriteRequest> uniquePriorVersion() {
        HashSet knownVersions = new HashSet();
        return (msg, ctx) -> MetadataApiValidator.uniquePriorVersion(msg, ctx, knownVersions);
    }

    private static ValidationContext uniquePriorVersion(MetadataWriteRequest msg, ValidationContext ctx, Set<String> knownObjectIds) {
        boolean alreadyPresent;
        String priorKey = MetadataUtil.objectKey((TagSelector)msg.getPriorVersion());
        boolean bl = alreadyPresent = !knownObjectIds.add(priorKey);
        if (alreadyPresent) {
            String err = String.format("Duplicate operation for object [%s] version [%d] in batch operation", msg.getPriorVersion().getObjectId(), msg.getPriorVersion().getObjectVersion());
            return ctx.error(err);
        }
        return ctx;
    }

    @Validator(method="platformInfo")
    public static ValidationContext platformInfo(PlatformInfoRequest msg, ValidationContext ctx) {
        return ctx;
    }

    @Validator(method="listTenants")
    public static ValidationContext listTenants(ListTenantsRequest msg, ValidationContext ctx) {
        return ctx;
    }

    @Validator(method="listResources")
    public static ValidationContext listResources(ListResourcesRequest msg, ValidationContext ctx) {
        ctx = ctx.push(LRR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(LRR_RESOURCE_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ResourceType.class).pop();
        return ctx;
    }

    @Validator(method="resourceInfo")
    public static ValidationContext resourceInfo(ResourceInfoRequest msg, ValidationContext ctx) {
        ctx = ctx.push(RIR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(RIR_RESOURCE_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ResourceType.class).pop();
        ctx = ctx.push(RIR_RESOURCE_KEY).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        return ctx;
    }

    static {
        METADATA_READ_REQUEST = MetadataReadRequest.getDescriptor();
        MRR_TENANT = ValidatorUtils.field(METADATA_READ_REQUEST, 1);
        MRR_SELECTOR = ValidatorUtils.field(METADATA_READ_REQUEST, 2);
        BATCH_READ_REQUEST = MetadataBatchRequest.getDescriptor();
        BRR_TENANT = ValidatorUtils.field(BATCH_READ_REQUEST, 1);
        BRR_SELECTORS = ValidatorUtils.field(BATCH_READ_REQUEST, 2);
        METADATA_WRITE_BATCH_REQUEST = MetadataWriteBatchRequest.getDescriptor();
        MWBR_TENANT = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 1);
        MWBR_CREATE_OBJECTS = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 2);
        MWBR_UPDATE_OBJECTS = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 3);
        MWBR_UPDATE_TAGS = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 4);
        MWBR_PREALLOCATE_IDS = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 5);
        MWBR_CREATE_PREALLOCATED_OBJECTS = ValidatorUtils.field(METADATA_WRITE_BATCH_REQUEST, 6);
        METADATA_SEARCH_REQUEST = MetadataSearchRequest.getDescriptor();
        MSR_TENANT = ValidatorUtils.field(METADATA_SEARCH_REQUEST, 1);
        MSR_SEARCH_PARAMS = ValidatorUtils.field(METADATA_SEARCH_REQUEST, 2);
        METADATA_GET_REQUEST = MetadataGetRequest.getDescriptor();
        MGR_TENANT = ValidatorUtils.field(METADATA_GET_REQUEST, 1);
        MGR_OBJECT_TYPE = ValidatorUtils.field(METADATA_GET_REQUEST, 2);
        MGR_OBJECT_ID = ValidatorUtils.field(METADATA_GET_REQUEST, 3);
        MGR_OBJECT_VERSION = ValidatorUtils.field(METADATA_GET_REQUEST, 4);
        MGR_TAG_VERSION = ValidatorUtils.field(METADATA_GET_REQUEST, 5);
        LIST_RESOURCES_REQUEST = ListResourcesRequest.getDescriptor();
        LRR_TENANT = ValidatorUtils.field(LIST_RESOURCES_REQUEST, 1);
        LRR_RESOURCE_TYPE = ValidatorUtils.field(LIST_RESOURCES_REQUEST, 2);
        RESOURCE_INFO_REQUEST = ResourceInfoRequest.getDescriptor();
        RIR_TENANT = ValidatorUtils.field(RESOURCE_INFO_REQUEST, 1);
        RIR_RESOURCE_TYPE = ValidatorUtils.field(RESOURCE_INFO_REQUEST, 2);
        RIR_RESOURCE_KEY = ValidatorUtils.field(RESOURCE_INFO_REQUEST, 3);
    }
}

