/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.api;

import com.google.protobuf.Descriptors;
import org.finos.tracdap.api.JobRequest;
import org.finos.tracdap.api.JobStatusRequest;
import org.finos.tracdap.api.Orchestrator;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.JobValidator;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.TagUpdateValidator;
import org.finos.tracdap.metadata.JobDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TagUpdate;

@Validator(type=ValidationType.STATIC, serviceFile=Orchestrator.class, serviceName="tracdap.api.TracOrchestratorApi")
public class OrchestratorApiValidator {
    private static final Descriptors.Descriptor JOB_REQUEST = JobRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor JR_TENANT = ValidatorUtils.field(JOB_REQUEST, 1);
    private static final Descriptors.FieldDescriptor JR_JOB = ValidatorUtils.field(JOB_REQUEST, 2);
    private static final Descriptors.FieldDescriptor JR_JOB_ATTRS = ValidatorUtils.field(JOB_REQUEST, 3);
    private static final Descriptors.Descriptor JOB_STATUS_REQUEST = JobStatusRequest.getDescriptor();
    private static final Descriptors.FieldDescriptor JSR_TENANT = ValidatorUtils.field(JOB_STATUS_REQUEST, 1);
    private static final Descriptors.FieldDescriptor JSR_SELECTOR = ValidatorUtils.field(JOB_STATUS_REQUEST, 2);

    @Validator(method="validateJob")
    public static ValidationContext validateJob(JobRequest msg, ValidationContext ctx) {
        return OrchestratorApiValidator.validateOrSubmit(msg, ctx);
    }

    @Validator(method="submitJob")
    public static ValidationContext submitJob(JobRequest msg, ValidationContext ctx) {
        return OrchestratorApiValidator.validateOrSubmit(msg, ctx);
    }

    private static ValidationContext validateOrSubmit(JobRequest msg, ValidationContext ctx) {
        ctx = ctx.push(JR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(JR_JOB).apply(CommonValidators::required).applyRegistered().apply(JobValidator::outputsMustBeEmpty, JobDefinition.class).pop();
        ctx = ctx.pushRepeated(JR_JOB_ATTRS).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).applyRepeated(TagUpdateValidator::reservedAttrs, TagUpdate.class, false).pop();
        return ctx;
    }

    @Validator(method="checkJob")
    public static ValidationContext checkJob(JobStatusRequest msg, ValidationContext ctx) {
        ctx = ctx.push(JSR_TENANT).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(JSR_SELECTOR).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.JOB).pop();
        return ctx;
    }
}

