/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.consistency;

import com.google.protobuf.Descriptors;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.graph.GraphBuilder;
import org.finos.tracdap.common.graph.GraphSection;
import org.finos.tracdap.common.graph.Node;
import org.finos.tracdap.common.graph.NodeMetadata;
import org.finos.tracdap.common.graph.NodeNamespace;
import org.finos.tracdap.common.graph.SocketId;
import org.finos.tracdap.common.metadata.MetadataBundle;
import org.finos.tracdap.common.metadata.MetadataUtil;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.consistency.ModelConsistencyValidator;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.metadata.DataDefinition;
import org.finos.tracdap.metadata.FieldSchema;
import org.finos.tracdap.metadata.FlowNodeType;
import org.finos.tracdap.metadata.ImportModelJob;
import org.finos.tracdap.metadata.JobDefinition;
import org.finos.tracdap.metadata.ModelDefinition;
import org.finos.tracdap.metadata.ModelInputSchema;
import org.finos.tracdap.metadata.ModelOutputSchema;
import org.finos.tracdap.metadata.ModelParameter;
import org.finos.tracdap.metadata.ObjectDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.RunFlowJob;
import org.finos.tracdap.metadata.RunModelJob;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.SchemaType;
import org.finos.tracdap.metadata.TableSchema;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.CONSISTENCY)
public class JobConsistencyValidator {
    private static final Descriptors.Descriptor JOB_DEFINITION = JobDefinition.getDescriptor();
    private static final Descriptors.OneofDescriptor JD_JOB_DETAILS = ValidatorUtils.field(JOB_DEFINITION, 2).getContainingOneof();
    private static final Descriptors.Descriptor IMPORT_MODEL_JOB = ImportModelJob.getDescriptor();
    private static final Descriptors.FieldDescriptor IMJ_LANGUAGE = ValidatorUtils.field(IMPORT_MODEL_JOB, 1);
    private static final Descriptors.FieldDescriptor IMJ_REPOSITORY = ValidatorUtils.field(IMPORT_MODEL_JOB, 2);
    private static final Descriptors.Descriptor RUN_MODEL_JOB = RunModelJob.getDescriptor();
    private static final Descriptors.FieldDescriptor RMJ_MODEL = ValidatorUtils.field(RUN_MODEL_JOB, 1);
    private static final Descriptors.FieldDescriptor RMJ_PARAMETERS = ValidatorUtils.field(RUN_MODEL_JOB, 2);
    private static final Descriptors.FieldDescriptor RMJ_INPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 3);
    private static final Descriptors.FieldDescriptor RMJ_OUTPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 4);
    private static final Descriptors.FieldDescriptor RMJ_PRIOR_OUTPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 5);
    private static final Descriptors.Descriptor RUN_FLOW_JOB = RunFlowJob.getDescriptor();
    private static final Descriptors.FieldDescriptor RFJ_FLOW = ValidatorUtils.field(RUN_FLOW_JOB, 1);
    private static final Descriptors.FieldDescriptor RFJ_MODELS = ValidatorUtils.field(RUN_FLOW_JOB, 6);
    private static final Descriptors.FieldDescriptor RFJ_PARAMETERS = ValidatorUtils.field(RUN_FLOW_JOB, 2);
    private static final Descriptors.FieldDescriptor RFJ_INPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 3);
    private static final Descriptors.FieldDescriptor RFJ_OUTPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 4);
    private static final Descriptors.FieldDescriptor RFJ_PRIOR_OUTPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 5);

    @Validator
    public static ValidationContext job(JobDefinition job, ValidationContext ctx) {
        return ctx.pushOneOf(JD_JOB_DETAILS).applyRegistered().pop();
    }

    @Validator
    public static ValidationContext importModelJob(ImportModelJob job, ValidationContext ctx) {
        ctx.push(IMJ_LANGUAGE).apply(ModelConsistencyValidator::isSupportedLanguage).pop();
        ctx.push(IMJ_REPOSITORY).apply(ModelConsistencyValidator::isKnownModelRepo).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext runModelJob(RunModelJob job, ValidationContext ctx) {
        MetadataBundle metadata = ctx.getMetadataBundle();
        ObjectDefinition modelObj = metadata.getResource(job.getModel());
        if (modelObj == null) {
            String message = "Required metadata is not available for [" + MetadataUtil.objectKey((TagSelector)job.getModel()) + "]";
            return ctx.push(RMJ_MODEL).error(message).pop();
        }
        ModelDefinition modelDef = modelObj.getModel();
        ctx.pushMap(RMJ_PARAMETERS, RunModelJob::getParametersMap).apply(JobConsistencyValidator::runModelParameters, Map.class, modelDef.getParametersMap()).pop();
        ctx.pushMap(RMJ_INPUTS, RunModelJob::getInputsMap).apply(JobConsistencyValidator::runModelInputs, Map.class, modelDef.getInputsMap()).pop();
        ctx.pushMap(RMJ_PRIOR_OUTPUTS, RunModelJob::getPriorOutputsMap).apply(JobConsistencyValidator::runModelPriorOutputs, Map.class, modelDef.getOutputsMap()).pop();
        ctx.pushMap(RMJ_OUTPUTS, RunModelJob::getOutputsMap).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext runFlowJob(RunFlowJob job, ValidationContext ctx) {
        ctx.push(RFJ_FLOW).apply(CommonValidators::required).apply(JobConsistencyValidator::flowAvailable, TagSelector.class).pop();
        if (ctx.failed()) {
            return ctx;
        }
        NodeNamespace namespace = NodeNamespace.ROOT;
        GraphBuilder builder = new GraphBuilder(namespace, ctx.getMetadataBundle(), JobConsistencyValidator.graphErrorHandler(ctx));
        GraphSection graph = builder.buildRunFlowJob(job);
        ctx.pushMap(RFJ_MODELS, RunFlowJob::getModelsMap).apply(JobConsistencyValidator::runFlowModels, Map.class, graph).pop();
        ctx.pushMap(RFJ_PARAMETERS, RunFlowJob::getParametersMap).apply(JobConsistencyValidator::runFlowParameters, Map.class, graph).pop();
        ctx.pushMap(RFJ_INPUTS, RunFlowJob::getInputsMap).apply(JobConsistencyValidator::runFlowInputs, Map.class, graph).pop();
        ctx.pushMap(RFJ_PRIOR_OUTPUTS, RunFlowJob::getPriorOutputsMap).apply(JobConsistencyValidator::runFlowPriorOutputs, Map.class, graph).pop();
        ctx.pushMap(RFJ_OUTPUTS, RunFlowJob::getOutputsMap).apply(JobConsistencyValidator::runFlowOutputs, Map.class, graph).pop();
        return ctx;
    }

    private static ValidationContext flowAvailable(TagSelector flowSelector, ValidationContext ctx) {
        ObjectDefinition flowObj = ctx.getMetadataBundle().getResource(flowSelector);
        if (flowObj == null) {
            return ctx.error(String.format("Flow definition is not available for [%s]", MetadataUtil.objectKey((TagSelector)flowSelector)));
        }
        if (flowObj.getObjectType() != ObjectType.FLOW) {
            return ctx.error(String.format("Flow definition is the wrong object type (expected %s, got %s)", ObjectType.FLOW.name(), flowObj.getObjectType().name()));
        }
        return ctx;
    }

    private static ValidationContext runFlowModels(Map<String, TagSelector> modelSelectors, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        Map<String, Node> modelNodes = graph.nodes().values().stream().filter(node -> ((NodeMetadata)node.payload()).flowNode().getNodeType() == FlowNodeType.MODEL_NODE).collect(Collectors.toMap(n -> n.nodeId().name(), n -> n));
        return JobConsistencyValidator.alignedMapValidation("model", JobConsistencyValidator.modelMatchesFlow(graph), false, modelSelectors, modelNodes, ctx);
    }

    private static ValidationContext runFlowParameters(Map<String, Value> paramValues, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        Map<String, Node> paramNodes = graph.nodes().values().stream().filter(node -> ((NodeMetadata)node.payload()).flowNode().getNodeType() == FlowNodeType.PARAMETER_NODE).collect(Collectors.toMap(n -> n.nodeId().name(), n -> n));
        return JobConsistencyValidator.alignedMapValidation("parameter", JobConsistencyValidator::paramMatchesSchema, false, paramValues, paramNodes, ctx);
    }

    private static ValidationContext runModelParameters(Map<String, Value> paramValues, Map<String, ModelParameter> requiredParams, ValidationContext ctx) {
        return JobConsistencyValidator.alignedMapValidation("parameter", JobConsistencyValidator::paramMatchesSchema, false, paramValues, requiredParams, ctx);
    }

    private static ValidationContext runFlowInputs(Map<String, TagSelector> inputSelectors, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        Map<String, Node> inputNodes = graph.nodes().values().stream().filter(node -> ((NodeMetadata)node.payload()).flowNode().getNodeType() == FlowNodeType.INPUT_NODE).collect(Collectors.toMap(n -> n.nodeId().name(), n -> n));
        return JobConsistencyValidator.alignedMapValidation("input", JobConsistencyValidator::inputMatchesSchema, JobConsistencyValidator::allowOptionalFlowInputs, inputSelectors, inputNodes, ctx);
    }

    private static boolean allowOptionalFlowInputs(Node<NodeMetadata> node) {
        ModelInputSchema inputSchema = ((NodeMetadata)node.payload()).modelInputSchema();
        return inputSchema != null && inputSchema.getOptional();
    }

    private static ValidationContext runModelInputs(Map<String, TagSelector> inputSelectors, Map<String, ModelInputSchema> requiredInputs, ValidationContext ctx) {
        return JobConsistencyValidator.alignedMapValidation("input", JobConsistencyValidator::inputMatchesSchema, JobConsistencyValidator::allowOptionalModelInputs, inputSelectors, requiredInputs, ctx);
    }

    private static boolean allowOptionalModelInputs(ModelInputSchema inputSchema) {
        return inputSchema != null && inputSchema.getOptional();
    }

    private static ValidationContext runFlowPriorOutputs(Map<String, TagSelector> priorOutputSelectors, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        Map<String, Node> outputNodes = graph.nodes().values().stream().filter(node -> ((NodeMetadata)node.payload()).flowNode().getNodeType() == FlowNodeType.OUTPUT_NODE).collect(Collectors.toMap(n -> n.nodeId().name(), n -> n));
        return JobConsistencyValidator.alignedMapValidation("prior output", JobConsistencyValidator::outputMatchesSchema, true, priorOutputSelectors, outputNodes, ctx);
    }

    private static ValidationContext runModelPriorOutputs(Map<String, TagSelector> priorOutputSelectors, Map<String, ModelOutputSchema> requiredOutputs, ValidationContext ctx) {
        return JobConsistencyValidator.alignedMapValidation("prior output", JobConsistencyValidator::outputMatchesSchema, true, priorOutputSelectors, requiredOutputs, ctx);
    }

    private static ValidationContext runFlowOutputs(Map<String, TagSelector> outputSelectors, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        List outputNodes = graph.nodes().values().stream().filter(node -> ((NodeMetadata)node.payload()).flowNode().getNodeType() == FlowNodeType.OUTPUT_NODE).collect(Collectors.toList());
        for (Node node2 : outputNodes) {
            String outputName = node2.nodeId().name();
            ctx = JobConsistencyValidator.outputNode(outputName, (Node<NodeMetadata>)node2, graph, ctx);
        }
        return ctx;
    }

    private static AlignedMapValidator<TagSelector, Node<NodeMetadata>> modelMatchesFlow(GraphSection<NodeMetadata> graph) {
        return (modelName, modelSelector, modelNode, ctx) -> JobConsistencyValidator.modelMatchesFlow(modelName, modelSelector, (Node<NodeMetadata>)modelNode, graph, ctx);
    }

    private static ValidationContext modelMatchesFlow(String modelName, TagSelector modelSelector, Node<NodeMetadata> modelNode, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        return JobConsistencyValidator.modelNode(modelName, modelSelector, modelNode, graph, ctx);
    }

    private static ValidationContext paramMatchesSchema(String paramName, Value paramValue, Node<NodeMetadata> paramNode, ValidationContext ctx) {
        if (((NodeMetadata)paramNode.payload()).modelParameter() == null) {
            return ctx.error("Type inference failed for parameter [" + paramName + "]");
        }
        return JobConsistencyValidator.paramMatchesSchema(paramName, paramValue, ((NodeMetadata)paramNode.payload()).modelParameter(), ctx);
    }

    private static ValidationContext paramMatchesSchema(String paramName, Value paramValue, ModelParameter requiredParam, ValidationContext ctx) {
        TypeDescriptor paramType = TypeSystem.descriptor((Value)paramValue);
        TypeDescriptor requiredType = requiredParam.getParamType();
        return JobConsistencyValidator.paramMatchesType(paramName, paramType, requiredType, ctx);
    }

    private static ValidationContext paramMatchesSchema(String paramName, ModelParameter suppliedParam, ModelParameter requiredParam, ValidationContext ctx) {
        TypeDescriptor paramType = suppliedParam.getParamType();
        TypeDescriptor requiredType = requiredParam.getParamType();
        return JobConsistencyValidator.paramMatchesType(paramName, paramType, requiredType, ctx);
    }

    private static ValidationContext paramMatchesType(String paramName, TypeDescriptor paramType, TypeDescriptor requiredType, ValidationContext ctx) {
        if (!paramType.equals((Object)requiredType)) {
            if (paramType.getBasicType() != requiredType.getBasicType()) {
                return ctx.error(String.format("Parameter [%s] has the wrong type (expected %s, got %s)", paramName, requiredType.getBasicType(), paramType.getBasicType()));
            }
            return ctx.error(String.format("Parameter [%s] has the wrong type (%s types, contents differ)", paramName, requiredType.getBasicType()));
        }
        return ctx;
    }

    private static ValidationContext inputMatchesSchema(String inputName, TagSelector inputSelector, Node<NodeMetadata> inputNode, ValidationContext ctx) {
        if (((NodeMetadata)inputNode.payload()).modelInputSchema() == null) {
            ctx.error("Type inference failed for input [" + inputName + "]");
        }
        return JobConsistencyValidator.inputMatchesSchema(inputName, inputSelector, ((NodeMetadata)inputNode.payload()).modelInputSchema(), ctx);
    }

    private static ValidationContext inputMatchesSchema(String inputName, TagSelector inputSelector, ModelInputSchema requiredSchema, ValidationContext ctx) {
        ObjectDefinition inputObject = ctx.getMetadataBundle().getResource(inputSelector);
        if (inputObject == null) {
            if (requiredSchema.getOptional()) {
                return ctx;
            }
            return ctx.error(String.format("Metadata is not available for required input [%s] (%s)", inputName, MetadataUtil.objectKey((TagSelector)inputSelector)));
        }
        if (inputObject.getObjectType() != ObjectType.DATA) {
            return ctx.error(String.format("Input is not a dataset (expected %s, got %s)", ObjectType.DATA, inputObject.getObjectType()));
        }
        if (ctx.failed()) {
            return ctx;
        }
        if (requiredSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(inputObject.getData(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(inputObject.getData(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext inputMatchesSchema(String inputName, ModelInputSchema inputSchema, ModelInputSchema requiredSchema, ValidationContext ctx) {
        if (inputSchema.getOptional() && !requiredSchema.getOptional()) {
            ctx.error("Required model input [" + inputName + "] is connected to an optional input");
        }
        if (requiredSchema.getDynamic() || inputSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(inputSchema.getSchema(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(inputSchema.getSchema(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext inputMatchesSchema(String inputName, ModelOutputSchema outputSchema, ModelInputSchema requiredSchema, ValidationContext ctx) {
        if (outputSchema.getOptional() && !requiredSchema.getOptional()) {
            ctx.error("Required model input [" + inputName + "] is connected to an optional model output");
        }
        if (requiredSchema.getDynamic() || outputSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(outputSchema.getSchema(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(outputSchema.getSchema(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext outputMatchesSchema(String outputName, TagSelector outputSelector, Node<NodeMetadata> outputNode, ValidationContext ctx) {
        if (((NodeMetadata)outputNode.payload()).modelOutputSchema() == null) {
            ctx.error("Type inference failed for output [" + outputName + "]");
        }
        return JobConsistencyValidator.outputMatchesSchema(outputName, outputSelector, ((NodeMetadata)outputNode.payload()).modelOutputSchema(), ctx);
    }

    private static ValidationContext outputMatchesSchema(String outputName, TagSelector outputSelector, ModelOutputSchema requiredSchema, ValidationContext ctx) {
        ObjectDefinition outputObject = ctx.getMetadataBundle().getResource(outputSelector);
        if (outputObject == null) {
            return ctx.error(String.format("Metadata is not available for output [%s] (%s)", outputName, MetadataUtil.objectKey((TagSelector)outputSelector)));
        }
        if (outputObject.getObjectType() != ObjectType.DATA) {
            return ctx.error(String.format("Output is not a dataset (expected %s, got %s)", ObjectType.DATA, outputObject.getObjectType()));
        }
        if (ctx.failed()) {
            return ctx;
        }
        if (requiredSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(outputObject.getData(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(outputObject.getData(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext outputMatchesSchema(String outputName, ModelInputSchema inputSchema, ModelOutputSchema requiredSchema, ValidationContext ctx) {
        if (inputSchema.getOptional() && !requiredSchema.getOptional()) {
            ctx.error("Required output [" + outputName + "] is connected to an optional input");
        }
        if (requiredSchema.getDynamic() || inputSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(inputSchema.getSchema(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(inputSchema.getSchema(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext outputMatchesSchema(String outputName, ModelOutputSchema outputSchema, ModelOutputSchema requiredSchema, ValidationContext ctx) {
        if (outputSchema.getOptional() && !requiredSchema.getOptional()) {
            ctx.error("Required output [" + outputName + "] is connected to an optional model output");
        }
        if (requiredSchema.getDynamic() || outputSchema.getDynamic()) {
            return JobConsistencyValidator.checkDynamicDataSchema(outputSchema.getSchema(), requiredSchema.getSchema(), ctx);
        }
        return JobConsistencyValidator.checkDataSchema(outputSchema.getSchema(), requiredSchema.getSchema(), ctx);
    }

    private static ValidationContext checkDataSchema(DataDefinition suppliedData, SchemaDefinition requiredSchema, ValidationContext ctx) {
        SchemaDefinition suppliedSchema = JobConsistencyValidator.findSchema(suppliedData, ctx.getMetadataBundle());
        return JobConsistencyValidator.checkDataSchema(suppliedSchema, requiredSchema, ctx);
    }

    private static ValidationContext checkDataSchema(SchemaDefinition suppliedSchema, SchemaDefinition requiredSchema, ValidationContext ctx) {
        if (suppliedSchema.getSchemaType() != requiredSchema.getSchemaType()) {
            return ctx.error(String.format("The dataset supplied has the wrong schema type (expected [%s], got [%s])", requiredSchema.getSchemaType(), suppliedSchema.getSchemaType()));
        }
        if (requiredSchema.getSchemaType() != SchemaType.TABLE) {
            throw new ETracInternal("Schema type " + String.valueOf(requiredSchema.getSchemaType()) + " is not supported");
        }
        return JobConsistencyValidator.checkTableSchema(suppliedSchema.getTable(), requiredSchema.getTable(), ctx);
    }

    private static ValidationContext checkDynamicDataSchema(DataDefinition suppliedData, SchemaDefinition requiredSchema, ValidationContext ctx) {
        SchemaDefinition suppliedSchema = JobConsistencyValidator.findSchema(suppliedData, ctx.getMetadataBundle());
        return JobConsistencyValidator.checkDynamicDataSchema(suppliedSchema, requiredSchema, ctx);
    }

    private static ValidationContext checkDynamicDataSchema(SchemaDefinition suppliedSchema, SchemaDefinition requiredSchema, ValidationContext ctx) {
        if (suppliedSchema.getSchemaType() != requiredSchema.getSchemaType()) {
            return ctx.error(String.format("The dataset supplied has the wrong schema type (expected [%s], got [%s])", requiredSchema.getSchemaType(), suppliedSchema.getSchemaType()));
        }
        if (requiredSchema.getSchemaType() != SchemaType.TABLE) {
            throw new ETracInternal("Schema type " + String.valueOf(requiredSchema.getSchemaType()) + " is not supported");
        }
        return ctx;
    }

    private static ValidationContext checkTableSchema(TableSchema suppliedSchema, TableSchema requiredSchema, ValidationContext ctx) {
        HashMap<String, FieldSchema> suppliedMapping = new HashMap<String, FieldSchema>(suppliedSchema.getFieldsCount());
        for (int fieldIndex = 0; fieldIndex < suppliedSchema.getFieldsCount(); ++fieldIndex) {
            FieldSchema field = suppliedSchema.getFields(fieldIndex);
            suppliedMapping.put(field.getFieldName().toLowerCase(), field);
        }
        for (FieldSchema requiredField : requiredSchema.getFieldsList()) {
            String fieldName = requiredField.getFieldName();
            FieldSchema suppliedField = (FieldSchema)suppliedMapping.get(fieldName.toLowerCase());
            if (suppliedField == null) {
                ctx = ctx.error(String.format("Field [%s] is not available in the supplied dataset", fieldName));
                continue;
            }
            ctx = JobConsistencyValidator.checkFieldSchema(suppliedField, requiredField, ctx);
        }
        return ctx;
    }

    private static ValidationContext checkFieldSchema(FieldSchema suppliedField, FieldSchema requiredField, ValidationContext ctx) {
        boolean suppliedNNotNull;
        if (requiredField.getFieldType() != suppliedField.getFieldType()) {
            return ctx.error(String.format("Field [%s] has the wrong type in the supplied dataset (expected %s, got %s)", requiredField.getFieldName(), requiredField.getFieldType(), suppliedField.getFieldType()));
        }
        if (requiredField.getBusinessKey() && !suppliedField.getBusinessKey()) {
            return ctx.error(String.format("Field [%s] should be a business key, but is not a business key in the supplied dataset", requiredField.getFieldName()));
        }
        boolean bl = suppliedNNotNull = suppliedField.hasNotNull() ? suppliedField.getNotNull() : suppliedField.getBusinessKey();
        if (requiredField.getNotNull() && !suppliedNNotNull) {
            return ctx.error(String.format("Field [%s] should not be nullable, but is nullable in the supplied dataset", requiredField.getFieldName()));
        }
        if (requiredField.getCategorical() && !suppliedField.getCategorical()) {
            return ctx.error(String.format("Field [%s] should not be categorical, but is not categorical in the supplied dataset", requiredField.getFieldName()));
        }
        return ctx;
    }

    private static SchemaDefinition findSchema(DataDefinition dataset, MetadataBundle resources) {
        if (dataset.hasSchema()) {
            return dataset.getSchema();
        }
        if (dataset.hasSchemaId()) {
            ObjectDefinition schema = resources.getResource(dataset.getSchemaId());
            if (schema == null) {
                throw new ETracInternal("Metadata not available for validation");
            }
            if (schema.getObjectType() == ObjectType.SCHEMA) {
                return schema.getSchema();
            }
        }
        throw new EUnexpected();
    }

    private static ValidationContext modelNode(String modelKey, TagSelector modelSelector, Node<NodeMetadata> node, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        ObjectDefinition modelObj = ctx.getMetadataBundle().getResource(modelSelector);
        if (modelObj == null) {
            return ctx.error("No model provided for [" + modelKey + "]");
        }
        if (modelObj.getObjectType() != ObjectType.MODEL) {
            return ctx.error("Object provided for [" + modelKey + "] is not a model");
        }
        ModelDefinition modelDef = modelObj.getModel();
        NodeMetadata nodeMetadata = (NodeMetadata)node.payload();
        KeyCheckResult paramsCheck = JobConsistencyValidator.compareKeys((Collection<String>)nodeMetadata.flowNode().getParametersList(), modelDef.getParametersMap().keySet());
        KeyCheckResult inputsCheck = JobConsistencyValidator.compareKeys((Collection<String>)nodeMetadata.flowNode().getInputsList(), modelDef.getInputsMap().keySet());
        KeyCheckResult outputsCheck = JobConsistencyValidator.compareKeys((Collection<String>)nodeMetadata.flowNode().getOutputsList(), modelDef.getOutputsMap().keySet());
        if (paramsCheck.anyErrors() || inputsCheck.anyErrors() || outputsCheck.anyErrors()) {
            ArrayList<String> details = new ArrayList<String>();
            JobConsistencyValidator.modelNodeKeyErrors("missing parameters: ", paramsCheck.missingKeys, details);
            JobConsistencyValidator.modelNodeKeyErrors("extra parameters: ", paramsCheck.extraKeys, details);
            JobConsistencyValidator.modelNodeKeyErrors("missing inputs: ", inputsCheck.missingKeys, details);
            JobConsistencyValidator.modelNodeKeyErrors("extra inputs: ", inputsCheck.extraKeys, details);
            JobConsistencyValidator.modelNodeKeyErrors("missing outputs: ", outputsCheck.missingKeys, details);
            JobConsistencyValidator.modelNodeKeyErrors("extra outputs: ", outputsCheck.extraKeys, details);
            String message = "Model is not compatible with the flow (" + String.join((CharSequence)", ", details) + ")";
            return ctx.error(message);
        }
        for (Map.Entry param : modelDef.getParametersMap().entrySet()) {
            ctx = JobConsistencyValidator.modelParameter(node, graph, (String)param.getKey(), (ModelParameter)param.getValue(), ctx);
        }
        for (Map.Entry input : modelDef.getInputsMap().entrySet()) {
            ctx = JobConsistencyValidator.modelInput(node, graph, (String)input.getKey(), (ModelInputSchema)input.getValue(), ctx);
        }
        return ctx;
    }

    private static void modelNodeKeyErrors(String prefix, List<String> keys, List<String> details) {
        if (!keys.isEmpty()) {
            String detail = prefix + "[" + String.join((CharSequence)", ", keys) + "]";
            details.add(detail);
        }
    }

    private static ValidationContext modelParameter(Node<NodeMetadata> node, GraphSection<NodeMetadata> graph, String paramName, ModelParameter modelParameter, ValidationContext ctx) {
        SocketId sourceSocket = (SocketId)node.dependencies().get(paramName);
        if (sourceSocket == null) {
            return ctx.error(String.format("Parameter [%s] is not connected in the flow", paramName));
        }
        Node sourceNode = (Node)graph.nodes().get(sourceSocket.nodeId());
        NodeMetadata sourceMetadata = (NodeMetadata)sourceNode.payload();
        String sourceNodeName = sourceSocket.nodeId().name();
        FlowNodeType sourceNodeType = sourceMetadata.flowNode().getNodeType();
        if (sourceNodeType == FlowNodeType.PARAMETER_NODE) {
            if (sourceMetadata.modelParameter() == null) {
                return ctx.error(String.format("No type information available for connected parameter [%s]", sourceNodeName));
            }
            return JobConsistencyValidator.paramMatchesSchema(paramName, sourceMetadata.modelParameter(), modelParameter, ctx);
        }
        return ctx.error(String.format("Parameter [%s] cannot be supplied from [%s] (%s)", paramName, sourceNodeName, sourceNodeType));
    }

    private static ValidationContext modelInput(Node<NodeMetadata> node, GraphSection<NodeMetadata> graph, String inputName, ModelInputSchema modelInput, ValidationContext ctx) {
        SocketId sourceSocket = (SocketId)node.dependencies().get(inputName);
        if (sourceSocket == null) {
            return ctx.error(String.format("Input [%s] is not connected in the flow", inputName));
        }
        Node sourceNode = (Node)graph.nodes().get(sourceSocket.nodeId());
        NodeMetadata sourceMetadata = (NodeMetadata)sourceNode.payload();
        String sourceNodeName = sourceSocket.nodeId().name();
        FlowNodeType sourceNodeType = sourceMetadata.flowNode().getNodeType();
        if (sourceNodeType == FlowNodeType.INPUT_NODE) {
            if (sourceMetadata.modelInputSchema() == null) {
                return ctx.error(String.format("No schema available for connected input [%s]", sourceNodeName));
            }
            return JobConsistencyValidator.inputMatchesSchema(inputName, sourceMetadata.modelInputSchema(), modelInput, ctx);
        }
        if (sourceNodeType == FlowNodeType.MODEL_NODE) {
            if (sourceMetadata.runtimeObjectType() != ObjectType.MODEL) {
                return ctx.error(String.format("No metadata available for connected model [%s]", sourceNodeName));
            }
            ModelDefinition sourceModel = sourceMetadata.runtimeObject().getModel();
            if (!sourceModel.containsOutputs(sourceSocket.socket())) {
                return ctx.error(String.format("Connected model [%s] has no output named [%s]", sourceNodeName, sourceSocket.socket()));
            }
            return JobConsistencyValidator.inputMatchesSchema(inputName, sourceModel.getOutputsOrThrow(sourceSocket.socket()), modelInput, ctx);
        }
        return ctx.error(String.format("Input [%s] cannot be supplied from [%s] (%s)", inputName, sourceNodeName, sourceNodeType));
    }

    private static ValidationContext outputNode(String outputName, Node<NodeMetadata> node, GraphSection<NodeMetadata> graph, ValidationContext ctx) {
        SocketId sourceSocket = (SocketId)node.dependencies().get("");
        if (sourceSocket == null) {
            return ctx.error(String.format("Output [%s] is not connected in the flow", outputName));
        }
        ModelOutputSchema modelOutput = ((NodeMetadata)node.payload()).modelOutputSchema();
        if (modelOutput == null) {
            return ctx.error("Type inference failed for output [" + outputName + "]");
        }
        Node sourceNode = (Node)graph.nodes().get(sourceSocket.nodeId());
        NodeMetadata sourceMetadata = (NodeMetadata)sourceNode.payload();
        String sourceNodeName = sourceSocket.nodeId().name();
        FlowNodeType sourceNodeType = sourceMetadata.flowNode().getNodeType();
        if (sourceNodeType == FlowNodeType.INPUT_NODE) {
            if (sourceMetadata.modelInputSchema() == null) {
                return ctx.error(String.format("No schema available for connected input [%s]", sourceNodeName));
            }
            return JobConsistencyValidator.outputMatchesSchema(outputName, sourceMetadata.modelInputSchema(), modelOutput, ctx);
        }
        if (sourceNodeType == FlowNodeType.MODEL_NODE) {
            if (sourceMetadata.runtimeObjectType() != ObjectType.MODEL) {
                return ctx.error(String.format("No metadata available for connected model [%s]", sourceNodeName));
            }
            ModelDefinition sourceModel = sourceMetadata.runtimeObject().getModel();
            if (!sourceModel.containsOutputs(sourceSocket.socket())) {
                return ctx.error(String.format("Connected model [%s] has no output named [%s]", sourceNodeName, sourceSocket.socket()));
            }
            return JobConsistencyValidator.outputMatchesSchema(outputName, sourceModel.getOutputsOrThrow(sourceSocket.socket()), modelOutput, ctx);
        }
        return ctx.error(String.format("Output [%s] cannot be supplied from [%s] (%s)", outputName, sourceNodeName, sourceNodeType));
    }

    private static <T, U> ValidationContext alignedMapValidation(String itemType, AlignedMapValidator<T, U> validatorFunc, boolean allowMissing, Map<String, T> providedValues, Map<String, U> requiredValues, ValidationContext ctx) {
        if (allowMissing) {
            return JobConsistencyValidator.alignedMapValidation(itemType, validatorFunc, null, providedValues, requiredValues, ctx);
        }
        return JobConsistencyValidator.alignedMapValidation(itemType, validatorFunc, x -> false, providedValues, requiredValues, ctx);
    }

    private static <T, U> ValidationContext alignedMapValidation(String itemType, AlignedMapValidator<T, U> validatorFunc, Function<U, Boolean> allowMissingFunc, Map<String, T> providedValues, Map<String, U> requiredValues, ValidationContext ctx) {
        for (Map.Entry<String, T> provided : providedValues.entrySet()) {
            String itemKey = provided.getKey();
            T providedValue = provided.getValue();
            U requiredValue = requiredValues.get(provided.getKey());
            ctx = ctx.pushMapKey(itemKey);
            if (requiredValue == null) {
                if (providedValue != null) {
                    ctx = ctx.error(String.format("Unexpected %s [%s]", itemType, itemKey));
                }
            } else {
                ctx = providedValue == null ? ctx.error(String.format("Missing required %s [%s]", itemType, itemKey)) : validatorFunc.validate(itemKey, providedValue, requiredValue, ctx);
            }
            ctx = ctx.pop();
        }
        if (allowMissingFunc != null) {
            for (String requiredKey : requiredValues.keySet()) {
                U requiredValue;
                Boolean allowMissing;
                if (providedValues.containsKey(requiredKey) || (allowMissing = allowMissingFunc.apply(requiredValue = requiredValues.get(requiredKey))).booleanValue()) continue;
                ctx = ctx.error(String.format("Missing required %s [%s]", itemType, requiredKey));
            }
        }
        return ctx;
    }

    private static KeyCheckResult compareKeys(Collection<String> expectedKeys, Collection<String> actualKeys) {
        ArrayList<String> missingKeys = new ArrayList<String>();
        ArrayList<String> extraKeys = new ArrayList<String>();
        for (String key : expectedKeys) {
            if (actualKeys.contains(key)) continue;
            missingKeys.add(key);
        }
        for (String key : actualKeys) {
            if (expectedKeys.contains(key)) continue;
            extraKeys.add(key);
        }
        return new KeyCheckResult(missingKeys, extraKeys);
    }

    private static GraphBuilder.ErrorHandler graphErrorHandler(ValidationContext ctx) {
        return (nodeId, detail) -> JobConsistencyValidator.graphErrorHandler(detail, ctx);
    }

    private static void graphErrorHandler(String detail, ValidationContext ctx) {
        ctx.error(detail);
    }

    @FunctionalInterface
    private static interface AlignedMapValidator<T, U> {
        public ValidationContext validate(String var1, T var2, U var3, ValidationContext var4);
    }

    private static class KeyCheckResult {
        final List<String> missingKeys;
        final List<String> extraKeys;

        public KeyCheckResult(List<String> missingKeys, List<String> extraKeys) {
            this.missingKeys = missingKeys;
            this.extraKeys = extraKeys;
        }

        public boolean anyErrors() {
            return !this.missingKeys.isEmpty() || !this.extraKeys.isEmpty();
        }
    }
}

