/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.consistency;

import com.google.protobuf.Descriptors;
import java.util.Map;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.config.PlatformConfig;
import org.finos.tracdap.metadata.ModelDefinition;

@Validator(type=ValidationType.CONSISTENCY)
public class ModelConsistencyValidator {
    private static final Descriptors.Descriptor MODEL_DEFINITION = ModelDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor MD_LANGUAGE = ValidatorUtils.field(MODEL_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor MD_REPOSITORY = ValidatorUtils.field(MODEL_DEFINITION, 2);

    @Validator
    public static ValidationContext modelDefinition(ModelDefinition model, ValidationContext ctx) {
        ctx.push(MD_LANGUAGE).apply(ModelConsistencyValidator::isSupportedLanguage).pop();
        ctx.push(MD_REPOSITORY).apply(ModelConsistencyValidator::isKnownModelRepo).pop();
        return ctx;
    }

    public static ValidationContext isSupportedLanguage(String language, ValidationContext ctx) {
        return ctx;
    }

    public static ValidationContext isKnownModelRepo(String repoName, ValidationContext ctx) {
        PlatformConfig resources = ctx.getResources();
        Map repos = resources.getRepositoriesMap();
        if (!repos.containsKey(repoName)) {
            return ctx.error("Model repository [" + repoName + "] is not available in the TRAC platform");
        }
        return ctx;
    }
}

