/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core;

import com.google.protobuf.Message;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.finos.tracdap.common.exception.ETrac;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.validation.core.ValidationContext;

public class ValidationFunction<T> {
    private final Class<T> targetClass;
    private final Basic basic;
    private final Typed<T> typed;
    private final Version<T> version;

    public static <S> ValidationFunction<S> makeTyped(Typed<S> func, Class<S> targetClass) {
        return new ValidationFunction<S>(func, targetClass);
    }

    public static <S> ValidationFunction<S> makeTyped(Method method, Class<S> targetClass) {
        return ValidationFunction.makeTyped(ValidationFunction.invokeTyped(method), targetClass);
    }

    public static <S> ValidationFunction<S> makeVersion(Version<S> func, Class<S> targetClass) {
        return new ValidationFunction<S>(func, targetClass);
    }

    public static <S> ValidationFunction<S> makeVersion(Method method, Class<S> targetClass) {
        return ValidationFunction.makeVersion(ValidationFunction.invokeVersion(method), targetClass);
    }

    public ValidationFunction(Basic validator, Class<T> targetClass) {
        this.targetClass = targetClass;
        this.basic = validator;
        this.typed = null;
        this.version = null;
    }

    public ValidationFunction(Typed<T> validator, Class<T> targetClass) {
        this.targetClass = targetClass;
        this.basic = null;
        this.typed = validator;
        this.version = null;
    }

    public ValidationFunction(Version<T> validator, Class<T> targetClass) {
        this.targetClass = targetClass;
        this.basic = null;
        this.typed = null;
        this.version = validator;
    }

    public Class<T> targetClass() {
        return this.targetClass;
    }

    public boolean isBasic() {
        return this.basic != null;
    }

    public Basic basic() {
        return this.basic;
    }

    public boolean isTyped() {
        return this.typed != null;
    }

    public Typed<T> typed() {
        return this.typed;
    }

    public boolean isVersion() {
        return this.version != null;
    }

    public Version<T> version() {
        return this.version;
    }

    private static <S> Typed<S> invokeTyped(Method method) {
        boolean signatureMatch;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        boolean bl = signatureMatch = isStatic && returnType.equals(ValidationContext.class) && paramTypes.length == 2 && Message.class.isAssignableFrom(paramTypes[0]) && paramTypes[1].equals(ValidationContext.class);
        if (!signatureMatch) {
            throw new EUnexpected();
        }
        return (msg, ctx) -> {
            try {
                return (ValidationContext)method.invoke(null, msg, ctx);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (e.getCause() != null && e.getCause() instanceof ETrac) {
                    throw (ETrac)e.getCause();
                }
                throw new EUnexpected((Throwable)e);
            }
        };
    }

    private static <S> Version<S> invokeVersion(Method method) {
        boolean signatureMatch;
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        boolean bl = signatureMatch = isStatic && returnType.equals(ValidationContext.class) && paramTypes.length == 3 && Message.class.isAssignableFrom(paramTypes[0]) && paramTypes[1].equals(paramTypes[0]) && paramTypes[2].equals(ValidationContext.class);
        if (!signatureMatch) {
            throw new EUnexpected();
        }
        return (msg, prior, ctx) -> {
            try {
                return (ValidationContext)method.invoke(null, msg, prior, ctx);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                if (e.getCause() != null && e.getCause() instanceof ETrac) {
                    throw (ETrac)e.getCause();
                }
                throw new EUnexpected((Throwable)e);
            }
        };
    }

    @FunctionalInterface
    public static interface Typed<T> {
        public ValidationContext apply(T var1, ValidationContext var2);
    }

    @FunctionalInterface
    public static interface Version<T> {
        public ValidationContext apply(T var1, T var2, ValidationContext var3);
    }

    @FunctionalInterface
    public static interface Basic {
        public ValidationContext apply(ValidationContext var1);
    }

    @FunctionalInterface
    public static interface TypedArg<T, U> {
        public ValidationContext apply(T var1, U var2, ValidationContext var3);
    }
}

