/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core.impl;

import com.google.protobuf.Descriptors;
import com.google.protobuf.MapEntry;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.function.Function;
import org.finos.tracdap.common.exception.ETracInternal;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.metadata.MetadataBundle;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationFunction;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.impl.ValidationFailure;
import org.finos.tracdap.common.validation.core.impl.ValidationKey;
import org.finos.tracdap.common.validation.core.impl.ValidationLocation;
import org.finos.tracdap.common.validation.core.impl.ValidatorBuilder;
import org.finos.tracdap.config.PlatformConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationContextImpl
implements ValidationContext {
    private static final Map<ValidationKey, ValidationFunction<?>> validators = ValidatorBuilder.buildValidatorMap();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ValidationType validationType;
    private final Stack<ValidationLocation> location;
    private final ValidationContextImpl priorCtx;
    private final List<ValidationFailure> failures;
    private final MetadataBundle metadata;
    private final PlatformConfig resources;

    private ValidationContextImpl(ValidationType validationType, ValidationLocation root, ValidationContextImpl priorCtx, MetadataBundle metadata, PlatformConfig resources) {
        this.validationType = validationType;
        this.location = new Stack();
        this.location.push(root);
        this.priorCtx = priorCtx;
        this.metadata = metadata;
        this.resources = resources;
        this.failures = new ArrayList<ValidationFailure>();
    }

    private ValidationContextImpl(ValidationType validationType, ValidationLocation root, ValidationContextImpl priorCtx) {
        this(validationType, root, priorCtx, null, null);
    }

    public static ValidationContext forMethod(Message msg, Descriptors.MethodDescriptor method) {
        ValidationLocation root = new ValidationLocation(null, msg, method, null, null, null);
        return new ValidationContextImpl(ValidationType.STATIC, root, null);
    }

    public static ValidationContext forMessage(Message msg) {
        ValidationLocation root = new ValidationLocation(null, msg, null, null);
        return new ValidationContextImpl(ValidationType.STATIC, root, null);
    }

    public static ValidationContext forVersion(Message current, Message prior) {
        ValidationLocation currentRoot = new ValidationLocation(null, current, null, null);
        ValidationLocation priorRoot = new ValidationLocation(null, prior, null, null);
        ValidationContextImpl priorCtx = new ValidationContextImpl(ValidationType.VERSION, priorRoot, null);
        return new ValidationContextImpl(ValidationType.VERSION, currentRoot, priorCtx);
    }

    public static ValidationContext forConsistency(Message msg, MetadataBundle metadata, PlatformConfig resources) {
        ValidationLocation root = new ValidationLocation(null, msg, null, null);
        return new ValidationContextImpl(ValidationType.CONSISTENCY, root, null, metadata, resources);
    }

    @Override
    public MetadataBundle getMetadataBundle() {
        return this.metadata;
    }

    @Override
    public PlatformConfig getResources() {
        return this.resources;
    }

    @Override
    public ValidationContext push(Descriptors.FieldDescriptor fd) {
        return this.push(fd, false, false, null);
    }

    private ValidationContext push(Descriptors.FieldDescriptor fd, boolean repeated, boolean map, Function<Message, Map<?, ?>> getMapFunc) {
        if (fd.isRepeated() != repeated || fd.isMapField() != map) {
            throw new ETracInternal("Use push, pushRepeated and pushMap for regular, repeated and map fields respectively");
        }
        ValidationLocation parentLoc = this.location.peek();
        Message msg = parentLoc.msg();
        Map<?, ?> obj = map && getMapFunc != null ? getMapFunc.apply(msg) : msg.getField(fd);
        ValidationLocation loc = new ValidationLocation(parentLoc, obj, null, fd, fd.getName());
        if (parentLoc.skipped()) {
            loc.skip();
        }
        this.location.push(loc);
        if (this.priorCtx != null) {
            this.priorCtx.push(fd, repeated, map, getMapFunc);
        }
        return this;
    }

    @Override
    public ValidationContext pushOneOf(Descriptors.OneofDescriptor oneOf) {
        ValidationLocation parentLoc = this.location.peek();
        Message msg = parentLoc.msg();
        Descriptors.FieldDescriptor fd = msg.hasOneof(oneOf) ? msg.getOneofFieldDescriptor(oneOf) : null;
        String name = fd != null ? fd.getName() : oneOf.getName();
        Object obj = fd != null ? msg.getField(fd) : null;
        ValidationLocation loc = new ValidationLocation(parentLoc, obj, oneOf, fd, name);
        if (parentLoc.skipped()) {
            loc.skip();
        }
        this.location.push(loc);
        if (this.priorCtx != null) {
            this.priorCtx.pushOneOf(oneOf);
        }
        return this;
    }

    @Override
    public ValidationContext pushRepeated(Descriptors.FieldDescriptor fd) {
        return this.push(fd, true, false, null);
    }

    @Override
    public ValidationContext pushRepeatedItem(int index) {
        return this.pushRepeatedItem(index, null, false, null);
    }

    @Override
    public ValidationContext pushRepeatedItem(int index, Object priorObj) {
        return this.pushRepeatedItem(index, null, false, priorObj);
    }

    @Override
    public ValidationContext pushRepeatedItem(Object obj, Object priorObj) {
        return this.pushRepeatedItem(-1, obj, false, priorObj);
    }

    private ValidationContext pushRepeatedItem(int index, Object obj, boolean isPrior, Object priorObj) {
        ValidationLocation parentLoc = this.location.peek();
        if (!parentLoc.field().isRepeated() || parentLoc.field().isMapField()) {
            throw new ETracInternal("[pushRepeatedItem] is only for repeated fields (and not map fields)");
        }
        Message msg = parentLoc.parent().msg();
        if (!isPrior) {
            List list;
            if (index < 0 && obj != null && (index = (list = (List)msg.getField(parentLoc.field())).indexOf(obj)) < 0) {
                throw new ETracInternal("Object not in list for [pushRepeatedItem]");
            }
            if (index < 0 || index >= msg.getRepeatedFieldCount(parentLoc.field())) {
                throw new ETracInternal("Index out of bounds for [pushRepeatedItem]");
            }
            if (obj == null) {
                list = (List)msg.getField(parentLoc.field());
                obj = list.get(index);
            }
        }
        String fieldName = String.format("%d", index);
        ValidationLocation loc = new ValidationLocation(parentLoc, obj, parentLoc.field(), fieldName);
        this.location.push(loc);
        if (this.priorCtx != null) {
            this.priorCtx.pushRepeatedItem(-1, priorObj, true, null);
        }
        return this;
    }

    @Override
    public ValidationContext pushMap(Descriptors.FieldDescriptor fd) {
        if (this.priorCtx != null) {
            throw new ETracInternal("Use [pushMap] with [getMapFunc] for version validation");
        }
        return this.push(fd, true, true, null);
    }

    @Override
    public <TMsg extends Message> ValidationContext pushMap(Descriptors.FieldDescriptor mapField, Function<TMsg, Map<?, ?>> getMapFunc) {
        Function<Message, Map<?, ?>> getMapFunc_ = getMapFunc;
        return this.push(mapField, true, true, getMapFunc_);
    }

    @Override
    public ValidationContext pushMapKey(Object key) {
        return this.pushMapEntry(key, true, false);
    }

    @Override
    public ValidationContext pushMapValue(Object key) {
        return this.pushMapEntry(key, false, false);
    }

    private ValidationContext pushMapEntry(Object key, boolean pushKey, boolean allowIfMissing) {
        String methodName = pushKey ? "[pushMapKey]" : "[pushMapValue]";
        ValidationLocation parentLoc = this.location.peek();
        if (!parentLoc.field().isMapField()) {
            throw new ETracInternal(methodName + " can only be used on map fields");
        }
        if (!(parentLoc.target() instanceof Map)) {
            throw new ETracInternal(methodName + " requires [pushMap] is called with [getMapFunc]");
        }
        Map map = (Map)parentLoc.target();
        boolean keyPresent = map.containsKey(key);
        if (!keyPresent && this.priorCtx == null && !allowIfMissing) {
            throw new ETracInternal(methodName + " attempted to push a key that is not in the map");
        }
        String fieldName = key.toString();
        Object obj = pushKey ? key : map.getOrDefault(key, null);
        ValidationLocation loc = new ValidationLocation(parentLoc, obj, parentLoc.field(), fieldName);
        this.location.push(loc);
        if (parentLoc.skipped()) {
            loc.skip();
        }
        if (this.priorCtx != null) {
            this.priorCtx.pushMapEntry(key, pushKey, keyPresent);
        }
        return this;
    }

    private ValidationContext pushMapEntry(int index, boolean pushKey) {
        String methodName = pushKey ? "[applyMapKeys]" : "[applyMapValues]";
        ValidationLocation parentLoc = this.location.peek();
        if (!parentLoc.field().isMapField()) {
            throw new ETracInternal(methodName + " can only be used on map fields");
        }
        if (!(parentLoc.target() instanceof List)) {
            throw new ETracInternal(methodName + " requires [pushMap] is called without [getMapFunc]");
        }
        if (this.priorCtx != null) {
            throw new ETracInternal(methodName + " by index is not allowed for version validators");
        }
        List list = (List)parentLoc.target();
        if (index < 0 || index > list.size()) {
            throw new ETracInternal(methodName + " map entry index is out of range");
        }
        MapEntry entry = (MapEntry)list.get(index);
        String fieldName = entry.getKey().toString();
        Object obj = pushKey ? entry.getKey() : entry.getValue();
        ValidationLocation loc = new ValidationLocation(parentLoc, obj, parentLoc.field(), fieldName);
        this.location.push(loc);
        if (parentLoc.skipped()) {
            loc.skip();
        }
        return this;
    }

    @Override
    public ValidationContext pop() {
        if (this.location.empty()) {
            throw new IllegalStateException();
        }
        ValidationLocation loc = this.location.peek();
        if (loc.failed() && loc.parent() != null) {
            loc.parent().fail();
        }
        this.location.pop();
        if (this.priorCtx != null) {
            this.priorCtx.pop();
        }
        return this;
    }

    @Override
    public ValidationContext error(String message) {
        ValidationFailure failure = new ValidationFailure(this.location.peek(), message);
        this.failures.add(failure);
        ValidationLocation loc = this.location.peek();
        loc.fail();
        return this;
    }

    @Override
    public ValidationContext skip() {
        ValidationLocation loc = this.location.peek();
        loc.skip();
        return this;
    }

    @Override
    public ValidationContext applyRegistered() {
        ValidationLocation loc = this.location.peek();
        Message msg = loc.msg();
        if (msg == null) {
            throw new ETracInternal("applyRegistered() can only be applied to message types");
        }
        ValidationKey key = new ValidationKey(this.validationType, msg.getDescriptorForType(), loc.method());
        ValidationFunction<?> validator = validators.get(key);
        if (validator == null) {
            String err = String.format("Required validator is not registered: [%s]", key.displayName());
            this.log.error(err);
            throw new ETracInternal(err);
        }
        if (validator.isBasic()) {
            return this.apply(validator.basic());
        }
        if (!validator.targetClass().isInstance(msg)) {
            throw new EUnexpected();
        }
        if (validator.isTyped()) {
            ValidationFunction.Typed<?> typedValidator = validator.typed();
            return this.apply(typedValidator, msg.getClass());
        }
        if (validator.isVersion()) {
            ValidationFunction.Version<?> versionValidator = validator.version();
            return this.apply(versionValidator, msg.getClass());
        }
        throw new EUnexpected();
    }

    @Override
    public ValidationContext apply(ValidationFunction.Basic validator) {
        return this.apply((obj, arg, ctx) -> validator.apply(ctx), Object.class, null);
    }

    @Override
    public ValidationContext apply(ValidationFunction.Typed<String> validator) {
        return this.apply((obj, arg, ctx) -> validator.apply((String)obj, ctx), String.class, null);
    }

    @Override
    public <T> ValidationContext apply(ValidationFunction.Typed<T> validator, Class<T> targetClass) {
        return this.apply((obj, arg, ctx) -> validator.apply(obj, ctx), targetClass, null);
    }

    @Override
    public <T, U> ValidationContext apply(ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, U arg) {
        if (this.done()) {
            return this;
        }
        Object obj = this.location.peek().target();
        if (obj == null || targetClass.isInstance(obj)) {
            Object target = obj;
            return validator.apply(target, arg, this);
        }
        if (Enum.class.isAssignableFrom(targetClass) && obj instanceof Descriptors.EnumValueDescriptor) {
            Descriptors.EnumValueDescriptor valueDesc = (Descriptors.EnumValueDescriptor)obj;
            Class<T> enumType = targetClass;
            T enumVal = Enum.valueOf(enumType, valueDesc.getName());
            return validator.apply(enumVal, arg, this);
        }
        String err = String.format("Validator type mismatch (this is a bug): expected [%s], got [%s]", targetClass.getSimpleName(), obj.getClass().getSimpleName());
        this.log.error(err);
        throw new ETracInternal(err);
    }

    @Override
    public ValidationContext apply(ValidationFunction.Version<Object> validator) {
        return this.apply(validator, Object.class);
    }

    @Override
    public <T> ValidationContext apply(ValidationFunction.Version<T> validator, Class<T> targetClass) {
        if (this.priorCtx == null) {
            throw new ETracInternal("Version validator requires a version validation context (ValidationContext.forVersion())");
        }
        if (this.done()) {
            return this;
        }
        Object current = this.location.peek().target();
        Object prior = this.priorCtx.location.peek().target();
        if ((current == null || targetClass.isInstance(current)) && (prior == null || targetClass.isInstance(prior))) {
            Object typedCurrent = current;
            Object typedPrior = prior;
            return validator.apply(typedCurrent, typedPrior, this);
        }
        if (Enum.class.isAssignableFrom(targetClass) && current instanceof Descriptors.EnumValueDescriptor && prior instanceof Descriptors.EnumValueDescriptor) {
            Class<T> enumType = targetClass;
            Descriptors.EnumValueDescriptor currentDesc = (Descriptors.EnumValueDescriptor)current;
            T currentVal = Enum.valueOf(enumType, currentDesc.getName());
            Descriptors.EnumValueDescriptor priorDesc = (Descriptors.EnumValueDescriptor)current;
            T priorVal = Enum.valueOf(enumType, priorDesc.getName());
            return validator.apply(currentVal, priorVal, this);
        }
        String currentClass = current != null ? current.getClass().getSimpleName() : "(null)";
        String priorClass = prior != null ? prior.getClass().getSimpleName() : "(null)";
        String err = String.format("Validator type mismatch (this is a bug): expected [%s], got prior = [%s], current = [%s]", targetClass.getSimpleName(), priorClass, currentClass);
        this.log.error(err);
        throw new ETracInternal(err);
    }

    @Override
    public ValidationContext applyIf(boolean condition, ValidationFunction.Basic validator) {
        if (!condition) {
            return this;
        }
        return this.apply(validator);
    }

    @Override
    public ValidationContext applyIf(boolean condition, ValidationFunction.Typed<String> validator) {
        if (!condition) {
            return this;
        }
        return this.apply(validator);
    }

    @Override
    public <T> ValidationContext applyIf(boolean condition, ValidationFunction.Typed<T> validator, Class<T> targetClass) {
        if (!condition) {
            return this;
        }
        return this.apply(validator, targetClass);
    }

    @Override
    public <T, U> ValidationContext applyIf(boolean condition, ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, U arg) {
        if (!condition) {
            return this;
        }
        return this.apply(validator, targetClass, arg);
    }

    @Override
    public <T> ValidationContext applyIf(boolean condition, ValidationFunction.Version<T> validator, Class<T> targetClass) {
        if (!condition) {
            return this;
        }
        return this.apply(validator, targetClass);
    }

    @Override
    public ValidationContext applyOneOf(Descriptors.FieldDescriptor field, ValidationFunction.Basic validator) {
        boolean oneOfCondition = this.oneOfFieldMatch(field);
        return this.applyIf(oneOfCondition, validator);
    }

    @Override
    public <T> ValidationContext applyOneOf(Descriptors.FieldDescriptor field, ValidationFunction.Typed<T> validator, Class<T> targetClass) {
        boolean oneOfCondition = this.oneOfFieldMatch(field);
        return this.applyIf(oneOfCondition, validator, targetClass);
    }

    @Override
    public <T, U> ValidationContext applyOneOf(Descriptors.FieldDescriptor field, ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, U arg) {
        boolean oneOfCondition = this.oneOfFieldMatch(field);
        return this.applyIf(oneOfCondition, validator, targetClass, arg);
    }

    @Override
    public <T> ValidationContext applyOneOf(Descriptors.FieldDescriptor field, ValidationFunction.Version<T> validator, Class<T> targetClass) {
        boolean oneOfCondition = this.oneOfFieldMatch(field);
        return this.applyIf(oneOfCondition, validator, targetClass);
    }

    private boolean oneOfFieldMatch(Descriptors.FieldDescriptor oneOfField) {
        ValidationLocation loc = this.location.peek();
        if (!loc.isOneOf()) {
            throw new ETracInternal("applyOneOf() can only be applied to one-of fields");
        }
        if (loc.oneOf() != oneOfField.getContainingOneof()) {
            throw new ETracInternal("applyOneOf() field is not a member of the current one-of");
        }
        return loc.field() == oneOfField;
    }

    @Override
    public ValidationContext applyRepeated(ValidationFunction.Basic validator) {
        return this.applyRepeated((obj, arg, ctx) -> validator.apply(ctx), Object.class, null);
    }

    @Override
    public ValidationContext applyRepeated(ValidationFunction.Typed<String> validator) {
        return this.applyRepeated((obj, arg, ctx) -> validator.apply((String)obj, ctx), String.class, null);
    }

    @Override
    public <T> ValidationContext applyRepeated(ValidationFunction.Typed<T> validator, Class<T> targetClass) {
        return this.applyRepeated((obj, arg, ctx) -> validator.apply(obj, ctx), targetClass, null);
    }

    @Override
    public <T, U> ValidationContext applyRepeated(ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, U arg) {
        ValidationLocation loc = this.location.peek();
        if (!loc.field().isRepeated() || loc.field().isMapField()) {
            throw new ETracInternal("applyRepeated() can only apply to repeated fields (not including map fields)");
        }
        if (this.done()) {
            return this;
        }
        int size = loc.parent().msg().getRepeatedFieldCount(loc.field());
        ValidationContextImpl resultCtx = this;
        for (int i = 0; i < size; ++i) {
            resultCtx = (ValidationContextImpl)resultCtx.pushRepeatedItem(i).apply(validator, targetClass, arg).pop();
        }
        return resultCtx;
    }

    @Override
    public ValidationContext applyMapKeys(ValidationFunction.Basic validator) {
        return this.applyMap((obj, arg, ctx) -> validator.apply(ctx), String.class, null, true);
    }

    @Override
    public ValidationContext applyMapKeys(ValidationFunction.Typed<String> validator) {
        return this.applyMap((obj, arg, ctx) -> validator.apply((String)obj, ctx), String.class, null, true);
    }

    @Override
    public <U> ValidationContext applyMapKeys(ValidationFunction.TypedArg<String, U> validator, U arg) {
        return this.applyMap(validator, String.class, _x -> arg, true);
    }

    @Override
    public ValidationContext applyMapValues(ValidationFunction.Basic validator) {
        return this.applyMap((obj, arg, ctx) -> validator.apply(ctx), Object.class, null, false);
    }

    @Override
    public <T> ValidationContext applyMapValues(ValidationFunction.Typed<T> validator, Class<T> targetClass) {
        return this.applyMap((obj, arg, ctx) -> validator.apply(obj, ctx), targetClass, null, false);
    }

    @Override
    public <T, U> ValidationContext applyMapValues(ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, U arg) {
        return this.applyMap(validator, targetClass, _x -> arg, false);
    }

    @Override
    public <T, U> ValidationContext applyMapValuesFunc(ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, Function<String, U> argFunc) {
        return this.applyMap(validator, targetClass, argFunc, false);
    }

    private <T, U> ValidationContext applyMap(ValidationFunction.TypedArg<T, U> validator, Class<T> targetClass, Function<String, U> argFunc, boolean pushKey) {
        String funcName = pushKey ? "[applyMapKeys]" : "[applyMapValues]";
        ValidationLocation loc = this.location.peek();
        if (!loc.field().isMapField()) {
            throw new ETracInternal(funcName + " can only apply to map fields");
        }
        if (this.done()) {
            return this;
        }
        ValidationContextImpl resultCtx = this;
        if (loc.target() instanceof Map) {
            Map map = (Map)loc.target();
            for (Object key : map.keySet()) {
                Object arg = argFunc != null ? (Object)argFunc.apply(key.toString()) : null;
                resultCtx = (ValidationContextImpl)resultCtx.pushMapEntry(key, pushKey, false).apply(validator, targetClass, arg).pop();
            }
        } else {
            int mapSize = loc.parent().msg().getRepeatedFieldCount(loc.field());
            for (int i = 0; i < mapSize; ++i) {
                Object arg = null;
                if (argFunc != null) {
                    List map = (List)loc.target();
                    MapEntry entry = (MapEntry)map.get(i);
                    Object key = entry.getKey();
                    arg = argFunc.apply(key.toString());
                }
                resultCtx = (ValidationContextImpl)resultCtx.pushMapEntry(i, pushKey).apply(validator, targetClass, arg).pop();
            }
        }
        return resultCtx;
    }

    @Override
    public ValidationType validationType() {
        return this.validationType;
    }

    @Override
    public ValidationKey key() {
        ValidationLocation loc = this.location.peek();
        Message msg = loc.msg();
        if (msg == null) {
            throw new EUnexpected();
        }
        return new ValidationKey(this.validationType, msg.getDescriptorForType(), loc.method());
    }

    @Override
    public Object target() {
        return this.location.peek().target();
    }

    @Override
    public Message parentMsg() {
        ValidationLocation loc = this.location.peek();
        ValidationLocation parent = loc.parent();
        if (parent == null) {
            throw new ETracInternal("Attempt to access parent of root location");
        }
        if (loc.isRepeated() && loc.field().equals(parent.field())) {
            parent = parent.parent();
        }
        return parent.msg();
    }

    @Override
    public boolean isOneOf() {
        return this.location.peek().isOneOf();
    }

    @Override
    public boolean isRepeated() {
        return this.location.peek().field().isRepeated();
    }

    @Override
    public boolean isMap() {
        return this.location.peek().field().isMapField();
    }

    @Override
    public Descriptors.OneofDescriptor oneOf() {
        return this.location.peek().oneOf();
    }

    @Override
    public Descriptors.FieldDescriptor field() {
        return this.location.peek().field();
    }

    @Override
    public String fieldName() {
        return this.location.peek().fieldName();
    }

    @Override
    public ValidationContext prior() {
        return this.priorCtx;
    }

    @Override
    public boolean failed() {
        return this.location.peek().failed();
    }

    @Override
    public boolean skipped() {
        return this.location.peek().skipped();
    }

    @Override
    public boolean done() {
        return this.location.peek().done();
    }

    @Override
    public List<ValidationFailure> getErrors() {
        return this.failures;
    }
}

