/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.core.impl;

import io.grpc.Status;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.finos.tracdap.api.TracErrorDetails;
import org.finos.tracdap.api.TracErrorItem;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.impl.ValidationFailure;

public class ValidationResult {
    private static final String MULTIPLE_ERRORS_MESSAGE = "There were multiple validation errors";
    private final ValidationType validationType;
    private final String shortName;
    private final List<ValidationFailure> failures;

    public static ValidationResult pass(ValidationType validationType, String shortName) {
        return new ValidationResult(validationType, shortName, List.of());
    }

    public static ValidationResult forContext(ValidationContext ctx) {
        return new ValidationResult(ctx.validationType(), ctx.key().shortName(), ctx.getErrors());
    }

    public ValidationResult(ValidationType validationType, String shortName, List<ValidationFailure> failures) {
        this.validationType = validationType;
        this.shortName = shortName;
        this.failures = Collections.unmodifiableList(failures);
    }

    public boolean ok() {
        return this.failures.isEmpty();
    }

    public List<ValidationFailure> failures() {
        return this.failures;
    }

    public String failureMessage() {
        if (this.failures.isEmpty()) {
            return "";
        }
        if (this.failures.size() == 1) {
            return this.failures.get(0).locationAndMessage();
        }
        return "There were multiple validation errors\n" + this.failures().stream().map(ValidationFailure::locationAndMessage).collect(Collectors.joining("\n"));
    }

    public TracErrorDetails errorDetails() {
        TracErrorDetails.Builder details = TracErrorDetails.newBuilder();
        switch (this.validationType) {
            case STATIC: {
                details.setCode(Status.Code.INVALID_ARGUMENT.value());
                details.setMessage("Validation failed for [" + this.shortName + "]");
                break;
            }
            case VERSION: {
                details.setCode(Status.Code.FAILED_PRECONDITION.value());
                details.setMessage("Version compatability check failed for [" + this.shortName + "}");
                break;
            }
            case CONSISTENCY: {
                details.setCode(Status.Code.FAILED_PRECONDITION.value());
                details.setMessage("Consistency check failed for [" + this.shortName + "]");
                break;
            }
            default: {
                throw new EUnexpected();
            }
        }
        for (ValidationFailure failure : this.failures) {
            TracErrorItem errorItem = TracErrorItem.newBuilder().setDetail(failure.message()).setFieldPath(failure.location()).build();
            details.addItems(errorItem);
        }
        return details.build();
    }
}

