/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.StorageValidator;
import org.finos.tracdap.metadata.FileDefinition;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.TagSelector;

@Validator(type=ValidationType.STATIC)
public class FileValidator {
    private static final Pattern EXT_PATTERN = Pattern.compile(".*\\.([^./\\\\]+)");
    private static final Descriptors.Descriptor FILE_DEF = FileDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor FD_NAME = ValidatorUtils.field(FILE_DEF, 1);
    private static final Descriptors.FieldDescriptor FD_EXTENSION = ValidatorUtils.field(FILE_DEF, 2);
    private static final Descriptors.FieldDescriptor FD_MIME_TYPE = ValidatorUtils.field(FILE_DEF, 3);
    private static final Descriptors.FieldDescriptor FD_SIZE = ValidatorUtils.field(FILE_DEF, 4);
    private static final Descriptors.FieldDescriptor FD_DATA_ITEM = ValidatorUtils.field(FILE_DEF, 6);
    private static final Descriptors.FieldDescriptor FD_STORAGE_ID = ValidatorUtils.field(FILE_DEF, 5);

    @Validator
    public static ValidationContext file(FileDefinition msg, ValidationContext ctx) {
        ctx = ctx.push(FD_NAME).apply(CommonValidators::required).apply(CommonValidators::fileName).pop();
        ctx = ctx.push(FD_EXTENSION).apply(FileValidator::extensionMatchesName, String.class, msg.getName()).pop();
        ctx = ctx.push(FD_MIME_TYPE).apply(CommonValidators::required).apply(CommonValidators::mimeType).pop();
        ctx = ctx.push(FD_SIZE).apply(CommonValidators::optional).apply(CommonValidators::notNegative, Long.class).pop();
        ctx = ctx.push(FD_DATA_ITEM).apply(CommonValidators::required).apply(StorageValidator::dataItemKey).pop();
        ctx = ctx.push(FD_STORAGE_ID).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.STORAGE).apply(ObjectIdValidator::selectorForLatest, TagSelector.class).pop();
        return ctx;
    }

    private static ValidationContext extensionMatchesName(String extension, String fileName, ValidationContext ctx) {
        String nameExt;
        Matcher nameExtMatch = EXT_PATTERN.matcher(fileName);
        if (nameExtMatch.matches() && !(nameExt = nameExtMatch.group(1)).equals(extension)) {
            String err = String.format("Extension does not match file name: extension = [%s], name ends with [%s]", extension, nameExtMatch.group());
            ctx = ctx.error(err);
        }
        return ctx;
    }
}

