/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ModelValidator;
import org.finos.tracdap.common.validation.static_.SearchValidator;
import org.finos.tracdap.common.validation.static_.TagUpdateValidator;
import org.finos.tracdap.metadata.FlowDefinition;
import org.finos.tracdap.metadata.FlowEdge;
import org.finos.tracdap.metadata.FlowNode;
import org.finos.tracdap.metadata.FlowNodeType;
import org.finos.tracdap.metadata.FlowSocket;
import org.finos.tracdap.metadata.SearchExpression;
import org.finos.tracdap.metadata.TagUpdate;

@Validator(type=ValidationType.STATIC)
public class FlowValidator {
    private static final Descriptors.Descriptor FLOW_DEFINITION = FlowDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor FD_NODES = ValidatorUtils.field(FLOW_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor FD_EDGES = ValidatorUtils.field(FLOW_DEFINITION, 2);
    private static final Descriptors.FieldDescriptor FD_PARAMETERS = ValidatorUtils.field(FLOW_DEFINITION, 3);
    private static final Descriptors.FieldDescriptor FD_INPUTS = ValidatorUtils.field(FLOW_DEFINITION, 4);
    private static final Descriptors.FieldDescriptor FD_OUTPUTS = ValidatorUtils.field(FLOW_DEFINITION, 5);
    private static final Descriptors.Descriptor FLOW_NODE = FlowNode.getDescriptor();
    private static final Descriptors.FieldDescriptor FN_NODE_TYPE = ValidatorUtils.field(FLOW_NODE, 1);
    private static final Descriptors.FieldDescriptor FN_PARAMETERS = ValidatorUtils.field(FLOW_NODE, 7);
    private static final Descriptors.FieldDescriptor FN_INPUTS = ValidatorUtils.field(FLOW_NODE, 2);
    private static final Descriptors.FieldDescriptor FN_OUTPUTS = ValidatorUtils.field(FLOW_NODE, 3);
    private static final Descriptors.FieldDescriptor FN_NODE_SEARCH = ValidatorUtils.field(FLOW_NODE, 4);
    private static final Descriptors.FieldDescriptor FN_NODE_ATTRS = ValidatorUtils.field(FLOW_NODE, 5);
    private static final Descriptors.FieldDescriptor FN_NODE_PROPS = ValidatorUtils.field(FLOW_NODE, 8);
    private static final Descriptors.FieldDescriptor FN_LABEL = ValidatorUtils.field(FLOW_NODE, 6);
    private static final Descriptors.Descriptor FLOW_EDGE = FlowEdge.getDescriptor();
    private static final Descriptors.FieldDescriptor FE_SOURCE = ValidatorUtils.field(FLOW_EDGE, 1);
    private static final Descriptors.FieldDescriptor FE_TARGET = ValidatorUtils.field(FLOW_EDGE, 2);
    private static final Descriptors.Descriptor FLOW_SOCKET = FlowSocket.getDescriptor();
    private static final Descriptors.FieldDescriptor FS_NODE = ValidatorUtils.field(FLOW_SOCKET, 1);
    private static final Descriptors.FieldDescriptor FS_SOCKET = ValidatorUtils.field(FLOW_SOCKET, 2);

    @Validator
    public static ValidationContext flow(FlowDefinition flow, ValidationContext ctx) {
        ctx = ctx.pushMap(FD_NODES).apply(CommonValidators::mapNotEmpty).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).apply(CommonValidators::caseInsensitiveDuplicates).applyMapValues(FlowValidator::flowNode, FlowNode.class).pop();
        if (!(ctx = ctx.pushRepeated(FD_EDGES).apply(CommonValidators::listNotEmpty).applyRepeated(FlowValidator::flowEdge, FlowEdge.class).pop()).failed()) {
            ctx = ctx.apply(FlowValidator::flowConsistency, FlowDefinition.class);
        }
        if (flow.getInputsCount() > 0 || flow.getOutputsCount() > 0 || flow.getParametersCount() > 0) {
            ctx = ModelValidator.modelSchema(FD_PARAMETERS, FD_INPUTS, FD_OUTPUTS, ctx);
        }
        if (flow.getInputsCount() > 0 || flow.getOutputsCount() > 0) {
            ctx = ctx.apply(FlowValidator::flowSchemaMatch, FlowDefinition.class);
        }
        if (flow.getParametersCount() > 0) {
            ctx = ctx.apply(FlowValidator::flowParametersMatch, FlowDefinition.class);
        }
        return ctx;
    }

    @Validator
    public static ValidationContext flowNode(FlowNode msg, ValidationContext ctx) {
        ctx = ctx.push(FN_NODE_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, FlowNodeType.class).pop();
        boolean isModelNode = msg.getNodeType() == FlowNodeType.MODEL_NODE;
        String isModelNodeQualifier = String.format("%s == %s", FN_NODE_TYPE.getName(), FlowNodeType.MODEL_NODE.name());
        boolean isOutputNode = msg.getNodeType() == FlowNodeType.OUTPUT_NODE;
        String isOutputNodeQualifier = String.format("%s == %s", FN_NODE_TYPE.getName(), FlowNodeType.OUTPUT_NODE.name());
        boolean notParamNode = msg.getNodeType() == FlowNodeType.PARAMETER_NODE;
        String notParamNodeQualifier = String.format("%s == %s", FN_NODE_TYPE.getName(), FlowNodeType.PARAMETER_NODE.name());
        HashMap<String, String> knownSockets = new HashMap<String, String>();
        ctx = ctx.pushRepeated(FN_PARAMETERS).apply(CommonValidators.onlyIf(isModelNode, isModelNodeQualifier)).applyRepeated(CommonValidators::identifier, String.class).applyRepeated(CommonValidators::notTracReserved, String.class).apply(CommonValidators::caseInsensitiveDuplicates).applyRepeated(CommonValidators.uniqueContextCheck(knownSockets, FN_PARAMETERS.getName())).pop();
        ctx = ctx.pushRepeated(FN_INPUTS).apply(CommonValidators.ifAndOnlyIf(isModelNode, isModelNodeQualifier)).applyRepeated(CommonValidators::identifier, String.class).applyRepeated(CommonValidators::notTracReserved, String.class).apply(CommonValidators::caseInsensitiveDuplicates).applyRepeated(CommonValidators.uniqueContextCheck(knownSockets, FN_INPUTS.getName())).pop();
        ctx = ctx.pushRepeated(FN_OUTPUTS).apply(CommonValidators.ifAndOnlyIf(isModelNode, isModelNodeQualifier)).applyRepeated(CommonValidators::identifier, String.class).applyRepeated(CommonValidators::notTracReserved, String.class).apply(CommonValidators::caseInsensitiveDuplicates).applyRepeated(CommonValidators.uniqueContextCheck(knownSockets, FN_OUTPUTS.getName())).pop();
        ctx = ctx.push(FN_NODE_SEARCH).apply(CommonValidators.onlyIf(notParamNode, notParamNodeQualifier, true)).apply(SearchValidator::searchExpression, SearchExpression.class).pop();
        ctx = ctx.pushRepeated(FN_NODE_ATTRS).apply(CommonValidators.onlyIf(isOutputNode, isOutputNodeQualifier)).applyRepeated(TagUpdateValidator::tagUpdate, TagUpdate.class).pop();
        ctx = ctx.pushMap(FN_NODE_PROPS).apply(CommonValidators::optional).apply(CommonValidators::standardProps).pop();
        ctx = ctx.push(FN_LABEL).apply(CommonValidators::optional).apply(CommonValidators::labelLengthLimit).pop();
        return ctx;
    }

    @Validator
    private static ValidationContext flowEdge(FlowEdge msg, ValidationContext ctx) {
        ctx = ctx.push(FE_SOURCE).apply(CommonValidators::required).apply(FlowValidator::flowSocket, FlowSocket.class).pop();
        ctx = ctx.push(FE_TARGET).apply(CommonValidators::required).apply(FlowValidator::flowSocket, FlowSocket.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext flowSocket(FlowSocket msg, ValidationContext ctx) {
        ctx = ctx.push(FS_NODE).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(FS_SOCKET).apply(CommonValidators::optional).apply(CommonValidators::identifier).pop();
        return ctx;
    }

    private static ValidationContext flowSchemaMatch(FlowDefinition flow, ValidationContext ctx) {
        HashSet schemaInputs = new HashSet(flow.getInputsMap().keySet());
        HashSet schemaOutputs = new HashSet(flow.getOutputsMap().keySet());
        for (Map.Entry nodeEntry : flow.getNodesMap().entrySet()) {
            boolean matched;
            String nodeName = (String)nodeEntry.getKey();
            FlowNode node = (FlowNode)nodeEntry.getValue();
            if (node.getNodeType() == FlowNodeType.INPUT_NODE && !(matched = schemaInputs.remove(nodeName))) {
                ctx = ctx.error(String.format("Input node [%s] is missing from flow explicit inputs", nodeName));
            }
            if (node.getNodeType() != FlowNodeType.OUTPUT_NODE || (matched = schemaOutputs.remove(nodeName))) continue;
            ctx = ctx.error(String.format("Output node [%s] is missing from flow explicit outputs", nodeName));
        }
        for (String inputName : schemaInputs) {
            ctx = ctx.error(String.format("Flow explicit input [%s] does not correspond to an input node", inputName));
        }
        for (String outputName : schemaOutputs) {
            ctx = ctx.error(String.format("Flow explicit output [%s] does not correspond to an output node", outputName));
        }
        return ctx;
    }

    private static ValidationContext flowParametersMatch(FlowDefinition flow, ValidationContext ctx) {
        for (String paramName : flow.getParametersMap().keySet()) {
            FlowNode node;
            if (!flow.containsNodes(paramName) || (node = flow.getNodesOrThrow(paramName)).getNodeType() != FlowNodeType.PARAMETER_NODE) continue;
            ctx = ctx.error(String.format("Flow parameter [%s] conflicts with a node of type [%s]", paramName, node.getNodeType()));
        }
        return ctx;
    }

    private static ValidationContext flowConsistency(FlowDefinition msg, ValidationContext ctx) {
        Map nodes = msg.getNodesMap();
        ctx = ctx.pushRepeated(FD_EDGES).applyRepeated(FlowValidator::edgeConnection, FlowEdge.class, nodes).pop();
        ctx.apply(FlowValidator::oneEdgePerTarget, FlowDefinition.class);
        ctx.apply(FlowValidator::noUnusedNodes, FlowDefinition.class);
        ctx.apply(FlowValidator::cyclicRedundancyCheck, FlowDefinition.class);
        return ctx;
    }

    private static ValidationContext edgeConnection(FlowEdge edge, Map<String, FlowNode> nodes, ValidationContext ctx) {
        ctx.push(FE_SOURCE);
        ctx.apply(FlowValidator::socketConnection, FlowSocket.class, nodes);
        ctx.pop();
        ctx.push(FE_TARGET);
        ctx.apply(FlowValidator::socketConnection, FlowSocket.class, nodes);
        ctx.pop();
        if (edge.getSource().getNode().equals(edge.getTarget().getNode())) {
            ctx.error(String.format("Source and target both point to the same node [%s]", edge.getSource().getNode()));
        }
        FlowNode sourceNode = nodes.getOrDefault(edge.getSource().getNode(), null);
        FlowNode targetNode = nodes.getOrDefault(edge.getTarget().getNode(), null);
        if (sourceNode != null && sourceNode.getNodeType() == FlowNodeType.INPUT_NODE && targetNode != null && targetNode.getNodeType() == FlowNodeType.OUTPUT_NODE) {
            ctx.error(String.format("Input node [%s] is connected directly to output node [%s]", edge.getSource().getNode(), edge.getTarget().getNode()));
        }
        return ctx;
    }

    private static ValidationContext socketConnection(FlowSocket socket, Map<String, FlowNode> nodes, ValidationContext ctx) {
        String socketType = ctx.field().equals(FE_SOURCE) ? "Source" : "Target";
        FlowNode node = nodes.getOrDefault(socket.getNode(), null);
        if (node == null) {
            ctx.error(String.format("%s node [%s] does not exist", socketType, socket.getNode()));
        } else if (node.getNodeType() == FlowNodeType.OUTPUT_NODE) {
            if (ctx.field().equals(FE_SOURCE)) {
                ctx.error(String.format("Output node [%s] cannot be used as a source", socket.getNode()));
            } else if (socket.hasField(FS_SOCKET)) {
                ctx.error(String.format("Target node [%s] is an output node, do not specify a [socket]", socket.getNode()));
            }
        } else if (node.getNodeType() == FlowNodeType.INPUT_NODE) {
            if (ctx.field().equals(FE_TARGET)) {
                ctx.error(String.format("Input node [%s] cannot be used as a target", socket.getNode()));
            } else if (socket.hasField(FS_SOCKET)) {
                ctx.error(String.format("Source node [%s] is an input node, do not specify a [socket]", socket.getNode()));
            }
        } else if (node.getNodeType() == FlowNodeType.PARAMETER_NODE) {
            if (ctx.field().equals(FE_TARGET)) {
                ctx.error(String.format("Parameter node [%s] cannot be used as a target", socket.getNode()));
            } else if (socket.hasField(FS_SOCKET)) {
                ctx.error(String.format("Source node [%s] is a parameter node, do not specify a [socket]", socket.getNode()));
            }
        } else {
            ProtocolStringList modelSockets;
            String inputOrOutput = ctx.field().equals(FE_SOURCE) ? "output" : "input";
            ProtocolStringList protocolStringList = modelSockets = ctx.field().equals(FE_SOURCE) ? node.getOutputsList() : node.getInputsList();
            if (!socket.hasField(FS_SOCKET)) {
                ctx.error(String.format("%s node [%s] is a model node, specify a [socket] to connect to a model %s", socketType, socket.getNode(), inputOrOutput));
            } else if (!modelSockets.contains((Object)socket.getSocket())) {
                ctx.error(String.format("Socket [%s] is not an %s of node [%s]", socket.getSocket(), inputOrOutput, socket.getNode()));
            }
        }
        return ctx;
    }

    private static ValidationContext oneEdgePerTarget(FlowDefinition flow, ValidationContext ctx) {
        HashMap<String, Integer> edgesByTarget = new HashMap<String, Integer>();
        for (FlowEdge flowEdge : flow.getEdgesList()) {
            String socketKey = FlowValidator.socketKey(flowEdge.getTarget());
            if (!edgesByTarget.containsKey(socketKey)) {
                edgesByTarget.put(socketKey, 1);
                continue;
            }
            edgesByTarget.put(socketKey, (Integer)edgesByTarget.get(socketKey) + 1);
        }
        for (Map.Entry entry : flow.getNodesMap().entrySet()) {
            String nodeName = (String)entry.getKey();
            FlowNode node = (FlowNode)entry.getValue();
            for (String target : FlowValidator.incomingSockets(nodeName, node)) {
                Integer incomingEdges = (Integer)edgesByTarget.get(target);
                if (incomingEdges == null || incomingEdges == 0) {
                    ctx.error(String.format("Target [%s] is not supplied by any edge", target));
                    continue;
                }
                if (incomingEdges <= 1) continue;
                ctx.error(String.format("Target [%s] is supplied by %d edges", target, incomingEdges));
            }
        }
        return ctx;
    }

    private static ValidationContext noUnusedNodes(FlowDefinition flow, ValidationContext ctx) {
        Set usedNodes = flow.getEdgesList().stream().map(FlowEdge::getSource).map(FlowSocket::getNode).collect(Collectors.toSet());
        for (Map.Entry nodeEntry : flow.getNodesMap().entrySet()) {
            String nodeName = (String)nodeEntry.getKey();
            FlowNode node = (FlowNode)nodeEntry.getValue();
            if (node.getNodeType() == FlowNodeType.PARAMETER_NODE && !usedNodes.contains(nodeName)) {
                ctx = ctx.error(String.format("Parameter node [%s] is not used", nodeName));
            }
            if (node.getNodeType() == FlowNodeType.INPUT_NODE && !usedNodes.contains(nodeName)) {
                ctx = ctx.error(String.format("Input node [%s] is not used", nodeName));
            }
            if (node.getNodeType() != FlowNodeType.MODEL_NODE || usedNodes.contains(nodeName)) continue;
            ctx = ctx.error(String.format("The outputs of model node [%s] are not used", nodeName));
        }
        return ctx;
    }

    private static ValidationContext cyclicRedundancyCheck(FlowDefinition flow, ValidationContext ctx) {
        HashMap remainingNodes = new HashMap(flow.getNodesMap());
        HashMap<String, FlowNode> reachableNodes = new HashMap<String, FlowNode>();
        HashMap edgesBySource = new HashMap();
        HashMap edgesByTarget = new HashMap();
        for (FlowEdge flowEdge : flow.getEdgesList()) {
            String sourceNode = flowEdge.getSource().getNode();
            String targetNode = flowEdge.getTarget().getNode();
            if (!edgesBySource.containsKey(sourceNode)) {
                edgesBySource.put(sourceNode, new ArrayList());
            }
            if (!edgesByTarget.containsKey(targetNode)) {
                edgesByTarget.put(targetNode, new ArrayList());
            }
            ((List)edgesBySource.get(sourceNode)).add(flowEdge);
            ((List)edgesByTarget.get(targetNode)).add(flowEdge);
        }
        for (Map.Entry entry : remainingNodes.entrySet()) {
            if (((FlowNode)entry.getValue()).getNodeType() != FlowNodeType.PARAMETER_NODE && ((FlowNode)entry.getValue()).getNodeType() != FlowNodeType.INPUT_NODE) continue;
            reachableNodes.put((String)entry.getKey(), (FlowNode)entry.getValue());
        }
        for (String string : reachableNodes.keySet()) {
            remainingNodes.remove(string);
        }
        while (!reachableNodes.isEmpty()) {
            Optional nodeKey = reachableNodes.keySet().stream().findAny();
            String string = (String)nodeKey.get();
            reachableNodes.remove(string);
            List sourceEdges = (List)edgesBySource.remove(string);
            if (sourceEdges == null) continue;
            for (FlowEdge edge : sourceEdges) {
                String targetNodeName = edge.getTarget().getNode();
                List targetEdges = (List)edgesByTarget.get(targetNodeName);
                targetEdges.remove(edge);
                if (!targetEdges.isEmpty()) continue;
                FlowNode targetNode = (FlowNode)remainingNodes.remove(targetNodeName);
                reachableNodes.put(targetNodeName, targetNode);
            }
        }
        for (String string : remainingNodes.keySet()) {
            ctx.error(String.format("Flow node [%s] is not reachable (this may indicate a cyclic dependency)", string));
        }
        return ctx;
    }

    private static String socketKey(FlowSocket socket) {
        return socket.getSocket().isEmpty() ? socket.getNode() : socket.getNode() + "." + socket.getSocket();
    }

    private static Iterable<String> incomingSockets(String nodeName, FlowNode node) {
        switch (node.getNodeType()) {
            case PARAMETER_NODE: 
            case INPUT_NODE: {
                return List.of();
            }
            case OUTPUT_NODE: {
                return List.of(nodeName);
            }
            case MODEL_NODE: {
                return node.getInputsList().stream().map(socket -> nodeName + "." + socket).collect(Collectors.toList());
            }
        }
        throw new EUnexpected();
    }
}

