/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.Map;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.ModelValidator;
import org.finos.tracdap.common.validation.static_.ObjectIdValidator;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.ImportModelJob;
import org.finos.tracdap.metadata.JobDefinition;
import org.finos.tracdap.metadata.JobType;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.RunFlowJob;
import org.finos.tracdap.metadata.RunModelJob;
import org.finos.tracdap.metadata.TagSelector;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class JobValidator {
    private static final Map<JobDefinition.JobDetailsCase, JobType> JOB_DETAILS_CASE_MAPPING = Map.ofEntries(Map.entry(JobDefinition.JobDetailsCase.RUNMODEL, JobType.RUN_MODEL), Map.entry(JobDefinition.JobDetailsCase.RUNFLOW, JobType.RUN_FLOW), Map.entry(JobDefinition.JobDetailsCase.IMPORTMODEL, JobType.IMPORT_MODEL));
    private static final Descriptors.Descriptor JOB_DEFINITION = JobDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor JD_JOB_TYPE = ValidatorUtils.field(JOB_DEFINITION, 1);
    private static final Descriptors.OneofDescriptor JD_JOB_DETAILS = ValidatorUtils.field(JOB_DEFINITION, 2).getContainingOneof();
    private static final Descriptors.Descriptor IMPORT_MODEL_JOB = ImportModelJob.getDescriptor();
    private static final Descriptors.FieldDescriptor IMJ_LANGUAGE = ValidatorUtils.field(IMPORT_MODEL_JOB, 1);
    private static final Descriptors.FieldDescriptor IMJ_REPOSITORY = ValidatorUtils.field(IMPORT_MODEL_JOB, 2);
    private static final Descriptors.FieldDescriptor IMJ_PATH = ValidatorUtils.field(IMPORT_MODEL_JOB, 3);
    private static final Descriptors.FieldDescriptor IMJ_ENTRY_POINT = ValidatorUtils.field(IMPORT_MODEL_JOB, 4);
    private static final Descriptors.FieldDescriptor IMJ_VERSION = ValidatorUtils.field(IMPORT_MODEL_JOB, 5);
    private static final Descriptors.Descriptor RUN_MODEL_JOB = RunModelJob.getDescriptor();
    private static final Descriptors.FieldDescriptor RMJ_MODEL = ValidatorUtils.field(RUN_MODEL_JOB, 1);
    private static final Descriptors.FieldDescriptor RMJ_PARAMETERS = ValidatorUtils.field(RUN_MODEL_JOB, 2);
    private static final Descriptors.FieldDescriptor RMJ_INPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 3);
    private static final Descriptors.FieldDescriptor RMJ_OUTPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 4);
    private static final Descriptors.FieldDescriptor RMJ_PRIOR_OUTPUTS = ValidatorUtils.field(RUN_MODEL_JOB, 5);
    private static final Descriptors.Descriptor RUN_FLOW_JOB = RunFlowJob.getDescriptor();
    private static final Descriptors.FieldDescriptor RFJ_FLOW = ValidatorUtils.field(RUN_FLOW_JOB, 1);
    private static final Descriptors.FieldDescriptor RFJ_MODELS = ValidatorUtils.field(RUN_FLOW_JOB, 6);
    private static final Descriptors.FieldDescriptor RFJ_PARAMETERS = ValidatorUtils.field(RUN_FLOW_JOB, 2);
    private static final Descriptors.FieldDescriptor RFJ_INPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 3);
    private static final Descriptors.FieldDescriptor RFJ_OUTPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 4);
    private static final Descriptors.FieldDescriptor RFJ_PRIOR_OUTPUTS = ValidatorUtils.field(RUN_FLOW_JOB, 5);

    @Validator
    public static ValidationContext job(JobDefinition msg, ValidationContext ctx) {
        ctx = ctx.push(JD_JOB_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, JobType.class).pop();
        ctx = ctx.pushOneOf(JD_JOB_DETAILS).apply(CommonValidators::required).apply(JobValidator::jobMatchesType).applyRegistered().pop();
        return ctx;
    }

    @Validator
    public static ValidationContext importModelJob(ImportModelJob msg, ValidationContext ctx) {
        return ModelValidator.modelDetails(IMJ_LANGUAGE, IMJ_REPOSITORY, IMJ_PATH, IMJ_ENTRY_POINT, IMJ_VERSION, ctx);
    }

    @Validator
    public static ValidationContext runModelJob(RunModelJob msg, ValidationContext ctx) {
        ctx = ctx.push(RMJ_MODEL).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.MODEL).pop();
        return JobValidator.runModelOrFlow(ctx, RMJ_PARAMETERS, RMJ_INPUTS, RMJ_OUTPUTS, RMJ_PRIOR_OUTPUTS);
    }

    @Validator
    public static ValidationContext runFlowJob(RunFlowJob msg, ValidationContext ctx) {
        ctx = ctx.push(RFJ_FLOW).apply(CommonValidators::required).apply(ObjectIdValidator::tagSelector, TagSelector.class).apply(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.FLOW).pop();
        ctx = ctx.pushMap(RFJ_MODELS).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).applyMapValues(ObjectIdValidator::tagSelector, TagSelector.class).applyMapValues(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.MODEL).applyMapValues(ObjectIdValidator::fixedObjectVersion, TagSelector.class).pop();
        return JobValidator.runModelOrFlow(ctx, RFJ_PARAMETERS, RFJ_INPUTS, RFJ_OUTPUTS, RFJ_PRIOR_OUTPUTS);
    }

    public static ValidationContext runModelOrFlow(ValidationContext ctx, Descriptors.FieldDescriptor parameters, Descriptors.FieldDescriptor inputs, Descriptors.FieldDescriptor outputs, Descriptors.FieldDescriptor priorOutputs) {
        ctx = ctx.pushMap(parameters).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).applyMapValues(TypeSystemValidator::value, Value.class).pop();
        ctx = ctx.pushMap(inputs).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).applyMapValues(ObjectIdValidator::tagSelector, TagSelector.class).applyMapValues(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.DATA).applyMapValues(ObjectIdValidator::fixedObjectVersion, TagSelector.class).pop();
        ctx = ctx.pushMap(outputs).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).applyMapValues(ObjectIdValidator::tagSelector, TagSelector.class).applyMapValues(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.DATA).applyMapValues(ObjectIdValidator::fixedObjectVersion, TagSelector.class).pop();
        ctx = ctx.pushMap(priorOutputs).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).applyMapValues(ObjectIdValidator::tagSelector, TagSelector.class).applyMapValues(ObjectIdValidator::selectorType, TagSelector.class, ObjectType.DATA).applyMapValues(ObjectIdValidator::fixedObjectVersion, TagSelector.class).pop();
        return ctx;
    }

    private static ValidationContext jobMatchesType(ValidationContext ctx) {
        JobType detailsType;
        JobDefinition job = (JobDefinition)ctx.parentMsg();
        JobDefinition.JobDetailsCase detailsCase = job.getJobDetailsCase();
        JobType jobType = job.getJobType();
        if (jobType != (detailsType = JOB_DETAILS_CASE_MAPPING.getOrDefault(detailsCase, JobType.UNRECOGNIZED))) {
            String err = String.format("Job has type [%s] but contains details of type [%s]", jobType, detailsType);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext outputsMustBeEmpty(JobDefinition msg, ValidationContext ctx) {
        ctx = ctx.pushOneOf(JD_JOB_DETAILS);
        if (msg.getJobType() == JobType.RUN_MODEL) {
            ctx = ctx.apply(JobValidator::outputsMustBeEmpty, RunModelJob.class);
        }
        return ctx.pop();
    }

    private static ValidationContext outputsMustBeEmpty(RunModelJob msg, ValidationContext ctx) {
        if (msg.getOutputsCount() > 0) {
            ctx = ctx.push(RMJ_OUTPUTS).error("Outputs must be empty, they cannot be specified explicitly when submitting a job").pop();
        }
        return ctx;
    }
}

