/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.HashMap;
import java.util.regex.Matcher;
import org.finos.tracdap.common.validation.ValidationConstants;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.SchemaValidator;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.ModelDefinition;
import org.finos.tracdap.metadata.ModelInputSchema;
import org.finos.tracdap.metadata.ModelOutputSchema;
import org.finos.tracdap.metadata.ModelParameter;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class ModelValidator {
    private static final Descriptors.Descriptor MODEL_DEFINITION = ModelDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor MD_LANGUAGE = ValidatorUtils.field(MODEL_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor MD_REPOSITORY = ValidatorUtils.field(MODEL_DEFINITION, 2);
    private static final Descriptors.FieldDescriptor MD_PATH = ValidatorUtils.field(MODEL_DEFINITION, 3);
    private static final Descriptors.FieldDescriptor MD_ENTRY_POINT = ValidatorUtils.field(MODEL_DEFINITION, 5);
    private static final Descriptors.FieldDescriptor MD_VERSION = ValidatorUtils.field(MODEL_DEFINITION, 6);
    private static final Descriptors.FieldDescriptor MD_PARAMETERS = ValidatorUtils.field(MODEL_DEFINITION, 7);
    private static final Descriptors.FieldDescriptor MD_INPUTS = ValidatorUtils.field(MODEL_DEFINITION, 8);
    private static final Descriptors.FieldDescriptor MD_OUTPUTS = ValidatorUtils.field(MODEL_DEFINITION, 9);
    private static final Descriptors.Descriptor MODEL_PARAMETER = ModelParameter.getDescriptor();
    private static final Descriptors.FieldDescriptor MP_PARAM_TYPE = ValidatorUtils.field(MODEL_PARAMETER, 1);
    private static final Descriptors.FieldDescriptor MP_LABEL = ValidatorUtils.field(MODEL_PARAMETER, 2);
    private static final Descriptors.FieldDescriptor MP_DEFAULT_VALUE = ValidatorUtils.field(MODEL_PARAMETER, 3);
    private static final Descriptors.FieldDescriptor MP_PARAM_PROPS = ValidatorUtils.field(MODEL_PARAMETER, 4);
    private static final Descriptors.Descriptor MODEL_INPUT_SCHEMA = ModelInputSchema.getDescriptor();
    private static final Descriptors.FieldDescriptor MIS_SCHEMA = ValidatorUtils.field(MODEL_INPUT_SCHEMA, 1);
    private static final Descriptors.FieldDescriptor MIS_LABEL = ValidatorUtils.field(MODEL_INPUT_SCHEMA, 2);
    private static final Descriptors.FieldDescriptor MIS_OPTIONAL = ValidatorUtils.field(MODEL_INPUT_SCHEMA, 3);
    private static final Descriptors.FieldDescriptor MIS_DYNAMIC = ValidatorUtils.field(MODEL_INPUT_SCHEMA, 5);
    private static final Descriptors.FieldDescriptor MIS_INPUT_PROPS = ValidatorUtils.field(MODEL_INPUT_SCHEMA, 4);
    private static final Descriptors.Descriptor MODEL_OUTPUT_SCHEMA = ModelOutputSchema.getDescriptor();
    private static final Descriptors.FieldDescriptor MOS_SCHEMA = ValidatorUtils.field(MODEL_OUTPUT_SCHEMA, 1);
    private static final Descriptors.FieldDescriptor MOS_LABEL = ValidatorUtils.field(MODEL_OUTPUT_SCHEMA, 2);
    private static final Descriptors.FieldDescriptor MOS_OPTIONAL = ValidatorUtils.field(MODEL_OUTPUT_SCHEMA, 3);
    private static final Descriptors.FieldDescriptor MOS_DYNAMIC = ValidatorUtils.field(MODEL_OUTPUT_SCHEMA, 5);
    private static final Descriptors.FieldDescriptor MOS_OUTPUT_PROPS = ValidatorUtils.field(MODEL_OUTPUT_SCHEMA, 4);

    @Validator
    public static ValidationContext model(ModelDefinition msg, ValidationContext ctx) {
        ctx = ModelValidator.modelDetails(MD_LANGUAGE, MD_REPOSITORY, MD_PATH, MD_ENTRY_POINT, MD_VERSION, ctx);
        ctx = ModelValidator.modelSchema(MD_PARAMETERS, MD_INPUTS, MD_OUTPUTS, ctx);
        return ctx;
    }

    public static ValidationContext modelDetails(Descriptors.FieldDescriptor languageField, Descriptors.FieldDescriptor repositoryField, Descriptors.FieldDescriptor pathField, Descriptors.FieldDescriptor entryPointField, Descriptors.FieldDescriptor versionField, ValidationContext ctx) {
        ctx = ctx.push(languageField).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(repositoryField).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(pathField).apply(CommonValidators::optional).apply(CommonValidators::relativePath).pop();
        ctx = ctx.push(entryPointField).apply(CommonValidators::required).apply(ModelValidator::modelEntryPoint).pop();
        ctx = ctx.push(versionField).apply(CommonValidators::required).apply(ModelValidator::modelVersion).pop();
        return ctx;
    }

    public static ValidationContext modelSchema(Descriptors.FieldDescriptor paramsField, Descriptors.FieldDescriptor inputsField, Descriptors.FieldDescriptor outputsField, ValidationContext ctx) {
        HashMap<String, String> knownIdentifiers = new HashMap<String, String>();
        ctx = ctx.pushMap(paramsField).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).apply(CommonValidators::caseInsensitiveDuplicates).applyMapKeys(CommonValidators.uniqueContextCheck(knownIdentifiers, paramsField.getName())).applyMapValues(ModelValidator::modelParameter, ModelParameter.class).pop();
        ctx = ctx.pushMap(inputsField).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).apply(CommonValidators::caseInsensitiveDuplicates).applyMapKeys(CommonValidators.uniqueContextCheck(knownIdentifiers, inputsField.getName())).applyMapValues(ModelValidator::modelInputSchema, ModelInputSchema.class).pop();
        ctx = ctx.pushMap(outputsField).applyMapKeys(CommonValidators::identifier).applyMapKeys(CommonValidators::notTracReserved).apply(CommonValidators::caseInsensitiveDuplicates).applyMapKeys(CommonValidators.uniqueContextCheck(knownIdentifiers, outputsField.getName())).applyMapValues(ModelValidator::modelOutputSchema, ModelOutputSchema.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext modelParameter(ModelParameter msg, ValidationContext ctx) {
        ctx = ctx.push(MP_PARAM_TYPE).apply(CommonValidators::required).apply(TypeSystemValidator::typeDescriptor, TypeDescriptor.class).pop();
        ctx = ctx.push(MP_LABEL).apply(CommonValidators::optional).apply(CommonValidators::labelLengthLimit).pop();
        ctx = ctx.push(MP_DEFAULT_VALUE).apply(CommonValidators::optional).apply(TypeSystemValidator::valueWithType, Value.class, msg.getParamType()).pop();
        ctx = ctx.pushMap(MP_PARAM_PROPS).apply(CommonValidators::optional).apply(CommonValidators::standardProps).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext modelInputSchema(ModelInputSchema msg, ValidationContext ctx) {
        ctx = ctx.push(MIS_SCHEMA).apply(CommonValidators::required).applyIf(!msg.getDynamic(), SchemaValidator::schema, SchemaDefinition.class).applyIf(msg.getDynamic(), SchemaValidator::dynamicSchema, SchemaDefinition.class).pop();
        ctx = ctx.push(MIS_LABEL).apply(CommonValidators::optional).apply(CommonValidators::labelLengthLimit).pop();
        ctx = ctx.pushMap(MIS_INPUT_PROPS).apply(CommonValidators::optional).apply(CommonValidators::standardProps).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext modelOutputSchema(ModelOutputSchema msg, ValidationContext ctx) {
        ctx = ctx.push(MOS_SCHEMA).apply(CommonValidators::required).applyIf(!msg.getDynamic(), SchemaValidator::schema, SchemaDefinition.class).applyIf(msg.getDynamic(), SchemaValidator::dynamicSchema, SchemaDefinition.class).pop();
        ctx = ctx.push(MOS_LABEL).apply(CommonValidators::optional).apply(CommonValidators::labelLengthLimit).pop();
        ctx = ctx.pushMap(MOS_OUTPUT_PROPS).apply(CommonValidators::optional).apply(CommonValidators::standardProps).pop();
        return ctx;
    }

    public static ValidationContext modelEntryPoint(String modelEntryPoint, ValidationContext ctx) {
        Matcher matcher = ValidationConstants.MODEL_ENTRY_POINT.matcher(modelEntryPoint);
        if (!matcher.matches()) {
            String err = String.format("Invalid model entry point [%s] (expected format: pkg.sub_pkg.ModelClass)", modelEntryPoint);
            return ctx.error(err);
        }
        return ctx;
    }

    public static ValidationContext modelVersion(String modelVersion, ValidationContext ctx) {
        Matcher matcher = ValidationConstants.MODEL_VERSION.matcher(modelVersion);
        if (!matcher.matches()) {
            String err = String.format("Invalid model version [%s] (version can contain letters, numbers, hyphen, underscore and period, starting with a letter or number)", modelVersion);
            return ctx.error(err);
        }
        return ctx;
    }
}

