/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.Map;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.metadata.ObjectDefinition;
import org.finos.tracdap.metadata.ObjectType;

@Validator(type=ValidationType.STATIC)
public class ObjectValidator {
    private static final Map<ObjectDefinition.DefinitionCase, ObjectType> DEFINITION_CASE_MAPPING = Map.ofEntries(Map.entry(ObjectDefinition.DefinitionCase.DATA, ObjectType.DATA), Map.entry(ObjectDefinition.DefinitionCase.MODEL, ObjectType.MODEL), Map.entry(ObjectDefinition.DefinitionCase.FLOW, ObjectType.FLOW), Map.entry(ObjectDefinition.DefinitionCase.JOB, ObjectType.JOB), Map.entry(ObjectDefinition.DefinitionCase.FILE, ObjectType.FILE), Map.entry(ObjectDefinition.DefinitionCase.CUSTOM, ObjectType.CUSTOM), Map.entry(ObjectDefinition.DefinitionCase.STORAGE, ObjectType.STORAGE), Map.entry(ObjectDefinition.DefinitionCase.SCHEMA, ObjectType.SCHEMA));
    private static final Descriptors.Descriptor OBJECT_DEFINITION = ObjectDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor OD_OBJECT_TYPE = ValidatorUtils.field(OBJECT_DEFINITION, 1);
    private static final Descriptors.OneofDescriptor OD_DEFINITION = ValidatorUtils.field(OBJECT_DEFINITION, 2).getContainingOneof();
    private static final Descriptors.FieldDescriptor OD_OBJECT_PROPS = ValidatorUtils.field(OBJECT_DEFINITION, 100);

    @Validator
    public static ValidationContext objectDefinition(ObjectDefinition msg, ValidationContext ctx) {
        ctx = ctx.push(OD_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ObjectType.class).pop();
        ctx = ctx.pushOneOf(OD_DEFINITION).apply(CommonValidators::required).apply(ObjectValidator::definitionMatchesType).applyRegistered().pop();
        ctx = ctx.pushMap(OD_OBJECT_PROPS).apply(CommonValidators::optional).apply(CommonValidators::standardProps).pop();
        return ctx;
    }

    public static ValidationContext objectType(ObjectDefinition msg, ObjectType expectedType, ValidationContext ctx) {
        ObjectType objectType;
        ObjectType objectType2 = objectType = msg.hasField(OD_OBJECT_TYPE) ? msg.getObjectType() : DEFINITION_CASE_MAPPING.getOrDefault(msg.getDefinitionCase(), ObjectType.UNRECOGNIZED);
        if (objectType != expectedType) {
            String err = String.format("The given [%s] has the wrong object type: expected [%s], got [%s]", ctx.fieldName(), expectedType, objectType);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext definitionMatchesType(ValidationContext ctx) {
        ObjectType definitionType;
        ObjectDefinition objectDef = (ObjectDefinition)ctx.parentMsg();
        ObjectDefinition.DefinitionCase definitionCase = objectDef.getDefinitionCase();
        ObjectType objectType = objectDef.getObjectType();
        if (objectType != (definitionType = DEFINITION_CASE_MAPPING.getOrDefault(definitionCase, ObjectType.UNRECOGNIZED))) {
            String err = String.format("Object has type [%s] but contains definition type [%s]", objectType, definitionType);
            return ctx.error(err);
        }
        return ctx;
    }
}

