/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.FieldSchema;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.SchemaType;
import org.finos.tracdap.metadata.TableSchema;

@Validator(type=ValidationType.STATIC)
public class SchemaValidator {
    private static final Map<SchemaDefinition.SchemaDetailsCase, SchemaType> SCHEMA_TYPE_CASE_MAPPING = Map.ofEntries(Map.entry(SchemaDefinition.SchemaDetailsCase.TABLE, SchemaType.TABLE));
    private static final List<BasicType> ALLOWED_BUSINESS_KEY_TYPES = List.of(BasicType.STRING, BasicType.INTEGER, BasicType.DATE);
    private static final List<BasicType> ALLOWED_CATEGORICAL_TYPES = List.of(BasicType.STRING);
    private static final Descriptors.Descriptor SCHEMA_DEFINITION = SchemaDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor SD_SCHEMA_TYPE = ValidatorUtils.field(SCHEMA_DEFINITION, 1);
    private static final Descriptors.OneofDescriptor SD_SCHEMA_DETAILS;
    private static final Descriptors.FieldDescriptor SD_TABLE;
    private static final Descriptors.Descriptor TABLE_SCHEMA;
    private static final Descriptors.FieldDescriptor TS_FIELDS;
    private static final Descriptors.Descriptor FIELD_SCHEMA;
    private static final Descriptors.FieldDescriptor FS_FIELD_NAME;
    private static final Descriptors.FieldDescriptor FS_FIELD_ORDER;
    private static final Descriptors.FieldDescriptor FS_FIELD_TYPE;
    private static final Descriptors.FieldDescriptor FS_LABEL;

    @Validator
    public static ValidationContext schema(SchemaDefinition schema, ValidationContext ctx) {
        return SchemaValidator.schema(schema, false, ctx);
    }

    public static ValidationContext dynamicSchema(SchemaDefinition schema, ValidationContext ctx) {
        return SchemaValidator.schema(schema, true, ctx);
    }

    private static ValidationContext schema(SchemaDefinition schema, boolean dynamic, ValidationContext ctx) {
        ctx = ctx.push(SD_SCHEMA_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, SchemaType.class).pop();
        ctx = dynamic ? ctx.pushOneOf(SD_SCHEMA_DETAILS).apply(CommonValidators::omitted).pop() : ctx.pushOneOf(SD_SCHEMA_DETAILS).apply(CommonValidators::required).apply(SchemaValidator::schemaMatchesType).applyRegistered().pop();
        return ctx;
    }

    public static ValidationContext schemaMatchesType(ValidationContext ctx) {
        SchemaType definitionType;
        SchemaDefinition schemaDef = (SchemaDefinition)ctx.parentMsg();
        SchemaDefinition.SchemaDetailsCase schemaDetails = schemaDef.getSchemaDetailsCase();
        SchemaType schemaType = schemaDef.getSchemaType();
        if (schemaType != (definitionType = SCHEMA_TYPE_CASE_MAPPING.getOrDefault(schemaDetails, SchemaType.UNRECOGNIZED))) {
            String err = String.format("Schema has type [%s] but contains definition type [%s]", schemaType, definitionType);
            return ctx.error(err);
        }
        return ctx;
    }

    @Validator
    public static ValidationContext tableSchema(TableSchema table, ValidationContext ctx) {
        boolean allZeroOrder;
        ctx = ctx.pushRepeated(TS_FIELDS).apply(CommonValidators::listNotEmpty).applyRepeated(SchemaValidator::fieldSchema, FieldSchema.class).pop();
        Set names = table.getFieldsList().stream().map(FieldSchema::getFieldName).map(String::toLowerCase).collect(Collectors.toSet());
        if (names.size() != table.getFieldsCount()) {
            String err = "Table schema contains duplicate field names";
            ctx = ctx.error(err);
        }
        if (!(allZeroOrder = table.getFieldsList().stream().map(FieldSchema::getFieldOrder).allMatch(order -> order == 0))) {
            Set orders = table.getFieldsList().stream().map(FieldSchema::getFieldOrder).collect(Collectors.toSet());
            for (int fieldOrder = 0; fieldOrder < table.getFieldsCount(); ++fieldOrder) {
                if (orders.contains(fieldOrder)) continue;
                String err = "Field orders must form a contiguous set of indices starting at zero";
                ctx = ctx.error(err);
            }
        }
        return ctx;
    }

    @Validator
    public static ValidationContext fieldSchema(FieldSchema field, ValidationContext ctx) {
        String err;
        ctx = ctx.push(FS_FIELD_NAME).apply(CommonValidators::required).apply(CommonValidators::identifier).apply(CommonValidators::notTracReserved).pop();
        ctx = ctx.push(FS_FIELD_ORDER).apply(CommonValidators::notNegative, Integer.class).pop();
        ctx = ctx.push(FS_FIELD_TYPE).apply(CommonValidators::required).apply(CommonValidators::recognizedEnum, BasicType.class).apply(CommonValidators::primitiveType, BasicType.class).pop();
        ctx = ctx.push(FS_LABEL).apply(CommonValidators::optional).apply(CommonValidators::labelLengthLimit).pop();
        if (field.getBusinessKey() && !ALLOWED_BUSINESS_KEY_TYPES.contains(field.getFieldType())) {
            err = String.format("Schema field [%s] cannot be a business key because it has type [%s]", ctx.fieldName(), field.getFieldType());
            ctx = ctx.error(err);
        }
        if (field.getCategorical() && !ALLOWED_CATEGORICAL_TYPES.contains(field.getFieldType())) {
            err = String.format("Schema field [%s] cannot be categorical because it has type [%s]", ctx.fieldName(), field.getFieldType());
            ctx = ctx.error(err);
        }
        if (field.getBusinessKey() && field.hasNotNull() && !field.getNotNull()) {
            err = String.format("Schema field [%s] cannot have notNull == false because it is a business key", ctx.fieldName());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    static {
        SD_TABLE = ValidatorUtils.field(SCHEMA_DEFINITION, 3);
        SD_SCHEMA_DETAILS = SD_TABLE.getContainingOneof();
        TABLE_SCHEMA = TableSchema.getDescriptor();
        TS_FIELDS = ValidatorUtils.field(TABLE_SCHEMA, 1);
        FIELD_SCHEMA = FieldSchema.getDescriptor();
        FS_FIELD_NAME = ValidatorUtils.field(FIELD_SCHEMA, 1);
        FS_FIELD_ORDER = ValidatorUtils.field(FIELD_SCHEMA, 2);
        FS_FIELD_TYPE = ValidatorUtils.field(FIELD_SCHEMA, 3);
        FS_LABEL = ValidatorUtils.field(FIELD_SCHEMA, 4);
    }
}

