/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.util.List;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.common.validation.static_.TypeSystemValidator;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.LogicalExpression;
import org.finos.tracdap.metadata.LogicalOperator;
import org.finos.tracdap.metadata.ObjectType;
import org.finos.tracdap.metadata.SearchExpression;
import org.finos.tracdap.metadata.SearchOperator;
import org.finos.tracdap.metadata.SearchParameters;
import org.finos.tracdap.metadata.SearchTerm;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class SearchValidator {
    private static final List<SearchOperator> ORDERED_OPERATORS = List.of(SearchOperator.LT, SearchOperator.LE, SearchOperator.GT, SearchOperator.GE);
    private static final List<SearchOperator> EQUALITY_OPERATORS = List.of(SearchOperator.EQ, SearchOperator.NE, SearchOperator.IN);
    private static final List<BasicType> ORDERED_TYPES = List.of(BasicType.INTEGER, BasicType.FLOAT, BasicType.DECIMAL, BasicType.DATE, BasicType.DATETIME);
    private static final List<BasicType> CONTINUOUS_TYPES = List.of(BasicType.FLOAT, BasicType.DECIMAL, BasicType.DATETIME);
    private static final Descriptors.Descriptor SEARCH_PARAMETERS = SearchParameters.getDescriptor();
    private static final Descriptors.FieldDescriptor SP_OBJECT_TYPE = ValidatorUtils.field(SEARCH_PARAMETERS, 1);
    private static final Descriptors.FieldDescriptor SP_SEARCH = ValidatorUtils.field(SEARCH_PARAMETERS, 2);
    private static final Descriptors.FieldDescriptor SP_SEARCH_ASOF = ValidatorUtils.field(SEARCH_PARAMETERS, 3);
    private static final Descriptors.FieldDescriptor SP_PRIOR_VERSIONS = ValidatorUtils.field(SEARCH_PARAMETERS, 4);
    private static final Descriptors.FieldDescriptor SP_PRIOR_TAGS = ValidatorUtils.field(SEARCH_PARAMETERS, 5);
    private static final Descriptors.Descriptor SEARCH_EXPRESSION = SearchExpression.getDescriptor();
    private static final Descriptors.OneofDescriptor SE_EXPR = ValidatorUtils.field(SEARCH_EXPRESSION, 1).getContainingOneof();
    private static final Descriptors.FieldDescriptor SE_TERM = ValidatorUtils.field(SEARCH_EXPRESSION, 1);
    private static final Descriptors.FieldDescriptor SE_LOGICAL = ValidatorUtils.field(SEARCH_EXPRESSION, 2);
    private static final Descriptors.Descriptor SEARCH_TERM = SearchTerm.getDescriptor();
    private static final Descriptors.FieldDescriptor ST_ATTR_NAME = ValidatorUtils.field(SEARCH_TERM, 1);
    private static final Descriptors.FieldDescriptor ST_ATTR_TYPE = ValidatorUtils.field(SEARCH_TERM, 2);
    private static final Descriptors.FieldDescriptor ST_OPERATOR = ValidatorUtils.field(SEARCH_TERM, 3);
    private static final Descriptors.FieldDescriptor ST_SEARCH_VALUE = ValidatorUtils.field(SEARCH_TERM, 4);
    private static final Descriptors.Descriptor LOGICAL_EXPRESSION = LogicalExpression.getDescriptor();
    private static final Descriptors.FieldDescriptor LE_OPERATOR = ValidatorUtils.field(LOGICAL_EXPRESSION, 1);
    private static final Descriptors.FieldDescriptor LE_EXPR = ValidatorUtils.field(LOGICAL_EXPRESSION, 2);

    @Validator
    public static ValidationContext searchParameters(SearchParameters msg, ValidationContext ctx) {
        ctx = ctx.push(SP_OBJECT_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, ObjectType.class).pop();
        ctx = ctx.push(SP_SEARCH).apply(CommonValidators::optional).apply(SearchValidator::searchExpression, SearchExpression.class).pop();
        ctx = ctx.push(SP_SEARCH_ASOF).apply(CommonValidators::optional).apply(TypeSystemValidator::datetimeValue, DatetimeValue.class).apply(TypeSystemValidator::notInTheFuture, DatetimeValue.class).pop();
        ctx = ctx.push(SP_PRIOR_VERSIONS).apply(CommonValidators::optional).pop();
        ctx = ctx.push(SP_PRIOR_TAGS).apply(CommonValidators::optional).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext searchExpression(SearchExpression msg, ValidationContext ctx) {
        ctx = ctx.pushOneOf(SE_EXPR).apply(CommonValidators::required).applyOneOf(SE_TERM, SearchValidator::searchTerm, SearchTerm.class).applyOneOf(SE_LOGICAL, SearchValidator::logicalExpression, LogicalExpression.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext searchTerm(SearchTerm msg, ValidationContext ctx) {
        ctx = ctx.push(ST_ATTR_NAME).apply(CommonValidators::required).apply(CommonValidators::identifier).pop();
        ctx = ctx.push(ST_ATTR_TYPE).applyIf(!msg.getOperator().equals((Object)SearchOperator.EXISTS), CommonValidators::required).applyIf(msg.getOperator().equals((Object)SearchOperator.EXISTS), CommonValidators::optional).apply(CommonValidators::nonZeroEnum, BasicType.class).apply(CommonValidators::primitiveType, BasicType.class).pop();
        ctx = ctx.push(ST_OPERATOR).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, SearchOperator.class).pop();
        if (!(ctx = ctx.push(ST_SEARCH_VALUE).applyIf(!msg.getOperator().equals((Object)SearchOperator.EXISTS), CommonValidators::required).applyIf(msg.getOperator().equals((Object)SearchOperator.EXISTS), CommonValidators::omitted).apply(TypeSystemValidator::value, Value.class).pop()).failed()) {
            ctx = ctx.apply(SearchValidator::operatorMatchesType, SearchTerm.class);
            ctx = ctx.applyIf(!msg.getOperator().equals((Object)SearchOperator.EXISTS), SearchValidator::valueMatchesType, SearchTerm.class);
        }
        return ctx;
    }

    @Validator
    public static ValidationContext logicalExpression(LogicalExpression msg, ValidationContext ctx) {
        ctx = ctx.push(LE_OPERATOR).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, LogicalOperator.class).pop();
        ctx = ctx.pushRepeated(LE_EXPR).apply(CommonValidators::listNotEmpty).pop();
        if (msg.getOperator() == LogicalOperator.NOT && msg.getExprCount() > 1) {
            ctx.error("Logical NOT expression cannot have multiple sub-expressions");
        }
        return ctx;
    }

    private static ValidationContext operatorMatchesType(SearchTerm msg, ValidationContext ctx) {
        String err;
        if (ORDERED_OPERATORS.contains(msg.getOperator()) && !ORDERED_TYPES.contains(msg.getAttrType())) {
            err = String.format("Search operation [%s] is not allowed on attribute type [%s] (ordered operation on unordered type)", msg.getOperator(), msg.getAttrType());
            ctx = ctx.error(err);
        }
        if (EQUALITY_OPERATORS.contains(msg.getOperator()) && CONTINUOUS_TYPES.contains(msg.getAttrType())) {
            err = String.format("Search operation [%s] is not allowed on attribute type [%s] (equality comparison on continuous type)", msg.getOperator(), msg.getAttrType());
            ctx = ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext valueMatchesType(SearchTerm msg, ValidationContext ctx) {
        BasicType searchValueBasicType;
        TypeDescriptor searchValueType = TypeSystem.descriptor((Value)msg.getSearchValue());
        if (msg.getOperator() == SearchOperator.IN && searchValueType.getBasicType() != BasicType.ARRAY) {
            String err = String.format("Search operation [%s] requires an [%s] search value", msg.getOperator(), BasicType.ARRAY);
            return ctx.error(err);
        }
        BasicType basicType = searchValueBasicType = msg.getOperator() == SearchOperator.IN ? searchValueType.getArrayType().getBasicType() : searchValueType.getBasicType();
        if (searchValueBasicType != msg.getAttrType()) {
            String err = String.format("Search value type [%s] does not match attribute type [%s]", searchValueBasicType, msg.getAttrType());
            return ctx.error(err);
        }
        return ctx;
    }
}

