/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.static_;

import com.google.protobuf.Descriptors;
import java.time.OffsetDateTime;
import org.finos.tracdap.common.metadata.MetadataCodec;
import org.finos.tracdap.common.metadata.TypeSystem;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.static_.CommonValidators;
import org.finos.tracdap.metadata.ArrayValue;
import org.finos.tracdap.metadata.BasicType;
import org.finos.tracdap.metadata.DateValue;
import org.finos.tracdap.metadata.DatetimeValue;
import org.finos.tracdap.metadata.DecimalValue;
import org.finos.tracdap.metadata.MapValue;
import org.finos.tracdap.metadata.TypeDescriptor;
import org.finos.tracdap.metadata.Value;

@Validator(type=ValidationType.STATIC)
public class TypeSystemValidator {
    private static final Descriptors.Descriptor TYPE_DESCRIPTOR = TypeDescriptor.getDescriptor();
    private static final Descriptors.FieldDescriptor TD_BASIC_TYPE = ValidatorUtils.field(TYPE_DESCRIPTOR, 1);
    private static final Descriptors.FieldDescriptor TD_ARRAY_TYPE = ValidatorUtils.field(TYPE_DESCRIPTOR, 2);
    private static final Descriptors.FieldDescriptor TD_MAP_TYPE = ValidatorUtils.field(TYPE_DESCRIPTOR, 3);
    private static final Descriptors.Descriptor VALUE = Value.getDescriptor();
    private static final Descriptors.FieldDescriptor V_TYPE = ValidatorUtils.field(VALUE, 1);
    private static final Descriptors.OneofDescriptor V_VALUE = ValidatorUtils.field(VALUE, 2).getContainingOneof();
    private static final Descriptors.FieldDescriptor V_ARRAY = ValidatorUtils.field(VALUE, 9);
    private static final Descriptors.FieldDescriptor V_MAP = ValidatorUtils.field(VALUE, 10);
    private static final Descriptors.Descriptor DECIMAL_VALUE = DecimalValue.getDescriptor();
    private static final Descriptors.FieldDescriptor DCV_DECIMAL = ValidatorUtils.field(DECIMAL_VALUE, 1);
    private static final Descriptors.Descriptor DATE_VALUE = DateValue.getDescriptor();
    private static final Descriptors.FieldDescriptor DV_ISO_DATE = ValidatorUtils.field(DATE_VALUE, 1);
    private static final Descriptors.Descriptor DATETIME_VALUE = DatetimeValue.getDescriptor();
    private static final Descriptors.FieldDescriptor DTV_ISO_DATETIME = ValidatorUtils.field(DATETIME_VALUE, 1);
    private static final Descriptors.Descriptor ARRAY_VALUE = ArrayValue.getDescriptor();
    private static final Descriptors.FieldDescriptor AV_ITEMS = ValidatorUtils.field(ARRAY_VALUE, 1);
    private static final Descriptors.Descriptor MAP_VALUE = MapValue.getDescriptor();
    private static final Descriptors.FieldDescriptor MV_ENTRIES = ValidatorUtils.field(MAP_VALUE, 1);

    @Validator
    public static ValidationContext typeDescriptor(TypeDescriptor typeDescriptor, ValidationContext ctx) {
        ctx = ctx.push(TD_BASIC_TYPE).apply(CommonValidators::required).apply(CommonValidators::nonZeroEnum, BasicType.class).pop();
        boolean isArray = typeDescriptor.getBasicType() == BasicType.ARRAY;
        boolean isMap = typeDescriptor.getBasicType() == BasicType.MAP;
        String isArrayQualifier = String.format("%s == %s", TD_BASIC_TYPE.getName(), BasicType.ARRAY.name());
        String isMapQualifier = String.format("%s == %s", TD_BASIC_TYPE.getName(), BasicType.MAP.name());
        ctx = ctx.push(TD_ARRAY_TYPE).apply(CommonValidators.ifAndOnlyIf(isArray, isArrayQualifier)).apply(TypeSystemValidator::typeDescriptor, TypeDescriptor.class).pop();
        ctx = ctx.push(TD_MAP_TYPE).apply(CommonValidators.ifAndOnlyIf(isMap, isMapQualifier)).apply(TypeSystemValidator::typeDescriptor, TypeDescriptor.class).pop();
        return ctx;
    }

    @Validator
    public static ValidationContext value(Value value, ValidationContext ctx) {
        if (!value.hasType()) {
            if (!value.hasOneof(V_VALUE)) {
                return ctx.error("Type cannot be inferred for null value");
            }
            if (!TypeSystem.isPrimitive((Value)value)) {
                return ctx.error("Type cannot be inferred for non-primitive value");
            }
        }
        TypeDescriptor expectedType = TypeSystem.descriptor((Value)value);
        return ctx.apply(TypeSystemValidator::innerValue, Value.class, expectedType);
    }

    public static ValidationContext valueWithType(Value value, TypeDescriptor expectedType, ValidationContext ctx) {
        if (!value.hasType()) {
            if (!value.hasOneof(V_VALUE)) {
                return ctx.error("Type cannot be inferred for null value");
            }
            if (!TypeSystem.isPrimitive((Value)value)) {
                return ctx.error("Type cannot be inferred for non-primitive value");
            }
        }
        return ctx.apply(TypeSystemValidator::innerValue, Value.class, expectedType);
    }

    @Validator
    public static ValidationContext decimalValue(DecimalValue msg, ValidationContext ctx) {
        return ctx.push(DCV_DECIMAL).apply(CommonValidators::required).apply(CommonValidators::decimal).pop();
    }

    @Validator
    public static ValidationContext dateValue(DateValue msg, ValidationContext ctx) {
        return ctx.push(DV_ISO_DATE).apply(CommonValidators::required).apply(CommonValidators::isoDate).pop();
    }

    @Validator
    public static ValidationContext datetimeValue(DatetimeValue msg, ValidationContext ctx) {
        return ctx.push(DTV_ISO_DATETIME).apply(CommonValidators::required).apply(CommonValidators::isoDatetime).pop();
    }

    public static ValidationContext notInTheFuture(DatetimeValue msg, ValidationContext ctx) {
        OffsetDateTime now = OffsetDateTime.now();
        OffsetDateTime datetime = MetadataCodec.decodeDatetime((DatetimeValue)msg);
        if (datetime.isAfter(now)) {
            String err = String.format("[%s] is in the future", ctx.fieldName());
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext innerValue(Value value, TypeDescriptor expectedType, ValidationContext ctx) {
        String wrongTypeMessage = "Value does not match the expected type";
        ctx = ctx.push(V_TYPE).apply(CommonValidators::optional).apply(TypeSystemValidator::typeDescriptor, TypeDescriptor.class).apply(CommonValidators.equalTo(expectedType, wrongTypeMessage), TypeDescriptor.class).pop();
        if (TypeSystem.isPrimitive((TypeDescriptor)expectedType)) {
            BasicType valueType = TypeSystem.valueCaseType((Value)value);
            ctx = ctx.pushOneOf(V_VALUE).apply(CommonValidators::optional).applyIf(valueType == BasicType.DECIMAL, TypeSystemValidator::decimalValue, DecimalValue.class).applyIf(valueType == BasicType.DATE, TypeSystemValidator::dateValue, DateValue.class).applyIf(valueType == BasicType.DATETIME, TypeSystemValidator::datetimeValue, DatetimeValue.class).pop();
            if (value.hasOneof(V_VALUE) && valueType != expectedType.getBasicType()) {
                ctx = ctx.error(wrongTypeMessage);
            }
            return ctx;
        }
        if (expectedType.getBasicType() == BasicType.ARRAY) {
            TypeDescriptor arrayType = expectedType.getArrayType();
            return ctx.push(V_ARRAY).apply(CommonValidators::required).apply(TypeSystemValidator::arrayValue, ArrayValue.class, arrayType).pop();
        }
        if (expectedType.getBasicType() == BasicType.MAP) {
            TypeDescriptor mapType = expectedType.getMapType();
            return ctx.push(V_MAP).apply(CommonValidators::required).apply(TypeSystemValidator::mapValue, MapValue.class, mapType).pop();
        }
        String unknownTypeError = String.format("Unknown type for [%s]", ctx.fieldName());
        ctx = ctx.error(unknownTypeError);
        return ctx;
    }

    private static ValidationContext arrayValue(ArrayValue msg, TypeDescriptor arrayType, ValidationContext ctx) {
        return ctx.pushRepeated(AV_ITEMS).applyRepeated(TypeSystemValidator::innerValue, Value.class, arrayType).pop();
    }

    private static ValidationContext mapValue(MapValue msg, TypeDescriptor mapType, ValidationContext ctx) {
        return ctx.pushMap(MV_ENTRIES).applyMapKeys(TypeSystemValidator::mapKey).applyMapValues(TypeSystemValidator::innerValue, Value.class, mapType).pop();
    }

    private static ValidationContext mapKey(String key, ValidationContext ctx) {
        if (key == null || key.isEmpty()) {
            ctx.error("Map keys cannot be null or empty");
        }
        return ctx;
    }
}

