/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.version;

import com.google.protobuf.Descriptors;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.version.CommonValidators;
import org.finos.tracdap.metadata.FileDefinition;

@Validator(type=ValidationType.VERSION)
public class FileVersionValidator {
    private static final Descriptors.Descriptor FILE_DEF = FileDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor FILE_NAME = ValidatorUtils.field(FILE_DEF, 1);
    private static final Descriptors.FieldDescriptor FILE_EXTENSION = ValidatorUtils.field(FILE_DEF, 2);
    private static final Descriptors.FieldDescriptor FILE_MIME_TYPE = ValidatorUtils.field(FILE_DEF, 3);
    private static final Descriptors.FieldDescriptor FILE_STORAGE_ID = ValidatorUtils.field(FILE_DEF, 5);

    @Validator
    public static ValidationContext fileVersion(FileDefinition current, FileDefinition prior, ValidationContext ctx) {
        ctx = ctx.push(FILE_NAME).apply(FileVersionValidator::sameExtension, String.class).pop();
        ctx = ctx.push(FILE_EXTENSION).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(FILE_MIME_TYPE).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(FILE_STORAGE_ID).apply(CommonValidators::exactMatch).pop();
        return ctx;
    }

    static ValidationContext sameExtension(String currentName, String priorName, ValidationContext ctx) {
        String currentExt;
        String priorExt = priorName.contains(".") ? priorName.substring(priorName.lastIndexOf(46)) : "";
        String string = currentExt = currentName.contains(".") ? currentName.substring(currentName.lastIndexOf(46)) : "";
        if (!priorExt.equals(currentExt)) {
            String err = String.format("File extension in field [%s] changed between versions: prior = [%s], new = [%s]", ctx.fieldName(), priorExt, currentExt);
            return ctx.error(err);
        }
        return ctx;
    }
}

