/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.version;

import com.google.protobuf.Descriptors;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.version.CommonValidators;
import org.finos.tracdap.metadata.ModelDefinition;

@Validator(type=ValidationType.VERSION)
public class ModelVersionValidator {
    private static final Descriptors.Descriptor MODEL_DEFINITION = ModelDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor MD_MODEL_TYPE = ValidatorUtils.field(MODEL_DEFINITION, 13);
    private static final Descriptors.FieldDescriptor MD_LANGUAGE = ValidatorUtils.field(MODEL_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor MD_REPOSITORY = ValidatorUtils.field(MODEL_DEFINITION, 2);
    private static final Descriptors.FieldDescriptor MD_PACKAGE_GROUP = ValidatorUtils.field(MODEL_DEFINITION, 10);
    private static final Descriptors.FieldDescriptor MD_PACKAGE = ValidatorUtils.field(MODEL_DEFINITION, 11);
    private static final Descriptors.FieldDescriptor MD_VERSION = ValidatorUtils.field(MODEL_DEFINITION, 6);
    private static final Descriptors.FieldDescriptor MD_PATH = ValidatorUtils.field(MODEL_DEFINITION, 3);
    private static final Descriptors.FieldDescriptor MD_ENTRY_POINT = ValidatorUtils.field(MODEL_DEFINITION, 5);

    @Validator
    public static ValidationContext modelVersion(ModelDefinition current, ModelDefinition prior, ValidationContext ctx) {
        ctx = ctx.push(MD_MODEL_TYPE).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_LANGUAGE).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_REPOSITORY).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_PACKAGE_GROUP).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_PACKAGE).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_VERSION).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_PATH).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(MD_ENTRY_POINT).apply(CommonValidators::exactMatch).pop();
        return ctx;
    }
}

