/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.version;

import com.google.protobuf.Descriptors;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.finos.tracdap.common.exception.EUnexpected;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.version.CommonValidators;
import org.finos.tracdap.metadata.FieldSchema;
import org.finos.tracdap.metadata.SchemaDefinition;
import org.finos.tracdap.metadata.SchemaType;
import org.finos.tracdap.metadata.TableSchema;

@Validator(type=ValidationType.VERSION)
public class SchemaVersionValidator {
    private static final Descriptors.Descriptor SCHEMA_DEFINITION = SchemaDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor SD_SCHEMA_TYPE = ValidatorUtils.field(SCHEMA_DEFINITION, 1);
    private static final Descriptors.FieldDescriptor SD_TABLE = ValidatorUtils.field(SCHEMA_DEFINITION, 3);

    @Validator
    public static ValidationContext schema(SchemaDefinition current, SchemaDefinition prior, ValidationContext ctx) {
        ctx = ctx.push(SD_SCHEMA_TYPE).apply(CommonValidators::exactMatch, SchemaType.class).pop();
        if (current.getSchemaType() == SchemaType.TABLE) {
            return ctx.push(SD_TABLE).apply(SchemaVersionValidator::tableSchema, TableSchema.class).pop();
        }
        throw new EUnexpected();
    }

    @Validator
    public static ValidationContext tableSchema(TableSchema current, TableSchema prior, ValidationContext ctx) {
        Map priorFields = prior.getFieldsList().stream().collect(Collectors.toMap(f -> f.getFieldName().toLowerCase(), Function.identity()));
        Map currentFields = current.getFieldsList().stream().collect(Collectors.toMap(f -> f.getFieldName().toLowerCase(), Function.identity()));
        List newFields = current.getFieldsList().stream().filter(f -> !priorFields.containsKey(f.getFieldName().toLowerCase())).collect(Collectors.toList());
        List existingFields = current.getFieldsList().stream().filter(f -> priorFields.containsKey(f.getFieldName().toLowerCase())).collect(Collectors.toList());
        List removedFields = prior.getFieldsList().stream().filter(f -> !currentFields.containsKey(f.getFieldName().toLowerCase())).collect(Collectors.toList());
        for (FieldSchema field : existingFields) {
            FieldSchema priorField = (FieldSchema)priorFields.get(field.getFieldName().toLowerCase());
            ctx = SchemaVersionValidator.existingField(field, priorField, ctx);
        }
        for (FieldSchema field : newFields) {
            ctx = SchemaVersionValidator.newField(field, ctx);
        }
        for (FieldSchema field : removedFields) {
            ctx = SchemaVersionValidator.removedField(field, ctx);
        }
        return ctx;
    }

    private static ValidationContext existingField(FieldSchema current, FieldSchema prior, ValidationContext ctx) {
        if (!current.getFieldName().equalsIgnoreCase(prior.getFieldName())) {
            throw new EUnexpected();
        }
        if (!current.getFieldName().equals(prior.getFieldName())) {
            ctx = ctx.error(String.format("Field name case changed for [%s]: prior = [%s], new = [%s]", prior.getFieldName(), prior.getFieldName(), current.getFieldName()));
        }
        if (current.getFieldOrder() != prior.getFieldOrder()) {
            ctx = ctx.error(String.format("Field order changed for [%s]: prior = [%d], new = [%d]", prior.getFieldName(), prior.getFieldOrder(), current.getFieldOrder()));
        }
        if (current.getFieldType() != prior.getFieldType()) {
            ctx = ctx.error(String.format("Field type changed for [%s]: prior = [%s], new = [%s]", prior.getFieldName(), prior.getFieldType(), current.getFieldType()));
        }
        if (current.getBusinessKey() != prior.getBusinessKey()) {
            ctx = ctx.error(String.format("Business key flag changed for [%s]: prior = [%s], new = [%s]", prior.getFieldName(), prior.getBusinessKey(), current.getBusinessKey()));
        }
        if (current.getCategorical() != prior.getCategorical()) {
            ctx = ctx.error(String.format("Categorical flag changed for [%s]: prior = [%s], new = [%s]", prior.getFieldName(), prior.getCategorical(), current.getCategorical()));
        }
        return ctx;
    }

    private static ValidationContext newField(FieldSchema newField, ValidationContext ctx) {
        if (newField.getBusinessKey()) {
            ctx = ctx.error(String.format("New field [%s] is marked as a business key", newField.getFieldName()));
        }
        return ctx;
    }

    private static ValidationContext removedField(FieldSchema removedField, ValidationContext ctx) {
        return ctx.error(String.format("Field [%s] from the prior schema version has been removed", removedField.getFieldName()));
    }
}

