/*
 * Decompiled with CFR 0.152.
 */
package org.finos.tracdap.common.validation.version;

import com.google.protobuf.Descriptors;
import java.util.Optional;
import java.util.OptionalInt;
import org.finos.tracdap.common.validation.core.ValidationContext;
import org.finos.tracdap.common.validation.core.ValidationType;
import org.finos.tracdap.common.validation.core.Validator;
import org.finos.tracdap.common.validation.core.ValidatorUtils;
import org.finos.tracdap.common.validation.version.CommonValidators;
import org.finos.tracdap.metadata.CopyStatus;
import org.finos.tracdap.metadata.IncarnationStatus;
import org.finos.tracdap.metadata.StorageCopy;
import org.finos.tracdap.metadata.StorageDefinition;
import org.finos.tracdap.metadata.StorageIncarnation;
import org.finos.tracdap.metadata.StorageItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Validator(type=ValidationType.VERSION)
public class StorageVersionValidator {
    private static final Descriptors.Descriptor STORAGE_DEFINITION = StorageDefinition.getDescriptor();
    private static final Descriptors.FieldDescriptor SD_DATA_ITEMS = ValidatorUtils.field(STORAGE_DEFINITION, 1);
    private static final Descriptors.Descriptor STORAGE_ITEM = StorageItem.getDescriptor();
    private static final Descriptors.FieldDescriptor SIT_INCARNATIONS = ValidatorUtils.field(STORAGE_ITEM, 1);
    private static final Descriptors.Descriptor STORAGE_INCARNATION = StorageIncarnation.getDescriptor();
    private static final Descriptors.FieldDescriptor SIN_COPIES = ValidatorUtils.field(STORAGE_INCARNATION, 1);
    private static final Descriptors.FieldDescriptor SIN_INCARNATION_INDEX = ValidatorUtils.field(STORAGE_INCARNATION, 2);
    private static final Descriptors.FieldDescriptor SIN_INCARNATION_TIMESTAMP = ValidatorUtils.field(STORAGE_INCARNATION, 3);
    private static final Descriptors.FieldDescriptor SIN_INCARNATION_STATUS = ValidatorUtils.field(STORAGE_INCARNATION, 4);
    private static final Descriptors.Descriptor STORAGE_COPY = StorageCopy.getDescriptor();
    private static final Descriptors.FieldDescriptor SC_STORAGE_KEY = ValidatorUtils.field(STORAGE_COPY, 1);
    private static final Descriptors.FieldDescriptor SC_STORAGE_PATH = ValidatorUtils.field(STORAGE_COPY, 2);
    private static final Descriptors.FieldDescriptor SC_STORAGE_FORMAT = ValidatorUtils.field(STORAGE_COPY, 3);
    private static final Descriptors.FieldDescriptor SC_COPY_STATUS = ValidatorUtils.field(STORAGE_COPY, 4);
    private static final Descriptors.FieldDescriptor SC_COPY_TIMESTAMP = ValidatorUtils.field(STORAGE_COPY, 5);

    @Validator
    public static ValidationContext storage(StorageDefinition current, StorageDefinition prior, ValidationContext ctx) {
        ctx = ctx.pushMap(SD_DATA_ITEMS, StorageDefinition::getDataItemsMap);
        for (String priorItem : prior.getDataItemsMap().keySet()) {
            if (current.containsDataItems(priorItem)) continue;
            String err = String.format("Data item [%s] has been removed", priorItem);
            ctx = ctx.error(err);
        }
        for (String key : current.getDataItemsMap().keySet()) {
            ctx = ctx.pushMapValue(key).apply(StorageVersionValidator::item, StorageItem.class).pop();
        }
        return ctx.pop();
    }

    @Validator
    public static ValidationContext item(StorageItem current, StorageItem prior, ValidationContext ctx) {
        Logger log = LoggerFactory.getLogger(StorageVersionValidator.class);
        log.info(prior == null ? "New storage item" : "Validating storage item version");
        if (prior == null) {
            return ctx;
        }
        ctx = ctx.pushRepeated(SIT_INCARNATIONS);
        for (StorageIncarnation currentIncarnation : current.getIncarnationsList()) {
            Optional<StorageIncarnation> priorIncarnation = prior.getIncarnationsList().stream().filter(pi -> pi.getIncarnationIndex() == currentIncarnation.getIncarnationIndex()).findFirst();
            ctx = ctx.pushRepeatedItem(currentIncarnation, priorIncarnation.orElse(null)).apply(StorageVersionValidator::incarnation, StorageIncarnation.class).pop();
        }
        return ctx.pop();
    }

    @Validator
    public static ValidationContext incarnation(StorageIncarnation current, StorageIncarnation prior, ValidationContext ctx) {
        if (prior == null) {
            StorageItem priorItem = (StorageItem)ctx.prior().parentMsg();
            return ctx.apply(StorageVersionValidator::newIncarnationIndex, StorageIncarnation.class, priorItem);
        }
        ctx = ctx.push(SIN_INCARNATION_INDEX).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SIN_INCARNATION_TIMESTAMP).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SIN_INCARNATION_STATUS).apply(StorageVersionValidator::incarnationStatus, IncarnationStatus.class).pop();
        ctx = ctx.pushRepeated(SIN_COPIES);
        for (StorageCopy currentCopy : current.getCopiesList()) {
            Optional<StorageCopy> priorCopy = prior.getCopiesList().stream().filter(pc -> pc.getStorageKey().equals(currentCopy.getStorageKey()) && pc.getStoragePath().equals(currentCopy.getStoragePath())).findFirst();
            ctx = ctx.pushRepeatedItem(currentCopy, priorCopy.orElse(null)).apply(StorageVersionValidator::copy, StorageCopy.class).pop();
        }
        return ctx.pop();
    }

    @Validator
    public static ValidationContext copy(StorageCopy current, StorageCopy prior, ValidationContext ctx) {
        if (prior == null) {
            return ctx;
        }
        ctx = ctx.push(SC_STORAGE_KEY).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SC_STORAGE_PATH).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SC_COPY_TIMESTAMP).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SC_STORAGE_FORMAT).apply(CommonValidators::exactMatch).pop();
        ctx = ctx.push(SC_COPY_STATUS).apply(StorageVersionValidator::copyStatus, CopyStatus.class).pop();
        return ctx;
    }

    private static ValidationContext newIncarnationIndex(StorageIncarnation current, StorageItem priorItem, ValidationContext ctx) {
        OptionalInt maxPriorIncarnation = priorItem.getIncarnationsList().stream().mapToInt(StorageIncarnation::getIncarnationIndex).max();
        if (maxPriorIncarnation.isEmpty()) {
            return ctx.error("Version validation failed because the prior version is invalid");
        }
        if (current.getIncarnationIndex() <= maxPriorIncarnation.getAsInt()) {
            String err = String.format("New incarnation index must be greater than any previous incarnation (incarnation index = [%d], prior max = [%d])", current.getIncarnationIndex(), maxPriorIncarnation.getAsInt());
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext incarnationStatus(IncarnationStatus current, IncarnationStatus prior, ValidationContext ctx) {
        if (prior == IncarnationStatus.INCARNATION_EXPUNGED && current == IncarnationStatus.INCARNATION_AVAILABLE) {
            String err = String.format("Incarnation status cannot move from [%s] to [%s]", prior, current);
            return ctx.error(err);
        }
        return ctx;
    }

    private static ValidationContext copyStatus(CopyStatus current, CopyStatus prior, ValidationContext ctx) {
        if (prior == CopyStatus.COPY_EXPUNGED && current == CopyStatus.COPY_AVAILABLE) {
            String err = String.format("Copy status cannot move from [%s] to [%s]", prior, current);
            return ctx.error(err);
        }
        return ctx;
    }
}

