/*
 * Decompiled with CFR 0.152.
 */
package org.finra.herd.model.api.adapters;

import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.finra.herd.model.api.adapters.RegistrationDateAdapter;
import org.junit.Assert;
import org.junit.Test;

public class RegistrationDateAdapterTest {
    @Test
    public void unmarshalAllAllowedFormatsTest() throws Exception {
        RegistrationDateAdapter adapter = new RegistrationDateAdapter();
        XMLGregorianCalendar calendar = adapter.unmarshal("2020-02-02");
        this.compareCalendarWithExpectedValues(calendar, 2020, 2, 2, 0, 0, 0);
        calendar = adapter.unmarshal("2015-12-25T00:01");
        this.compareCalendarWithExpectedValues(calendar, 2015, 12, 25, 0, 1, 0);
        calendar = adapter.unmarshal("2015-12-25T00:01+04:00");
        this.compareCalendarWithExpectedValues(calendar, 2015, 12, 24, 20, 1, 0);
        calendar = adapter.unmarshal("2018-02-03T10:00:02");
        this.compareCalendarWithExpectedValues(calendar, 2018, 2, 3, 10, 0, 2);
        calendar = adapter.unmarshal("2018-02-03T10:00:02+04:00");
        this.compareCalendarWithExpectedValues(calendar, 2018, 2, 3, 6, 0, 2);
        calendar = adapter.unmarshal("2018-02-03 10:00:02+05:30");
        this.compareCalendarWithExpectedValues(calendar, 2018, 2, 3, 4, 30, 2);
        calendar = adapter.unmarshal("2018-03-03 00:20:02");
        this.compareCalendarWithExpectedValues(calendar, 2018, 3, 3, 0, 20, 2);
    }

    private void compareCalendarWithExpectedValues(XMLGregorianCalendar calendar, int year, int month, int day, int hour, int minute, int second) {
        Assert.assertEquals((long)calendar.getYear(), (long)year);
        Assert.assertEquals((long)calendar.getMonth(), (long)month);
        Assert.assertEquals((long)calendar.getDay(), (long)day);
        Assert.assertEquals((long)calendar.getHour(), (long)hour);
        Assert.assertEquals((long)calendar.getMinute(), (long)minute);
        Assert.assertEquals((long)calendar.getSecond(), (long)second);
        Assert.assertEquals((long)calendar.getTimezone(), (long)0L);
    }

    @Test
    public void unmarshalIllegalFormatTest() {
        RegistrationDateAdapter adapter = new RegistrationDateAdapter();
        try {
            adapter.unmarshal("2020-02");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Valid date or date and time format must be used when specifying values for start/end registration dates."));
        }
        try {
            adapter.unmarshal("2020-02-02T12:02AM");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Valid date or date and time format must be used when specifying values for start/end registration dates."));
        }
    }

    @Test
    public void marshalTest() throws Exception {
        XMLGregorianCalendar calendar = DatatypeFactory.newInstance().newXMLGregorianCalendar();
        calendar.setYear(2020);
        calendar.setMonth(2);
        calendar.setDay(1);
        calendar.setHour(2);
        calendar.setMinute(59);
        calendar.setSecond(0);
        String calendarStringRepresentation = calendar.toXMLFormat();
        RegistrationDateAdapter adapter = new RegistrationDateAdapter();
        Assert.assertEquals((Object)calendarStringRepresentation, (Object)adapter.marshal(calendar));
    }
}

