
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * The request to create a business object data notification registration.
 * 
 * <p>Java class for businessObjectDataNotificationRegistrationCreateRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="businessObjectDataNotificationRegistrationCreateRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="businessObjectDataNotificationRegistrationKey" type="{}notificationRegistrationKey"/&gt;
 *         &lt;element name="businessObjectDataEventType" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="businessObjectDataNotificationFilter" type="{}businessObjectDataNotificationFilter"/&gt;
 *         &lt;element name="jobActions" type="{}jobActions"/&gt;
 *         &lt;element name="notificationRegistrationStatus" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "businessObjectDataNotificationRegistrationCreateRequest", propOrder = {

})
@XmlRootElement(name = "businessObjectDataNotificationRegistrationCreateRequest")
public class BusinessObjectDataNotificationRegistrationCreateRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected NotificationRegistrationKey businessObjectDataNotificationRegistrationKey;
    @XmlElement(required = true)
    protected String businessObjectDataEventType;
    @XmlElement(required = true)
    protected BusinessObjectDataNotificationFilter businessObjectDataNotificationFilter;
    @XmlElementWrapper(required = true)
    @XmlElement(name = "jobAction")
    protected List<JobAction> jobActions;
    protected String notificationRegistrationStatus;

    /**
     * Default no-arg constructor
     * 
     */
    public BusinessObjectDataNotificationRegistrationCreateRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public BusinessObjectDataNotificationRegistrationCreateRequest(final NotificationRegistrationKey businessObjectDataNotificationRegistrationKey, final String businessObjectDataEventType, final BusinessObjectDataNotificationFilter businessObjectDataNotificationFilter, final List<JobAction> jobActions, final String notificationRegistrationStatus) {
        this.businessObjectDataNotificationRegistrationKey = businessObjectDataNotificationRegistrationKey;
        this.businessObjectDataEventType = businessObjectDataEventType;
        this.businessObjectDataNotificationFilter = businessObjectDataNotificationFilter;
        this.jobActions = jobActions;
        this.notificationRegistrationStatus = notificationRegistrationStatus;
    }

    /**
     * Gets the value of the businessObjectDataNotificationRegistrationKey property.
     * 
     * @return
     *     possible object is
     *     {@link NotificationRegistrationKey }
     *     
     */
    public NotificationRegistrationKey getBusinessObjectDataNotificationRegistrationKey() {
        return businessObjectDataNotificationRegistrationKey;
    }

    /**
     * Sets the value of the businessObjectDataNotificationRegistrationKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link NotificationRegistrationKey }
     *     
     */
    public void setBusinessObjectDataNotificationRegistrationKey(NotificationRegistrationKey value) {
        this.businessObjectDataNotificationRegistrationKey = value;
    }

    /**
     * Gets the value of the businessObjectDataEventType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getBusinessObjectDataEventType() {
        return businessObjectDataEventType;
    }

    /**
     * Sets the value of the businessObjectDataEventType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setBusinessObjectDataEventType(String value) {
        this.businessObjectDataEventType = value;
    }

    /**
     * Gets the value of the businessObjectDataNotificationFilter property.
     * 
     * @return
     *     possible object is
     *     {@link BusinessObjectDataNotificationFilter }
     *     
     */
    public BusinessObjectDataNotificationFilter getBusinessObjectDataNotificationFilter() {
        return businessObjectDataNotificationFilter;
    }

    /**
     * Sets the value of the businessObjectDataNotificationFilter property.
     * 
     * @param value
     *     allowed object is
     *     {@link BusinessObjectDataNotificationFilter }
     *     
     */
    public void setBusinessObjectDataNotificationFilter(BusinessObjectDataNotificationFilter value) {
        this.businessObjectDataNotificationFilter = value;
    }

    /**
     * Gets the value of the notificationRegistrationStatus property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNotificationRegistrationStatus() {
        return notificationRegistrationStatus;
    }

    /**
     * Sets the value of the notificationRegistrationStatus property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNotificationRegistrationStatus(String value) {
        this.notificationRegistrationStatus = value;
    }

    public List<JobAction> getJobActions() {
        return jobActions;
    }

    public void setJobActions(List<JobAction> jobActions) {
        this.jobActions = jobActions;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            NotificationRegistrationKey theBusinessObjectDataNotificationRegistrationKey;
            theBusinessObjectDataNotificationRegistrationKey = this.getBusinessObjectDataNotificationRegistrationKey();
            strategy.appendField(locator, this, "businessObjectDataNotificationRegistrationKey", buffer, theBusinessObjectDataNotificationRegistrationKey);
        }
        {
            String theBusinessObjectDataEventType;
            theBusinessObjectDataEventType = this.getBusinessObjectDataEventType();
            strategy.appendField(locator, this, "businessObjectDataEventType", buffer, theBusinessObjectDataEventType);
        }
        {
            BusinessObjectDataNotificationFilter theBusinessObjectDataNotificationFilter;
            theBusinessObjectDataNotificationFilter = this.getBusinessObjectDataNotificationFilter();
            strategy.appendField(locator, this, "businessObjectDataNotificationFilter", buffer, theBusinessObjectDataNotificationFilter);
        }
        {
            List<JobAction> theJobActions;
            theJobActions = this.getJobActions();
            strategy.appendField(locator, this, "jobActions", buffer, theJobActions);
        }
        {
            String theNotificationRegistrationStatus;
            theNotificationRegistrationStatus = this.getNotificationRegistrationStatus();
            strategy.appendField(locator, this, "notificationRegistrationStatus", buffer, theNotificationRegistrationStatus);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final BusinessObjectDataNotificationRegistrationCreateRequest that = ((BusinessObjectDataNotificationRegistrationCreateRequest) object);
        {
            NotificationRegistrationKey lhsBusinessObjectDataNotificationRegistrationKey;
            lhsBusinessObjectDataNotificationRegistrationKey = this.getBusinessObjectDataNotificationRegistrationKey();
            NotificationRegistrationKey rhsBusinessObjectDataNotificationRegistrationKey;
            rhsBusinessObjectDataNotificationRegistrationKey = that.getBusinessObjectDataNotificationRegistrationKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataNotificationRegistrationKey", lhsBusinessObjectDataNotificationRegistrationKey), LocatorUtils.property(thatLocator, "businessObjectDataNotificationRegistrationKey", rhsBusinessObjectDataNotificationRegistrationKey), lhsBusinessObjectDataNotificationRegistrationKey, rhsBusinessObjectDataNotificationRegistrationKey)) {
                return false;
            }
        }
        {
            String lhsBusinessObjectDataEventType;
            lhsBusinessObjectDataEventType = this.getBusinessObjectDataEventType();
            String rhsBusinessObjectDataEventType;
            rhsBusinessObjectDataEventType = that.getBusinessObjectDataEventType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataEventType", lhsBusinessObjectDataEventType), LocatorUtils.property(thatLocator, "businessObjectDataEventType", rhsBusinessObjectDataEventType), lhsBusinessObjectDataEventType, rhsBusinessObjectDataEventType)) {
                return false;
            }
        }
        {
            BusinessObjectDataNotificationFilter lhsBusinessObjectDataNotificationFilter;
            lhsBusinessObjectDataNotificationFilter = this.getBusinessObjectDataNotificationFilter();
            BusinessObjectDataNotificationFilter rhsBusinessObjectDataNotificationFilter;
            rhsBusinessObjectDataNotificationFilter = that.getBusinessObjectDataNotificationFilter();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "businessObjectDataNotificationFilter", lhsBusinessObjectDataNotificationFilter), LocatorUtils.property(thatLocator, "businessObjectDataNotificationFilter", rhsBusinessObjectDataNotificationFilter), lhsBusinessObjectDataNotificationFilter, rhsBusinessObjectDataNotificationFilter)) {
                return false;
            }
        }
        {
            List<JobAction> lhsJobActions;
            lhsJobActions = this.getJobActions();
            List<JobAction> rhsJobActions;
            rhsJobActions = that.getJobActions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "jobActions", lhsJobActions), LocatorUtils.property(thatLocator, "jobActions", rhsJobActions), lhsJobActions, rhsJobActions)) {
                return false;
            }
        }
        {
            String lhsNotificationRegistrationStatus;
            lhsNotificationRegistrationStatus = this.getNotificationRegistrationStatus();
            String rhsNotificationRegistrationStatus;
            rhsNotificationRegistrationStatus = that.getNotificationRegistrationStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "notificationRegistrationStatus", lhsNotificationRegistrationStatus), LocatorUtils.property(thatLocator, "notificationRegistrationStatus", rhsNotificationRegistrationStatus), lhsNotificationRegistrationStatus, rhsNotificationRegistrationStatus)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            NotificationRegistrationKey theBusinessObjectDataNotificationRegistrationKey;
            theBusinessObjectDataNotificationRegistrationKey = this.getBusinessObjectDataNotificationRegistrationKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataNotificationRegistrationKey", theBusinessObjectDataNotificationRegistrationKey), currentHashCode, theBusinessObjectDataNotificationRegistrationKey);
        }
        {
            String theBusinessObjectDataEventType;
            theBusinessObjectDataEventType = this.getBusinessObjectDataEventType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataEventType", theBusinessObjectDataEventType), currentHashCode, theBusinessObjectDataEventType);
        }
        {
            BusinessObjectDataNotificationFilter theBusinessObjectDataNotificationFilter;
            theBusinessObjectDataNotificationFilter = this.getBusinessObjectDataNotificationFilter();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "businessObjectDataNotificationFilter", theBusinessObjectDataNotificationFilter), currentHashCode, theBusinessObjectDataNotificationFilter);
        }
        {
            List<JobAction> theJobActions;
            theJobActions = this.getJobActions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "jobActions", theJobActions), currentHashCode, theJobActions);
        }
        {
            String theNotificationRegistrationStatus;
            theNotificationRegistrationStatus = this.getNotificationRegistrationStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "notificationRegistrationStatus", theNotificationRegistrationStatus), currentHashCode, theNotificationRegistrationStatus);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof BusinessObjectDataNotificationRegistrationCreateRequest) {
            final BusinessObjectDataNotificationRegistrationCreateRequest copy = ((BusinessObjectDataNotificationRegistrationCreateRequest) draftCopy);
            if (this.businessObjectDataNotificationRegistrationKey!= null) {
                NotificationRegistrationKey sourceBusinessObjectDataNotificationRegistrationKey;
                sourceBusinessObjectDataNotificationRegistrationKey = this.getBusinessObjectDataNotificationRegistrationKey();
                NotificationRegistrationKey copyBusinessObjectDataNotificationRegistrationKey = ((NotificationRegistrationKey) strategy.copy(LocatorUtils.property(locator, "businessObjectDataNotificationRegistrationKey", sourceBusinessObjectDataNotificationRegistrationKey), sourceBusinessObjectDataNotificationRegistrationKey));
                copy.setBusinessObjectDataNotificationRegistrationKey(copyBusinessObjectDataNotificationRegistrationKey);
            } else {
                copy.businessObjectDataNotificationRegistrationKey = null;
            }
            if (this.businessObjectDataEventType!= null) {
                String sourceBusinessObjectDataEventType;
                sourceBusinessObjectDataEventType = this.getBusinessObjectDataEventType();
                String copyBusinessObjectDataEventType = ((String) strategy.copy(LocatorUtils.property(locator, "businessObjectDataEventType", sourceBusinessObjectDataEventType), sourceBusinessObjectDataEventType));
                copy.setBusinessObjectDataEventType(copyBusinessObjectDataEventType);
            } else {
                copy.businessObjectDataEventType = null;
            }
            if (this.businessObjectDataNotificationFilter!= null) {
                BusinessObjectDataNotificationFilter sourceBusinessObjectDataNotificationFilter;
                sourceBusinessObjectDataNotificationFilter = this.getBusinessObjectDataNotificationFilter();
                BusinessObjectDataNotificationFilter copyBusinessObjectDataNotificationFilter = ((BusinessObjectDataNotificationFilter) strategy.copy(LocatorUtils.property(locator, "businessObjectDataNotificationFilter", sourceBusinessObjectDataNotificationFilter), sourceBusinessObjectDataNotificationFilter));
                copy.setBusinessObjectDataNotificationFilter(copyBusinessObjectDataNotificationFilter);
            } else {
                copy.businessObjectDataNotificationFilter = null;
            }
            if (this.jobActions!= null) {
                List<JobAction> sourceJobActions;
                sourceJobActions = this.getJobActions();
                @SuppressWarnings("unchecked")
                List<JobAction> copyJobActions = ((List<JobAction> ) strategy.copy(LocatorUtils.property(locator, "jobActions", sourceJobActions), sourceJobActions));
                copy.jobActions = null;
                copy.setJobActions(copyJobActions);
            } else {
                copy.jobActions = null;
            }
            if (this.notificationRegistrationStatus!= null) {
                String sourceNotificationRegistrationStatus;
                sourceNotificationRegistrationStatus = this.getNotificationRegistrationStatus();
                String copyNotificationRegistrationStatus = ((String) strategy.copy(LocatorUtils.property(locator, "notificationRegistrationStatus", sourceNotificationRegistrationStatus), sourceNotificationRegistrationStatus));
                copy.setNotificationRegistrationStatus(copyNotificationRegistrationStatus);
            } else {
                copy.notificationRegistrationStatus = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new BusinessObjectDataNotificationRegistrationCreateRequest();
    }

}
