
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for emrClusterDefinition complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="emrClusterDefinition"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="sshKeyPairName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="subnetId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="logBucket" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="keepAlive" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="visibleToAll" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="terminationProtection" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="encryptionEnabled" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="serviceIamRole" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="ec2NodeIamProfileName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="amiVersion" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="releaseLabel" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="hadoopVersion" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="hiveVersion" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="pigVersion" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="installOozie" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="customBootstrapActionMaster" type="{}scriptDefinitions" minOccurs="0"/&gt;
 *         &lt;element name="customBootstrapActionAll" type="{}scriptDefinitions" minOccurs="0"/&gt;
 *         &lt;element name="additionalInfo" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="instanceDefinitions" type="{}instanceDefinitions" minOccurs="0"/&gt;
 *         &lt;element name="nodeTags" type="{}nodeTags" minOccurs="0"/&gt;
 *         &lt;element name="supportedProduct" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="applications" type="{}emrClusterDefinitionApplications" minOccurs="0"/&gt;
 *         &lt;element name="configurations" type="{}emrClusterDefinitionConfigurations" minOccurs="0"/&gt;
 *         &lt;element name="daemonConfigurations" type="{}daemonConfigurations" minOccurs="0"/&gt;
 *         &lt;element name="hadoopConfigurations" type="{}hadoopConfigurations" minOccurs="0"/&gt;
 *         &lt;element name="hadoopJarSteps" type="{}hadoopJarSteps" minOccurs="0"/&gt;
 *         &lt;element name="additionalMasterSecurityGroups" type="{}additionalMasterSecurityGroups" minOccurs="0"/&gt;
 *         &lt;element name="additionalSlaveSecurityGroups" type="{}additionalSlaveSecurityGroups" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "emrClusterDefinition", propOrder = {

})
@XmlRootElement(name = "emrClusterDefinition")
public class EmrClusterDefinition implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected String sshKeyPairName;
    protected String subnetId;
    protected String logBucket;
    protected Boolean keepAlive;
    protected Boolean visibleToAll;
    protected Boolean terminationProtection;
    protected Boolean encryptionEnabled;
    protected String serviceIamRole;
    protected String ec2NodeIamProfileName;
    protected String amiVersion;
    protected String releaseLabel;
    protected String hadoopVersion;
    protected String hiveVersion;
    protected String pigVersion;
    protected Boolean installOozie;
    @XmlElementWrapper
    @XmlElement(name = "scriptDefinition")
    protected List<ScriptDefinition> customBootstrapActionMaster;
    @XmlElementWrapper
    @XmlElement(name = "scriptDefinition")
    protected List<ScriptDefinition> customBootstrapActionAll;
    protected String additionalInfo;
    protected InstanceDefinitions instanceDefinitions;
    @XmlElementWrapper
    @XmlElement(name = "nodeTag")
    protected List<NodeTag> nodeTags;
    protected String supportedProduct;
    @XmlElementWrapper
    @XmlElement(name = "application")
    protected List<EmrClusterDefinitionApplication> applications;
    @XmlElementWrapper
    @XmlElement(name = "configuration")
    protected List<EmrClusterDefinitionConfiguration> configurations;
    @XmlElementWrapper
    @XmlElement(name = "daemonParam")
    protected List<Parameter> daemonConfigurations;
    @XmlElementWrapper
    @XmlElements({
        @XmlElement(name = "configurationFiles", type = ConfigurationFiles.class),
        @XmlElement(name = "keyValuePairConfigurations", type = KeyValuePairConfigurations.class)
    })
    protected List<Serializable> hadoopConfigurations;
    @XmlElementWrapper
    @XmlElement(name = "hadoopJarStep")
    protected List<HadoopJarStep> hadoopJarSteps;
    @XmlElementWrapper
    @XmlElement(name = "additionalMasterSecurityGroup")
    protected List<String> additionalMasterSecurityGroups;
    @XmlElementWrapper
    @XmlElement(name = "additionalSlaveSecurityGroup")
    protected List<String> additionalSlaveSecurityGroups;

    /**
     * Default no-arg constructor
     * 
     */
    public EmrClusterDefinition() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public EmrClusterDefinition(final String sshKeyPairName, final String subnetId, final String logBucket, final Boolean keepAlive, final Boolean visibleToAll, final Boolean terminationProtection, final Boolean encryptionEnabled, final String serviceIamRole, final String ec2NodeIamProfileName, final String amiVersion, final String releaseLabel, final String hadoopVersion, final String hiveVersion, final String pigVersion, final Boolean installOozie, final List<ScriptDefinition> customBootstrapActionMaster, final List<ScriptDefinition> customBootstrapActionAll, final String additionalInfo, final InstanceDefinitions instanceDefinitions, final List<NodeTag> nodeTags, final String supportedProduct, final List<EmrClusterDefinitionApplication> applications, final List<EmrClusterDefinitionConfiguration> configurations, final List<Parameter> daemonConfigurations, final List<Serializable> hadoopConfigurations, final List<HadoopJarStep> hadoopJarSteps, final List<String> additionalMasterSecurityGroups, final List<String> additionalSlaveSecurityGroups) {
        this.sshKeyPairName = sshKeyPairName;
        this.subnetId = subnetId;
        this.logBucket = logBucket;
        this.keepAlive = keepAlive;
        this.visibleToAll = visibleToAll;
        this.terminationProtection = terminationProtection;
        this.encryptionEnabled = encryptionEnabled;
        this.serviceIamRole = serviceIamRole;
        this.ec2NodeIamProfileName = ec2NodeIamProfileName;
        this.amiVersion = amiVersion;
        this.releaseLabel = releaseLabel;
        this.hadoopVersion = hadoopVersion;
        this.hiveVersion = hiveVersion;
        this.pigVersion = pigVersion;
        this.installOozie = installOozie;
        this.customBootstrapActionMaster = customBootstrapActionMaster;
        this.customBootstrapActionAll = customBootstrapActionAll;
        this.additionalInfo = additionalInfo;
        this.instanceDefinitions = instanceDefinitions;
        this.nodeTags = nodeTags;
        this.supportedProduct = supportedProduct;
        this.applications = applications;
        this.configurations = configurations;
        this.daemonConfigurations = daemonConfigurations;
        this.hadoopConfigurations = hadoopConfigurations;
        this.hadoopJarSteps = hadoopJarSteps;
        this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
        this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
    }

    /**
     * Gets the value of the sshKeyPairName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSshKeyPairName() {
        return sshKeyPairName;
    }

    /**
     * Sets the value of the sshKeyPairName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSshKeyPairName(String value) {
        this.sshKeyPairName = value;
    }

    /**
     * Gets the value of the subnetId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSubnetId() {
        return subnetId;
    }

    /**
     * Sets the value of the subnetId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSubnetId(String value) {
        this.subnetId = value;
    }

    /**
     * Gets the value of the logBucket property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLogBucket() {
        return logBucket;
    }

    /**
     * Sets the value of the logBucket property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLogBucket(String value) {
        this.logBucket = value;
    }

    /**
     * Gets the value of the keepAlive property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isKeepAlive() {
        return keepAlive;
    }

    /**
     * Sets the value of the keepAlive property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setKeepAlive(Boolean value) {
        this.keepAlive = value;
    }

    /**
     * Gets the value of the visibleToAll property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isVisibleToAll() {
        return visibleToAll;
    }

    /**
     * Sets the value of the visibleToAll property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setVisibleToAll(Boolean value) {
        this.visibleToAll = value;
    }

    /**
     * Gets the value of the terminationProtection property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isTerminationProtection() {
        return terminationProtection;
    }

    /**
     * Sets the value of the terminationProtection property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTerminationProtection(Boolean value) {
        this.terminationProtection = value;
    }

    /**
     * Gets the value of the encryptionEnabled property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isEncryptionEnabled() {
        return encryptionEnabled;
    }

    /**
     * Sets the value of the encryptionEnabled property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEncryptionEnabled(Boolean value) {
        this.encryptionEnabled = value;
    }

    /**
     * Gets the value of the serviceIamRole property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getServiceIamRole() {
        return serviceIamRole;
    }

    /**
     * Sets the value of the serviceIamRole property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setServiceIamRole(String value) {
        this.serviceIamRole = value;
    }

    /**
     * Gets the value of the ec2NodeIamProfileName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getEc2NodeIamProfileName() {
        return ec2NodeIamProfileName;
    }

    /**
     * Sets the value of the ec2NodeIamProfileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setEc2NodeIamProfileName(String value) {
        this.ec2NodeIamProfileName = value;
    }

    /**
     * Gets the value of the amiVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAmiVersion() {
        return amiVersion;
    }

    /**
     * Sets the value of the amiVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAmiVersion(String value) {
        this.amiVersion = value;
    }

    /**
     * Gets the value of the releaseLabel property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getReleaseLabel() {
        return releaseLabel;
    }

    /**
     * Sets the value of the releaseLabel property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setReleaseLabel(String value) {
        this.releaseLabel = value;
    }

    /**
     * Gets the value of the hadoopVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHadoopVersion() {
        return hadoopVersion;
    }

    /**
     * Sets the value of the hadoopVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHadoopVersion(String value) {
        this.hadoopVersion = value;
    }

    /**
     * Gets the value of the hiveVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHiveVersion() {
        return hiveVersion;
    }

    /**
     * Sets the value of the hiveVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHiveVersion(String value) {
        this.hiveVersion = value;
    }

    /**
     * Gets the value of the pigVersion property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPigVersion() {
        return pigVersion;
    }

    /**
     * Sets the value of the pigVersion property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPigVersion(String value) {
        this.pigVersion = value;
    }

    /**
     * Gets the value of the installOozie property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isInstallOozie() {
        return installOozie;
    }

    /**
     * Sets the value of the installOozie property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setInstallOozie(Boolean value) {
        this.installOozie = value;
    }

    /**
     * Gets the value of the additionalInfo property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAdditionalInfo() {
        return additionalInfo;
    }

    /**
     * Sets the value of the additionalInfo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setAdditionalInfo(String value) {
        this.additionalInfo = value;
    }

    /**
     * Gets the value of the instanceDefinitions property.
     * 
     * @return
     *     possible object is
     *     {@link InstanceDefinitions }
     *     
     */
    public InstanceDefinitions getInstanceDefinitions() {
        return instanceDefinitions;
    }

    /**
     * Sets the value of the instanceDefinitions property.
     * 
     * @param value
     *     allowed object is
     *     {@link InstanceDefinitions }
     *     
     */
    public void setInstanceDefinitions(InstanceDefinitions value) {
        this.instanceDefinitions = value;
    }

    /**
     * Gets the value of the supportedProduct property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSupportedProduct() {
        return supportedProduct;
    }

    /**
     * Sets the value of the supportedProduct property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSupportedProduct(String value) {
        this.supportedProduct = value;
    }

    public List<ScriptDefinition> getCustomBootstrapActionMaster() {
        return customBootstrapActionMaster;
    }

    public void setCustomBootstrapActionMaster(List<ScriptDefinition> customBootstrapActionMaster) {
        this.customBootstrapActionMaster = customBootstrapActionMaster;
    }

    public List<ScriptDefinition> getCustomBootstrapActionAll() {
        return customBootstrapActionAll;
    }

    public void setCustomBootstrapActionAll(List<ScriptDefinition> customBootstrapActionAll) {
        this.customBootstrapActionAll = customBootstrapActionAll;
    }

    public List<NodeTag> getNodeTags() {
        return nodeTags;
    }

    public void setNodeTags(List<NodeTag> nodeTags) {
        this.nodeTags = nodeTags;
    }

    public List<EmrClusterDefinitionApplication> getApplications() {
        return applications;
    }

    public void setApplications(List<EmrClusterDefinitionApplication> applications) {
        this.applications = applications;
    }

    public List<EmrClusterDefinitionConfiguration> getConfigurations() {
        return configurations;
    }

    public void setConfigurations(List<EmrClusterDefinitionConfiguration> configurations) {
        this.configurations = configurations;
    }

    public List<Parameter> getDaemonConfigurations() {
        return daemonConfigurations;
    }

    public void setDaemonConfigurations(List<Parameter> daemonConfigurations) {
        this.daemonConfigurations = daemonConfigurations;
    }

    public List<Serializable> getHadoopConfigurations() {
        return hadoopConfigurations;
    }

    public void setHadoopConfigurations(List<Serializable> hadoopConfigurations) {
        this.hadoopConfigurations = hadoopConfigurations;
    }

    public List<HadoopJarStep> getHadoopJarSteps() {
        return hadoopJarSteps;
    }

    public void setHadoopJarSteps(List<HadoopJarStep> hadoopJarSteps) {
        this.hadoopJarSteps = hadoopJarSteps;
    }

    public List<String> getAdditionalMasterSecurityGroups() {
        return additionalMasterSecurityGroups;
    }

    public void setAdditionalMasterSecurityGroups(List<String> additionalMasterSecurityGroups) {
        this.additionalMasterSecurityGroups = additionalMasterSecurityGroups;
    }

    public List<String> getAdditionalSlaveSecurityGroups() {
        return additionalSlaveSecurityGroups;
    }

    public void setAdditionalSlaveSecurityGroups(List<String> additionalSlaveSecurityGroups) {
        this.additionalSlaveSecurityGroups = additionalSlaveSecurityGroups;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theSshKeyPairName;
            theSshKeyPairName = this.getSshKeyPairName();
            strategy.appendField(locator, this, "sshKeyPairName", buffer, theSshKeyPairName);
        }
        {
            String theSubnetId;
            theSubnetId = this.getSubnetId();
            strategy.appendField(locator, this, "subnetId", buffer, theSubnetId);
        }
        {
            String theLogBucket;
            theLogBucket = this.getLogBucket();
            strategy.appendField(locator, this, "logBucket", buffer, theLogBucket);
        }
        {
            Boolean theKeepAlive;
            theKeepAlive = this.isKeepAlive();
            strategy.appendField(locator, this, "keepAlive", buffer, theKeepAlive);
        }
        {
            Boolean theVisibleToAll;
            theVisibleToAll = this.isVisibleToAll();
            strategy.appendField(locator, this, "visibleToAll", buffer, theVisibleToAll);
        }
        {
            Boolean theTerminationProtection;
            theTerminationProtection = this.isTerminationProtection();
            strategy.appendField(locator, this, "terminationProtection", buffer, theTerminationProtection);
        }
        {
            Boolean theEncryptionEnabled;
            theEncryptionEnabled = this.isEncryptionEnabled();
            strategy.appendField(locator, this, "encryptionEnabled", buffer, theEncryptionEnabled);
        }
        {
            String theServiceIamRole;
            theServiceIamRole = this.getServiceIamRole();
            strategy.appendField(locator, this, "serviceIamRole", buffer, theServiceIamRole);
        }
        {
            String theEc2NodeIamProfileName;
            theEc2NodeIamProfileName = this.getEc2NodeIamProfileName();
            strategy.appendField(locator, this, "ec2NodeIamProfileName", buffer, theEc2NodeIamProfileName);
        }
        {
            String theAmiVersion;
            theAmiVersion = this.getAmiVersion();
            strategy.appendField(locator, this, "amiVersion", buffer, theAmiVersion);
        }
        {
            String theReleaseLabel;
            theReleaseLabel = this.getReleaseLabel();
            strategy.appendField(locator, this, "releaseLabel", buffer, theReleaseLabel);
        }
        {
            String theHadoopVersion;
            theHadoopVersion = this.getHadoopVersion();
            strategy.appendField(locator, this, "hadoopVersion", buffer, theHadoopVersion);
        }
        {
            String theHiveVersion;
            theHiveVersion = this.getHiveVersion();
            strategy.appendField(locator, this, "hiveVersion", buffer, theHiveVersion);
        }
        {
            String thePigVersion;
            thePigVersion = this.getPigVersion();
            strategy.appendField(locator, this, "pigVersion", buffer, thePigVersion);
        }
        {
            Boolean theInstallOozie;
            theInstallOozie = this.isInstallOozie();
            strategy.appendField(locator, this, "installOozie", buffer, theInstallOozie);
        }
        {
            List<ScriptDefinition> theCustomBootstrapActionMaster;
            theCustomBootstrapActionMaster = this.getCustomBootstrapActionMaster();
            strategy.appendField(locator, this, "customBootstrapActionMaster", buffer, theCustomBootstrapActionMaster);
        }
        {
            List<ScriptDefinition> theCustomBootstrapActionAll;
            theCustomBootstrapActionAll = this.getCustomBootstrapActionAll();
            strategy.appendField(locator, this, "customBootstrapActionAll", buffer, theCustomBootstrapActionAll);
        }
        {
            String theAdditionalInfo;
            theAdditionalInfo = this.getAdditionalInfo();
            strategy.appendField(locator, this, "additionalInfo", buffer, theAdditionalInfo);
        }
        {
            InstanceDefinitions theInstanceDefinitions;
            theInstanceDefinitions = this.getInstanceDefinitions();
            strategy.appendField(locator, this, "instanceDefinitions", buffer, theInstanceDefinitions);
        }
        {
            List<NodeTag> theNodeTags;
            theNodeTags = this.getNodeTags();
            strategy.appendField(locator, this, "nodeTags", buffer, theNodeTags);
        }
        {
            String theSupportedProduct;
            theSupportedProduct = this.getSupportedProduct();
            strategy.appendField(locator, this, "supportedProduct", buffer, theSupportedProduct);
        }
        {
            List<EmrClusterDefinitionApplication> theApplications;
            theApplications = this.getApplications();
            strategy.appendField(locator, this, "applications", buffer, theApplications);
        }
        {
            List<EmrClusterDefinitionConfiguration> theConfigurations;
            theConfigurations = this.getConfigurations();
            strategy.appendField(locator, this, "configurations", buffer, theConfigurations);
        }
        {
            List<Parameter> theDaemonConfigurations;
            theDaemonConfigurations = this.getDaemonConfigurations();
            strategy.appendField(locator, this, "daemonConfigurations", buffer, theDaemonConfigurations);
        }
        {
            List<Serializable> theHadoopConfigurations;
            theHadoopConfigurations = this.getHadoopConfigurations();
            strategy.appendField(locator, this, "hadoopConfigurations", buffer, theHadoopConfigurations);
        }
        {
            List<HadoopJarStep> theHadoopJarSteps;
            theHadoopJarSteps = this.getHadoopJarSteps();
            strategy.appendField(locator, this, "hadoopJarSteps", buffer, theHadoopJarSteps);
        }
        {
            List<String> theAdditionalMasterSecurityGroups;
            theAdditionalMasterSecurityGroups = this.getAdditionalMasterSecurityGroups();
            strategy.appendField(locator, this, "additionalMasterSecurityGroups", buffer, theAdditionalMasterSecurityGroups);
        }
        {
            List<String> theAdditionalSlaveSecurityGroups;
            theAdditionalSlaveSecurityGroups = this.getAdditionalSlaveSecurityGroups();
            strategy.appendField(locator, this, "additionalSlaveSecurityGroups", buffer, theAdditionalSlaveSecurityGroups);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final EmrClusterDefinition that = ((EmrClusterDefinition) object);
        {
            String lhsSshKeyPairName;
            lhsSshKeyPairName = this.getSshKeyPairName();
            String rhsSshKeyPairName;
            rhsSshKeyPairName = that.getSshKeyPairName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "sshKeyPairName", lhsSshKeyPairName), LocatorUtils.property(thatLocator, "sshKeyPairName", rhsSshKeyPairName), lhsSshKeyPairName, rhsSshKeyPairName)) {
                return false;
            }
        }
        {
            String lhsSubnetId;
            lhsSubnetId = this.getSubnetId();
            String rhsSubnetId;
            rhsSubnetId = that.getSubnetId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "subnetId", lhsSubnetId), LocatorUtils.property(thatLocator, "subnetId", rhsSubnetId), lhsSubnetId, rhsSubnetId)) {
                return false;
            }
        }
        {
            String lhsLogBucket;
            lhsLogBucket = this.getLogBucket();
            String rhsLogBucket;
            rhsLogBucket = that.getLogBucket();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "logBucket", lhsLogBucket), LocatorUtils.property(thatLocator, "logBucket", rhsLogBucket), lhsLogBucket, rhsLogBucket)) {
                return false;
            }
        }
        {
            Boolean lhsKeepAlive;
            lhsKeepAlive = this.isKeepAlive();
            Boolean rhsKeepAlive;
            rhsKeepAlive = that.isKeepAlive();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "keepAlive", lhsKeepAlive), LocatorUtils.property(thatLocator, "keepAlive", rhsKeepAlive), lhsKeepAlive, rhsKeepAlive)) {
                return false;
            }
        }
        {
            Boolean lhsVisibleToAll;
            lhsVisibleToAll = this.isVisibleToAll();
            Boolean rhsVisibleToAll;
            rhsVisibleToAll = that.isVisibleToAll();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "visibleToAll", lhsVisibleToAll), LocatorUtils.property(thatLocator, "visibleToAll", rhsVisibleToAll), lhsVisibleToAll, rhsVisibleToAll)) {
                return false;
            }
        }
        {
            Boolean lhsTerminationProtection;
            lhsTerminationProtection = this.isTerminationProtection();
            Boolean rhsTerminationProtection;
            rhsTerminationProtection = that.isTerminationProtection();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "terminationProtection", lhsTerminationProtection), LocatorUtils.property(thatLocator, "terminationProtection", rhsTerminationProtection), lhsTerminationProtection, rhsTerminationProtection)) {
                return false;
            }
        }
        {
            Boolean lhsEncryptionEnabled;
            lhsEncryptionEnabled = this.isEncryptionEnabled();
            Boolean rhsEncryptionEnabled;
            rhsEncryptionEnabled = that.isEncryptionEnabled();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "encryptionEnabled", lhsEncryptionEnabled), LocatorUtils.property(thatLocator, "encryptionEnabled", rhsEncryptionEnabled), lhsEncryptionEnabled, rhsEncryptionEnabled)) {
                return false;
            }
        }
        {
            String lhsServiceIamRole;
            lhsServiceIamRole = this.getServiceIamRole();
            String rhsServiceIamRole;
            rhsServiceIamRole = that.getServiceIamRole();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "serviceIamRole", lhsServiceIamRole), LocatorUtils.property(thatLocator, "serviceIamRole", rhsServiceIamRole), lhsServiceIamRole, rhsServiceIamRole)) {
                return false;
            }
        }
        {
            String lhsEc2NodeIamProfileName;
            lhsEc2NodeIamProfileName = this.getEc2NodeIamProfileName();
            String rhsEc2NodeIamProfileName;
            rhsEc2NodeIamProfileName = that.getEc2NodeIamProfileName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "ec2NodeIamProfileName", lhsEc2NodeIamProfileName), LocatorUtils.property(thatLocator, "ec2NodeIamProfileName", rhsEc2NodeIamProfileName), lhsEc2NodeIamProfileName, rhsEc2NodeIamProfileName)) {
                return false;
            }
        }
        {
            String lhsAmiVersion;
            lhsAmiVersion = this.getAmiVersion();
            String rhsAmiVersion;
            rhsAmiVersion = that.getAmiVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "amiVersion", lhsAmiVersion), LocatorUtils.property(thatLocator, "amiVersion", rhsAmiVersion), lhsAmiVersion, rhsAmiVersion)) {
                return false;
            }
        }
        {
            String lhsReleaseLabel;
            lhsReleaseLabel = this.getReleaseLabel();
            String rhsReleaseLabel;
            rhsReleaseLabel = that.getReleaseLabel();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "releaseLabel", lhsReleaseLabel), LocatorUtils.property(thatLocator, "releaseLabel", rhsReleaseLabel), lhsReleaseLabel, rhsReleaseLabel)) {
                return false;
            }
        }
        {
            String lhsHadoopVersion;
            lhsHadoopVersion = this.getHadoopVersion();
            String rhsHadoopVersion;
            rhsHadoopVersion = that.getHadoopVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "hadoopVersion", lhsHadoopVersion), LocatorUtils.property(thatLocator, "hadoopVersion", rhsHadoopVersion), lhsHadoopVersion, rhsHadoopVersion)) {
                return false;
            }
        }
        {
            String lhsHiveVersion;
            lhsHiveVersion = this.getHiveVersion();
            String rhsHiveVersion;
            rhsHiveVersion = that.getHiveVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "hiveVersion", lhsHiveVersion), LocatorUtils.property(thatLocator, "hiveVersion", rhsHiveVersion), lhsHiveVersion, rhsHiveVersion)) {
                return false;
            }
        }
        {
            String lhsPigVersion;
            lhsPigVersion = this.getPigVersion();
            String rhsPigVersion;
            rhsPigVersion = that.getPigVersion();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "pigVersion", lhsPigVersion), LocatorUtils.property(thatLocator, "pigVersion", rhsPigVersion), lhsPigVersion, rhsPigVersion)) {
                return false;
            }
        }
        {
            Boolean lhsInstallOozie;
            lhsInstallOozie = this.isInstallOozie();
            Boolean rhsInstallOozie;
            rhsInstallOozie = that.isInstallOozie();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "installOozie", lhsInstallOozie), LocatorUtils.property(thatLocator, "installOozie", rhsInstallOozie), lhsInstallOozie, rhsInstallOozie)) {
                return false;
            }
        }
        {
            List<ScriptDefinition> lhsCustomBootstrapActionMaster;
            lhsCustomBootstrapActionMaster = this.getCustomBootstrapActionMaster();
            List<ScriptDefinition> rhsCustomBootstrapActionMaster;
            rhsCustomBootstrapActionMaster = that.getCustomBootstrapActionMaster();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "customBootstrapActionMaster", lhsCustomBootstrapActionMaster), LocatorUtils.property(thatLocator, "customBootstrapActionMaster", rhsCustomBootstrapActionMaster), lhsCustomBootstrapActionMaster, rhsCustomBootstrapActionMaster)) {
                return false;
            }
        }
        {
            List<ScriptDefinition> lhsCustomBootstrapActionAll;
            lhsCustomBootstrapActionAll = this.getCustomBootstrapActionAll();
            List<ScriptDefinition> rhsCustomBootstrapActionAll;
            rhsCustomBootstrapActionAll = that.getCustomBootstrapActionAll();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "customBootstrapActionAll", lhsCustomBootstrapActionAll), LocatorUtils.property(thatLocator, "customBootstrapActionAll", rhsCustomBootstrapActionAll), lhsCustomBootstrapActionAll, rhsCustomBootstrapActionAll)) {
                return false;
            }
        }
        {
            String lhsAdditionalInfo;
            lhsAdditionalInfo = this.getAdditionalInfo();
            String rhsAdditionalInfo;
            rhsAdditionalInfo = that.getAdditionalInfo();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "additionalInfo", lhsAdditionalInfo), LocatorUtils.property(thatLocator, "additionalInfo", rhsAdditionalInfo), lhsAdditionalInfo, rhsAdditionalInfo)) {
                return false;
            }
        }
        {
            InstanceDefinitions lhsInstanceDefinitions;
            lhsInstanceDefinitions = this.getInstanceDefinitions();
            InstanceDefinitions rhsInstanceDefinitions;
            rhsInstanceDefinitions = that.getInstanceDefinitions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "instanceDefinitions", lhsInstanceDefinitions), LocatorUtils.property(thatLocator, "instanceDefinitions", rhsInstanceDefinitions), lhsInstanceDefinitions, rhsInstanceDefinitions)) {
                return false;
            }
        }
        {
            List<NodeTag> lhsNodeTags;
            lhsNodeTags = this.getNodeTags();
            List<NodeTag> rhsNodeTags;
            rhsNodeTags = that.getNodeTags();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "nodeTags", lhsNodeTags), LocatorUtils.property(thatLocator, "nodeTags", rhsNodeTags), lhsNodeTags, rhsNodeTags)) {
                return false;
            }
        }
        {
            String lhsSupportedProduct;
            lhsSupportedProduct = this.getSupportedProduct();
            String rhsSupportedProduct;
            rhsSupportedProduct = that.getSupportedProduct();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "supportedProduct", lhsSupportedProduct), LocatorUtils.property(thatLocator, "supportedProduct", rhsSupportedProduct), lhsSupportedProduct, rhsSupportedProduct)) {
                return false;
            }
        }
        {
            List<EmrClusterDefinitionApplication> lhsApplications;
            lhsApplications = this.getApplications();
            List<EmrClusterDefinitionApplication> rhsApplications;
            rhsApplications = that.getApplications();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "applications", lhsApplications), LocatorUtils.property(thatLocator, "applications", rhsApplications), lhsApplications, rhsApplications)) {
                return false;
            }
        }
        {
            List<EmrClusterDefinitionConfiguration> lhsConfigurations;
            lhsConfigurations = this.getConfigurations();
            List<EmrClusterDefinitionConfiguration> rhsConfigurations;
            rhsConfigurations = that.getConfigurations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "configurations", lhsConfigurations), LocatorUtils.property(thatLocator, "configurations", rhsConfigurations), lhsConfigurations, rhsConfigurations)) {
                return false;
            }
        }
        {
            List<Parameter> lhsDaemonConfigurations;
            lhsDaemonConfigurations = this.getDaemonConfigurations();
            List<Parameter> rhsDaemonConfigurations;
            rhsDaemonConfigurations = that.getDaemonConfigurations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "daemonConfigurations", lhsDaemonConfigurations), LocatorUtils.property(thatLocator, "daemonConfigurations", rhsDaemonConfigurations), lhsDaemonConfigurations, rhsDaemonConfigurations)) {
                return false;
            }
        }
        {
            List<Serializable> lhsHadoopConfigurations;
            lhsHadoopConfigurations = this.getHadoopConfigurations();
            List<Serializable> rhsHadoopConfigurations;
            rhsHadoopConfigurations = that.getHadoopConfigurations();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "hadoopConfigurations", lhsHadoopConfigurations), LocatorUtils.property(thatLocator, "hadoopConfigurations", rhsHadoopConfigurations), lhsHadoopConfigurations, rhsHadoopConfigurations)) {
                return false;
            }
        }
        {
            List<HadoopJarStep> lhsHadoopJarSteps;
            lhsHadoopJarSteps = this.getHadoopJarSteps();
            List<HadoopJarStep> rhsHadoopJarSteps;
            rhsHadoopJarSteps = that.getHadoopJarSteps();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "hadoopJarSteps", lhsHadoopJarSteps), LocatorUtils.property(thatLocator, "hadoopJarSteps", rhsHadoopJarSteps), lhsHadoopJarSteps, rhsHadoopJarSteps)) {
                return false;
            }
        }
        {
            List<String> lhsAdditionalMasterSecurityGroups;
            lhsAdditionalMasterSecurityGroups = this.getAdditionalMasterSecurityGroups();
            List<String> rhsAdditionalMasterSecurityGroups;
            rhsAdditionalMasterSecurityGroups = that.getAdditionalMasterSecurityGroups();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "additionalMasterSecurityGroups", lhsAdditionalMasterSecurityGroups), LocatorUtils.property(thatLocator, "additionalMasterSecurityGroups", rhsAdditionalMasterSecurityGroups), lhsAdditionalMasterSecurityGroups, rhsAdditionalMasterSecurityGroups)) {
                return false;
            }
        }
        {
            List<String> lhsAdditionalSlaveSecurityGroups;
            lhsAdditionalSlaveSecurityGroups = this.getAdditionalSlaveSecurityGroups();
            List<String> rhsAdditionalSlaveSecurityGroups;
            rhsAdditionalSlaveSecurityGroups = that.getAdditionalSlaveSecurityGroups();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "additionalSlaveSecurityGroups", lhsAdditionalSlaveSecurityGroups), LocatorUtils.property(thatLocator, "additionalSlaveSecurityGroups", rhsAdditionalSlaveSecurityGroups), lhsAdditionalSlaveSecurityGroups, rhsAdditionalSlaveSecurityGroups)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theSshKeyPairName;
            theSshKeyPairName = this.getSshKeyPairName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "sshKeyPairName", theSshKeyPairName), currentHashCode, theSshKeyPairName);
        }
        {
            String theSubnetId;
            theSubnetId = this.getSubnetId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "subnetId", theSubnetId), currentHashCode, theSubnetId);
        }
        {
            String theLogBucket;
            theLogBucket = this.getLogBucket();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "logBucket", theLogBucket), currentHashCode, theLogBucket);
        }
        {
            Boolean theKeepAlive;
            theKeepAlive = this.isKeepAlive();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "keepAlive", theKeepAlive), currentHashCode, theKeepAlive);
        }
        {
            Boolean theVisibleToAll;
            theVisibleToAll = this.isVisibleToAll();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "visibleToAll", theVisibleToAll), currentHashCode, theVisibleToAll);
        }
        {
            Boolean theTerminationProtection;
            theTerminationProtection = this.isTerminationProtection();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "terminationProtection", theTerminationProtection), currentHashCode, theTerminationProtection);
        }
        {
            Boolean theEncryptionEnabled;
            theEncryptionEnabled = this.isEncryptionEnabled();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "encryptionEnabled", theEncryptionEnabled), currentHashCode, theEncryptionEnabled);
        }
        {
            String theServiceIamRole;
            theServiceIamRole = this.getServiceIamRole();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "serviceIamRole", theServiceIamRole), currentHashCode, theServiceIamRole);
        }
        {
            String theEc2NodeIamProfileName;
            theEc2NodeIamProfileName = this.getEc2NodeIamProfileName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "ec2NodeIamProfileName", theEc2NodeIamProfileName), currentHashCode, theEc2NodeIamProfileName);
        }
        {
            String theAmiVersion;
            theAmiVersion = this.getAmiVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "amiVersion", theAmiVersion), currentHashCode, theAmiVersion);
        }
        {
            String theReleaseLabel;
            theReleaseLabel = this.getReleaseLabel();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "releaseLabel", theReleaseLabel), currentHashCode, theReleaseLabel);
        }
        {
            String theHadoopVersion;
            theHadoopVersion = this.getHadoopVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "hadoopVersion", theHadoopVersion), currentHashCode, theHadoopVersion);
        }
        {
            String theHiveVersion;
            theHiveVersion = this.getHiveVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "hiveVersion", theHiveVersion), currentHashCode, theHiveVersion);
        }
        {
            String thePigVersion;
            thePigVersion = this.getPigVersion();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "pigVersion", thePigVersion), currentHashCode, thePigVersion);
        }
        {
            Boolean theInstallOozie;
            theInstallOozie = this.isInstallOozie();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "installOozie", theInstallOozie), currentHashCode, theInstallOozie);
        }
        {
            List<ScriptDefinition> theCustomBootstrapActionMaster;
            theCustomBootstrapActionMaster = this.getCustomBootstrapActionMaster();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "customBootstrapActionMaster", theCustomBootstrapActionMaster), currentHashCode, theCustomBootstrapActionMaster);
        }
        {
            List<ScriptDefinition> theCustomBootstrapActionAll;
            theCustomBootstrapActionAll = this.getCustomBootstrapActionAll();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "customBootstrapActionAll", theCustomBootstrapActionAll), currentHashCode, theCustomBootstrapActionAll);
        }
        {
            String theAdditionalInfo;
            theAdditionalInfo = this.getAdditionalInfo();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "additionalInfo", theAdditionalInfo), currentHashCode, theAdditionalInfo);
        }
        {
            InstanceDefinitions theInstanceDefinitions;
            theInstanceDefinitions = this.getInstanceDefinitions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "instanceDefinitions", theInstanceDefinitions), currentHashCode, theInstanceDefinitions);
        }
        {
            List<NodeTag> theNodeTags;
            theNodeTags = this.getNodeTags();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "nodeTags", theNodeTags), currentHashCode, theNodeTags);
        }
        {
            String theSupportedProduct;
            theSupportedProduct = this.getSupportedProduct();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "supportedProduct", theSupportedProduct), currentHashCode, theSupportedProduct);
        }
        {
            List<EmrClusterDefinitionApplication> theApplications;
            theApplications = this.getApplications();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "applications", theApplications), currentHashCode, theApplications);
        }
        {
            List<EmrClusterDefinitionConfiguration> theConfigurations;
            theConfigurations = this.getConfigurations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "configurations", theConfigurations), currentHashCode, theConfigurations);
        }
        {
            List<Parameter> theDaemonConfigurations;
            theDaemonConfigurations = this.getDaemonConfigurations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "daemonConfigurations", theDaemonConfigurations), currentHashCode, theDaemonConfigurations);
        }
        {
            List<Serializable> theHadoopConfigurations;
            theHadoopConfigurations = this.getHadoopConfigurations();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "hadoopConfigurations", theHadoopConfigurations), currentHashCode, theHadoopConfigurations);
        }
        {
            List<HadoopJarStep> theHadoopJarSteps;
            theHadoopJarSteps = this.getHadoopJarSteps();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "hadoopJarSteps", theHadoopJarSteps), currentHashCode, theHadoopJarSteps);
        }
        {
            List<String> theAdditionalMasterSecurityGroups;
            theAdditionalMasterSecurityGroups = this.getAdditionalMasterSecurityGroups();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "additionalMasterSecurityGroups", theAdditionalMasterSecurityGroups), currentHashCode, theAdditionalMasterSecurityGroups);
        }
        {
            List<String> theAdditionalSlaveSecurityGroups;
            theAdditionalSlaveSecurityGroups = this.getAdditionalSlaveSecurityGroups();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "additionalSlaveSecurityGroups", theAdditionalSlaveSecurityGroups), currentHashCode, theAdditionalSlaveSecurityGroups);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof EmrClusterDefinition) {
            final EmrClusterDefinition copy = ((EmrClusterDefinition) draftCopy);
            if (this.sshKeyPairName!= null) {
                String sourceSshKeyPairName;
                sourceSshKeyPairName = this.getSshKeyPairName();
                String copySshKeyPairName = ((String) strategy.copy(LocatorUtils.property(locator, "sshKeyPairName", sourceSshKeyPairName), sourceSshKeyPairName));
                copy.setSshKeyPairName(copySshKeyPairName);
            } else {
                copy.sshKeyPairName = null;
            }
            if (this.subnetId!= null) {
                String sourceSubnetId;
                sourceSubnetId = this.getSubnetId();
                String copySubnetId = ((String) strategy.copy(LocatorUtils.property(locator, "subnetId", sourceSubnetId), sourceSubnetId));
                copy.setSubnetId(copySubnetId);
            } else {
                copy.subnetId = null;
            }
            if (this.logBucket!= null) {
                String sourceLogBucket;
                sourceLogBucket = this.getLogBucket();
                String copyLogBucket = ((String) strategy.copy(LocatorUtils.property(locator, "logBucket", sourceLogBucket), sourceLogBucket));
                copy.setLogBucket(copyLogBucket);
            } else {
                copy.logBucket = null;
            }
            if (this.keepAlive!= null) {
                Boolean sourceKeepAlive;
                sourceKeepAlive = this.isKeepAlive();
                Boolean copyKeepAlive = ((Boolean) strategy.copy(LocatorUtils.property(locator, "keepAlive", sourceKeepAlive), sourceKeepAlive));
                copy.setKeepAlive(copyKeepAlive);
            } else {
                copy.keepAlive = null;
            }
            if (this.visibleToAll!= null) {
                Boolean sourceVisibleToAll;
                sourceVisibleToAll = this.isVisibleToAll();
                Boolean copyVisibleToAll = ((Boolean) strategy.copy(LocatorUtils.property(locator, "visibleToAll", sourceVisibleToAll), sourceVisibleToAll));
                copy.setVisibleToAll(copyVisibleToAll);
            } else {
                copy.visibleToAll = null;
            }
            if (this.terminationProtection!= null) {
                Boolean sourceTerminationProtection;
                sourceTerminationProtection = this.isTerminationProtection();
                Boolean copyTerminationProtection = ((Boolean) strategy.copy(LocatorUtils.property(locator, "terminationProtection", sourceTerminationProtection), sourceTerminationProtection));
                copy.setTerminationProtection(copyTerminationProtection);
            } else {
                copy.terminationProtection = null;
            }
            if (this.encryptionEnabled!= null) {
                Boolean sourceEncryptionEnabled;
                sourceEncryptionEnabled = this.isEncryptionEnabled();
                Boolean copyEncryptionEnabled = ((Boolean) strategy.copy(LocatorUtils.property(locator, "encryptionEnabled", sourceEncryptionEnabled), sourceEncryptionEnabled));
                copy.setEncryptionEnabled(copyEncryptionEnabled);
            } else {
                copy.encryptionEnabled = null;
            }
            if (this.serviceIamRole!= null) {
                String sourceServiceIamRole;
                sourceServiceIamRole = this.getServiceIamRole();
                String copyServiceIamRole = ((String) strategy.copy(LocatorUtils.property(locator, "serviceIamRole", sourceServiceIamRole), sourceServiceIamRole));
                copy.setServiceIamRole(copyServiceIamRole);
            } else {
                copy.serviceIamRole = null;
            }
            if (this.ec2NodeIamProfileName!= null) {
                String sourceEc2NodeIamProfileName;
                sourceEc2NodeIamProfileName = this.getEc2NodeIamProfileName();
                String copyEc2NodeIamProfileName = ((String) strategy.copy(LocatorUtils.property(locator, "ec2NodeIamProfileName", sourceEc2NodeIamProfileName), sourceEc2NodeIamProfileName));
                copy.setEc2NodeIamProfileName(copyEc2NodeIamProfileName);
            } else {
                copy.ec2NodeIamProfileName = null;
            }
            if (this.amiVersion!= null) {
                String sourceAmiVersion;
                sourceAmiVersion = this.getAmiVersion();
                String copyAmiVersion = ((String) strategy.copy(LocatorUtils.property(locator, "amiVersion", sourceAmiVersion), sourceAmiVersion));
                copy.setAmiVersion(copyAmiVersion);
            } else {
                copy.amiVersion = null;
            }
            if (this.releaseLabel!= null) {
                String sourceReleaseLabel;
                sourceReleaseLabel = this.getReleaseLabel();
                String copyReleaseLabel = ((String) strategy.copy(LocatorUtils.property(locator, "releaseLabel", sourceReleaseLabel), sourceReleaseLabel));
                copy.setReleaseLabel(copyReleaseLabel);
            } else {
                copy.releaseLabel = null;
            }
            if (this.hadoopVersion!= null) {
                String sourceHadoopVersion;
                sourceHadoopVersion = this.getHadoopVersion();
                String copyHadoopVersion = ((String) strategy.copy(LocatorUtils.property(locator, "hadoopVersion", sourceHadoopVersion), sourceHadoopVersion));
                copy.setHadoopVersion(copyHadoopVersion);
            } else {
                copy.hadoopVersion = null;
            }
            if (this.hiveVersion!= null) {
                String sourceHiveVersion;
                sourceHiveVersion = this.getHiveVersion();
                String copyHiveVersion = ((String) strategy.copy(LocatorUtils.property(locator, "hiveVersion", sourceHiveVersion), sourceHiveVersion));
                copy.setHiveVersion(copyHiveVersion);
            } else {
                copy.hiveVersion = null;
            }
            if (this.pigVersion!= null) {
                String sourcePigVersion;
                sourcePigVersion = this.getPigVersion();
                String copyPigVersion = ((String) strategy.copy(LocatorUtils.property(locator, "pigVersion", sourcePigVersion), sourcePigVersion));
                copy.setPigVersion(copyPigVersion);
            } else {
                copy.pigVersion = null;
            }
            if (this.installOozie!= null) {
                Boolean sourceInstallOozie;
                sourceInstallOozie = this.isInstallOozie();
                Boolean copyInstallOozie = ((Boolean) strategy.copy(LocatorUtils.property(locator, "installOozie", sourceInstallOozie), sourceInstallOozie));
                copy.setInstallOozie(copyInstallOozie);
            } else {
                copy.installOozie = null;
            }
            if (this.customBootstrapActionMaster!= null) {
                List<ScriptDefinition> sourceCustomBootstrapActionMaster;
                sourceCustomBootstrapActionMaster = this.getCustomBootstrapActionMaster();
                @SuppressWarnings("unchecked")
                List<ScriptDefinition> copyCustomBootstrapActionMaster = ((List<ScriptDefinition> ) strategy.copy(LocatorUtils.property(locator, "customBootstrapActionMaster", sourceCustomBootstrapActionMaster), sourceCustomBootstrapActionMaster));
                copy.customBootstrapActionMaster = null;
                copy.setCustomBootstrapActionMaster(copyCustomBootstrapActionMaster);
            } else {
                copy.customBootstrapActionMaster = null;
            }
            if (this.customBootstrapActionAll!= null) {
                List<ScriptDefinition> sourceCustomBootstrapActionAll;
                sourceCustomBootstrapActionAll = this.getCustomBootstrapActionAll();
                @SuppressWarnings("unchecked")
                List<ScriptDefinition> copyCustomBootstrapActionAll = ((List<ScriptDefinition> ) strategy.copy(LocatorUtils.property(locator, "customBootstrapActionAll", sourceCustomBootstrapActionAll), sourceCustomBootstrapActionAll));
                copy.customBootstrapActionAll = null;
                copy.setCustomBootstrapActionAll(copyCustomBootstrapActionAll);
            } else {
                copy.customBootstrapActionAll = null;
            }
            if (this.additionalInfo!= null) {
                String sourceAdditionalInfo;
                sourceAdditionalInfo = this.getAdditionalInfo();
                String copyAdditionalInfo = ((String) strategy.copy(LocatorUtils.property(locator, "additionalInfo", sourceAdditionalInfo), sourceAdditionalInfo));
                copy.setAdditionalInfo(copyAdditionalInfo);
            } else {
                copy.additionalInfo = null;
            }
            if (this.instanceDefinitions!= null) {
                InstanceDefinitions sourceInstanceDefinitions;
                sourceInstanceDefinitions = this.getInstanceDefinitions();
                InstanceDefinitions copyInstanceDefinitions = ((InstanceDefinitions) strategy.copy(LocatorUtils.property(locator, "instanceDefinitions", sourceInstanceDefinitions), sourceInstanceDefinitions));
                copy.setInstanceDefinitions(copyInstanceDefinitions);
            } else {
                copy.instanceDefinitions = null;
            }
            if (this.nodeTags!= null) {
                List<NodeTag> sourceNodeTags;
                sourceNodeTags = this.getNodeTags();
                @SuppressWarnings("unchecked")
                List<NodeTag> copyNodeTags = ((List<NodeTag> ) strategy.copy(LocatorUtils.property(locator, "nodeTags", sourceNodeTags), sourceNodeTags));
                copy.nodeTags = null;
                copy.setNodeTags(copyNodeTags);
            } else {
                copy.nodeTags = null;
            }
            if (this.supportedProduct!= null) {
                String sourceSupportedProduct;
                sourceSupportedProduct = this.getSupportedProduct();
                String copySupportedProduct = ((String) strategy.copy(LocatorUtils.property(locator, "supportedProduct", sourceSupportedProduct), sourceSupportedProduct));
                copy.setSupportedProduct(copySupportedProduct);
            } else {
                copy.supportedProduct = null;
            }
            if (this.applications!= null) {
                List<EmrClusterDefinitionApplication> sourceApplications;
                sourceApplications = this.getApplications();
                @SuppressWarnings("unchecked")
                List<EmrClusterDefinitionApplication> copyApplications = ((List<EmrClusterDefinitionApplication> ) strategy.copy(LocatorUtils.property(locator, "applications", sourceApplications), sourceApplications));
                copy.applications = null;
                copy.setApplications(copyApplications);
            } else {
                copy.applications = null;
            }
            if (this.configurations!= null) {
                List<EmrClusterDefinitionConfiguration> sourceConfigurations;
                sourceConfigurations = this.getConfigurations();
                @SuppressWarnings("unchecked")
                List<EmrClusterDefinitionConfiguration> copyConfigurations = ((List<EmrClusterDefinitionConfiguration> ) strategy.copy(LocatorUtils.property(locator, "configurations", sourceConfigurations), sourceConfigurations));
                copy.configurations = null;
                copy.setConfigurations(copyConfigurations);
            } else {
                copy.configurations = null;
            }
            if (this.daemonConfigurations!= null) {
                List<Parameter> sourceDaemonConfigurations;
                sourceDaemonConfigurations = this.getDaemonConfigurations();
                @SuppressWarnings("unchecked")
                List<Parameter> copyDaemonConfigurations = ((List<Parameter> ) strategy.copy(LocatorUtils.property(locator, "daemonConfigurations", sourceDaemonConfigurations), sourceDaemonConfigurations));
                copy.daemonConfigurations = null;
                copy.setDaemonConfigurations(copyDaemonConfigurations);
            } else {
                copy.daemonConfigurations = null;
            }
            if (this.hadoopConfigurations!= null) {
                List<Serializable> sourceHadoopConfigurations;
                sourceHadoopConfigurations = this.getHadoopConfigurations();
                @SuppressWarnings("unchecked")
                List<Serializable> copyHadoopConfigurations = ((List<Serializable> ) strategy.copy(LocatorUtils.property(locator, "hadoopConfigurations", sourceHadoopConfigurations), sourceHadoopConfigurations));
                copy.hadoopConfigurations = null;
                copy.setHadoopConfigurations(copyHadoopConfigurations);
            } else {
                copy.hadoopConfigurations = null;
            }
            if (this.hadoopJarSteps!= null) {
                List<HadoopJarStep> sourceHadoopJarSteps;
                sourceHadoopJarSteps = this.getHadoopJarSteps();
                @SuppressWarnings("unchecked")
                List<HadoopJarStep> copyHadoopJarSteps = ((List<HadoopJarStep> ) strategy.copy(LocatorUtils.property(locator, "hadoopJarSteps", sourceHadoopJarSteps), sourceHadoopJarSteps));
                copy.hadoopJarSteps = null;
                copy.setHadoopJarSteps(copyHadoopJarSteps);
            } else {
                copy.hadoopJarSteps = null;
            }
            if (this.additionalMasterSecurityGroups!= null) {
                List<String> sourceAdditionalMasterSecurityGroups;
                sourceAdditionalMasterSecurityGroups = this.getAdditionalMasterSecurityGroups();
                @SuppressWarnings("unchecked")
                List<String> copyAdditionalMasterSecurityGroups = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "additionalMasterSecurityGroups", sourceAdditionalMasterSecurityGroups), sourceAdditionalMasterSecurityGroups));
                copy.additionalMasterSecurityGroups = null;
                copy.setAdditionalMasterSecurityGroups(copyAdditionalMasterSecurityGroups);
            } else {
                copy.additionalMasterSecurityGroups = null;
            }
            if (this.additionalSlaveSecurityGroups!= null) {
                List<String> sourceAdditionalSlaveSecurityGroups;
                sourceAdditionalSlaveSecurityGroups = this.getAdditionalSlaveSecurityGroups();
                @SuppressWarnings("unchecked")
                List<String> copyAdditionalSlaveSecurityGroups = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "additionalSlaveSecurityGroups", sourceAdditionalSlaveSecurityGroups), sourceAdditionalSlaveSecurityGroups));
                copy.additionalSlaveSecurityGroups = null;
                copy.setAdditionalSlaveSecurityGroups(copyAdditionalSlaveSecurityGroups);
            } else {
                copy.additionalSlaveSecurityGroups = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new EmrClusterDefinition();
    }

}
