
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for errorInformation complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="errorInformation"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="statusCode" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="statusDescription" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="message" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="messageDetails" type="{}messageDetails" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "errorInformation", propOrder = {

})
@XmlRootElement(name = "errorInformation")
public class ErrorInformation implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected int statusCode;
    @XmlElement(required = true)
    protected String statusDescription;
    @XmlElement(required = true)
    protected String message;
    @XmlElementWrapper
    @XmlElement(name = "message")
    protected List<String> messageDetails;

    /**
     * Default no-arg constructor
     * 
     */
    public ErrorInformation() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ErrorInformation(final int statusCode, final String statusDescription, final String message, final List<String> messageDetails) {
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
        this.message = message;
        this.messageDetails = messageDetails;
    }

    /**
     * Gets the value of the statusCode property.
     * 
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     */
    public void setStatusCode(int value) {
        this.statusCode = value;
    }

    /**
     * Gets the value of the statusDescription property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStatusDescription() {
        return statusDescription;
    }

    /**
     * Sets the value of the statusDescription property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStatusDescription(String value) {
        this.statusDescription = value;
    }

    /**
     * Gets the value of the message property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getMessage() {
        return message;
    }

    /**
     * Sets the value of the message property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setMessage(String value) {
        this.message = value;
    }

    public List<String> getMessageDetails() {
        return messageDetails;
    }

    public void setMessageDetails(List<String> messageDetails) {
        this.messageDetails = messageDetails;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            int theStatusCode;
            theStatusCode = this.getStatusCode();
            strategy.appendField(locator, this, "statusCode", buffer, theStatusCode);
        }
        {
            String theStatusDescription;
            theStatusDescription = this.getStatusDescription();
            strategy.appendField(locator, this, "statusDescription", buffer, theStatusDescription);
        }
        {
            String theMessage;
            theMessage = this.getMessage();
            strategy.appendField(locator, this, "message", buffer, theMessage);
        }
        {
            List<String> theMessageDetails;
            theMessageDetails = this.getMessageDetails();
            strategy.appendField(locator, this, "messageDetails", buffer, theMessageDetails);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final ErrorInformation that = ((ErrorInformation) object);
        {
            int lhsStatusCode;
            lhsStatusCode = this.getStatusCode();
            int rhsStatusCode;
            rhsStatusCode = that.getStatusCode();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "statusCode", lhsStatusCode), LocatorUtils.property(thatLocator, "statusCode", rhsStatusCode), lhsStatusCode, rhsStatusCode)) {
                return false;
            }
        }
        {
            String lhsStatusDescription;
            lhsStatusDescription = this.getStatusDescription();
            String rhsStatusDescription;
            rhsStatusDescription = that.getStatusDescription();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "statusDescription", lhsStatusDescription), LocatorUtils.property(thatLocator, "statusDescription", rhsStatusDescription), lhsStatusDescription, rhsStatusDescription)) {
                return false;
            }
        }
        {
            String lhsMessage;
            lhsMessage = this.getMessage();
            String rhsMessage;
            rhsMessage = that.getMessage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "message", lhsMessage), LocatorUtils.property(thatLocator, "message", rhsMessage), lhsMessage, rhsMessage)) {
                return false;
            }
        }
        {
            List<String> lhsMessageDetails;
            lhsMessageDetails = this.getMessageDetails();
            List<String> rhsMessageDetails;
            rhsMessageDetails = that.getMessageDetails();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "messageDetails", lhsMessageDetails), LocatorUtils.property(thatLocator, "messageDetails", rhsMessageDetails), lhsMessageDetails, rhsMessageDetails)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            int theStatusCode;
            theStatusCode = this.getStatusCode();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "statusCode", theStatusCode), currentHashCode, theStatusCode);
        }
        {
            String theStatusDescription;
            theStatusDescription = this.getStatusDescription();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "statusDescription", theStatusDescription), currentHashCode, theStatusDescription);
        }
        {
            String theMessage;
            theMessage = this.getMessage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "message", theMessage), currentHashCode, theMessage);
        }
        {
            List<String> theMessageDetails;
            theMessageDetails = this.getMessageDetails();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "messageDetails", theMessageDetails), currentHashCode, theMessageDetails);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof ErrorInformation) {
            final ErrorInformation copy = ((ErrorInformation) draftCopy);
            {
                int sourceStatusCode;
                sourceStatusCode = this.getStatusCode();
                int copyStatusCode = strategy.copy(LocatorUtils.property(locator, "statusCode", sourceStatusCode), sourceStatusCode);
                copy.setStatusCode(copyStatusCode);
            }
            if (this.statusDescription!= null) {
                String sourceStatusDescription;
                sourceStatusDescription = this.getStatusDescription();
                String copyStatusDescription = ((String) strategy.copy(LocatorUtils.property(locator, "statusDescription", sourceStatusDescription), sourceStatusDescription));
                copy.setStatusDescription(copyStatusDescription);
            } else {
                copy.statusDescription = null;
            }
            if (this.message!= null) {
                String sourceMessage;
                sourceMessage = this.getMessage();
                String copyMessage = ((String) strategy.copy(LocatorUtils.property(locator, "message", sourceMessage), sourceMessage));
                copy.setMessage(copyMessage);
            } else {
                copy.message = null;
            }
            if (this.messageDetails!= null) {
                List<String> sourceMessageDetails;
                sourceMessageDetails = this.getMessageDetails();
                @SuppressWarnings("unchecked")
                List<String> copyMessageDetails = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "messageDetails", sourceMessageDetails), sourceMessageDetails));
                copy.messageDetails = null;
                copy.setMessageDetails(copyMessageDetails);
            } else {
                copy.messageDetails = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new ErrorInformation();
    }

}
