
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for jdbcStatement complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="jdbcStatement"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;sequence&gt;
 *         &lt;element name="type" type="{}jdbcStatementType"/&gt;
 *         &lt;element name="sql" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="continueOnError" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *         &lt;element name="status" type="{}jdbcStatementStatus" minOccurs="0"/&gt;
 *         &lt;element name="result" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="resultSet" type="{}jdbcStatementResultSet" minOccurs="0"/&gt;
 *         &lt;element name="errorMessage" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/sequence&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jdbcStatement", propOrder = {
    "type",
    "sql",
    "continueOnError",
    "status",
    "result",
    "resultSet",
    "errorMessage"
})
public class JdbcStatement implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    @XmlSchemaType(name = "string")
    protected JdbcStatementType type;
    @XmlElement(required = true)
    protected String sql;
    protected Boolean continueOnError;
    @XmlSchemaType(name = "string")
    protected JdbcStatementStatus status;
    protected String result;
    protected JdbcStatementResultSet resultSet;
    protected String errorMessage;

    /**
     * Default no-arg constructor
     * 
     */
    public JdbcStatement() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public JdbcStatement(final JdbcStatementType type, final String sql, final Boolean continueOnError, final JdbcStatementStatus status, final String result, final JdbcStatementResultSet resultSet, final String errorMessage) {
        this.type = type;
        this.sql = sql;
        this.continueOnError = continueOnError;
        this.status = status;
        this.result = result;
        this.resultSet = resultSet;
        this.errorMessage = errorMessage;
    }

    /**
     * Gets the value of the type property.
     * 
     * @return
     *     possible object is
     *     {@link JdbcStatementType }
     *     
     */
    public JdbcStatementType getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link JdbcStatementType }
     *     
     */
    public void setType(JdbcStatementType value) {
        this.type = value;
    }

    /**
     * Gets the value of the sql property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getSql() {
        return sql;
    }

    /**
     * Sets the value of the sql property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setSql(String value) {
        this.sql = value;
    }

    /**
     * Gets the value of the continueOnError property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isContinueOnError() {
        return continueOnError;
    }

    /**
     * Sets the value of the continueOnError property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setContinueOnError(Boolean value) {
        this.continueOnError = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link JdbcStatementStatus }
     *     
     */
    public JdbcStatementStatus getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link JdbcStatementStatus }
     *     
     */
    public void setStatus(JdbcStatementStatus value) {
        this.status = value;
    }

    /**
     * Gets the value of the result property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getResult() {
        return result;
    }

    /**
     * Sets the value of the result property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setResult(String value) {
        this.result = value;
    }

    /**
     * Gets the value of the resultSet property.
     * 
     * @return
     *     possible object is
     *     {@link JdbcStatementResultSet }
     *     
     */
    public JdbcStatementResultSet getResultSet() {
        return resultSet;
    }

    /**
     * Sets the value of the resultSet property.
     * 
     * @param value
     *     allowed object is
     *     {@link JdbcStatementResultSet }
     *     
     */
    public void setResultSet(JdbcStatementResultSet value) {
        this.resultSet = value;
    }

    /**
     * Gets the value of the errorMessage property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * Sets the value of the errorMessage property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setErrorMessage(String value) {
        this.errorMessage = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            JdbcStatementType theType;
            theType = this.getType();
            strategy.appendField(locator, this, "type", buffer, theType);
        }
        {
            String theSql;
            theSql = this.getSql();
            strategy.appendField(locator, this, "sql", buffer, theSql);
        }
        {
            Boolean theContinueOnError;
            theContinueOnError = this.isContinueOnError();
            strategy.appendField(locator, this, "continueOnError", buffer, theContinueOnError);
        }
        {
            JdbcStatementStatus theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus);
        }
        {
            String theResult;
            theResult = this.getResult();
            strategy.appendField(locator, this, "result", buffer, theResult);
        }
        {
            JdbcStatementResultSet theResultSet;
            theResultSet = this.getResultSet();
            strategy.appendField(locator, this, "resultSet", buffer, theResultSet);
        }
        {
            String theErrorMessage;
            theErrorMessage = this.getErrorMessage();
            strategy.appendField(locator, this, "errorMessage", buffer, theErrorMessage);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final JdbcStatement that = ((JdbcStatement) object);
        {
            JdbcStatementType lhsType;
            lhsType = this.getType();
            JdbcStatementType rhsType;
            rhsType = that.getType();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "type", lhsType), LocatorUtils.property(thatLocator, "type", rhsType), lhsType, rhsType)) {
                return false;
            }
        }
        {
            String lhsSql;
            lhsSql = this.getSql();
            String rhsSql;
            rhsSql = that.getSql();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "sql", lhsSql), LocatorUtils.property(thatLocator, "sql", rhsSql), lhsSql, rhsSql)) {
                return false;
            }
        }
        {
            Boolean lhsContinueOnError;
            lhsContinueOnError = this.isContinueOnError();
            Boolean rhsContinueOnError;
            rhsContinueOnError = that.isContinueOnError();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "continueOnError", lhsContinueOnError), LocatorUtils.property(thatLocator, "continueOnError", rhsContinueOnError), lhsContinueOnError, rhsContinueOnError)) {
                return false;
            }
        }
        {
            JdbcStatementStatus lhsStatus;
            lhsStatus = this.getStatus();
            JdbcStatementStatus rhsStatus;
            rhsStatus = that.getStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "status", lhsStatus), LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus)) {
                return false;
            }
        }
        {
            String lhsResult;
            lhsResult = this.getResult();
            String rhsResult;
            rhsResult = that.getResult();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "result", lhsResult), LocatorUtils.property(thatLocator, "result", rhsResult), lhsResult, rhsResult)) {
                return false;
            }
        }
        {
            JdbcStatementResultSet lhsResultSet;
            lhsResultSet = this.getResultSet();
            JdbcStatementResultSet rhsResultSet;
            rhsResultSet = that.getResultSet();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "resultSet", lhsResultSet), LocatorUtils.property(thatLocator, "resultSet", rhsResultSet), lhsResultSet, rhsResultSet)) {
                return false;
            }
        }
        {
            String lhsErrorMessage;
            lhsErrorMessage = this.getErrorMessage();
            String rhsErrorMessage;
            rhsErrorMessage = that.getErrorMessage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "errorMessage", lhsErrorMessage), LocatorUtils.property(thatLocator, "errorMessage", rhsErrorMessage), lhsErrorMessage, rhsErrorMessage)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            JdbcStatementType theType;
            theType = this.getType();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "type", theType), currentHashCode, theType);
        }
        {
            String theSql;
            theSql = this.getSql();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "sql", theSql), currentHashCode, theSql);
        }
        {
            Boolean theContinueOnError;
            theContinueOnError = this.isContinueOnError();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "continueOnError", theContinueOnError), currentHashCode, theContinueOnError);
        }
        {
            JdbcStatementStatus theStatus;
            theStatus = this.getStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus);
        }
        {
            String theResult;
            theResult = this.getResult();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "result", theResult), currentHashCode, theResult);
        }
        {
            JdbcStatementResultSet theResultSet;
            theResultSet = this.getResultSet();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "resultSet", theResultSet), currentHashCode, theResultSet);
        }
        {
            String theErrorMessage;
            theErrorMessage = this.getErrorMessage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "errorMessage", theErrorMessage), currentHashCode, theErrorMessage);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof JdbcStatement) {
            final JdbcStatement copy = ((JdbcStatement) draftCopy);
            if (this.type!= null) {
                JdbcStatementType sourceType;
                sourceType = this.getType();
                JdbcStatementType copyType = ((JdbcStatementType) strategy.copy(LocatorUtils.property(locator, "type", sourceType), sourceType));
                copy.setType(copyType);
            } else {
                copy.type = null;
            }
            if (this.sql!= null) {
                String sourceSql;
                sourceSql = this.getSql();
                String copySql = ((String) strategy.copy(LocatorUtils.property(locator, "sql", sourceSql), sourceSql));
                copy.setSql(copySql);
            } else {
                copy.sql = null;
            }
            if (this.continueOnError!= null) {
                Boolean sourceContinueOnError;
                sourceContinueOnError = this.isContinueOnError();
                Boolean copyContinueOnError = ((Boolean) strategy.copy(LocatorUtils.property(locator, "continueOnError", sourceContinueOnError), sourceContinueOnError));
                copy.setContinueOnError(copyContinueOnError);
            } else {
                copy.continueOnError = null;
            }
            if (this.status!= null) {
                JdbcStatementStatus sourceStatus;
                sourceStatus = this.getStatus();
                JdbcStatementStatus copyStatus = ((JdbcStatementStatus) strategy.copy(LocatorUtils.property(locator, "status", sourceStatus), sourceStatus));
                copy.setStatus(copyStatus);
            } else {
                copy.status = null;
            }
            if (this.result!= null) {
                String sourceResult;
                sourceResult = this.getResult();
                String copyResult = ((String) strategy.copy(LocatorUtils.property(locator, "result", sourceResult), sourceResult));
                copy.setResult(copyResult);
            } else {
                copy.result = null;
            }
            if (this.resultSet!= null) {
                JdbcStatementResultSet sourceResultSet;
                sourceResultSet = this.getResultSet();
                JdbcStatementResultSet copyResultSet = ((JdbcStatementResultSet) strategy.copy(LocatorUtils.property(locator, "resultSet", sourceResultSet), sourceResultSet));
                copy.setResultSet(copyResultSet);
            } else {
                copy.resultSet = null;
            }
            if (this.errorMessage!= null) {
                String sourceErrorMessage;
                sourceErrorMessage = this.getErrorMessage();
                String copyErrorMessage = ((String) strategy.copy(LocatorUtils.property(locator, "errorMessage", sourceErrorMessage), sourceErrorMessage));
                copy.setErrorMessage(copyErrorMessage);
            } else {
                copy.errorMessage = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new JdbcStatement();
    }

}
