
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for job complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="job"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element ref="{}status" minOccurs="0"/&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="jobName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="currentWorkflowStep" type="{}workflowStep" minOccurs="0"/&gt;
 *         &lt;element name="completedWorkflowSteps" type="{}workflowSteps" minOccurs="0"/&gt;
 *         &lt;element name="parameters" type="{}parameters" minOccurs="0"/&gt;
 *         &lt;element name="activitiJobXml" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="workflowErrors" type="{}workflowErrors" minOccurs="0"/&gt;
 *         &lt;element name="deleteReason" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "job", propOrder = {

})
@XmlRootElement(name = "job")
public class Job implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String id;
    protected JobStatusEnum status;
    protected String namespace;
    protected String jobName;
    protected WorkflowStep currentWorkflowStep;
    @XmlElementWrapper
    @XmlElement(name = "workflowStep")
    protected List<WorkflowStep> completedWorkflowSteps;
    @XmlElementWrapper
    @XmlElement(name = "parameter")
    protected List<Parameter> parameters;
    @XmlCDATA
    protected String activitiJobXml;
    @XmlElementWrapper
    @XmlElement(name = "workflowError")
    protected List<WorkflowError> workflowErrors;
    protected String deleteReason;

    /**
     * Default no-arg constructor
     * 
     */
    public Job() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Job(final String id, final JobStatusEnum status, final String namespace, final String jobName, final WorkflowStep currentWorkflowStep, final List<WorkflowStep> completedWorkflowSteps, final List<Parameter> parameters, final String activitiJobXml, final List<WorkflowError> workflowErrors, final String deleteReason) {
        this.id = id;
        this.status = status;
        this.namespace = namespace;
        this.jobName = jobName;
        this.currentWorkflowStep = currentWorkflowStep;
        this.completedWorkflowSteps = completedWorkflowSteps;
        this.parameters = parameters;
        this.activitiJobXml = activitiJobXml;
        this.workflowErrors = workflowErrors;
        this.deleteReason = deleteReason;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link JobStatusEnum }
     *     
     */
    public JobStatusEnum getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobStatusEnum }
     *     
     */
    public void setStatus(JobStatusEnum value) {
        this.status = value;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the jobName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    /**
     * Gets the value of the currentWorkflowStep property.
     * 
     * @return
     *     possible object is
     *     {@link WorkflowStep }
     *     
     */
    public WorkflowStep getCurrentWorkflowStep() {
        return currentWorkflowStep;
    }

    /**
     * Sets the value of the currentWorkflowStep property.
     * 
     * @param value
     *     allowed object is
     *     {@link WorkflowStep }
     *     
     */
    public void setCurrentWorkflowStep(WorkflowStep value) {
        this.currentWorkflowStep = value;
    }

    /**
     * Gets the value of the activitiJobXml property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getActivitiJobXml() {
        return activitiJobXml;
    }

    /**
     * Sets the value of the activitiJobXml property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setActivitiJobXml(String value) {
        this.activitiJobXml = value;
    }

    /**
     * Gets the value of the deleteReason property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDeleteReason() {
        return deleteReason;
    }

    /**
     * Sets the value of the deleteReason property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDeleteReason(String value) {
        this.deleteReason = value;
    }

    public List<WorkflowStep> getCompletedWorkflowSteps() {
        return completedWorkflowSteps;
    }

    public void setCompletedWorkflowSteps(List<WorkflowStep> completedWorkflowSteps) {
        this.completedWorkflowSteps = completedWorkflowSteps;
    }

    public List<Parameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<WorkflowError> getWorkflowErrors() {
        return workflowErrors;
    }

    public void setWorkflowErrors(List<WorkflowError> workflowErrors) {
        this.workflowErrors = workflowErrors;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId);
        }
        {
            JobStatusEnum theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            strategy.appendField(locator, this, "jobName", buffer, theJobName);
        }
        {
            WorkflowStep theCurrentWorkflowStep;
            theCurrentWorkflowStep = this.getCurrentWorkflowStep();
            strategy.appendField(locator, this, "currentWorkflowStep", buffer, theCurrentWorkflowStep);
        }
        {
            List<WorkflowStep> theCompletedWorkflowSteps;
            theCompletedWorkflowSteps = this.getCompletedWorkflowSteps();
            strategy.appendField(locator, this, "completedWorkflowSteps", buffer, theCompletedWorkflowSteps);
        }
        {
            List<Parameter> theParameters;
            theParameters = this.getParameters();
            strategy.appendField(locator, this, "parameters", buffer, theParameters);
        }
        {
            String theActivitiJobXml;
            theActivitiJobXml = this.getActivitiJobXml();
            strategy.appendField(locator, this, "activitiJobXml", buffer, theActivitiJobXml);
        }
        {
            List<WorkflowError> theWorkflowErrors;
            theWorkflowErrors = this.getWorkflowErrors();
            strategy.appendField(locator, this, "workflowErrors", buffer, theWorkflowErrors);
        }
        {
            String theDeleteReason;
            theDeleteReason = this.getDeleteReason();
            strategy.appendField(locator, this, "deleteReason", buffer, theDeleteReason);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Job that = ((Job) object);
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId)) {
                return false;
            }
        }
        {
            JobStatusEnum lhsStatus;
            lhsStatus = this.getStatus();
            JobStatusEnum rhsStatus;
            rhsStatus = that.getStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "status", lhsStatus), LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus)) {
                return false;
            }
        }
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsJobName;
            lhsJobName = this.getJobName();
            String rhsJobName;
            rhsJobName = that.getJobName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "jobName", lhsJobName), LocatorUtils.property(thatLocator, "jobName", rhsJobName), lhsJobName, rhsJobName)) {
                return false;
            }
        }
        {
            WorkflowStep lhsCurrentWorkflowStep;
            lhsCurrentWorkflowStep = this.getCurrentWorkflowStep();
            WorkflowStep rhsCurrentWorkflowStep;
            rhsCurrentWorkflowStep = that.getCurrentWorkflowStep();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "currentWorkflowStep", lhsCurrentWorkflowStep), LocatorUtils.property(thatLocator, "currentWorkflowStep", rhsCurrentWorkflowStep), lhsCurrentWorkflowStep, rhsCurrentWorkflowStep)) {
                return false;
            }
        }
        {
            List<WorkflowStep> lhsCompletedWorkflowSteps;
            lhsCompletedWorkflowSteps = this.getCompletedWorkflowSteps();
            List<WorkflowStep> rhsCompletedWorkflowSteps;
            rhsCompletedWorkflowSteps = that.getCompletedWorkflowSteps();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "completedWorkflowSteps", lhsCompletedWorkflowSteps), LocatorUtils.property(thatLocator, "completedWorkflowSteps", rhsCompletedWorkflowSteps), lhsCompletedWorkflowSteps, rhsCompletedWorkflowSteps)) {
                return false;
            }
        }
        {
            List<Parameter> lhsParameters;
            lhsParameters = this.getParameters();
            List<Parameter> rhsParameters;
            rhsParameters = that.getParameters();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "parameters", lhsParameters), LocatorUtils.property(thatLocator, "parameters", rhsParameters), lhsParameters, rhsParameters)) {
                return false;
            }
        }
        {
            String lhsActivitiJobXml;
            lhsActivitiJobXml = this.getActivitiJobXml();
            String rhsActivitiJobXml;
            rhsActivitiJobXml = that.getActivitiJobXml();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "activitiJobXml", lhsActivitiJobXml), LocatorUtils.property(thatLocator, "activitiJobXml", rhsActivitiJobXml), lhsActivitiJobXml, rhsActivitiJobXml)) {
                return false;
            }
        }
        {
            List<WorkflowError> lhsWorkflowErrors;
            lhsWorkflowErrors = this.getWorkflowErrors();
            List<WorkflowError> rhsWorkflowErrors;
            rhsWorkflowErrors = that.getWorkflowErrors();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "workflowErrors", lhsWorkflowErrors), LocatorUtils.property(thatLocator, "workflowErrors", rhsWorkflowErrors), lhsWorkflowErrors, rhsWorkflowErrors)) {
                return false;
            }
        }
        {
            String lhsDeleteReason;
            lhsDeleteReason = this.getDeleteReason();
            String rhsDeleteReason;
            rhsDeleteReason = that.getDeleteReason();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "deleteReason", lhsDeleteReason), LocatorUtils.property(thatLocator, "deleteReason", rhsDeleteReason), lhsDeleteReason, rhsDeleteReason)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId);
        }
        {
            JobStatusEnum theStatus;
            theStatus = this.getStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "jobName", theJobName), currentHashCode, theJobName);
        }
        {
            WorkflowStep theCurrentWorkflowStep;
            theCurrentWorkflowStep = this.getCurrentWorkflowStep();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "currentWorkflowStep", theCurrentWorkflowStep), currentHashCode, theCurrentWorkflowStep);
        }
        {
            List<WorkflowStep> theCompletedWorkflowSteps;
            theCompletedWorkflowSteps = this.getCompletedWorkflowSteps();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "completedWorkflowSteps", theCompletedWorkflowSteps), currentHashCode, theCompletedWorkflowSteps);
        }
        {
            List<Parameter> theParameters;
            theParameters = this.getParameters();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "parameters", theParameters), currentHashCode, theParameters);
        }
        {
            String theActivitiJobXml;
            theActivitiJobXml = this.getActivitiJobXml();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "activitiJobXml", theActivitiJobXml), currentHashCode, theActivitiJobXml);
        }
        {
            List<WorkflowError> theWorkflowErrors;
            theWorkflowErrors = this.getWorkflowErrors();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "workflowErrors", theWorkflowErrors), currentHashCode, theWorkflowErrors);
        }
        {
            String theDeleteReason;
            theDeleteReason = this.getDeleteReason();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "deleteReason", theDeleteReason), currentHashCode, theDeleteReason);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof Job) {
            final Job copy = ((Job) draftCopy);
            if (this.id!= null) {
                String sourceId;
                sourceId = this.getId();
                String copyId = ((String) strategy.copy(LocatorUtils.property(locator, "id", sourceId), sourceId));
                copy.setId(copyId);
            } else {
                copy.id = null;
            }
            if (this.status!= null) {
                JobStatusEnum sourceStatus;
                sourceStatus = this.getStatus();
                JobStatusEnum copyStatus = ((JobStatusEnum) strategy.copy(LocatorUtils.property(locator, "status", sourceStatus), sourceStatus));
                copy.setStatus(copyStatus);
            } else {
                copy.status = null;
            }
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.jobName!= null) {
                String sourceJobName;
                sourceJobName = this.getJobName();
                String copyJobName = ((String) strategy.copy(LocatorUtils.property(locator, "jobName", sourceJobName), sourceJobName));
                copy.setJobName(copyJobName);
            } else {
                copy.jobName = null;
            }
            if (this.currentWorkflowStep!= null) {
                WorkflowStep sourceCurrentWorkflowStep;
                sourceCurrentWorkflowStep = this.getCurrentWorkflowStep();
                WorkflowStep copyCurrentWorkflowStep = ((WorkflowStep) strategy.copy(LocatorUtils.property(locator, "currentWorkflowStep", sourceCurrentWorkflowStep), sourceCurrentWorkflowStep));
                copy.setCurrentWorkflowStep(copyCurrentWorkflowStep);
            } else {
                copy.currentWorkflowStep = null;
            }
            if (this.completedWorkflowSteps!= null) {
                List<WorkflowStep> sourceCompletedWorkflowSteps;
                sourceCompletedWorkflowSteps = this.getCompletedWorkflowSteps();
                @SuppressWarnings("unchecked")
                List<WorkflowStep> copyCompletedWorkflowSteps = ((List<WorkflowStep> ) strategy.copy(LocatorUtils.property(locator, "completedWorkflowSteps", sourceCompletedWorkflowSteps), sourceCompletedWorkflowSteps));
                copy.completedWorkflowSteps = null;
                copy.setCompletedWorkflowSteps(copyCompletedWorkflowSteps);
            } else {
                copy.completedWorkflowSteps = null;
            }
            if (this.parameters!= null) {
                List<Parameter> sourceParameters;
                sourceParameters = this.getParameters();
                @SuppressWarnings("unchecked")
                List<Parameter> copyParameters = ((List<Parameter> ) strategy.copy(LocatorUtils.property(locator, "parameters", sourceParameters), sourceParameters));
                copy.parameters = null;
                copy.setParameters(copyParameters);
            } else {
                copy.parameters = null;
            }
            if (this.activitiJobXml!= null) {
                String sourceActivitiJobXml;
                sourceActivitiJobXml = this.getActivitiJobXml();
                String copyActivitiJobXml = ((String) strategy.copy(LocatorUtils.property(locator, "activitiJobXml", sourceActivitiJobXml), sourceActivitiJobXml));
                copy.setActivitiJobXml(copyActivitiJobXml);
            } else {
                copy.activitiJobXml = null;
            }
            if (this.workflowErrors!= null) {
                List<WorkflowError> sourceWorkflowErrors;
                sourceWorkflowErrors = this.getWorkflowErrors();
                @SuppressWarnings("unchecked")
                List<WorkflowError> copyWorkflowErrors = ((List<WorkflowError> ) strategy.copy(LocatorUtils.property(locator, "workflowErrors", sourceWorkflowErrors), sourceWorkflowErrors));
                copy.workflowErrors = null;
                copy.setWorkflowErrors(copyWorkflowErrors);
            } else {
                copy.workflowErrors = null;
            }
            if (this.deleteReason!= null) {
                String sourceDeleteReason;
                sourceDeleteReason = this.getDeleteReason();
                String copyDeleteReason = ((String) strategy.copy(LocatorUtils.property(locator, "deleteReason", sourceDeleteReason), sourceDeleteReason));
                copy.setDeleteReason(copyDeleteReason);
            } else {
                copy.deleteReason = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new Job();
    }

}
