
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * A notification action which executes an Activiti job when triggered.
 * 
 * <p>Java class for jobAction complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="jobAction"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="jobName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="correlationData" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jobAction", propOrder = {

})
public class JobAction implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String jobName;
    @XmlCDATA
    protected String correlationData;

    /**
     * Default no-arg constructor
     * 
     */
    public JobAction() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public JobAction(final String namespace, final String jobName, final String correlationData) {
        this.namespace = namespace;
        this.jobName = jobName;
        this.correlationData = correlationData;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the jobName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    /**
     * Gets the value of the correlationData property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getCorrelationData() {
        return correlationData;
    }

    /**
     * Sets the value of the correlationData property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setCorrelationData(String value) {
        this.correlationData = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            strategy.appendField(locator, this, "jobName", buffer, theJobName);
        }
        {
            String theCorrelationData;
            theCorrelationData = this.getCorrelationData();
            strategy.appendField(locator, this, "correlationData", buffer, theCorrelationData);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final JobAction that = ((JobAction) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsJobName;
            lhsJobName = this.getJobName();
            String rhsJobName;
            rhsJobName = that.getJobName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "jobName", lhsJobName), LocatorUtils.property(thatLocator, "jobName", rhsJobName), lhsJobName, rhsJobName)) {
                return false;
            }
        }
        {
            String lhsCorrelationData;
            lhsCorrelationData = this.getCorrelationData();
            String rhsCorrelationData;
            rhsCorrelationData = that.getCorrelationData();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "correlationData", lhsCorrelationData), LocatorUtils.property(thatLocator, "correlationData", rhsCorrelationData), lhsCorrelationData, rhsCorrelationData)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "jobName", theJobName), currentHashCode, theJobName);
        }
        {
            String theCorrelationData;
            theCorrelationData = this.getCorrelationData();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "correlationData", theCorrelationData), currentHashCode, theCorrelationData);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof JobAction) {
            final JobAction copy = ((JobAction) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.jobName!= null) {
                String sourceJobName;
                sourceJobName = this.getJobName();
                String copyJobName = ((String) strategy.copy(LocatorUtils.property(locator, "jobName", sourceJobName), sourceJobName));
                copy.setJobName(copyJobName);
            } else {
                copy.jobName = null;
            }
            if (this.correlationData!= null) {
                String sourceCorrelationData;
                sourceCorrelationData = this.getCorrelationData();
                String copyCorrelationData = ((String) strategy.copy(LocatorUtils.property(locator, "correlationData", sourceCorrelationData), sourceCorrelationData));
                copy.setCorrelationData(copyCorrelationData);
            } else {
                copy.correlationData = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new JobAction();
    }

}
