
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.persistence.oxm.annotations.XmlCDATA;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for jobDefinition complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="jobDefinition"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}int"/&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="jobName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="description" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="activitiJobXml" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="parameters" type="{}parameters" minOccurs="0"/&gt;
 *         &lt;element name="s3PropertiesLocation" type="{}s3PropertiesLocation" minOccurs="0"/&gt;
 *         &lt;element name="lastUpdatedByUserId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jobDefinition", propOrder = {

})
@XmlRootElement(name = "jobDefinition")
public class JobDefinition implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected int id;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElement(required = true)
    protected String jobName;
    protected String description;
    @XmlElement(required = true)
    @XmlCDATA
    protected String activitiJobXml;
    @XmlElementWrapper
    @XmlElement(name = "parameter")
    protected List<Parameter> parameters;
    protected S3PropertiesLocation s3PropertiesLocation;
    protected String lastUpdatedByUserId;

    /**
     * Default no-arg constructor
     * 
     */
    public JobDefinition() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public JobDefinition(final int id, final String namespace, final String jobName, final String description, final String activitiJobXml, final List<Parameter> parameters, final S3PropertiesLocation s3PropertiesLocation, final String lastUpdatedByUserId) {
        this.id = id;
        this.namespace = namespace;
        this.jobName = jobName;
        this.description = description;
        this.activitiJobXml = activitiJobXml;
        this.parameters = parameters;
        this.s3PropertiesLocation = s3PropertiesLocation;
        this.lastUpdatedByUserId = lastUpdatedByUserId;
    }

    /**
     * Gets the value of the id property.
     * 
     */
    public int getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     */
    public void setId(int value) {
        this.id = value;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the jobName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * Gets the value of the activitiJobXml property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getActivitiJobXml() {
        return activitiJobXml;
    }

    /**
     * Sets the value of the activitiJobXml property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setActivitiJobXml(String value) {
        this.activitiJobXml = value;
    }

    /**
     * Gets the value of the s3PropertiesLocation property.
     * 
     * @return
     *     possible object is
     *     {@link S3PropertiesLocation }
     *     
     */
    public S3PropertiesLocation getS3PropertiesLocation() {
        return s3PropertiesLocation;
    }

    /**
     * Sets the value of the s3PropertiesLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link S3PropertiesLocation }
     *     
     */
    public void setS3PropertiesLocation(S3PropertiesLocation value) {
        this.s3PropertiesLocation = value;
    }

    /**
     * Gets the value of the lastUpdatedByUserId property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getLastUpdatedByUserId() {
        return lastUpdatedByUserId;
    }

    /**
     * Sets the value of the lastUpdatedByUserId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setLastUpdatedByUserId(String value) {
        this.lastUpdatedByUserId = value;
    }

    public List<Parameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            int theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            strategy.appendField(locator, this, "jobName", buffer, theJobName);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription);
        }
        {
            String theActivitiJobXml;
            theActivitiJobXml = this.getActivitiJobXml();
            strategy.appendField(locator, this, "activitiJobXml", buffer, theActivitiJobXml);
        }
        {
            List<Parameter> theParameters;
            theParameters = this.getParameters();
            strategy.appendField(locator, this, "parameters", buffer, theParameters);
        }
        {
            S3PropertiesLocation theS3PropertiesLocation;
            theS3PropertiesLocation = this.getS3PropertiesLocation();
            strategy.appendField(locator, this, "s3PropertiesLocation", buffer, theS3PropertiesLocation);
        }
        {
            String theLastUpdatedByUserId;
            theLastUpdatedByUserId = this.getLastUpdatedByUserId();
            strategy.appendField(locator, this, "lastUpdatedByUserId", buffer, theLastUpdatedByUserId);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final JobDefinition that = ((JobDefinition) object);
        {
            int lhsId;
            lhsId = this.getId();
            int rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId)) {
                return false;
            }
        }
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsJobName;
            lhsJobName = this.getJobName();
            String rhsJobName;
            rhsJobName = that.getJobName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "jobName", lhsJobName), LocatorUtils.property(thatLocator, "jobName", rhsJobName), lhsJobName, rhsJobName)) {
                return false;
            }
        }
        {
            String lhsDescription;
            lhsDescription = this.getDescription();
            String rhsDescription;
            rhsDescription = that.getDescription();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "description", lhsDescription), LocatorUtils.property(thatLocator, "description", rhsDescription), lhsDescription, rhsDescription)) {
                return false;
            }
        }
        {
            String lhsActivitiJobXml;
            lhsActivitiJobXml = this.getActivitiJobXml();
            String rhsActivitiJobXml;
            rhsActivitiJobXml = that.getActivitiJobXml();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "activitiJobXml", lhsActivitiJobXml), LocatorUtils.property(thatLocator, "activitiJobXml", rhsActivitiJobXml), lhsActivitiJobXml, rhsActivitiJobXml)) {
                return false;
            }
        }
        {
            List<Parameter> lhsParameters;
            lhsParameters = this.getParameters();
            List<Parameter> rhsParameters;
            rhsParameters = that.getParameters();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "parameters", lhsParameters), LocatorUtils.property(thatLocator, "parameters", rhsParameters), lhsParameters, rhsParameters)) {
                return false;
            }
        }
        {
            S3PropertiesLocation lhsS3PropertiesLocation;
            lhsS3PropertiesLocation = this.getS3PropertiesLocation();
            S3PropertiesLocation rhsS3PropertiesLocation;
            rhsS3PropertiesLocation = that.getS3PropertiesLocation();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "s3PropertiesLocation", lhsS3PropertiesLocation), LocatorUtils.property(thatLocator, "s3PropertiesLocation", rhsS3PropertiesLocation), lhsS3PropertiesLocation, rhsS3PropertiesLocation)) {
                return false;
            }
        }
        {
            String lhsLastUpdatedByUserId;
            lhsLastUpdatedByUserId = this.getLastUpdatedByUserId();
            String rhsLastUpdatedByUserId;
            rhsLastUpdatedByUserId = that.getLastUpdatedByUserId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "lastUpdatedByUserId", lhsLastUpdatedByUserId), LocatorUtils.property(thatLocator, "lastUpdatedByUserId", rhsLastUpdatedByUserId), lhsLastUpdatedByUserId, rhsLastUpdatedByUserId)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            int theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "jobName", theJobName), currentHashCode, theJobName);
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "description", theDescription), currentHashCode, theDescription);
        }
        {
            String theActivitiJobXml;
            theActivitiJobXml = this.getActivitiJobXml();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "activitiJobXml", theActivitiJobXml), currentHashCode, theActivitiJobXml);
        }
        {
            List<Parameter> theParameters;
            theParameters = this.getParameters();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "parameters", theParameters), currentHashCode, theParameters);
        }
        {
            S3PropertiesLocation theS3PropertiesLocation;
            theS3PropertiesLocation = this.getS3PropertiesLocation();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "s3PropertiesLocation", theS3PropertiesLocation), currentHashCode, theS3PropertiesLocation);
        }
        {
            String theLastUpdatedByUserId;
            theLastUpdatedByUserId = this.getLastUpdatedByUserId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "lastUpdatedByUserId", theLastUpdatedByUserId), currentHashCode, theLastUpdatedByUserId);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof JobDefinition) {
            final JobDefinition copy = ((JobDefinition) draftCopy);
            {
                int sourceId;
                sourceId = this.getId();
                int copyId = strategy.copy(LocatorUtils.property(locator, "id", sourceId), sourceId);
                copy.setId(copyId);
            }
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.jobName!= null) {
                String sourceJobName;
                sourceJobName = this.getJobName();
                String copyJobName = ((String) strategy.copy(LocatorUtils.property(locator, "jobName", sourceJobName), sourceJobName));
                copy.setJobName(copyJobName);
            } else {
                copy.jobName = null;
            }
            if (this.description!= null) {
                String sourceDescription;
                sourceDescription = this.getDescription();
                String copyDescription = ((String) strategy.copy(LocatorUtils.property(locator, "description", sourceDescription), sourceDescription));
                copy.setDescription(copyDescription);
            } else {
                copy.description = null;
            }
            if (this.activitiJobXml!= null) {
                String sourceActivitiJobXml;
                sourceActivitiJobXml = this.getActivitiJobXml();
                String copyActivitiJobXml = ((String) strategy.copy(LocatorUtils.property(locator, "activitiJobXml", sourceActivitiJobXml), sourceActivitiJobXml));
                copy.setActivitiJobXml(copyActivitiJobXml);
            } else {
                copy.activitiJobXml = null;
            }
            if (this.parameters!= null) {
                List<Parameter> sourceParameters;
                sourceParameters = this.getParameters();
                @SuppressWarnings("unchecked")
                List<Parameter> copyParameters = ((List<Parameter> ) strategy.copy(LocatorUtils.property(locator, "parameters", sourceParameters), sourceParameters));
                copy.parameters = null;
                copy.setParameters(copyParameters);
            } else {
                copy.parameters = null;
            }
            if (this.s3PropertiesLocation!= null) {
                S3PropertiesLocation sourceS3PropertiesLocation;
                sourceS3PropertiesLocation = this.getS3PropertiesLocation();
                S3PropertiesLocation copyS3PropertiesLocation = ((S3PropertiesLocation) strategy.copy(LocatorUtils.property(locator, "s3PropertiesLocation", sourceS3PropertiesLocation), sourceS3PropertiesLocation));
                copy.setS3PropertiesLocation(copyS3PropertiesLocation);
            } else {
                copy.s3PropertiesLocation = null;
            }
            if (this.lastUpdatedByUserId!= null) {
                String sourceLastUpdatedByUserId;
                sourceLastUpdatedByUserId = this.getLastUpdatedByUserId();
                String copyLastUpdatedByUserId = ((String) strategy.copy(LocatorUtils.property(locator, "lastUpdatedByUserId", sourceLastUpdatedByUserId), sourceLastUpdatedByUserId));
                copy.setLastUpdatedByUserId(copyLastUpdatedByUserId);
            } else {
                copy.lastUpdatedByUserId = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new JobDefinition();
    }

}
