
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for jobSummary complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="jobSummary"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="id" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="jobName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="startTime" type="{http://www.w3.org/2001/XMLSchema}dateTime"/&gt;
 *         &lt;element name="endTime" type="{http://www.w3.org/2001/XMLSchema}dateTime" minOccurs="0"/&gt;
 *         &lt;element ref="{}status" minOccurs="0"/&gt;
 *         &lt;element name="totalExceptions" type="{http://www.w3.org/2001/XMLSchema}long"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "jobSummary", propOrder = {

})
public class JobSummary implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String id;
    protected String namespace;
    @XmlElement(required = true)
    protected String jobName;
    @XmlElement(required = true)
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar startTime;
    @XmlSchemaType(name = "dateTime")
    protected XMLGregorianCalendar endTime;
    protected JobStatusEnum status;
    protected long totalExceptions;

    /**
     * Default no-arg constructor
     * 
     */
    public JobSummary() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public JobSummary(final String id, final String namespace, final String jobName, final XMLGregorianCalendar startTime, final XMLGregorianCalendar endTime, final JobStatusEnum status, final long totalExceptions) {
        this.id = id;
        this.namespace = namespace;
        this.jobName = jobName;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.totalExceptions = totalExceptions;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getId() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setId(String value) {
        this.id = value;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    /**
     * Gets the value of the jobName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        return jobName;
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    /**
     * Gets the value of the startTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getStartTime() {
        return startTime;
    }

    /**
     * Sets the value of the startTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setStartTime(XMLGregorianCalendar value) {
        this.startTime = value;
    }

    /**
     * Gets the value of the endTime property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getEndTime() {
        return endTime;
    }

    /**
     * Sets the value of the endTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setEndTime(XMLGregorianCalendar value) {
        this.endTime = value;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link JobStatusEnum }
     *     
     */
    public JobStatusEnum getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link JobStatusEnum }
     *     
     */
    public void setStatus(JobStatusEnum value) {
        this.status = value;
    }

    /**
     * Gets the value of the totalExceptions property.
     * 
     */
    public long getTotalExceptions() {
        return totalExceptions;
    }

    /**
     * Sets the value of the totalExceptions property.
     * 
     */
    public void setTotalExceptions(long value) {
        this.totalExceptions = value;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theId;
            theId = this.getId();
            strategy.appendField(locator, this, "id", buffer, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            strategy.appendField(locator, this, "jobName", buffer, theJobName);
        }
        {
            XMLGregorianCalendar theStartTime;
            theStartTime = this.getStartTime();
            strategy.appendField(locator, this, "startTime", buffer, theStartTime);
        }
        {
            XMLGregorianCalendar theEndTime;
            theEndTime = this.getEndTime();
            strategy.appendField(locator, this, "endTime", buffer, theEndTime);
        }
        {
            JobStatusEnum theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus);
        }
        {
            long theTotalExceptions;
            theTotalExceptions = this.getTotalExceptions();
            strategy.appendField(locator, this, "totalExceptions", buffer, theTotalExceptions);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final JobSummary that = ((JobSummary) object);
        {
            String lhsId;
            lhsId = this.getId();
            String rhsId;
            rhsId = that.getId();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "id", lhsId), LocatorUtils.property(thatLocator, "id", rhsId), lhsId, rhsId)) {
                return false;
            }
        }
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            String lhsJobName;
            lhsJobName = this.getJobName();
            String rhsJobName;
            rhsJobName = that.getJobName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "jobName", lhsJobName), LocatorUtils.property(thatLocator, "jobName", rhsJobName), lhsJobName, rhsJobName)) {
                return false;
            }
        }
        {
            XMLGregorianCalendar lhsStartTime;
            lhsStartTime = this.getStartTime();
            XMLGregorianCalendar rhsStartTime;
            rhsStartTime = that.getStartTime();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "startTime", lhsStartTime), LocatorUtils.property(thatLocator, "startTime", rhsStartTime), lhsStartTime, rhsStartTime)) {
                return false;
            }
        }
        {
            XMLGregorianCalendar lhsEndTime;
            lhsEndTime = this.getEndTime();
            XMLGregorianCalendar rhsEndTime;
            rhsEndTime = that.getEndTime();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "endTime", lhsEndTime), LocatorUtils.property(thatLocator, "endTime", rhsEndTime), lhsEndTime, rhsEndTime)) {
                return false;
            }
        }
        {
            JobStatusEnum lhsStatus;
            lhsStatus = this.getStatus();
            JobStatusEnum rhsStatus;
            rhsStatus = that.getStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "status", lhsStatus), LocatorUtils.property(thatLocator, "status", rhsStatus), lhsStatus, rhsStatus)) {
                return false;
            }
        }
        {
            long lhsTotalExceptions;
            lhsTotalExceptions = this.getTotalExceptions();
            long rhsTotalExceptions;
            rhsTotalExceptions = that.getTotalExceptions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "totalExceptions", lhsTotalExceptions), LocatorUtils.property(thatLocator, "totalExceptions", rhsTotalExceptions), lhsTotalExceptions, rhsTotalExceptions)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theId;
            theId = this.getId();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "id", theId), currentHashCode, theId);
        }
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            String theJobName;
            theJobName = this.getJobName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "jobName", theJobName), currentHashCode, theJobName);
        }
        {
            XMLGregorianCalendar theStartTime;
            theStartTime = this.getStartTime();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "startTime", theStartTime), currentHashCode, theStartTime);
        }
        {
            XMLGregorianCalendar theEndTime;
            theEndTime = this.getEndTime();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "endTime", theEndTime), currentHashCode, theEndTime);
        }
        {
            JobStatusEnum theStatus;
            theStatus = this.getStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "status", theStatus), currentHashCode, theStatus);
        }
        {
            long theTotalExceptions;
            theTotalExceptions = this.getTotalExceptions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "totalExceptions", theTotalExceptions), currentHashCode, theTotalExceptions);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof JobSummary) {
            final JobSummary copy = ((JobSummary) draftCopy);
            if (this.id!= null) {
                String sourceId;
                sourceId = this.getId();
                String copyId = ((String) strategy.copy(LocatorUtils.property(locator, "id", sourceId), sourceId));
                copy.setId(copyId);
            } else {
                copy.id = null;
            }
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.jobName!= null) {
                String sourceJobName;
                sourceJobName = this.getJobName();
                String copyJobName = ((String) strategy.copy(LocatorUtils.property(locator, "jobName", sourceJobName), sourceJobName));
                copy.setJobName(copyJobName);
            } else {
                copy.jobName = null;
            }
            if (this.startTime!= null) {
                XMLGregorianCalendar sourceStartTime;
                sourceStartTime = this.getStartTime();
                XMLGregorianCalendar copyStartTime = ((XMLGregorianCalendar) strategy.copy(LocatorUtils.property(locator, "startTime", sourceStartTime), sourceStartTime));
                copy.setStartTime(copyStartTime);
            } else {
                copy.startTime = null;
            }
            if (this.endTime!= null) {
                XMLGregorianCalendar sourceEndTime;
                sourceEndTime = this.getEndTime();
                XMLGregorianCalendar copyEndTime = ((XMLGregorianCalendar) strategy.copy(LocatorUtils.property(locator, "endTime", sourceEndTime), sourceEndTime));
                copy.setEndTime(copyEndTime);
            } else {
                copy.endTime = null;
            }
            if (this.status!= null) {
                JobStatusEnum sourceStatus;
                sourceStatus = this.getStatus();
                JobStatusEnum copyStatus = ((JobStatusEnum) strategy.copy(LocatorUtils.property(locator, "status", sourceStatus), sourceStatus));
                copy.setStatus(copyStatus);
            } else {
                copy.status = null;
            }
            {
                long sourceTotalExceptions;
                sourceTotalExceptions = this.getTotalExceptions();
                long copyTotalExceptions = strategy.copy(LocatorUtils.property(locator, "totalExceptions", sourceTotalExceptions), sourceTotalExceptions);
                copy.setTotalExceptions(copyTotalExceptions);
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new JobSummary();
    }

}
