
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for namespaceAuthorization complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="namespaceAuthorization"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="namespace" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="namespacePermissions" type="{}namespacePermissions"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "namespaceAuthorization", propOrder = {

})
public class NamespaceAuthorization implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String namespace;
    @XmlElementWrapper(required = true)
    @XmlElement(name = "namespacePermission")
    protected List<NamespacePermissionEnum> namespacePermissions;

    /**
     * Default no-arg constructor
     * 
     */
    public NamespaceAuthorization() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public NamespaceAuthorization(final String namespace, final List<NamespacePermissionEnum> namespacePermissions) {
        this.namespace = namespace;
        this.namespacePermissions = namespacePermissions;
    }

    /**
     * Gets the value of the namespace property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getNamespace() {
        return namespace;
    }

    /**
     * Sets the value of the namespace property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setNamespace(String value) {
        this.namespace = value;
    }

    public List<NamespacePermissionEnum> getNamespacePermissions() {
        return namespacePermissions;
    }

    public void setNamespacePermissions(List<NamespacePermissionEnum> namespacePermissions) {
        this.namespacePermissions = namespacePermissions;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            strategy.appendField(locator, this, "namespace", buffer, theNamespace);
        }
        {
            List<NamespacePermissionEnum> theNamespacePermissions;
            theNamespacePermissions = this.getNamespacePermissions();
            strategy.appendField(locator, this, "namespacePermissions", buffer, theNamespacePermissions);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final NamespaceAuthorization that = ((NamespaceAuthorization) object);
        {
            String lhsNamespace;
            lhsNamespace = this.getNamespace();
            String rhsNamespace;
            rhsNamespace = that.getNamespace();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespace", lhsNamespace), LocatorUtils.property(thatLocator, "namespace", rhsNamespace), lhsNamespace, rhsNamespace)) {
                return false;
            }
        }
        {
            List<NamespacePermissionEnum> lhsNamespacePermissions;
            lhsNamespacePermissions = this.getNamespacePermissions();
            List<NamespacePermissionEnum> rhsNamespacePermissions;
            rhsNamespacePermissions = that.getNamespacePermissions();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "namespacePermissions", lhsNamespacePermissions), LocatorUtils.property(thatLocator, "namespacePermissions", rhsNamespacePermissions), lhsNamespacePermissions, rhsNamespacePermissions)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theNamespace;
            theNamespace = this.getNamespace();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespace", theNamespace), currentHashCode, theNamespace);
        }
        {
            List<NamespacePermissionEnum> theNamespacePermissions;
            theNamespacePermissions = this.getNamespacePermissions();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "namespacePermissions", theNamespacePermissions), currentHashCode, theNamespacePermissions);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof NamespaceAuthorization) {
            final NamespaceAuthorization copy = ((NamespaceAuthorization) draftCopy);
            if (this.namespace!= null) {
                String sourceNamespace;
                sourceNamespace = this.getNamespace();
                String copyNamespace = ((String) strategy.copy(LocatorUtils.property(locator, "namespace", sourceNamespace), sourceNamespace));
                copy.setNamespace(copyNamespace);
            } else {
                copy.namespace = null;
            }
            if (this.namespacePermissions!= null) {
                List<NamespacePermissionEnum> sourceNamespacePermissions;
                sourceNamespacePermissions = this.getNamespacePermissions();
                @SuppressWarnings("unchecked")
                List<NamespacePermissionEnum> copyNamespacePermissions = ((List<NamespacePermissionEnum> ) strategy.copy(LocatorUtils.property(locator, "namespacePermissions", sourceNamespacePermissions), sourceNamespacePermissions));
                copy.namespacePermissions = null;
                copy.setNamespacePermissions(copyNamespacePermissions);
            } else {
                copy.namespacePermissions = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new NamespaceAuthorization();
    }

}
