
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for partitionValueFilter complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="partitionValueFilter"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="partitionKey" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *         &lt;element name="partitionValues" type="{}partitionValues" minOccurs="0"/&gt;
 *         &lt;element name="partitionValueRange" type="{}partitionValueRange" minOccurs="0"/&gt;
 *         &lt;element name="latestBeforePartitionValue" type="{}latestBeforePartitionValue" minOccurs="0"/&gt;
 *         &lt;element name="latestAfterPartitionValue" type="{}latestAfterPartitionValue" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "partitionValueFilter", propOrder = {

})
public class PartitionValueFilter implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    protected String partitionKey;
    @XmlElementWrapper
    @XmlElement(name = "partitionValue")
    protected List<String> partitionValues;
    protected PartitionValueRange partitionValueRange;
    protected LatestBeforePartitionValue latestBeforePartitionValue;
    protected LatestAfterPartitionValue latestAfterPartitionValue;

    /**
     * Default no-arg constructor
     * 
     */
    public PartitionValueFilter() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public PartitionValueFilter(final String partitionKey, final List<String> partitionValues, final PartitionValueRange partitionValueRange, final LatestBeforePartitionValue latestBeforePartitionValue, final LatestAfterPartitionValue latestAfterPartitionValue) {
        this.partitionKey = partitionKey;
        this.partitionValues = partitionValues;
        this.partitionValueRange = partitionValueRange;
        this.latestBeforePartitionValue = latestBeforePartitionValue;
        this.latestAfterPartitionValue = latestAfterPartitionValue;
    }

    /**
     * Gets the value of the partitionKey property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPartitionKey() {
        return partitionKey;
    }

    /**
     * Sets the value of the partitionKey property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPartitionKey(String value) {
        this.partitionKey = value;
    }

    /**
     * Gets the value of the partitionValueRange property.
     * 
     * @return
     *     possible object is
     *     {@link PartitionValueRange }
     *     
     */
    public PartitionValueRange getPartitionValueRange() {
        return partitionValueRange;
    }

    /**
     * Sets the value of the partitionValueRange property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartitionValueRange }
     *     
     */
    public void setPartitionValueRange(PartitionValueRange value) {
        this.partitionValueRange = value;
    }

    /**
     * Gets the value of the latestBeforePartitionValue property.
     * 
     * @return
     *     possible object is
     *     {@link LatestBeforePartitionValue }
     *     
     */
    public LatestBeforePartitionValue getLatestBeforePartitionValue() {
        return latestBeforePartitionValue;
    }

    /**
     * Sets the value of the latestBeforePartitionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestBeforePartitionValue }
     *     
     */
    public void setLatestBeforePartitionValue(LatestBeforePartitionValue value) {
        this.latestBeforePartitionValue = value;
    }

    /**
     * Gets the value of the latestAfterPartitionValue property.
     * 
     * @return
     *     possible object is
     *     {@link LatestAfterPartitionValue }
     *     
     */
    public LatestAfterPartitionValue getLatestAfterPartitionValue() {
        return latestAfterPartitionValue;
    }

    /**
     * Sets the value of the latestAfterPartitionValue property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestAfterPartitionValue }
     *     
     */
    public void setLatestAfterPartitionValue(LatestAfterPartitionValue value) {
        this.latestAfterPartitionValue = value;
    }

    public List<String> getPartitionValues() {
        return partitionValues;
    }

    public void setPartitionValues(List<String> partitionValues) {
        this.partitionValues = partitionValues;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            strategy.appendField(locator, this, "partitionKey", buffer, thePartitionKey);
        }
        {
            List<String> thePartitionValues;
            thePartitionValues = this.getPartitionValues();
            strategy.appendField(locator, this, "partitionValues", buffer, thePartitionValues);
        }
        {
            PartitionValueRange thePartitionValueRange;
            thePartitionValueRange = this.getPartitionValueRange();
            strategy.appendField(locator, this, "partitionValueRange", buffer, thePartitionValueRange);
        }
        {
            LatestBeforePartitionValue theLatestBeforePartitionValue;
            theLatestBeforePartitionValue = this.getLatestBeforePartitionValue();
            strategy.appendField(locator, this, "latestBeforePartitionValue", buffer, theLatestBeforePartitionValue);
        }
        {
            LatestAfterPartitionValue theLatestAfterPartitionValue;
            theLatestAfterPartitionValue = this.getLatestAfterPartitionValue();
            strategy.appendField(locator, this, "latestAfterPartitionValue", buffer, theLatestAfterPartitionValue);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final PartitionValueFilter that = ((PartitionValueFilter) object);
        {
            String lhsPartitionKey;
            lhsPartitionKey = this.getPartitionKey();
            String rhsPartitionKey;
            rhsPartitionKey = that.getPartitionKey();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionKey", lhsPartitionKey), LocatorUtils.property(thatLocator, "partitionKey", rhsPartitionKey), lhsPartitionKey, rhsPartitionKey)) {
                return false;
            }
        }
        {
            List<String> lhsPartitionValues;
            lhsPartitionValues = this.getPartitionValues();
            List<String> rhsPartitionValues;
            rhsPartitionValues = that.getPartitionValues();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValues", lhsPartitionValues), LocatorUtils.property(thatLocator, "partitionValues", rhsPartitionValues), lhsPartitionValues, rhsPartitionValues)) {
                return false;
            }
        }
        {
            PartitionValueRange lhsPartitionValueRange;
            lhsPartitionValueRange = this.getPartitionValueRange();
            PartitionValueRange rhsPartitionValueRange;
            rhsPartitionValueRange = that.getPartitionValueRange();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "partitionValueRange", lhsPartitionValueRange), LocatorUtils.property(thatLocator, "partitionValueRange", rhsPartitionValueRange), lhsPartitionValueRange, rhsPartitionValueRange)) {
                return false;
            }
        }
        {
            LatestBeforePartitionValue lhsLatestBeforePartitionValue;
            lhsLatestBeforePartitionValue = this.getLatestBeforePartitionValue();
            LatestBeforePartitionValue rhsLatestBeforePartitionValue;
            rhsLatestBeforePartitionValue = that.getLatestBeforePartitionValue();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "latestBeforePartitionValue", lhsLatestBeforePartitionValue), LocatorUtils.property(thatLocator, "latestBeforePartitionValue", rhsLatestBeforePartitionValue), lhsLatestBeforePartitionValue, rhsLatestBeforePartitionValue)) {
                return false;
            }
        }
        {
            LatestAfterPartitionValue lhsLatestAfterPartitionValue;
            lhsLatestAfterPartitionValue = this.getLatestAfterPartitionValue();
            LatestAfterPartitionValue rhsLatestAfterPartitionValue;
            rhsLatestAfterPartitionValue = that.getLatestAfterPartitionValue();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "latestAfterPartitionValue", lhsLatestAfterPartitionValue), LocatorUtils.property(thatLocator, "latestAfterPartitionValue", rhsLatestAfterPartitionValue), lhsLatestAfterPartitionValue, rhsLatestAfterPartitionValue)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String thePartitionKey;
            thePartitionKey = this.getPartitionKey();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionKey", thePartitionKey), currentHashCode, thePartitionKey);
        }
        {
            List<String> thePartitionValues;
            thePartitionValues = this.getPartitionValues();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValues", thePartitionValues), currentHashCode, thePartitionValues);
        }
        {
            PartitionValueRange thePartitionValueRange;
            thePartitionValueRange = this.getPartitionValueRange();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "partitionValueRange", thePartitionValueRange), currentHashCode, thePartitionValueRange);
        }
        {
            LatestBeforePartitionValue theLatestBeforePartitionValue;
            theLatestBeforePartitionValue = this.getLatestBeforePartitionValue();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "latestBeforePartitionValue", theLatestBeforePartitionValue), currentHashCode, theLatestBeforePartitionValue);
        }
        {
            LatestAfterPartitionValue theLatestAfterPartitionValue;
            theLatestAfterPartitionValue = this.getLatestAfterPartitionValue();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "latestAfterPartitionValue", theLatestAfterPartitionValue), currentHashCode, theLatestAfterPartitionValue);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof PartitionValueFilter) {
            final PartitionValueFilter copy = ((PartitionValueFilter) draftCopy);
            if (this.partitionKey!= null) {
                String sourcePartitionKey;
                sourcePartitionKey = this.getPartitionKey();
                String copyPartitionKey = ((String) strategy.copy(LocatorUtils.property(locator, "partitionKey", sourcePartitionKey), sourcePartitionKey));
                copy.setPartitionKey(copyPartitionKey);
            } else {
                copy.partitionKey = null;
            }
            if (this.partitionValues!= null) {
                List<String> sourcePartitionValues;
                sourcePartitionValues = this.getPartitionValues();
                @SuppressWarnings("unchecked")
                List<String> copyPartitionValues = ((List<String> ) strategy.copy(LocatorUtils.property(locator, "partitionValues", sourcePartitionValues), sourcePartitionValues));
                copy.partitionValues = null;
                copy.setPartitionValues(copyPartitionValues);
            } else {
                copy.partitionValues = null;
            }
            if (this.partitionValueRange!= null) {
                PartitionValueRange sourcePartitionValueRange;
                sourcePartitionValueRange = this.getPartitionValueRange();
                PartitionValueRange copyPartitionValueRange = ((PartitionValueRange) strategy.copy(LocatorUtils.property(locator, "partitionValueRange", sourcePartitionValueRange), sourcePartitionValueRange));
                copy.setPartitionValueRange(copyPartitionValueRange);
            } else {
                copy.partitionValueRange = null;
            }
            if (this.latestBeforePartitionValue!= null) {
                LatestBeforePartitionValue sourceLatestBeforePartitionValue;
                sourceLatestBeforePartitionValue = this.getLatestBeforePartitionValue();
                LatestBeforePartitionValue copyLatestBeforePartitionValue = ((LatestBeforePartitionValue) strategy.copy(LocatorUtils.property(locator, "latestBeforePartitionValue", sourceLatestBeforePartitionValue), sourceLatestBeforePartitionValue));
                copy.setLatestBeforePartitionValue(copyLatestBeforePartitionValue);
            } else {
                copy.latestBeforePartitionValue = null;
            }
            if (this.latestAfterPartitionValue!= null) {
                LatestAfterPartitionValue sourceLatestAfterPartitionValue;
                sourceLatestAfterPartitionValue = this.getLatestAfterPartitionValue();
                LatestAfterPartitionValue copyLatestAfterPartitionValue = ((LatestAfterPartitionValue) strategy.copy(LocatorUtils.property(locator, "latestAfterPartitionValue", sourceLatestAfterPartitionValue), sourceLatestAfterPartitionValue));
                copy.setLatestAfterPartitionValue(copyLatestAfterPartitionValue);
            } else {
                copy.latestAfterPartitionValue = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new PartitionValueFilter();
    }

}
