
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for storage complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="storage"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="storagePlatformName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="attributes" type="{}attributes" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "storage", propOrder = {

})
@XmlRootElement(name = "storage")
public class Storage implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String name;
    @XmlElement(required = true)
    protected String storagePlatformName;
    @XmlElementWrapper
    @XmlElement(name = "attribute")
    protected List<Attribute> attributes;

    /**
     * Default no-arg constructor
     * 
     */
    public Storage() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Storage(final String name, final String storagePlatformName, final List<Attribute> attributes) {
        this.name = name;
        this.storagePlatformName = storagePlatformName;
        this.attributes = attributes;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * Gets the value of the storagePlatformName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStoragePlatformName() {
        return storagePlatformName;
    }

    /**
     * Sets the value of the storagePlatformName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStoragePlatformName(String value) {
        this.storagePlatformName = value;
    }

    public List<Attribute> getAttributes() {
        return attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName);
        }
        {
            String theStoragePlatformName;
            theStoragePlatformName = this.getStoragePlatformName();
            strategy.appendField(locator, this, "storagePlatformName", buffer, theStoragePlatformName);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            strategy.appendField(locator, this, "attributes", buffer, theAttributes);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Storage that = ((Storage) object);
        {
            String lhsName;
            lhsName = this.getName();
            String rhsName;
            rhsName = that.getName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "name", lhsName), LocatorUtils.property(thatLocator, "name", rhsName), lhsName, rhsName)) {
                return false;
            }
        }
        {
            String lhsStoragePlatformName;
            lhsStoragePlatformName = this.getStoragePlatformName();
            String rhsStoragePlatformName;
            rhsStoragePlatformName = that.getStoragePlatformName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storagePlatformName", lhsStoragePlatformName), LocatorUtils.property(thatLocator, "storagePlatformName", rhsStoragePlatformName), lhsStoragePlatformName, rhsStoragePlatformName)) {
                return false;
            }
        }
        {
            List<Attribute> lhsAttributes;
            lhsAttributes = this.getAttributes();
            List<Attribute> rhsAttributes;
            rhsAttributes = that.getAttributes();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "attributes", lhsAttributes), LocatorUtils.property(thatLocator, "attributes", rhsAttributes), lhsAttributes, rhsAttributes)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theName;
            theName = this.getName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "name", theName), currentHashCode, theName);
        }
        {
            String theStoragePlatformName;
            theStoragePlatformName = this.getStoragePlatformName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storagePlatformName", theStoragePlatformName), currentHashCode, theStoragePlatformName);
        }
        {
            List<Attribute> theAttributes;
            theAttributes = this.getAttributes();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "attributes", theAttributes), currentHashCode, theAttributes);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof Storage) {
            final Storage copy = ((Storage) draftCopy);
            if (this.name!= null) {
                String sourceName;
                sourceName = this.getName();
                String copyName = ((String) strategy.copy(LocatorUtils.property(locator, "name", sourceName), sourceName));
                copy.setName(copyName);
            } else {
                copy.name = null;
            }
            if (this.storagePlatformName!= null) {
                String sourceStoragePlatformName;
                sourceStoragePlatformName = this.getStoragePlatformName();
                String copyStoragePlatformName = ((String) strategy.copy(LocatorUtils.property(locator, "storagePlatformName", sourceStoragePlatformName), sourceStoragePlatformName));
                copy.setStoragePlatformName(copyStoragePlatformName);
            } else {
                copy.storagePlatformName = null;
            }
            if (this.attributes!= null) {
                List<Attribute> sourceAttributes;
                sourceAttributes = this.getAttributes();
                @SuppressWarnings("unchecked")
                List<Attribute> copyAttributes = ((List<Attribute> ) strategy.copy(LocatorUtils.property(locator, "attributes", sourceAttributes), sourceAttributes));
                copy.attributes = null;
                copy.setAttributes(copyAttributes);
            } else {
                copy.attributes = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new Storage();
    }

}
