
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for storageUnit complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="storageUnit"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="storage" type="{}storage"/&gt;
 *         &lt;element name="storageDirectory" type="{}storageDirectory" minOccurs="0"/&gt;
 *         &lt;element name="storageFiles" type="{}storageFiles" minOccurs="0"/&gt;
 *         &lt;element name="storageUnitStatus" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "storageUnit", propOrder = {

})
public class StorageUnit implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected Storage storage;
    protected StorageDirectory storageDirectory;
    @XmlElementWrapper
    @XmlElement(name = "storageFile")
    protected List<StorageFile> storageFiles;
    protected String storageUnitStatus;

    /**
     * Default no-arg constructor
     * 
     */
    public StorageUnit() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public StorageUnit(final Storage storage, final StorageDirectory storageDirectory, final List<StorageFile> storageFiles, final String storageUnitStatus) {
        this.storage = storage;
        this.storageDirectory = storageDirectory;
        this.storageFiles = storageFiles;
        this.storageUnitStatus = storageUnitStatus;
    }

    /**
     * Gets the value of the storage property.
     * 
     * @return
     *     possible object is
     *     {@link Storage }
     *     
     */
    public Storage getStorage() {
        return storage;
    }

    /**
     * Sets the value of the storage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Storage }
     *     
     */
    public void setStorage(Storage value) {
        this.storage = value;
    }

    /**
     * Gets the value of the storageDirectory property.
     * 
     * @return
     *     possible object is
     *     {@link StorageDirectory }
     *     
     */
    public StorageDirectory getStorageDirectory() {
        return storageDirectory;
    }

    /**
     * Sets the value of the storageDirectory property.
     * 
     * @param value
     *     allowed object is
     *     {@link StorageDirectory }
     *     
     */
    public void setStorageDirectory(StorageDirectory value) {
        this.storageDirectory = value;
    }

    /**
     * Gets the value of the storageUnitStatus property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStorageUnitStatus() {
        return storageUnitStatus;
    }

    /**
     * Sets the value of the storageUnitStatus property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStorageUnitStatus(String value) {
        this.storageUnitStatus = value;
    }

    public List<StorageFile> getStorageFiles() {
        return storageFiles;
    }

    public void setStorageFiles(List<StorageFile> storageFiles) {
        this.storageFiles = storageFiles;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            Storage theStorage;
            theStorage = this.getStorage();
            strategy.appendField(locator, this, "storage", buffer, theStorage);
        }
        {
            StorageDirectory theStorageDirectory;
            theStorageDirectory = this.getStorageDirectory();
            strategy.appendField(locator, this, "storageDirectory", buffer, theStorageDirectory);
        }
        {
            List<StorageFile> theStorageFiles;
            theStorageFiles = this.getStorageFiles();
            strategy.appendField(locator, this, "storageFiles", buffer, theStorageFiles);
        }
        {
            String theStorageUnitStatus;
            theStorageUnitStatus = this.getStorageUnitStatus();
            strategy.appendField(locator, this, "storageUnitStatus", buffer, theStorageUnitStatus);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StorageUnit that = ((StorageUnit) object);
        {
            Storage lhsStorage;
            lhsStorage = this.getStorage();
            Storage rhsStorage;
            rhsStorage = that.getStorage();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storage", lhsStorage), LocatorUtils.property(thatLocator, "storage", rhsStorage), lhsStorage, rhsStorage)) {
                return false;
            }
        }
        {
            StorageDirectory lhsStorageDirectory;
            lhsStorageDirectory = this.getStorageDirectory();
            StorageDirectory rhsStorageDirectory;
            rhsStorageDirectory = that.getStorageDirectory();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageDirectory", lhsStorageDirectory), LocatorUtils.property(thatLocator, "storageDirectory", rhsStorageDirectory), lhsStorageDirectory, rhsStorageDirectory)) {
                return false;
            }
        }
        {
            List<StorageFile> lhsStorageFiles;
            lhsStorageFiles = this.getStorageFiles();
            List<StorageFile> rhsStorageFiles;
            rhsStorageFiles = that.getStorageFiles();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageFiles", lhsStorageFiles), LocatorUtils.property(thatLocator, "storageFiles", rhsStorageFiles), lhsStorageFiles, rhsStorageFiles)) {
                return false;
            }
        }
        {
            String lhsStorageUnitStatus;
            lhsStorageUnitStatus = this.getStorageUnitStatus();
            String rhsStorageUnitStatus;
            rhsStorageUnitStatus = that.getStorageUnitStatus();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageUnitStatus", lhsStorageUnitStatus), LocatorUtils.property(thatLocator, "storageUnitStatus", rhsStorageUnitStatus), lhsStorageUnitStatus, rhsStorageUnitStatus)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            Storage theStorage;
            theStorage = this.getStorage();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storage", theStorage), currentHashCode, theStorage);
        }
        {
            StorageDirectory theStorageDirectory;
            theStorageDirectory = this.getStorageDirectory();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageDirectory", theStorageDirectory), currentHashCode, theStorageDirectory);
        }
        {
            List<StorageFile> theStorageFiles;
            theStorageFiles = this.getStorageFiles();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageFiles", theStorageFiles), currentHashCode, theStorageFiles);
        }
        {
            String theStorageUnitStatus;
            theStorageUnitStatus = this.getStorageUnitStatus();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageUnitStatus", theStorageUnitStatus), currentHashCode, theStorageUnitStatus);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof StorageUnit) {
            final StorageUnit copy = ((StorageUnit) draftCopy);
            if (this.storage!= null) {
                Storage sourceStorage;
                sourceStorage = this.getStorage();
                Storage copyStorage = ((Storage) strategy.copy(LocatorUtils.property(locator, "storage", sourceStorage), sourceStorage));
                copy.setStorage(copyStorage);
            } else {
                copy.storage = null;
            }
            if (this.storageDirectory!= null) {
                StorageDirectory sourceStorageDirectory;
                sourceStorageDirectory = this.getStorageDirectory();
                StorageDirectory copyStorageDirectory = ((StorageDirectory) strategy.copy(LocatorUtils.property(locator, "storageDirectory", sourceStorageDirectory), sourceStorageDirectory));
                copy.setStorageDirectory(copyStorageDirectory);
            } else {
                copy.storageDirectory = null;
            }
            if (this.storageFiles!= null) {
                List<StorageFile> sourceStorageFiles;
                sourceStorageFiles = this.getStorageFiles();
                @SuppressWarnings("unchecked")
                List<StorageFile> copyStorageFiles = ((List<StorageFile> ) strategy.copy(LocatorUtils.property(locator, "storageFiles", sourceStorageFiles), sourceStorageFiles));
                copy.storageFiles = null;
                copy.setStorageFiles(copyStorageFiles);
            } else {
                copy.storageFiles = null;
            }
            if (this.storageUnitStatus!= null) {
                String sourceStorageUnitStatus;
                sourceStorageUnitStatus = this.getStorageUnitStatus();
                String copyStorageUnitStatus = ((String) strategy.copy(LocatorUtils.property(locator, "storageUnitStatus", sourceStorageUnitStatus), sourceStorageUnitStatus));
                copy.setStorageUnitStatus(copyStorageUnitStatus);
            } else {
                copy.storageUnitStatus = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new StorageUnit();
    }

}
