
package org.finra.herd.model.api.xml;

import java.io.Serializable;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlType;
import org.jvnet.jaxb2_commons.lang.CopyStrategy;
import org.jvnet.jaxb2_commons.lang.CopyTo;
import org.jvnet.jaxb2_commons.lang.Equals;
import org.jvnet.jaxb2_commons.lang.EqualsStrategy;
import org.jvnet.jaxb2_commons.lang.HashCode;
import org.jvnet.jaxb2_commons.lang.HashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBCopyStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBEqualsStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBHashCodeStrategy;
import org.jvnet.jaxb2_commons.lang.JAXBToStringStrategy;
import org.jvnet.jaxb2_commons.lang.ToString;
import org.jvnet.jaxb2_commons.lang.ToStringStrategy;
import org.jvnet.jaxb2_commons.locator.ObjectLocator;
import org.jvnet.jaxb2_commons.locator.util.LocatorUtils;


/**
 * <p>Java class for storageUnitCreateRequest complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="storageUnitCreateRequest"&gt;
 *   &lt;complexContent&gt;
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType"&gt;
 *       &lt;all&gt;
 *         &lt;element name="storageName" type="{http://www.w3.org/2001/XMLSchema}string"/&gt;
 *         &lt;element name="storageDirectory" type="{}storageDirectory" minOccurs="0"/&gt;
 *         &lt;element name="storageFiles" type="{}storageFiles" minOccurs="0"/&gt;
 *         &lt;element name="discoverStorageFiles" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/&gt;
 *       &lt;/all&gt;
 *     &lt;/restriction&gt;
 *   &lt;/complexContent&gt;
 * &lt;/complexType&gt;
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "storageUnitCreateRequest", propOrder = {

})
public class StorageUnitCreateRequest implements Serializable, Cloneable, CopyTo, Equals, HashCode, ToString
{

    private final static long serialVersionUID = -1L;
    @XmlElement(required = true)
    protected String storageName;
    protected StorageDirectory storageDirectory;
    @XmlElementWrapper
    @XmlElement(name = "storageFile")
    protected List<StorageFile> storageFiles;
    protected Boolean discoverStorageFiles;

    /**
     * Default no-arg constructor
     * 
     */
    public StorageUnitCreateRequest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public StorageUnitCreateRequest(final String storageName, final StorageDirectory storageDirectory, final List<StorageFile> storageFiles, final Boolean discoverStorageFiles) {
        this.storageName = storageName;
        this.storageDirectory = storageDirectory;
        this.storageFiles = storageFiles;
        this.discoverStorageFiles = discoverStorageFiles;
    }

    /**
     * Gets the value of the storageName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getStorageName() {
        return storageName;
    }

    /**
     * Sets the value of the storageName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setStorageName(String value) {
        this.storageName = value;
    }

    /**
     * Gets the value of the storageDirectory property.
     * 
     * @return
     *     possible object is
     *     {@link StorageDirectory }
     *     
     */
    public StorageDirectory getStorageDirectory() {
        return storageDirectory;
    }

    /**
     * Sets the value of the storageDirectory property.
     * 
     * @param value
     *     allowed object is
     *     {@link StorageDirectory }
     *     
     */
    public void setStorageDirectory(StorageDirectory value) {
        this.storageDirectory = value;
    }

    /**
     * Gets the value of the discoverStorageFiles property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean isDiscoverStorageFiles() {
        return discoverStorageFiles;
    }

    /**
     * Sets the value of the discoverStorageFiles property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDiscoverStorageFiles(Boolean value) {
        this.discoverStorageFiles = value;
    }

    public List<StorageFile> getStorageFiles() {
        return storageFiles;
    }

    public void setStorageFiles(List<StorageFile> storageFiles) {
        this.storageFiles = storageFiles;
    }

    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.INSTANCE;
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            strategy.appendField(locator, this, "storageName", buffer, theStorageName);
        }
        {
            StorageDirectory theStorageDirectory;
            theStorageDirectory = this.getStorageDirectory();
            strategy.appendField(locator, this, "storageDirectory", buffer, theStorageDirectory);
        }
        {
            List<StorageFile> theStorageFiles;
            theStorageFiles = this.getStorageFiles();
            strategy.appendField(locator, this, "storageFiles", buffer, theStorageFiles);
        }
        {
            Boolean theDiscoverStorageFiles;
            theDiscoverStorageFiles = this.isDiscoverStorageFiles();
            strategy.appendField(locator, this, "discoverStorageFiles", buffer, theDiscoverStorageFiles);
        }
        return buffer;
    }

    public boolean equals(ObjectLocator thisLocator, ObjectLocator thatLocator, Object object, EqualsStrategy strategy) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final StorageUnitCreateRequest that = ((StorageUnitCreateRequest) object);
        {
            String lhsStorageName;
            lhsStorageName = this.getStorageName();
            String rhsStorageName;
            rhsStorageName = that.getStorageName();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageName", lhsStorageName), LocatorUtils.property(thatLocator, "storageName", rhsStorageName), lhsStorageName, rhsStorageName)) {
                return false;
            }
        }
        {
            StorageDirectory lhsStorageDirectory;
            lhsStorageDirectory = this.getStorageDirectory();
            StorageDirectory rhsStorageDirectory;
            rhsStorageDirectory = that.getStorageDirectory();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageDirectory", lhsStorageDirectory), LocatorUtils.property(thatLocator, "storageDirectory", rhsStorageDirectory), lhsStorageDirectory, rhsStorageDirectory)) {
                return false;
            }
        }
        {
            List<StorageFile> lhsStorageFiles;
            lhsStorageFiles = this.getStorageFiles();
            List<StorageFile> rhsStorageFiles;
            rhsStorageFiles = that.getStorageFiles();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "storageFiles", lhsStorageFiles), LocatorUtils.property(thatLocator, "storageFiles", rhsStorageFiles), lhsStorageFiles, rhsStorageFiles)) {
                return false;
            }
        }
        {
            Boolean lhsDiscoverStorageFiles;
            lhsDiscoverStorageFiles = this.isDiscoverStorageFiles();
            Boolean rhsDiscoverStorageFiles;
            rhsDiscoverStorageFiles = that.isDiscoverStorageFiles();
            if (!strategy.equals(LocatorUtils.property(thisLocator, "discoverStorageFiles", lhsDiscoverStorageFiles), LocatorUtils.property(thatLocator, "discoverStorageFiles", rhsDiscoverStorageFiles), lhsDiscoverStorageFiles, rhsDiscoverStorageFiles)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object object) {
        final EqualsStrategy strategy = JAXBEqualsStrategy.INSTANCE;
        return equals(null, null, object, strategy);
    }

    public int hashCode(ObjectLocator locator, HashCodeStrategy strategy) {
        int currentHashCode = 1;
        {
            String theStorageName;
            theStorageName = this.getStorageName();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageName", theStorageName), currentHashCode, theStorageName);
        }
        {
            StorageDirectory theStorageDirectory;
            theStorageDirectory = this.getStorageDirectory();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageDirectory", theStorageDirectory), currentHashCode, theStorageDirectory);
        }
        {
            List<StorageFile> theStorageFiles;
            theStorageFiles = this.getStorageFiles();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "storageFiles", theStorageFiles), currentHashCode, theStorageFiles);
        }
        {
            Boolean theDiscoverStorageFiles;
            theDiscoverStorageFiles = this.isDiscoverStorageFiles();
            currentHashCode = strategy.hashCode(LocatorUtils.property(locator, "discoverStorageFiles", theDiscoverStorageFiles), currentHashCode, theDiscoverStorageFiles);
        }
        return currentHashCode;
    }

    public int hashCode() {
        final HashCodeStrategy strategy = JAXBHashCodeStrategy.INSTANCE;
        return this.hashCode(null, strategy);
    }

    public Object clone() {
        return copyTo(createNewInstance());
    }

    public Object copyTo(Object target) {
        final CopyStrategy strategy = JAXBCopyStrategy.INSTANCE;
        return copyTo(null, target, strategy);
    }

    public Object copyTo(ObjectLocator locator, Object target, CopyStrategy strategy) {
        final Object draftCopy = ((target == null)?createNewInstance():target);
        if (draftCopy instanceof StorageUnitCreateRequest) {
            final StorageUnitCreateRequest copy = ((StorageUnitCreateRequest) draftCopy);
            if (this.storageName!= null) {
                String sourceStorageName;
                sourceStorageName = this.getStorageName();
                String copyStorageName = ((String) strategy.copy(LocatorUtils.property(locator, "storageName", sourceStorageName), sourceStorageName));
                copy.setStorageName(copyStorageName);
            } else {
                copy.storageName = null;
            }
            if (this.storageDirectory!= null) {
                StorageDirectory sourceStorageDirectory;
                sourceStorageDirectory = this.getStorageDirectory();
                StorageDirectory copyStorageDirectory = ((StorageDirectory) strategy.copy(LocatorUtils.property(locator, "storageDirectory", sourceStorageDirectory), sourceStorageDirectory));
                copy.setStorageDirectory(copyStorageDirectory);
            } else {
                copy.storageDirectory = null;
            }
            if (this.storageFiles!= null) {
                List<StorageFile> sourceStorageFiles;
                sourceStorageFiles = this.getStorageFiles();
                @SuppressWarnings("unchecked")
                List<StorageFile> copyStorageFiles = ((List<StorageFile> ) strategy.copy(LocatorUtils.property(locator, "storageFiles", sourceStorageFiles), sourceStorageFiles));
                copy.storageFiles = null;
                copy.setStorageFiles(copyStorageFiles);
            } else {
                copy.storageFiles = null;
            }
            if (this.discoverStorageFiles!= null) {
                Boolean sourceDiscoverStorageFiles;
                sourceDiscoverStorageFiles = this.isDiscoverStorageFiles();
                Boolean copyDiscoverStorageFiles = ((Boolean) strategy.copy(LocatorUtils.property(locator, "discoverStorageFiles", sourceDiscoverStorageFiles), sourceDiscoverStorageFiles));
                copy.setDiscoverStorageFiles(copyDiscoverStorageFiles);
            } else {
                copy.discoverStorageFiles = null;
            }
        }
        return draftCopy;
    }

    public Object createNewInstance() {
        return new StorageUnitCreateRequest();
    }

}
